#include	"defs.h"
/*
 * $Log: /IP/IPINIT.C $
 * 
 * 2     1/26/96 8:18p Titus
 * Revision corresponds to IP Release 1.31
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipinit.c$  $version: 1.23$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/15/94 yarran initialize trace buffer for debugging transport buffer leakage.
1.4 02/28/94 yarran Change port and route flags from bit map to enum BOOLEAN.
1.5 03/01/94 yarran Change ptop to point_to_point and other style changes.
1.6 03/02/94 yarran Set port allow_broadcast for non-point-to-point port.
1.7 03/03/94 yarran Check if default route configured by NVRAM.
1.8 03/03/94 yarran Handle NVRAM parameters directly by IP
1.9 03/09/94 yarran Add new ip control commands.
1.10 03/10/94 yarran If remote ip address is 0 in port-up-event, do not write to port class.
1.11 03/11/94 yarran Change PPP to WAN in printf.
1.12 03/17/94 yarran Add register_to_ip_from_upper_layer routine.
1.13 05/02/94 yarran added rfc1042 changes.
1.14 06/15/94 yarran added conditional compile for __LSL__.
1.15 09/01/94 ross added BYTE and USHORT_ENUM support.
1.16 10/10/94 ross added rarp, proxy arp, remote access functions
1.17 10/10/94 ross bootp changes.
1.18 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.19 12/20/94 ross
1.20 12/27/94 ross added better table instrumentation via new snmp.
1.21 01/17/95 ross fixed arp problems from snmp
1.22 03/03/95 ross added lsl control.
1.23 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define	GLOBAL_FILE
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include	"ip.h"


#define TCP_CSUM_DEBUG 1
#if TCP_CSUM_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
void ip_debugger (void) ;
#endif

#if 1
/* Jo 11/08/99 Added rip debugger */
void rip_debugger (void);
/* Jo 11/08/99 Added rip debugger */
#endif

/* Sachin 11/06/1996 */
void arrange_port_index_list (void) ;
/*  Sachin 11/06/1996 */

/* kamalanath 16\08\1996 */
enum BOOLEAN is_dhcp_client_enabled(BYTE real_port_number);
void enable_ip_bootp_params_for_dhcp_relay_agent (void);
/* kamalanath 16\08\1996 */

extern void create_ip_mib_table_sorted_on_indices(void);
extern enum BOOLEAN is_remote_access_enabled_on_port (USHORT port_number);
extern enum BOOLEAN is_dhcp_client_enabled_in_the_configuration();
extern BYTE is_ras_link_coming_up(USHORT real_port_number);

/* sudhir 1/4/97  */
extern enum TEST initialize_dns (void); /* sudha 20 Nov 1998 */

/****************************************************************************/
MAC_ADDRESS ethernet_broadcast_address = {0xffffffffL, 0xffff};
/****************************************************************************/
static enum TEST initialize_ip_protocol (ULONG clock_ticks_per_second);
static void reset_ip_counters (void);
static void initialize_ip_route_cache (void);
static void initialize_static_route_entries (void);

#if defined (_MSC_VER)
static void halt_ip_router (void);
/*************************************************************************/
ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...)
{
	va_list argptr;
	ULONG return_value;
	ULONG parameter[10];
	BYTE parameter_index;

	va_start (argptr, command);

	for (parameter_index = 0x00; parameter_index < 6;)
		{
		parameter[parameter_index] = va_arg (argptr, ULONG);

		parameter_index = (BYTE) (parameter_index + 1);
		}

	return_value = 0x00000000L;

	switch (command)
		{
		case RW_INITIALIZE:

			return_value = initialize_ip (parameter[0x00]);

			break;

		case RW_GET_CLASS_ADDRESS:

			return_value = (ULONG) &ip;

			break;

		case RW_GET_CLASS_SIZE:

			return_value = sizeof (IP_CLASS);

			break;

		case RW_GET_CONFIGURATION_TABLE_ADDRESS:

			return_value = get_ip_configuration_table_address ();

			break;
	#ifdef __NEW_CONFIG__
		case RW_GET_EXPORT_TABLE:

			return_value = (ULONG) &ip_export_table;

			break;

		case RW_GET_IMPORT_TABLE:

			return_value = (ULONG) &winrouter_import_table;

			break;
	#endif /* __NEW_CONFIG__ */

		case RW_SPECIAL_CONFIGURATION_FUNCTION:

			return_value = special_configuration_function_processing (&parameter[0x00]);

			break;

		case RW_CLOSE:

			return_value = ip_control (CLOSE_PROTOCOL_STACK, (ULONG) NULL, (ULONG) NULL, (ULONG) NULL);

			break;

		case RW_HALT:

			halt_ip_router ();

			break;
		}

	return (return_value);
}
/*************************************************************************/
static void halt_ip_router (void)
{
#ifdef __IP_ALARM_DEBUG__
	ip_printf (IP_ALARM_PRINTF, "IP: router is HALTED\n");
#endif /* __IP__ALARM_DEBUG__ */

	free_ip_rip_list_entries ();

	free_udp_control_blocks ();

	free_ip_route_cache_entries ();

	free_ip_routing_table_entries ();

	free_ip_reassembly_control_blocks ();

	free_ip_arp_entries ();

	free_ip_rarp_entries ();

	ip.timer_enabled = FALSE;

	if (ip.stack_id != 0x00000000L)
		{
		lsl_control ((ULONG) DEREGISTER_PROTOCOL_STACK, (ULONG) NETWORK_LAYER_TYPE, (ULONG) ip.stack_id);
		}

	ip.enabled = FALSE;
}
#endif
/****************************************************************************/
enum TEST initialize_ip (ULONG clock_ticks_per_second)
{
	USHORT port_index=0, number_of_wan_ports=0;
#ifdef __IP_BREAKPOINT__
	check_for_ip_initialization_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	if (ip.enabled == FALSE)
		{
		return (PASS);
/*		return (FAIL);*/
		}

/* Sachin 11/06/1996 */
	arrange_port_index_list () ;
/* Sachin 11/06/1996 */

#if TCP_CSUM_DEBUG
	register_debugger (ip_debugger, "ip debug") ;
#endif

/* Jo 11/08/99 Added rip debugger */
#if 1
	register_debugger (rip_debugger, "rip debug") ;
#endif
/* Jo 11/08/99 Added rip debugger */
	
	ip.number_of_lan_ports = lsl_control (GET_NUMBER_OF_LAN_PORTS);

	ip.port[0].routing_status = ROUTING_PORT;
	
	number_of_wan_ports = lsl_control (GET_NUMBER_OF_WAN_PORTS);

	for (port_index = 1; port_index <= number_of_wan_ports; port_index++)
		ip.port[port_index].routing_status = PROXY_PORT;


	if (initialize_ip_protocol (clock_ticks_per_second) == FAIL)
		{
		return (FAIL);
		}

#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_PROTOCOL_STACK, "IP Routing", ip_router_rx_packet, ip_router_timer, ip_control,
		&ip.stack_id) == FAIL)
		{
		return (FAIL);
		}
#endif

	if (initialize_rarp () == FAIL)
		{
		return (FAIL);
		}

	if (initialize_all_virtual_ports () == FAIL)
		{
		return (FAIL);
		}

	initialize_static_route_entries ();

	initialize_ip_route_cache ();

	if (initialize_arp () == FAIL)
		{
		return (FAIL);
		}

	if (initialize_icmp () == FAIL)
		{
		return (FAIL);
		}

	if (initialize_udp () == FAIL)
		{
		return (FAIL);
		}

/* sudhir 1/4/97 */
   if (initialize_dns () == FAIL)
      return FAIL;

	ip.timer_enabled = TRUE;

	if (ip.rip.protocol_enabled == TRUE)
		{
		if (rip_initialization () == FAIL)
			{
			return (FAIL);
			}

		rip_broadcast_request_packets_on_all_ports ();
		}
	else
		{
		set_rip_protocol_and_default_values (FALSE); 					/* resets all the default values for the rip protocol */
		}

	/* Srikar 22/11/96 */
	create_ip_mib_table_sorted_on_indices();				/* initialize IP address
																		table */
	/* Srikar 22/11/96 */
	return (PASS);
}
/****************************************************************************/
static void initialize_static_route_entries (void)
{
	NVRAM_ROUTE_ENTRY *sptr_nvram_route_entry;

	sptr_nvram_route_entry = (NVRAM_ROUTE_ENTRY *) get_entry_from_list ((LINK *) &ip.list_of_nvram_static_route_entries);

	while (sptr_nvram_route_entry != NULL)
		{
		rip_add_static_route_entry (sptr_nvram_route_entry);

		table_free (sptr_nvram_route_entry);

		sptr_nvram_route_entry = (NVRAM_ROUTE_ENTRY *) get_entry_from_list ((LINK *) &ip.list_of_nvram_static_route_entries);
		}
}
/****************************************************************************/
static void initialize_ip_route_cache (void)
{
	USHORT hash_table_size;
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	USHORT hash_table_index;
	USHORT bucket_index;
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry;

	if (ip.number_of_route_cache_hash_table_buckets == 0x00)
		{
		ip.number_of_route_cache_hash_table_buckets = MAXIMUM_SIZE_OF_ROUTE_CACHE_HASH_TABLE;
		}

	if (ip.number_of_routes_in_bucket == 0x00)
		{
		ip.number_of_routes_in_bucket = MAXIMUM_LENGTH_OF_ROUTE_CACHE_HASH_BUCKET;
		}

	hash_table_size = (USHORT) (ip.number_of_route_cache_hash_table_buckets * sizeof (IP_ROUTE_CACHE_HASH_BUCKET));

	ip.sptr_route_cache = (IP_ROUTE_CACHE_HASH_BUCKET *) buffer_malloc (hash_table_size);

	if (ip.sptr_route_cache == NULL)
		{
		ip_printf (IP_ALARM_PRINTF, "IP: table_malloc failed\n");

		return;
		}

	memset (ip.sptr_route_cache, 0x00, hash_table_size);

	sptr_bucket = ip.sptr_route_cache;

	for (hash_table_index = 0x0000; hash_table_index < ip.number_of_route_cache_hash_table_buckets; ++hash_table_index)
		{
		for (bucket_index = 0x0000; bucket_index < ip.number_of_routes_in_bucket; ++bucket_index)
			{
			sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) table_malloc (1, sizeof (IP_ROUTE_CACHE_ENTRY));

			if (sptr_route_cache_entry == NULL)
				{
				ip_printf (IP_ALARM_PRINTF, "IP: table_malloc failed\n");

				return;
				}

			add_entry_to_list ((LINK *) &sptr_bucket->links, (LINK *) sptr_route_cache_entry);
			}

		++sptr_bucket;
		}
}
#ifdef __IP_BREAKPOINT__
/****************************************************************************/
void check_for_ip_initialization_breakpoint (void)
{
	if (ip.initialization_breakpoint == TRUE)
		{
		BREAKPOINT;
		}
}
#endif /* __IP_BREAKPOINT__ */
/****************************************************************************/
static enum TEST initialize_ip_protocol (ULONG clock_ticks_per_second)
{
	ip.clock_ticks_per_second = clock_ticks_per_second;

	/* initialize ip MIBs */

	reset_ip_counters ();

	if (ip.default_route.gateway == 0x00000000L)
		{
		/* default route is not configured by the NVRAM */

		memset (&ip.default_route.flags, 0x00, sizeof (ROUTE_FLAGS));

		ip.default_route.port_number = NO_SUCH_PORT;
		ip.default_route.target = 0x00000000L;
		ip.default_route.mask = 0xffffffffL;
		ip.default_route.number_of_subnet_mask_bits = 0x00;
		ip.default_route.gateway = 0x00000000L;
		ip.default_route.aging_timer = 0x0000;
		ip.default_route.use_count = 0x00000000L;
		ip.default_route.metric = INFINITY_METRIC_VALUE;
		/* Srikar, Mar 18, 1997. Added the initialization for 'metric2' and 'ipRouteInfo' */
		ip.default_route.metric2 = (ULONG) -1;	/* Unused metric */
		ip.default_route.ipRouteInfo = 0;		/* Null object identifier */
		}

	ip.sptr_reassembly_link_list = NULL;
	ip.tick_counter = 0x00000000L;
	ip.timer_enabled = FALSE;
	ip.number_of_other_transport_protocols = 0x0000;

	ip.fptr_snmp_trap_function = ip_send_snmp_trap;

	return (PASS);
}
/****************************************************************************/
static void reset_ip_counters (void)
{
	ip.mib.ipInReceives = 0x00000000L;
	ip.mib.ipInHdrErrors = 0x00000000L;
	ip.mib.ipInAddrErrors = 0x00000000L;
	ip.mib.ipForwDatagrams = 0x00000000L;
	ip.mib.ipInUnknownProtos = 0x00000000L;
	ip.mib.ipInDiscards = 0x00000000L;
	ip.mib.ipInDelivers = 0x00000000L;
	ip.mib.ipOutRequests = 0x00000000L;
	ip.mib.ipOutDiscards = 0x00000000L;
	ip.mib.ipOutNoRoutes = 0x00000000L;
	ip.mib.ipReasmReqds = 0x00000000L;
	ip.mib.ipReasmOKs = 0x00000000L;
	ip.mib.ipReasmFails = 0x00000000L;
	ip.mib.ipFragOKs = 0x00000000L;
	ip.mib.ipFragFails = 0x00000000L;
	ip.mib.ipFragCreates = 0x00000000L;

	memset (&ip.statistics, (int) NULL, sizeof (IP_STATISTICS));
}
/****************************************************************************/
enum TEST initialize_all_virtual_ports (void)
{
	USHORT virtual_port_number;

	/* initialize each virtual port */

	for (virtual_port_number = 0x0000; virtual_port_number < ip.number_of_ports; ++virtual_port_number)
		{
		if (ip.port[virtual_port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		if (set_up_port_class_data (virtual_port_number) == FAIL)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP: failed to set up port class data for port %u\n", virtual_port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return (FAIL);
			}

		if (initialize_virtual_port (virtual_port_number) == FAIL)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP: failed to initialize port %u\n", virtual_port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return (FAIL);
			}
		}

	return (PASS);
}
/****************************************************************************/
enum TEST set_up_port_class_data (USHORT virtual_port_number)
{
	IP_PORT_CLASS *sptr_port;

	sptr_port = &ip.port[virtual_port_number];

	if (sptr_port->config.ip_address != 0x00000000L)
		{
		if (IN_CLASS_A (sptr_port->config.ip_address))
			{
			sptr_port->netmask =  IN_CLASS_A_NET;
			}
		else if (IN_CLASS_B (sptr_port->config.ip_address))
			{
			sptr_port->netmask =  IN_CLASS_B_NET;
			}
		else if (IN_CLASS_C (sptr_port->config.ip_address))
			{
			sptr_port->netmask =  IN_CLASS_C_NET;
			}
		else
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP: virtual port %d has illegal ip address\n", sptr_port->config.virtual_port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return (FAIL);
			}

		sptr_port->subnet_address = sptr_port->config.ip_address & sptr_port->config.subnetmask;

		sptr_port->net_address = sptr_port->config.ip_address & sptr_port->netmask;

		sptr_port->net_broadcast_address = sptr_port->net_address | ~sptr_port->netmask;

		sptr_port->subnet_broadcast_address = sptr_port->subnet_address | ~sptr_port->config.subnetmask;
		}

	return (PASS);
}
/****************************************************************************/
enum TEST initialize_virtual_port (USHORT port_number)
{
	IP_PORT_CLASS *sptr_port;

	sptr_port = &ip.port[port_number];

	sptr_port->config.virtual_port_number = port_number;

	if (sptr_port->config.ip_address != 0x00000000L)
	{
		if (sptr_port->config.point_to_point_link == FALSE)
		{
		#ifdef __LSL__
			lsl_control (GET_MAC_ADDRESS, port_number, ip.stack_id, &sptr_port->mac_address);

		#ifdef __IP_DEBUG__
			ip_printf (IP_PRINTF, "IP: got mac address %x:%x for port %u\n", sptr_port->mac_address._ulong,
				sptr_port->mac_address._ushort, port_number);
		#endif /* __IP_DEBUG__ */
		#endif /* __LSL__ */
		}

		/* Kamalnath 10\02\1997 allowed broadcast on all ports */
		/*sptr_port->allow_broadcast = FALSE;*/
		sptr_port->allow_broadcast = TRUE;
		/* Kamalnath 10\02\1997 */
		sptr_port->is_point_to_point = FALSE;
		sptr_port->port_is_up = FALSE;

		reset_ip_port_statistics (sptr_port);

		/* Assuming all point to point link is not broadcastable and all LAN physical port is up. */

		if (sptr_port->config.point_to_point_link == FALSE)
			{
			sptr_port->allow_broadcast = TRUE;
			sptr_port->hardware_address_length = MAC_ADDRESS_LENGTH;

/*			printf("\r\n *******port_is_up for %d\r\n",port_number);*/
			sptr_port->port_is_up = TRUE;

			ip_add_route_for_port (port_number);
			}
		else
			{
/*			printf("\r\n *******port_is_down for %d\r\n",port_number);*/
			sptr_port->is_point_to_point = TRUE;
			sptr_port->config.arp_enabled = FALSE;
			}
	}
	else if (ip.rarp.port[port_number].config.client_enabled == TRUE)
	{
		send_rarp_request (port_number);

		ip.rarp.port[port_number].pending_reply = TRUE;

		ip.rarp.port[port_number].second_counter = 0x0000;
	}
	else if (ip.port[port_number].config.bootp_enabled == TRUE)
	{
	#ifdef __LSL__
		lsl_control (GET_MAC_ADDRESS, port_number, ip.stack_id, &sptr_port->mac_address);

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: got mac address %x:%x for port %u\n", sptr_port->mac_address._ulong,
			sptr_port->mac_address._ushort, port_number);
	#endif /* __IP_DEBUG__ */

	#endif /* __LSL__ */

		sptr_port->allow_broadcast = TRUE;
		sptr_port->hardware_address_length = MAC_ADDRESS_LENGTH;
	}

	return (PASS);
}
/****************************************************************************/
void reset_ip_port_statistics (IP_PORT_CLASS *sptr_port)
{
	memset (&sptr_port->statistics, (int) NULL, sizeof (IP_PORT_STATISTICS));
}
/****************************************************************************/
void free_ip_route_cache_entries (void)
{
	USHORT hash_table_index;
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry;

	sptr_bucket = ip.sptr_route_cache;

	for (hash_table_index = 0x0000; hash_table_index < ip.number_of_route_cache_hash_table_buckets; ++hash_table_index)
		{
		sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_entry_from_list ((LINK *) &sptr_bucket->links);

		while (sptr_route_cache_entry != NULL)
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_MEMORY_PRINTF, "IP: freeing route cache entry %p\n", sptr_route_cache_entry);
		#endif /* __IP__DEBUG__ */

			table_free (sptr_route_cache_entry);

			sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_entry_from_list ((LINK *) &sptr_bucket->links);
			}

		++sptr_bucket;
		}

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: freeing route cache hash table %p\n", ip.sptr_route_cache);
#endif /* __IP__DEBUG__ */

	buffer_free (ip.sptr_route_cache);

	ip.number_of_routes_in_bucket = 0x00;
	ip.number_of_route_cache_hash_table_buckets = 0x00;

	ip.sptr_route_cache = NULL;

	ip.sptr_most_recently_used_route = NULL;

	ip.sptr_route_cache = NULL;
}

/* kamalanath 16\08\1996 */

enum BOOLEAN is_dhcp_client_enabled (BYTE real_port_number)
{
	/* Return true only if all the following conditions succeed
		. IP is enabled
		. IP for real_port_number is enabled
		. BOOTP is enabled for the port
		. The port is a remote access port (client only)

	/* DHCP functioning for remote client works only when if it is a 
		remote access (client only) port and bootp enabled */

 	if ((ip.enabled) &&
	    (ip.port[real_port_number].config.port_enabled) &&
		 (is_remote_access_enabled_on_port(real_port_number - ip.number_of_lan_ports)) &&
		 (is_ras_link_coming_up(real_port_number - ip.number_of_lan_ports)) &&
	    (is_dhcp_client_enabled_in_the_configuration()))
#if 0
		 &&
	    (ip.port[real_port_number].config.remote_access_enabled) )
#endif
		return (TRUE);
	else 
		return (FALSE);
}

void enable_ip_bootp_params_for_dhcp_relay_agent (void)
{
	IP_PORT_CLASS *sptr_port;
	USHORT port_number;
	
	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
	{
		sptr_port =	&ip.port[port_number];
		
		/* bootp_enabled set to TRUE for LAN and all client_only ports */

		if((sptr_port->config.point_to_point_link !=TRUE) || (sptr_port->config.remote_access_enabled == TRUE))
		{
  			sptr_port->config.bootp_enabled = TRUE;
			printf("BOOTP enabled for the port %d", port_number);
		}
	}
}
/* kamalanath 16\08\1996 */

#if TCP_CSUM_DEBUG
extern ULONG tcp_checksum_failed_packets ;
void ip_debugger (void)
{
   printf ("TCP Checksum failed packets : %d\n", tcp_checksum_failed_packets) ;
}
#endif

#if 1
/* Jo 11/08/99 Added rip debugger */

char *status_debug_convert_ip_address_to_dot_format (char *cptr_array_to_store_dot_format_address, ULONG ip_address);

void rip_debugger (void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	char *ptr_to_string;
   USHORT port_number ;
	IP_CLASS *sptr_ip = &ip; 

	printf ("\n\tIP routing table..........\n");
   /* printf ("\n  | xxx.xxx.xxx.xxx | xxx.xxx.xxx.xxx |  xxx   | xxx  | xxx.xxx.xxx.xxx |") ; */
   printf ("\n  ͻ") ;
   printf ("\n       TARGET           GATEWAY      METRIC  PORT    SUBNET MASK   ") ;
   printf ("\n  ͹") ;

	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_ip->route_list);

	while (sptr_route_entry != NULL)
	{
		ptr_to_string = &sptr_ip->string_to_print[0];

		convert_ip_address_to_dot_format (&sptr_ip->print_buffer[0], sptr_route_entry->target);

		convert_ip_address_to_dot_format (&sptr_ip->print_buffer_2[0], sptr_route_entry->gateway);
		convert_ip_address_to_dot_format (&sptr_ip->print_buffer_3[0], sptr_route_entry->mask);

		ptr_to_string += sprintf (ptr_to_string, "\n   %-15s  %-15s   %03u    %03u   %-15s ",
			&sptr_ip->print_buffer[0], &sptr_ip->print_buffer_2[0], sptr_route_entry->metric, sptr_route_entry->port_number, &sptr_ip->print_buffer_3[0]) ;

		printf (&sptr_ip->string_to_print[0]);

		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
	}

   printf ("\n  ͼ") ;
   /* printf ("\n  |-----------------|-----------------|--------|------|-----------------|") ; */

	printf ("\n\tPort Parameters..........\n");
   for (port_number = 0 ; port_number < sptr_ip->number_of_ports ; port_number++)
      printf ("\tPort Number %04X : Status : %s, MTU : %04d\n",
         port_number, sptr_ip->port[port_number].port_is_up ? "  UP" : "DOWN",
         sptr_ip->port[port_number].config.mtu) ;
}

/* Jo 11/08/99 Added rip debugger */
#endif


