#include	"defs.h"


/*
 * $Log: /IP/IPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iprx.c$  $version: 1.16$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/09/94 yarran fix reassembly bug
1.4 02/22/94 yarran Fix i960 compiler error for header.vptr_data casting
1.5 02/28/94 yarran Change route, port flags from bit map to enum BOOLEAN.
1.6 03/01/94 yarran Split iprx.c to multiple files.
1.7 03/17/94 yarran Change type_of_service type.
1.8 05/02/94 yarran added rfc1042 changes.
1.9 07/06/94 ross fixed time to live bug with count of one.
1.10 09/22/94 ross
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 11/04/94 ross remote access testing and fixes.
1.13 12/20/94 ross
1.14 01/17/95 ross fixed arp problems from snmp
1.15 06/29/95 ross new snmp access routine
1.16 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include "ip.h"


/****************************************************************************/
static enum BOOLEAN is_received_packet_recognized (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet,
	LSL_IP_HEADER *sptr_lsl_packet, enum IP_PACKET_STATE *eptr_return_code);
enum IP_PACKET_STATE route_ip_rx_packet (USHORT rx_port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT number_of_bytes_rxed);
static enum TEST verify_ip_rx_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port, IP_ROUTE_ENTRY **sptr_route_entry, enum BOOLEAN *eptr_source_route_flag,
	enum BOOLEAN *eptr_need_new_checksum, enum BOOLEAN *eptr_change_ip_destination_for_source_route,
	USHORT *usptr_processed_option_length, USHORT *usptr_number_of_bytes_rxed);
static enum BOOLEAN check_if_ip_packet_length_and_header_length_and_checksum_are_valid (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes_rxed, IP_PORT_CLASS *sptr_incoming_port);
static enum BOOLEAN check_if_ip_version_is_valid (IP_PARAMETERS *sptr_ip_parameters);
static void	send_icmp_source_quench_message_if_memory_is_low (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port);
static void	adjust_number_of_bytes_received_and_initialize_certain_fields (IP_PARAMETERS *sptr_ip_parameters,
	USHORT *usptr_number_of_bytes_rxed, enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route);
enum BOOLEAN check_if_packet_is_destined_to_us (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters);
static enum BOOLEAN check_if_ip_rx_packet_is_to_be_forwarded (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length);

/*	Kamalnath 12\02\1997 Removed static to call from iprxbc.c */
enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length);
/* Kamalnath 12\02\1997 */
/*
static enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length);
*/
static enum TEST get_route_on_which_to_forward_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length);
static void	send_redirect_icmp_if_necessary (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY *sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port);

#ifdef __IP_DEBUG__
static void print_rxed_mac_header (LSL_IP_HEADER *sptr_lsl_header);
#endif /* __IP__DEBUG__ */

/* 07/07/99 Jo added for Static routes */
extern enum BOOLEAN check_if_packet_is_destined_to_configured_static_routes (ULONG destination_address, IP_ROUTE_ENTRY **route_entry_ptr) ;
extern void send_icmp_redirect_message (USHORT port_number, IP_ROUTE_ENTRY *sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port,
	IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet) ;

/* sudhir 11//7/97 for proxy  */
extern enum BOOLEAN check_if_packet_is_to_be_proxied (UNION_IP_PACKET *, IP_PARAMETERS *, enum BOOLEAN *, USHORT*, void **, enum BOOLEAN *eptr_size_modified);
extern void process_proxy_ip_packet (UNION_IP_PACKET *, IP_PARAMETERS *, BYTE *, enum BOOLEAN);
extern enum BOOLEAN check_if_packet_is_meant_for_our_remote_address (ULONG destination_address, USHORT *outgoing_port_number);

extern enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *,
	IP_PARAMETERS *, USHORT *, enum BOOLEAN *, enum BOOLEAN *);

void set_tcp_checksum (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT checksum); /* sudha 20 Nov 1998 */


/* sudhir 11//7/97 for proxy  */

/****************************************************************************/



/* sachin 1/1/98 */
#if TCP_CSUM_DEBUG
ULONG tcp_checksum_failed_packets = 0 ;
extern void tcp_checksum (ULONG source_address, ULONG destination_address, BYTE *packet, USHORT packet_length) ;
extern USHORT ip_get_outgoing_port_number_from_ip_address (ULONG destination_ip_address);

BYTE temp_tcp_buffer[3000] ;

void bad_tcp_packet_received ()
{
	return;
}

enum BOOLEAN debug_verify_tcp_checksum (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet)
{
   USHORT computed_checksum, actual_checksum ;

   if (sptr_ip_parameters->protocol != TCP_PROTOCOL)
      return (TRUE) ;

   memcpy (&temp_tcp_buffer[0], (BYTE *)(&uptr_ip_rx_packet->ip.header) + sptr_ip_parameters->header_length,
      sptr_ip_parameters->total_length - sptr_ip_parameters->header_length) ;

   actual_checksum = *((USHORT *)&temp_tcp_buffer[16]) ;

   tcp_checksum (sptr_ip_parameters->source_address, sptr_ip_parameters->destination_address,
      &temp_tcp_buffer[0], sptr_ip_parameters->total_length  - sptr_ip_parameters->header_length) ;

   computed_checksum = *((USHORT *)&temp_tcp_buffer[16]) ;

   if (actual_checksum == computed_checksum)
      return (TRUE) ;
   else
	{
		bad_tcp_packet_received ();	
		set_tcp_checksum (uptr_ip_rx_packet,sptr_ip_parameters,0);
      return (FALSE) ;
	}
}
#endif
/* sachin 1/1/98 */


enum RX_PACKET_STATE ip_router_rx_packet (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet)
{
	enum IP_PACKET_STATE return_code;
	LSL_IP_HEADER *sptr_lsl_packet;

#ifdef __IP_BREAKPOINT__
	check_for_ip_runtime_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	sptr_lsl_packet = (LSL_IP_HEADER *) ((ULONG) uptr_ip_rx_packet - sizeof (USHORT_ENUM (SNAP_PROTOCOL_ID)));

	switch (sptr_lsl_packet->lsl_packet_type)
		{
		case RAW_8023:
		case LLC_PACKET:

			/* illegal types for IP */

			return (PACKET_NOT_RECOGNIZED);

		case ETHERNET_TYPE_II:
		case SNAP_PACKET:
			
			if (ip.port[port_number].config.port_enabled == FALSE)
			{
				++ip.port[port_number].statistics.number_of_packets_rxed_on_disabled_port;
#if 0
				switch (((LSL_IP_HEADER *)sptr_lsl_packet)->protocol_type)
				{
					case (SNAP_IP_RARP_PACKET) :
					case (SNAP_IP_ARP_PACKET) :
					case (SNAP_IP_PACKET) :
						return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED) ;

					default :
						return (PACKET_NOT_RECOGNIZED) ;
				}
#endif
				return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
/*				return (PACKET_NOT_RECOGNIZED);*/
			}

			if (is_received_packet_recognized (port_number, uptr_ip_rx_packet, size_of_packet, sptr_lsl_packet, &return_code)
				== FALSE)
				{
				return (PACKET_NOT_RECOGNIZED);
				}

			break;

		default:

			return (PACKET_NOT_RECOGNIZED);
		}

	if (return_code == IP_DATA_PACKET_RXED_AND_WAS_FORWARDED)
		{
		return (PACKET_RECOGNIZED_AND_FORWARDED);
		}
	else
		{
		++ip.port[port_number].statistics.number_of_packets_not_forwarded;

		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
}
/****************************************************************************/
static enum BOOLEAN is_received_packet_recognized (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet,
	LSL_IP_HEADER *sptr_lsl_packet_header, enum IP_PACKET_STATE *eptr_return_code)
{
	switch (sptr_lsl_packet_header->protocol_type)
		{
		case SNAP_IP_RARP_PACKET:

			++ip.port[port_number].statistics.number_of_rarp_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = rarp_packet_received (port_number, &uptr_ip_rx_packet->rarp, size_of_packet);

			break;

		case SNAP_IP_PACKET:

			++ip.port[port_number].statistics.number_of_ip_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = route_ip_rx_packet (port_number, uptr_ip_rx_packet, size_of_packet);

			break;

		case SNAP_IP_ARP_PACKET:

			++ip.port[port_number].statistics.number_of_arp_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = arp_packet_received (port_number, &uptr_ip_rx_packet->arp, size_of_packet);

			break;

		default:

			++ip.port[port_number].statistics.number_of_non_ip_packets_rxed;

			return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/

void my_debug_func ()
{
}

enum IP_PACKET_STATE route_ip_rx_packet (USHORT rx_port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT number_of_bytes_rxed)
{
	enum BOOLEAN change_ip_destination_for_source_route;
	enum FORWARD_STATUS  forward_return_code;
	enum BOOLEAN source_route_flag;
	enum BOOLEAN need_new_checksum;
	USHORT processed_option_length, dest_port ;
	IP_PARAMETERS ip_parameters;
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PORT_CLASS *sptr_incoming_port;
	enum IP_PACKET_STATE return_value;

/* sudhir 11/7/97 for proxy server */
	USHORT outgoing_port_number=0;
	enum BOOLEAN abort_forwarding=FALSE;
	void *proxy_server_info;
	int old_length, old_pkt_length ;
	enum BOOLEAN size_modified, pkt_size_modified = FALSE, is_my_packet=FALSE;
	ULONG subnet_mask, gateway_address = 0;

	++ip.mib.ipInReceives;

	sptr_incoming_port = &ip.port[rx_port_number];

	ip_parameters.rx_port_number = rx_port_number;

	sptr_route_entry = NULL;

	if (verify_ip_rx_packet (&ip_parameters, uptr_ip_rx_packet, sptr_incoming_port, &sptr_route_entry, &source_route_flag,
		&need_new_checksum, &change_ip_destination_for_source_route, &processed_option_length, &number_of_bytes_rxed) == FAIL)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}
	
#ifdef __IP_DEBUG__
	print_rxed_ip_header (&uptr_ip_rx_packet->ip.header, rx_port_number);
#endif /* __IP__DEBUG__ */

	if (check_if_packet_is_destined_to_us (rx_port_number, uptr_ip_rx_packet, &ip_parameters) == TRUE)  
	{
#if 0
		if (ip.port[rx_port_number].routing_status == PROXY_PORT)
		{
/* sudhir 2/2/98 */
			if (check_and_process_the_packets_to_or_from_internet_servers (uptr_ip_rx_packet,
					&ip_parameters, &outgoing_port_number, &is_my_packet, &pkt_size_modified) == TRUE)
			{
/*				printf ("VSERVER: Processing Packets meant for servers on %d\n",rx_port_number); */
				forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
					change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number);

				if (forward_return_code == FORWARD_OK)
				{
					return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
				}
				else
				{
					return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
				}													

#if 0
				return_value = pass_ip_packet_to_upper_layer (rx_port_number, &ip_parameters,uptr_ip_rx_packet, number_of_bytes_rxed);
				return return_value;
#endif
			}
/* sudhir 2/2/98 */
		}
#endif
		return_value = pass_ip_packet_to_upper_layer (rx_port_number, &ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed);

/* sudha 19 May 1999.Fix taken from firewall.
if packet is a proxy response packet & forwarded, we can return directly 
from here. */
		if ( return_value == IP_DATA_PACKET_RXED_AND_WAS_FORWARDED )
			return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);

/* else continue with the packet. sudha 19 May 1999 */

		/* Kamalnath 07\02\1997 */
		if (check_if_packet_is_a_broadcast (&ip_parameters, rx_port_number) == TRUE)
		{
			put_ip_packet_on_all_the_concerned_ports(&ip_parameters, rx_port_number, uptr_ip_rx_packet, number_of_bytes_rxed, 
					need_new_checksum, processed_option_length);
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
		/* Kamalnath 07\02\1997 */

		if (check_if_packet_is_to_be_forwarded_onto_a_directly_attached_network (rx_port_number, uptr_ip_rx_packet) == FALSE)
		{
			return (return_value);
		}
	}


#if TCP_CSUM_DEBUG
   if (debug_verify_tcp_checksum (&ip_parameters, uptr_ip_rx_packet) == FALSE)
   {
		if (ip_parameters.more_fragment_flag == FALSE)
		{
      	printf ("TCP Packet (from %s to %s, id : %04X) failed checksum validation\n",
         	convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_parameters.source_address),
         	convert_ip_address_to_dot_format (&ip.print_buffer_2[0], ip_parameters.destination_address),
				ip_parameters.id) ;
      	tcp_checksum_failed_packets++ ;
		}
   }
#endif

/* sudha moved this block here for nat ftp, web to function properly in case
if proxy any application is enabled.Fix taken from Sir.2 April 1999... */

/* sudhir 19/1/98 */

#ifdef __PROXY_SERVER_  
	old_pkt_length = ip_parameters.total_length;
	if (check_and_process_the_packets_to_or_from_internet_servers (uptr_ip_rx_packet,
			&ip_parameters, &outgoing_port_number, &is_my_packet, &pkt_size_modified) == TRUE)
	{
/*		printf ("Forwarding packets meant for internet Port %04x\n", outgoing_port_number); */
		
		if(pkt_size_modified)
			number_of_bytes_rxed += (ip_parameters.total_length - old_pkt_length) ;

/* 07/07/99 Jo added for Static routes */
		if (check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, &sptr_route_entry) == TRUE)
		{
			outgoing_port_number = NO_SUCH_PORT ;	
			forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
				change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, sptr_route_entry->gateway) ;

			if (forward_return_code == FORWARD_OK)
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED) ;
			else
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED) ; 
		}
		else
		{
/* 07/07/99 Jo added for Static routes */
			forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
				change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, gateway_address);

			if (forward_return_code == FORWARD_OK)
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			}
			else
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}													
		}
	}
#endif
/* ...sudha moved this block here for nat ftp, web to function properly in case
if proxy any application is enabled.Fix taken from Sir.2 April 1999 */

	if (ip.port[rx_port_number].routing_status == ROUTING_PORT )
	{
		subnet_mask = ip.port[rx_port_number].config.subnetmask ;
		if ((subnet_mask & ip.port[rx_port_number].config.ip_address) == 
			(subnet_mask & ip_parameters.destination_address))				
		{
			if (check_if_packet_is_meant_for_our_remote_address (ip_parameters.destination_address, &outgoing_port_number) == TRUE)
 			{
				my_debug_func ();
				forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
				change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, gateway_address);
				if (forward_return_code == FORWARD_OK)
					return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
				else
					return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
			else
			{
				outgoing_port_number = ip_get_outgoing_port_number_from_ip_address (ip_parameters.destination_address);
				if (outgoing_port_number != NO_SUCH_PORT)
				{
					forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
						change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, gateway_address);
					if (forward_return_code == FORWARD_OK)
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
					else
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
				}
			}
		}
		else
		{

/* 10/08/99 Jo added for Static routes */
			if (check_if_packet_is_destined_to_configured_static_routes (ip_parameters.destination_address, &sptr_route_entry) == TRUE)	
			{
				if (sptr_route_entry->port_number == 0)
				{
/* Jo 12/08/99 Added for ICMP Redirect */
					uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1 ;
					send_icmp_redirect_message (rx_port_number, sptr_route_entry, sptr_incoming_port, &ip_parameters,
						uptr_ip_rx_packet) ;
					uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1 ;
/* Jo 12/08/99 Added for ICMP Redirect */

					forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
						change_ip_destination_for_source_route, number_of_bytes_rxed, sptr_route_entry->port_number, sptr_route_entry->gateway) ;
					if (forward_return_code == FORWARD_OK)
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED) ;
					else
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED) ; 
				}
			}
/* 10/08/99 Jo added for Static routes */

			if (check_if_packet_is_to_be_proxied (uptr_ip_rx_packet, &ip_parameters, &abort_forwarding,
				&outgoing_port_number,&proxy_server_info, &size_modified) == TRUE)
			{
			/* This is necessary in case we happen to do something that could
				change the packet size */
				old_length = ip_parameters.total_length ;
				process_proxy_ip_packet (uptr_ip_rx_packet, &ip_parameters, proxy_server_info, size_modified);
				if (size_modified)
					number_of_bytes_rxed += (ip_parameters.total_length - old_length) ;
/* sudhir 1/1/98 
		This flag is used at a later stage to determine wheather the buffer
		is freed by device driver. Most of the cases the default value will
		be FALSE. Some cases it is TRUE. In that case buffer won't be freed.
		This will cause ethernet device driver buffer leakage. So we need to 
		make this flag FALSE here
*/
				ip_parameters.union_ip_packet_is_to_be_freed = FALSE;

				forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
						change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, gateway_address);
				
				if (forward_return_code == FORWARD_OK)
					return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
				else
					return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
			else if (abort_forwarding)
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
		}
	}


	if (check_if_ip_rx_packet_is_to_be_forwarded (rx_port_number, &ip_parameters, uptr_ip_rx_packet, &sptr_route_entry,
		source_route_flag, sptr_incoming_port, processed_option_length) == TRUE)
		{
		forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, need_new_checksum,
			change_ip_destination_for_source_route, number_of_bytes_rxed, NO_SUCH_PORT, gateway_address);

		if (forward_return_code == FORWARD_OK)
			{
			return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			}
		else
			{
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
		}
	else
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
}
/****************************************************************************/
static enum TEST verify_ip_rx_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN *eptr_source_route_flag,
	enum BOOLEAN *eptr_need_new_checksum, enum BOOLEAN *eptr_change_ip_destination_for_source_route,
	USHORT *usptr_processed_option_length, USHORT *usptr_number_of_bytes_rxed)
{
	enum TEST return_code;

	if (check_if_ip_packet_length_and_header_length_and_checksum_are_valid (sptr_ip_parameters, sptr_ip_packet,
		usptr_number_of_bytes_rxed, sptr_incoming_port) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	extract_ip_header (sptr_ip_parameters, &sptr_ip_packet->ip.header, sptr_ip_parameters->header_length);

	if (check_if_ip_version_is_valid (sptr_ip_parameters) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_check_if_destination_address_is_valid (sptr_ip_parameters->destination_address) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet to --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_check_if_source_address_is_valid (sptr_ip_parameters->source_address, sptr_ip_parameters->rx_port_number) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet from <-- %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_rx_filter (sptr_incoming_port, sptr_ip_packet) == TRUE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: filtered packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		++sptr_incoming_port->statistics.number_of_rxed_packets_filtered;

		return (FAIL);
		}

	send_icmp_source_quench_message_if_memory_is_low (sptr_ip_parameters, sptr_ip_packet, sptr_incoming_port);

	adjust_number_of_bytes_received_and_initialize_certain_fields (sptr_ip_parameters, usptr_number_of_bytes_rxed,
		eptr_source_route_flag, eptr_need_new_checksum, eptr_change_ip_destination_for_source_route);

	return_code = process_ip_options (sptr_ip_packet, sptr_ip_parameters, eptr_source_route_flag, eptr_need_new_checksum,
		ptr_to_sptr_route_entry, usptr_processed_option_length, eptr_change_ip_destination_for_source_route);

	return (return_code);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_packet_length_and_header_length_and_checksum_are_valid (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes_rxed, IP_PORT_CLASS *sptr_incoming_port)
{
	if (*usptr_number_of_bytes_rxed < MINIMUM_IP_HEADER_LENGTH)
		{
		++sptr_incoming_port->statistics.number_of_short_ip_packets_received;

		return (FALSE);
		}

	sptr_ip_parameters->header_length = (USHORT) (sptr_ip_packet->ip.header.version_header_length.header_length << 2);

	if (sptr_ip_parameters->header_length < MINIMUM_IP_HEADER_LENGTH)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed packet with short header (from port %d) is discarded\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	sptr_ip_parameters->total_length = sptr_ip_packet->ip.header.total_length;

	if (sptr_ip_parameters->total_length < sptr_ip_parameters->header_length)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed packet with short header (from port %d) is discarded\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	if (calculate_ip_checksum (NULL, (BYTE *) &sptr_ip_packet->ip.header, sptr_ip_parameters->header_length) != 0x0000)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed bad header checksum from port %d\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_version_is_valid (IP_PARAMETERS *sptr_ip_parameters)
{
	if (sptr_ip_parameters->version != IP_VERSION)		/* wrong version of IP */
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed bad version from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static void	send_icmp_source_quench_message_if_memory_is_low (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port)
{
	/* if running low on memory, return an ICMP source quench message */

	if (memory_is_low () == TRUE)
		{
		send_icmp_error_packet (sptr_incoming_port->config.virtual_port_number, sptr_ip_parameters, sptr_ip_packet,
			ICMP_SOURCE_QUENCH_TYPE, 0, NULL);
		}
}
/****************************************************************************/
static void	adjust_number_of_bytes_received_and_initialize_certain_fields (IP_PARAMETERS *sptr_ip_parameters,
	USHORT *usptr_number_of_bytes_rxed, enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route)
{
	/* adjust byte_count because the actual ip data may be shorter than what is received from the network.*/

	*usptr_number_of_bytes_rxed = (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER));

	*eptr_source_route_flag = FALSE;
	*eptr_need_new_checksum = FALSE;
	*eptr_change_ip_destination_for_source_route = FALSE;

	ip.source_route_working_area.number_of_hops_in_source_route = 0x0000;
}
/****************************************************************************/
enum BOOLEAN check_if_packet_is_destined_to_us (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT port_index;
	IP_PORT_CLASS *sptr_port;
	ULONG destination_address;
	enum BOOLEAN broadcast_from_interface;

	destination_address = sptr_ip_parameters->destination_address;

	if ((destination_address == INTERNET_ADDRESS_BROADCAST) || (destination_address == INTERNET_ADDRESS_ANY))
		{
		return (TRUE);
   	}

	broadcast_from_interface = received_broadcast_from_interface (port_number, uptr_ip_rx_packet);

	if (broadcast_from_interface == TRUE)
		{
		return (TRUE);
   	}

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		if (ip.port[port_index].config.port_enabled == TRUE)
			{
			sptr_port = &ip.port[port_index];

			if (sptr_port->config.ip_address == destination_address)
				{
				return (TRUE);
		   	}

			if ((sptr_port->subnet_broadcast_address == destination_address) ||
				(sptr_port->net_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->subnet_address) || (destination_address == sptr_port->net_address))
				{
				return (TRUE);
				}
			}
		}

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_rx_packet_is_to_be_forwarded (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length)
{
	if (ip.mib.ipForwarding == (BYTE) FALSE)
		{
		return (FALSE);
		}

	if (check_if_time_to_live_field_in_ip_packet_is_valid (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
		processed_option_length) == FALSE)
		{
		return (FALSE);
		}

	if (get_route_on_which_to_forward_packet (sptr_ip_parameters, uptr_ip_rx_packet, ptr_to_sptr_route_entry, sptr_incoming_port,
		processed_option_length) == FAIL)
		{
		return (FALSE);
		}

	send_redirect_icmp_if_necessary (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet, *ptr_to_sptr_route_entry,
		source_route_flag, sptr_incoming_port);

	return (TRUE);
}
/****************************************************************************/
enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length)
{
	UNION_ICMP_PARAMETER icmp_parameter;

	uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1;

	if ((uptr_ip_rx_packet->ip.header.time_to_live == 0x00) &&
		(check_if_packet_is_destined_to_us (rx_port_number, uptr_ip_rx_packet, sptr_ip_parameters) == FALSE))
		{
		++ip.mib.ipInHdrErrors;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet due to time-to-live from %s to %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1 ;
		/*
			Set the ttl value back to what it originally was. It is required to
			have the image of the header in the packet that is being sent, exactly
			as it was received. This change was made in response to the problem
			with PCTCP's trace that was reported from Bombay.
		*/
/* Sachin 07/10/1996 */

		send_icmp_error_packet (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet, ICMP_TIME_EXCEEDED_TYPE,
			ICMP_TTL_EXCEEDED_CODE, &icmp_parameter);

/* Sachin 07/10/1996 */
		/* Restore the ttl value */
		uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1 ;
/* Sachin 07/10/1996 */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST get_route_on_which_to_forward_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length)
{
	UNION_ICMP_PARAMETER icmp_parameter;
	ULONG type_of_service;

	if (*ptr_to_sptr_route_entry == NULL)
		{
		/* route has not been determined by the source route option */

		type_of_service = (ULONG) 0x01;

		*ptr_to_sptr_route_entry = ip_find_route_and_update_cache (sptr_ip_parameters->destination_address, type_of_service);

		if (*ptr_to_sptr_route_entry == NULL)
			{
			/* this is not good */

			++ip.mib.ipOutNoRoutes;

			icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1 ;
/* Sachin 07/10/1996 */
			send_icmp_error_packet (sptr_incoming_port->config.virtual_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
				ICMP_DESTINATION_UNREACHABLE_TYPE, ICMP_HOST_UNREACHABLE_CODE, &icmp_parameter);
/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1 ;
/* Sachin 07/10/1996 */

			return (FAIL);
			}
		else
			{
			++((*ptr_to_sptr_route_entry)->use_count);
			}

		}

	return (PASS);
}
/****************************************************************************/
static void	send_redirect_icmp_if_necessary (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY *sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port)
{
	/* check if redirect icmp should be sent: If outgoing port is the same as the incoming port,
	 * send a ICMP redirect to the sender but with the following conditions:
	 * 	- sender is on the directly connected networks
	 * 	- the packet was not source routed (or has any options)
	 *		- forwarding does not use a default route or a route modified by a redirect. */

	if ((sptr_incoming_port->config.virtual_port_number == sptr_route_entry->port_number) &&
		(source_route_flag == FALSE) && (sptr_incoming_port->config.icmp_redirect_enabled == TRUE) &&
		((sptr_ip_parameters->source_address & sptr_incoming_port->config.subnetmask) == sptr_incoming_port->subnet_address))
	{
/* Sachin 17/06/1996 */
/*
		if ((remote_access_enabled_for_lan (sptr_route_entry->port_number) == FALSE) &&
			(ip.port[sptr_route_entry->port_number].config.proxy_arp_enabled == FALSE))
*/
/* Sachin 17/06/1996 */
		{
			if (sptr_route_entry != &ip.default_route)
			{
				/* By now we have decremented the ttl feild. Increment it and
				   restore it. Just give the send_icmp_redirect_message()
					as we received it. But do not forget to restore the value bacause
					the checksum is computed for the decremented ttl.
				*/
				uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1;
				send_icmp_redirect_message (rx_port_number, sptr_route_entry, sptr_incoming_port, sptr_ip_parameters,
					uptr_ip_rx_packet);
				uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1;
			}
		}
	}
}
#ifdef __IP_DEBUG__
/****************************************************************************/
static void print_rxed_mac_header (LSL_IP_HEADER *sptr_lsl_header)
{
	ip_printf (IP_RX_PRINTF, "IP: rxed packet mac %8x:%4x --> mac %8x:%4x\n",
		net_to_host_long (sptr_lsl_header->source_address._ulong),
		net_to_host_short (sptr_lsl_header->source_address._ushort),
		net_to_host_long (sptr_lsl_header->destination_address._ulong),
		net_to_host_short (sptr_lsl_header->destination_address._ushort));
}
#endif /* __IP__DEBUG__ */
