#include	"defs.h"
/*
 * $Log: /IP/IPRXASSM.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iprxassm.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
* Modifications : 
* { sudha 28-Oct-1999. Taken from firewall, support for DNS in 
*	 pass_ip_packet_to_upper_layer(), included few dns header files, function
*	 prototypes }
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "ip.h"
#include "kip.h" 
/* sudha 28-Oct-1999... */
#include "dns.h"
#include "kdns.h"
#include "vdnsstr.h"
/* ...sudha 28-Oct-1999 */

/****************************************************************************/
extern void receive_tcp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters, BYTE *uptr_ip_rx_packet,
			USHORT pkt_length);
enum BOOLEAN check_if_protocol_to_which_packet_is_destined_is_supported (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet);
enum BOOLEAN check_if_packet_has_any_data (USHORT number_of_bytes_rxed, IP_PARAMETERS *sptr_ip_parameters);
enum TEST reassemble_packet_if_necessary (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet, USHORT number_of_bytes_rxed, USHORT last_byte_offset_of_current_packet);
enum ASSEMBLY_RESULT assemble_ip_fragment (UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters, USHORT last_byte_offset_of_current_packet, USHORT number_of_bytes_rxed);
enum TEST find_matching_reassembly_control_block_or_create_new_one (IP_PARAMETERS *sptr_ip_parameters,
	REASSEMBLY **ptr_to_sptr_reassembly);
REASSEMBLY *find_matching_reassembly_block (IP_PARAMETERS *sptr_ip_parameters);
REASSEMBLY *create_reassembly (IP_PARAMETERS *sptr_ip_parameters);
void pass_packet_to_receive_routine_of_one_of_the_upper_transport_layer_protocols (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT last_byte_offset_of_current_packet);

extern enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *,
	IP_PARAMETERS *, USHORT *, enum BOOLEAN *, enum BOOLEAN *);

/* 07/07/99 Jo added for Static routes */
extern enum BOOLEAN check_if_packet_is_destined_to_configured_static_routes (ULONG destination_address, IP_ROUTE_ENTRY **route_entry_ptr) ;

#ifdef __IP_DEBUG__
void	print_reassembly_list (REASSEMBLY *sptr_reassembly);
#endif /* __IP__DEBUG__ */



/* sachin 1/1/98 */
		
#if TCP_CSUM_DEBUG
extern enum BOOLEAN debug_verify_tcp_checksum (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet) ;
extern ULONG tcp_checksum_failed_packets ;
#endif
/* sachin 1/1/98 */


extern enum BOOLEAN is_proxy_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		ULONG *client_ip_address, USHORT *destination_port, USHORT *outgoing_physical_port, void **proxy_info);

/* sudha 14 sep 1998 */
extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern BYTE *get_ptr_to_dns_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern BYTE *get_domain_name_from_dns_query_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_length_of_dns_reply_pkt (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN check_if_dns_pkt_has_any_reply(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_send_id_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);

extern void send_completion_udp_packet (USHORT port_number, UNION_IP_PACKET *sptr_udp_tx_packet);
extern void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT length, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet));
extern BYTE *get_dns_response_from_local_cache_if_any ( BYTE *domain_name, USHORT *data_len, USHORT dns_id);

extern enum BOOLEAN process_dns_response_and_store_in_local_cache ( BYTE *ptr_to_dns_pkt, BYTE *domain_name, USHORT dns_len );
extern enum BOOLEAN check_if_packet_is_to_be_proxied (UNION_IP_PACKET *, IP_PARAMETERS *, enum BOOLEAN *, USHORT*, void **, enum BOOLEAN *eptr_size_modified);
extern void process_proxy_ip_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	   BYTE *proxy_server_info, enum BOOLEAN ftp_port_command);
extern void process_proxy_response_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	  USHORT destination_port, ULONG client_ip_address, BYTE *proxy_server_info);

/* sudha 14 sep 1998 */

/* Sudha 07 Nov 1998 */
enum BOOLEAN is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
enum BOOLEAN is_proxy_lan_addr ( ULONG lan_addr ) ;
/* Sudha 07 Nov 1998 */

/* sudha 28-Oct-1999 */
extern HEADER *get_dns_header_from_rxed_packet (BYTE *in_buff);

/****************************************************************************/
enum IP_PACKET_STATE pass_ip_packet_to_upper_layer (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT number_of_bytes_rxed)
{
	USHORT last_byte_offset_of_current_packet;

/* sudhir 11/7/97 for proxy server */
	USHORT outgoing_port_number=0;
	USHORT destination_port=0, dest_port=0, src_port=0, dns_len=0 ;
	ULONG client_ip_address=0, gateway_address=0;
	void *proxy_server_info;
	enum FORWARD_STATUS  forward_return_code;
	enum BOOLEAN packet_meant_for_our_server = FALSE;
	BYTE *dns_pkt_ptr , *name ;   
	USHORT qdcnt=0, dns_id=0, data_len=0;
	BYTE *dns_response_ptr ;
	enum BOOLEAN abort_forwarding=FALSE;
	enum BOOLEAN size_modified, pkt_size_modified = FALSE ;
	int old_length, old_pkt_length ;
	IP_ROUTE_ENTRY *sptr_route_entry;

/* sudha 28-Oct-1999... */	
	HEADER *dns_header;
	enum BOOLEAN dns_response_packet = FALSE;
/* ...sudha 28-Oct-1999 */	

	if (check_if_protocol_to_which_packet_is_destined_is_supported (sptr_ip_parameters, uptr_ip_rx_packet) == FALSE)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

	++ip.mib.ipInDelivers;

	if (check_if_packet_has_any_data (number_of_bytes_rxed, sptr_ip_parameters) == FALSE)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

	last_byte_offset_of_current_packet = (USHORT) (sptr_ip_parameters->offset + sptr_ip_parameters->total_length -
		sptr_ip_parameters->header_length - 1);

#if 0
/*	fix taken from sir for small proxy for the problem of in need buffer.05 May 1999. */
#endif

	if (reassemble_packet_if_necessary (sptr_ip_parameters, &uptr_ip_rx_packet, number_of_bytes_rxed,
		last_byte_offset_of_current_packet) == FAIL)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		} 

/* Sudha 07 Nov 1998 */
/* First checking whether udp dns query packet has proxy's lan addr as dns
server addr. If so, see whether any matching entry is there in
proxy's dns cache for client's request.If yes, send the response to the
client.Else proxy the dns query of client to dns server addr configured
for proxy & send the response back to client as got from the dns server. */

		if ( is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server(uptr_ip_rx_packet, sptr_ip_parameters ) == TRUE )
		{
#if __Sudha__
printf("\n\rIPRXASSM : dns query pkt destined to proxy lan is true.");
#endif
			dns_pkt_ptr = get_ptr_to_dns_packet ( uptr_ip_rx_packet, sptr_ip_parameters ) ;
			name = get_domain_name_from_dns_query_packet ( uptr_ip_rx_packet,sptr_ip_parameters ) ;
#if __Sudha__
printf("\n\rIPRXASSM : DNS query name is %s", name );
#endif
			qdcnt = get_quest_count_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);
#if __Sudha__
printf("\n\rIPRXASSM : qdcnt is %d",qdcnt );
#endif
			dns_id = get_send_id_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);
#if __Sudha__
printf("\n\rIPRXASSM : dns query id is %d",dns_id );
#endif

/* Processing dns query pkt only if question count is 1.Else proxy the pkt
directly to the dns server addr configured for proxy. */

			if ( qdcnt == 1 ) 
			{
				dns_response_ptr = get_dns_response_from_local_cache_if_any(name, &data_len, dns_id);
				if ( dns_response_ptr != NULL ) 
				{
					get_dns_response_packet(uptr_ip_rx_packet, sptr_ip_parameters, dns_response_ptr, 
						data_len,(void (*) (USHORT port_number, void *vptr_tx_packet)) send_completion_udp_packet );
#if __Sudha__
printf("n\rPROXY : after get dns response");
#endif
					free ( dns_response_ptr );
				   return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED); 
				}
			}	

			if ( qdcnt > 1 || dns_response_ptr == NULL )
			{
#if __Sudha__
printf("\n\rIPRXASSM : Inside qdcnt > 1 || dns_response_ptr == NULL.");
#endif
				if (check_if_packet_is_to_be_proxied (uptr_ip_rx_packet, sptr_ip_parameters, &abort_forwarding,
					&outgoing_port_number,&proxy_server_info, &size_modified) == TRUE)
				{
				/* This is necessary in case we happen to do something that could
					change the packet size */
					old_length = sptr_ip_parameters->total_length ;
					process_proxy_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, proxy_server_info, size_modified);
					if (size_modified)
						number_of_bytes_rxed += (sptr_ip_parameters->total_length - old_length) ;
/* sudhir 1/1/98 
			This flag is used at a later stage to determine wheather the buffer
			is freed by device driver. Most of the cases the default value will
			be FALSE. Some cases it is TRUE. In that case buffer won't be freed.
			This will cause ethernet device driver buffer leakage. So we need to 
			make this flag FALSE here
*/
					sptr_ip_parameters->union_ip_packet_is_to_be_freed = FALSE;
			
					forward_return_code = forward_ip_packet (sptr_ip_parameters, uptr_ip_rx_packet, TRUE,
							FALSE, number_of_bytes_rxed, outgoing_port_number, gateway_address);
				
					if (forward_return_code == FORWARD_OK)
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
					else
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
				}
				else if (abort_forwarding)
				{
					return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
				}
			}
		}
/* Sudha 07 Nov 1998 .For DNS caching */

   	if (is_proxy_response_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &client_ip_address, 
	   		&destination_port, &outgoing_port_number, &proxy_server_info) == TRUE)
	   {
/* sachin 1/1/98 
	This is to verify the csum of the packet received. In case a packet with
	a wrong csum is received it will be forwarded with a new tcp csum of value 0 
	*/
#if TCP_CSUM_DEBUG
	   	if (debug_verify_tcp_checksum (sptr_ip_parameters, uptr_ip_rx_packet) == FALSE)
   		{
      		printf ("TCP Packet (from %s to %s, id : %04X) failed checksum validation\n",
         		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
         	convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address),
				sptr_ip_parameters->id) ;
      		tcp_checksum_failed_packets++ ;
   		}
#endif

		   process_proxy_response_packet (uptr_ip_rx_packet, sptr_ip_parameters, 
			   destination_port, client_ip_address, proxy_server_info);
#if 0
		printf ("Forward response packet of length %d to %04X\n", number_of_bytes_rxed, outgoing_port_number);
#endif
			if (outgoing_port_number > 4)
			{
				while (1)
					printf ("Outgoing Port number is %04x\n",outgoing_port_number);
			}

/* sudha 10 Sep 1998 
For DNS Caching.Checking whether source port is DNS (53).
If so update in local dns cache .*/

			if ( sptr_ip_parameters->protocol == IP_UDP_PROTOCOL ) 
				dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 
			if (src_port == DNS_PORT_NUMBER) 
			{
				dns_pkt_ptr = get_ptr_to_dns_packet ( uptr_ip_rx_packet, sptr_ip_parameters ) ;
				name = get_domain_name_from_dns_query_packet ( uptr_ip_rx_packet,sptr_ip_parameters ) ;
				qdcnt = get_quest_count_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);
				if ( qdcnt == 1 && 
    				(check_if_dns_pkt_has_any_reply(uptr_ip_rx_packet,sptr_ip_parameters) == TRUE ))
				{
					dns_len = get_length_of_dns_reply_pkt (uptr_ip_rx_packet, sptr_ip_parameters);
					process_dns_response_and_store_in_local_cache ( dns_pkt_ptr,name, dns_len ) ;
				}
			}

/* 11/08/99 Jo added for Static routes */

			if (check_if_packet_is_destined_to_configured_static_routes (sptr_ip_parameters->destination_address, &sptr_route_entry) == TRUE)
			{
				outgoing_port_number = sptr_route_entry->port_number ;
				gateway_address = sptr_route_entry->gateway ;
			}
/* 11/08/99 Jo added for Static routes */

			forward_return_code = forward_ip_packet (sptr_ip_parameters, uptr_ip_rx_packet, TRUE,
			   	FALSE, (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER)), outgoing_port_number, gateway_address); 

/*		   forward_return_code = forward_ip_packet (sptr_ip_parameters, uptr_ip_rx_packet, TRUE,
			   	FALSE, (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER)), 0);  */


   		if (sptr_ip_parameters->union_ip_packet_is_to_be_freed == TRUE)
	   	{
         	uptr_ip_rx_packet = normalize_ip_send_packet_header (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet) ;
			   free_an_ip_send_packet (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet);
		   }

/* sudha 20 May 1999.This if condn has been missed out somehow !!!!.So again
put that properly. */

         if (forward_return_code == FORWARD_OK)
            return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
         else
		   	return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	   }
/* sudhir 11/7/97 */


		if (ip.port[rx_port_number].routing_status == PROXY_PORT)
		{
/* sudha 28-Oct-1999.Fix taken from firewall...*/
/* If we have domain name filters & also nat mapping for wan interface address
exists, dns queries sent by proxy DNS client wont get dns response pkts. This 
was the problem. What was happening was, the dns response pkts sent from internet 
DNS server to proxy DNS client, was mistaken for nat request pkt from Internet 
client to local server. So DNS response pkt, instead of being given to upper 
layer was being put in the lan of proxy. Taken care for that now, by the below
check for nat. Assuming that, if the DNS pkt rcvd is a response pkt & not a 
query pkt, it may not be the nat request pkt. So, giving those dns response 
pkts to upper layer */

			if ( sptr_ip_parameters->protocol == IP_UDP_PROTOCOL ) 
				dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 
			if (src_port == DNS_PORT_NUMBER) 
			{
				dns_pkt_ptr = get_ptr_to_dns_packet ( uptr_ip_rx_packet, sptr_ip_parameters ) ;
				dns_header = get_dns_header_from_rxed_packet(dns_pkt_ptr);
			   if (dns_header != NULL)
				{
					if (CHECK_IF_RESPONSE_PKT(dns_header))
						dns_response_packet = TRUE;
				}
			}
/* ...sudha 28-Oct-1999.Fix taken from firewall */

/* sudhir 2/2/98 */
			old_pkt_length = sptr_ip_parameters.total_length;
/* sudha 28-Oct-1999. Added one more check in this if condition, for dns response
pkts.Fix taken from firewall */
			if ((check_and_process_the_packets_to_or_from_internet_servers (uptr_ip_rx_packet,
					sptr_ip_parameters, &outgoing_port_number, &packet_meant_for_our_server, &pkt_size_modified) == TRUE)
				 	&& !dns_response_packet)
			{
				if( pkt_size_modified )
					number_of_bytes_rxed += sptr_ip_parameters.total_length - old_pkt_length;

				if (packet_meant_for_our_server == FALSE)
				{
/*					printf ("VSERVER: Processing Packets meant for servers on %d\n",rx_port_number);  */
/* 07/07/99 Jo added for Static routes */
					if (check_if_packet_is_destined_to_configured_static_routes(sptr_ip_parameters->destination_address, &sptr_route_entry) == TRUE)
					{
						outgoing_port_number = NO_SUCH_PORT ;	
						forward_return_code = forward_ip_packet (sptr_ip_parameters, uptr_ip_rx_packet, TRUE,
					   	FALSE, (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER)), outgoing_port_number, sptr_route_entry->gateway) ; 
					}
					else
					{
/* 07/07/99 Jo added for Static routes */
						forward_return_code = forward_ip_packet (sptr_ip_parameters, uptr_ip_rx_packet, TRUE,
							FALSE, (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER)), outgoing_port_number, gateway_address);
					}
		
	   			if (sptr_ip_parameters->union_ip_packet_is_to_be_freed == TRUE)
		   		{
      	   		uptr_ip_rx_packet = normalize_ip_send_packet_header (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet) ;
				   	free_an_ip_send_packet (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet);
				   }

					if (forward_return_code == FORWARD_OK)
					{
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
					}
					else
					{
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
					}													
				}
			}
		}

/*	printf ("IPPROX: Passing packet to upper layer rcvd on port %04x\n",sptr_ip_parameters->rx_port_number); */

	if (sptr_ip_parameters->protocol == UDP_PROTOCOL)
	{
		++ip.port[rx_port_number].statistics.number_of_udp_packets_rxed;

/* sudha 10 Sep 1998 
For DNS Caching.Checking whether source port is DNS (53).
If so update in local dns cache .*/
		dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 
#if 0
		printf("IP: Source Port is %d",src_port);
#endif
		if (src_port == DNS_PORT_NUMBER) 
		{
			dns_pkt_ptr = get_ptr_to_dns_packet ( uptr_ip_rx_packet, sptr_ip_parameters ) ;
			name = get_domain_name_from_dns_query_packet ( uptr_ip_rx_packet,sptr_ip_parameters ) ;
			qdcnt = get_quest_count_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);
			if ( qdcnt == 1 && 
   			(check_if_dns_pkt_has_any_reply(uptr_ip_rx_packet,sptr_ip_parameters) == TRUE ))
			{
				dns_len = get_length_of_dns_reply_pkt (uptr_ip_rx_packet, sptr_ip_parameters);
				process_dns_response_and_store_in_local_cache ( dns_pkt_ptr,name, dns_len ) ;
			}
		}

/* Sachin 13th May, 1997 */
/* In case of reassembled packets, we allocate buffer on port_number 0 
into which all the fragments are copied. rx_port_number may be different
sptr_ip_parameters->rx_port_number is set during reassembly. so it is
better to use it */
      /*
		receive_udp_packet (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
      */
		receive_udp_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
/* Sachin 13th May, 1997 */
		}
	else if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
		{
		++ip.port[rx_port_number].statistics.number_of_icmp_packets_rxed;

/* Sachin 13th May, 1997 */
/* In case of reassembled packets, we allocate buffer on port_number 0 
into which all the fragments are copied. rx_port_number may be different
sptr_ip_parameters->rx_port_number is set during reassembly. so it is
better to use it */
      /*
		receive_icmp_packet (rx_port_number, sptr_ip_parameters, &uptr_ip_rx_packet->icmp,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
      */
		receive_icmp_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, &uptr_ip_rx_packet->icmp,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
/* Sachin 13th May, 1997 */
/* Sachin 16th May, 1997 */
		/* return (return_code); */
/* Sachin 16th May, 1997 */
		}
	else if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		{
		++ip.port[rx_port_number].statistics.number_of_tcp_packets_rxed;
/* Sachin 13th May, 1997 */
/* In case of reassembled packets, we allocate buffer on port_number 0 
into which all the fragments are copied. rx_port_number may be different
sptr_ip_parameters->rx_port_number is set during reassembly. so it is
better to use it */
      /*
		receive_tcp_packet (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
      */
		receive_tcp_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, (BYTE *)uptr_ip_rx_packet,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
/* Sachin 13th May, 1997 */
		}
	else if (ip.number_of_other_transport_protocols > 0x0000)
		{
		pass_packet_to_receive_routine_of_one_of_the_upper_transport_layer_protocols (sptr_ip_parameters, uptr_ip_rx_packet,
			(USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));
		}

	if (sptr_ip_parameters->union_ip_packet_is_to_be_freed == TRUE)
		{
/* Sachin 13th May 1997 */
/* Normalize before freeing */
      uptr_ip_rx_packet = normalize_ip_send_packet_header (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet) ;
		/* free_an_ip_send_packet (NO_SUCH_PORT, uptr_ip_rx_packet); */
		free_an_ip_send_packet (sptr_ip_parameters->rx_port_number, uptr_ip_rx_packet);
/* Sachin 13th May 1997 */
		}

	return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
}
/****************************************************************************/
enum BOOLEAN check_if_protocol_to_which_packet_is_destined_is_supported (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet)
{
	/* ie. transport layer protocols like TCP, IGRP, BOOTP, DHCP etc. */

	USHORT index;

/* sudhir added for PPTP in Proxy Server 13/3/98 */

	if ((sptr_ip_parameters->protocol != UDP_PROTOCOL) && (sptr_ip_parameters->protocol != ICMP_PROTOCOL) && 
		 (sptr_ip_parameters->protocol != TCP_PROTOCOL) && (sptr_ip_parameters->protocol != GRE_PROTOCOL))
		{
/* sudhir added for PPTP in Proxy Server 13/3/98 */

		if (ip.number_of_other_transport_protocols > 0x0000)
			{
			for (index = 0x0000; index < ip.number_of_other_transport_protocols; ++index)
				{
				if (sptr_ip_parameters->protocol == ip.other_transport_protocols[index].protocol)
					{
					return (TRUE);
					}
				}
			}

		++ip.mib.ipInUnknownProtos;

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: rxed packet for unsupported transport protocol %d from %s\n", sptr_ip_parameters->protocol,
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP__DEBUG__ */

		send_icmp_error_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
			ICMP_DESTINATION_UNREACHABLE_TYPE, ICMP_PROTOCOL_UNREACHABLE_CODE, NULL);

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
enum BOOLEAN check_if_packet_has_any_data (USHORT number_of_bytes_rxed, IP_PARAMETERS *sptr_ip_parameters)
{
	if ((number_of_bytes_rxed - sptr_ip_parameters->header_length) == 0x0000)
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: rxed packet with no data from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP__DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
enum TEST reassemble_packet_if_necessary (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet, USHORT number_of_bytes_rxed, USHORT last_byte_offset_of_current_packet)
{
	enum ASSEMBLY_RESULT assembly_result;

	/* If offset or more fragment bits are set, must reassemble. Make sure the ip_header is correct and the reassembled
	 * ip frame contains the header. */

	if ((sptr_ip_parameters->offset > 0x0000) || (sptr_ip_parameters->more_fragment_flag == TRUE))
		{
		if (last_byte_offset_of_current_packet > ip.port[sptr_ip_parameters->rx_port_number].config.maximum_reassembly_size)
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_PRINTF, "IP: rxed fragment dropped: exceeded maximum reassembly size %d\n",
				last_byte_offset_of_current_packet);
		#endif /* __IP__DEBUG__ */

			return (FAIL);
			}

		assembly_result = assemble_ip_fragment (ptr_to_uptr_ip_rx_packet, sptr_ip_parameters,
			last_byte_offset_of_current_packet, number_of_bytes_rxed);

		switch (assembly_result)
			{
			case ALL_FRAGMENTS_ASSEMBLED:

				/* Reassembly of IP datagram is completed. Pass up to the upper layer */

				break;

			case FRAGMENT_ASSEMBLED_BUT_INCOMPLETE:

				/* fragment is now in the reassembly queue, do not release the ip_list_packet */

				return (FAIL);

			case ASSEMBLY_FAIL:

				return (FAIL);

			default:

			#ifdef __IP_ALARM_DEBUG__
				ip_printf (IP_ALARM_PRINTF, "IP: failed to assemble fragments\n");
			#endif /* __IP__ALARM_DEBUG__ */

				return (FAIL);
			}
		}
	else
		{
		sptr_ip_parameters->union_ip_packet_is_to_be_freed = FALSE;
		}

	return (PASS);
}
/****************************************************************************/
enum ASSEMBLY_RESULT assemble_ip_fragment (UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters, USHORT last_byte_offset_of_current_packet, USHORT number_of_bytes_rxed)
{
	REASSEMBLY *sptr_reassembly;
	IP_LIST_PACKET *sptr_ip_list_packet;

	++ip.mib.ipReasmReqds;

#ifdef __IP_DEBUG__
	ip_printf (IP_REASSEMBLY_PRINTF, "IP: assembling fragments\n");
#endif /* __IP__DEBUG__ */

	if (find_matching_reassembly_control_block_or_create_new_one (sptr_ip_parameters, &sptr_reassembly) == FAIL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: failed to find reassembly control block\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (ASSEMBLY_FAIL);
		}

	sptr_reassembly->timer_in_seconds = 0x0000;

	if (sptr_ip_parameters->more_fragment_flag == FALSE)
		{
		/* This is the last fragment. So we now have the offset of the last byte. i.e. total reassembled datagram length */

		sptr_reassembly->length = (USHORT) (last_byte_offset_of_current_packet + 1);
		}

	sptr_ip_list_packet = copy_ip_list_packet ((USHORT) (number_of_bytes_rxed - sizeof (UNION_MAC_HEADER)),
		sptr_ip_parameters->header_length, sptr_ip_parameters->total_length, (BYTE *) *ptr_to_uptr_ip_rx_packet);
		/* reserve ip header, LLC/SNAP, MAC header space in ip_list_packet */

	if (sptr_ip_list_packet == NULL)
		{
		++ip.mib.ipReasmFails;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: failed to copy fragment\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (ASSEMBLY_FAIL);
		}

	if (put_packet_into_reassembly_queue (sptr_reassembly, sptr_ip_parameters->offset, last_byte_offset_of_current_packet,
		sptr_ip_list_packet) == FAIL)
		{
		++ip.mib.ipReasmFails;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: failed to put packet into reassembly queue\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (ASSEMBLY_FAIL);
		}

	if (check_if_the_whole_datagram_has_been_reassembled (ptr_to_uptr_ip_rx_packet, sptr_ip_parameters, sptr_reassembly)
		== PASS)
		{
	#ifdef __IP_DEBUG__
		print_reassembled_ip_header (&(*ptr_to_uptr_ip_rx_packet)->ip.header);
	#endif /* __IP__DEBUG__ */

		return (ALL_FRAGMENTS_ASSEMBLED);
		}
	else
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: packet has not been completely reassembled\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FRAGMENT_ASSEMBLED_BUT_INCOMPLETE);
		}
}
/****************************************************************************/
enum TEST find_matching_reassembly_control_block_or_create_new_one (IP_PARAMETERS *sptr_ip_parameters,
	REASSEMBLY **ptr_to_sptr_reassembly)
{
	/* find the matching reassembly control block */

	*ptr_to_sptr_reassembly = find_matching_reassembly_block (sptr_ip_parameters);

	/* If not found, then this is the first fragment arrived */

	if (*ptr_to_sptr_reassembly == NULL)
		{
		*ptr_to_sptr_reassembly = create_reassembly (sptr_ip_parameters);

		if (*ptr_to_sptr_reassembly == NULL)
			{
			++ip.mib.ipReasmFails;

			return (FAIL);
			}
		else
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: created reassembly control block for first fragment\n");
		#endif /* __IP__DEBUG__ */
			}
		}
	else
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_REASSEMBLY_PRINTF, "IP: found reassembly control block\n");
	#endif /* __IP__DEBUG__ */
		}

	return (PASS);
}
/****************************************************************************/
REASSEMBLY *find_matching_reassembly_block (IP_PARAMETERS *sptr_ip_parameters)
{
	REASSEMBLY *sptr_last_reassembly;
	REASSEMBLY *sptr_reassembly;

	sptr_last_reassembly = NULL;

	sptr_reassembly = ip.sptr_reassembly_link_list;

#ifdef __IP_DEBUG__
	print_reassembly_list (sptr_reassembly);
#endif /* __IP__DEBUG__ */

	for (; sptr_reassembly != NULL; sptr_reassembly = sptr_reassembly->sptr_forward)
		{
		if ((sptr_ip_parameters->id == sptr_reassembly->id) &&
			(sptr_ip_parameters->source_address == sptr_reassembly->source_address) &&
			(sptr_ip_parameters->destination_address == sptr_reassembly->destination_address) &&
			(sptr_ip_parameters->protocol == sptr_reassembly->protocol))
			{
			if (sptr_last_reassembly != NULL)
				{
				/* Move to top of list for speed */

				sptr_last_reassembly->sptr_forward = sptr_reassembly->sptr_forward;

				sptr_reassembly->sptr_forward = ip.sptr_reassembly_link_list;

				ip.sptr_reassembly_link_list = sptr_reassembly;
				}

			break;
			}

		sptr_last_reassembly = sptr_reassembly;
		}

	return (sptr_reassembly);
}
/****************************************************************************/
/* Create a reassembly descriptor, put at head of reassembly list */

REASSEMBLY *create_reassembly (IP_PARAMETERS *sptr_ip_parameters)
{
	REASSEMBLY *sptr_reassembly;

	sptr_reassembly = (REASSEMBLY *) table_malloc (1, sizeof (REASSEMBLY));

	if (sptr_reassembly == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: table_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
		}

	sptr_reassembly->source_address = sptr_ip_parameters->source_address;
	sptr_reassembly->destination_address = sptr_ip_parameters->destination_address;
	sptr_reassembly->id = sptr_ip_parameters->id;
	sptr_reassembly->protocol = (BYTE) sptr_ip_parameters->protocol;
	sptr_reassembly->timer_in_seconds = 0x0000;
	sptr_reassembly->sptr_forward = ip.sptr_reassembly_link_list;

	ip.sptr_reassembly_link_list = sptr_reassembly;

	return (sptr_reassembly);
}
/****************************************************************************/
/* Free all resources associated with a reassembly descriptor */

void free_reassembly (REASSEMBLY *sptr_reassembly_to_free)
{
	REASSEMBLY *sptr_reassembly;
	REASSEMBLY *sptr_last_reassembly;
	FRAGMENT *sptr_fragment;

	sptr_last_reassembly = NULL;

	sptr_reassembly = ip.sptr_reassembly_link_list;

	for (; sptr_reassembly != NULL; sptr_reassembly = sptr_reassembly->sptr_forward)
		{
		if (sptr_reassembly_to_free == sptr_reassembly)
			{
			break;
			}

		sptr_last_reassembly = sptr_reassembly;
		}

	if (sptr_reassembly == NULL)
		{
		return; 															/* Not on list */
		}

	/* Remove from list of reassembly control block */

	if (sptr_last_reassembly != NULL)
		{
		sptr_last_reassembly->sptr_forward = sptr_reassembly->sptr_forward;
		}
	else
		{
		ip.sptr_reassembly_link_list = sptr_reassembly->sptr_forward;
		}

	/* Free any fragments on list, starting at beginning */

	while (sptr_reassembly->sptr_fragment_link != NULL)
		{
		sptr_fragment = sptr_reassembly->sptr_fragment_link;

		sptr_reassembly->sptr_fragment_link = sptr_fragment->sptr_forward;

		free_fragment (sptr_fragment);
		}

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: freeing reassembly control block %p\n", sptr_reassembly);
#endif /* __IP__DEBUG__ */

	table_free (sptr_reassembly);
}
/****************************************************************************/
void print_reassembly_control_block (REASSEMBLY *sptr_reassembly)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_reassembly->source_address);

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_reassembly->destination_address);

		ptr_to_string += sprintf (ptr_to_string, "IP: reassembly control block %s --> %s\n", &ip.print_buffer[0],
			ip.print_buffer_2);

		ptr_to_string += sprintf (ptr_to_string, "   reassembly: len:%u,iden:%u,proto:%u,secs:%u,fwdptr:%p,fraglnk:%p\n",
			sptr_reassembly->length, sptr_reassembly->id, sptr_reassembly->protocol, sptr_reassembly->timer_in_seconds,
			sptr_reassembly->sptr_forward, sptr_reassembly->sptr_fragment_link);

		ip_printf (IP_REASSEMBLY_PRINTF, &ip.string_to_print[0]);
		}
}
/****************************************************************************/
void pass_packet_to_receive_routine_of_one_of_the_upper_transport_layer_protocols (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT last_byte_offset_of_current_packet)
{
	USHORT index;

	for (index = 0x0000; index < ip.number_of_other_transport_protocols; ++index)
		{
		if (sptr_ip_parameters->protocol == ip.other_transport_protocols[index].protocol)
			{
			if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
				{
	 			++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_tcp_packets_rxed;
				}
			else if (sptr_ip_parameters->protocol == IGP_PROTOCOL)
				{
	 			++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_igrp_packets_rxed;
				}

			if (ip.other_transport_protocols[index].fptr_receive_packet != NULL)
				{
				(*ip.other_transport_protocols[index].fptr_receive_packet)
					(sptr_ip_parameters, uptr_ip_rx_packet, last_byte_offset_of_current_packet);
				}

			return;
			}
		}

 	++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_unrecognized_packets_rxed;

	return;
}
/****************************************************************************/
void print_reassembled_ip_header (IP_HEADER *sptr_ip_header)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_ip_header->source_ip_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_ip_header->destination_ip_address));

		ptr_to_string += sprintf (ptr_to_string, "IP: reassembled packet %s --> %s\n", &ip.print_buffer[0], ip.print_buffer_2);

		ptr_to_string += sprintf (ptr_to_string, "   header: hlen:%u,ver:%u,tos.rel:%u,tos.tgh:%u,tos.del:%u,tos.prec:%u\n",
			sptr_ip_header->version_header_length.header_length,
			sptr_ip_header->version_header_length.version, sptr_ip_header->service_type.high_reliability,
			sptr_ip_header->service_type.high_throughput, sptr_ip_header->service_type.low_delay,
			sptr_ip_header->service_type.precedence);

		ip_printf (IP_REASSEMBLY_PRINTF, &ip.string_to_print[0]);

		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string,
			"      header: tlen:%u,iden:%u,flg.mf:%u,flg.df:%u,off.hg:%u,off.lw:%u,ttl:%u,proto:%u,cksum:%x\n",
			net_to_host_short (sptr_ip_header->total_length), net_to_host_short (sptr_ip_header->identifier),
			sptr_ip_header->flags_fragment_offset.more_fragment_flag, sptr_ip_header->flags_fragment_offset.do_not_fragment_flag,
			sptr_ip_header->flags_fragment_offset.fragment_offset_most_significant_part,
			sptr_ip_header->fragment_offset_least_significant_part, sptr_ip_header->time_to_live, sptr_ip_header->protocol,
			sptr_ip_header->header_checksum);

		ip_printf (IP_REASSEMBLY_PRINTF, &ip.string_to_print[0]);
		}
}
#ifdef __IP_DEBUG__
/****************************************************************************/
void	print_reassembly_list (REASSEMBLY *sptr_reassembly)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		while (sptr_reassembly != NULL)
			{
			ptr_to_string = &ip.string_to_print[0];

			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_reassembly->source_address);

			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_reassembly->destination_address);

			ptr_to_string += sprintf (ptr_to_string, "IP: reassembly control block %s --> %s\n", &ip.print_buffer[0],
				&ip.print_buffer_2[0]);

			ptr_to_string += sprintf (ptr_to_string, "   reassembly: len:%u,iden:%u,proto:%u,secs:%u,fwdptr:%p,fraglnk:%p\n",
				sptr_reassembly->length, sptr_reassembly->id, sptr_reassembly->protocol, sptr_reassembly->timer_in_seconds,
				sptr_reassembly->sptr_forward, sptr_reassembly->sptr_fragment_link);

			ip_printf (IP_REASSEMBLY_PRINTF, &ip.string_to_print[0]);

			sptr_reassembly = sptr_reassembly->sptr_forward;
			}
		}
}
#endif /* __IP__DEBUG__ */
/****************************************************************************/
void free_ip_reassembly_control_blocks (void)
{
	REASSEMBLY *sptr_reassembly;
	REASSEMBLY *sptr_reassembly_next;
	FRAGMENT *sptr_fragment;

	sptr_reassembly_next = NULL;

	sptr_reassembly = ip.sptr_reassembly_link_list;

	for ( ; sptr_reassembly != NULL; )
		{
		sptr_reassembly_next = sptr_reassembly->sptr_forward;

		while (sptr_reassembly->sptr_fragment_link != NULL)
			{
			sptr_fragment = sptr_reassembly->sptr_fragment_link;

			sptr_reassembly->sptr_fragment_link = sptr_fragment->sptr_forward;

			free_fragment (sptr_fragment);
			}

	#ifdef __IP_DEBUG__
		ip_printf (IP_MEMORY_PRINTF, "IP: freeing reassembly control block %p\n", sptr_reassembly);
	#endif /* __IP__DEBUG__ */

		table_free (sptr_reassembly);

		sptr_reassembly = sptr_reassembly_next;
		}
}

enum BOOLEAN is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT dest_port, src_port, rx_port_number = 0; /* lan port */

	if ( sptr_ip_parameters->protocol == IP_UDP_PROTOCOL ) 
		dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 

	if (sptr_ip_parameters->protocol == IP_UDP_PROTOCOL && 
		dest_port == DNS_PORT_NUMBER && 
		(ip.port[rx_port_number].config.ip_address == 
			sptr_ip_parameters->destination_address))				
		return TRUE ;
	 else
	 	return FALSE ;
}

enum BOOLEAN is_proxy_lan_addr ( ULONG lan_addr )
{
	ULONG rx_port_number = 0 ; /* Lan of Proxy */

	if (ip.port[rx_port_number].config.ip_address == lan_addr)
		return TRUE ;
	else
		return FALSE ;
}
