/* Kamalnath 07/02/1997 */
#include "defs.h"
#include "ip.h"

static enum BOOLEAN check_if_the_rx_packet_is_an_local_net_broadcast_from_the_client_or_lan_port (IP_PARAMETERS *ip_parameters, USHORT rx_port_number); 
static check_if_the_rx_packet_is_an_unlimited_broadcast(UNION_IP_PACKET *uptr_ip_rx_packet);

/* sudha 20 Nov 1998 */
extern enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length);
extern enum IP_SEND_CONFIRMATION send_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *sptr_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
	enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet),
	ULONG type_of_service, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);

/* sudha 20 Nov 1998 */

enum BOOLEAN check_if_packet_is_a_broadcast (IP_PARAMETERS *sptr_ip_parameters, USHORT rx_port_num)  
{
	IP_PORT_CLASS *sptr_port;
	ULONG destination_address;

	destination_address = sptr_ip_parameters->destination_address;
	sptr_port =	&ip.port[rx_port_num];

	if((sptr_port->config.point_to_point_link !=TRUE) || (sptr_port->config.remote_access_enabled == TRUE))
	{
		if ((destination_address == INTERNET_ADDRESS_BROADCAST) || (destination_address == INTERNET_ADDRESS_ANY))
		{
			return (TRUE);
  		}
	}

	sptr_port = &ip.port[0];
	
	if ((sptr_port->subnet_broadcast_address == destination_address) ||
				(sptr_port->net_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->subnet_address) || (destination_address == sptr_port->net_address))
	{
				return (TRUE);
	}
	return (FALSE);
}

enum IP_PACKET_STATE put_ip_packet_on_all_the_concerned_ports(IP_PARAMETERS *ip_parameters, USHORT rx_port_number, 
		UNION_IP_PACKET *uptr_ip_rx_packet, USHORT bytes_rxed, enum BOOLEAN need_checksum, USHORT processed_option_length)
{
	UNION_IP_PACKET *uptr_ip_packet;
	IP_PORT_CLASS *sptr_port;
   enum IP_SEND_CONFIRMATION	send_confirm;
	IP_UPPER_LAYER_PARAMETERS dummy_parameters;
	int port_num;
	
	dummy_parameters.gateway = 0x0L;
	
	if (check_if_the_rx_packet_is_an_local_net_broadcast_from_the_client_or_lan_port (ip_parameters, rx_port_number) == TRUE)
	{
		printf("This is a local net broadcast from client or lan port\n");
		
		if (ip.mib.ipForwarding == (BYTE) FALSE)
		{
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

		if (check_if_time_to_live_field_in_ip_packet_is_valid (rx_port_number, ip_parameters, uptr_ip_rx_packet,
				processed_option_length) == FALSE)
		{
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
		need_checksum = TRUE;
	}
	
	for (port_num = 0x0000; port_num < ip.number_of_ports; ++port_num)
	{
	  	sptr_port = &ip.port[port_num];
	 	
		if (port_num == rx_port_number)
			continue;
	  
		if (sptr_port->port_is_up != TRUE)
			continue;
		
		/*
		   If the received packet is an unlimited packet, put it on all the ports 
			or else on the client_only ports and the lan accordingly 
		*/
		if (check_if_the_rx_packet_is_an_unlimited_broadcast(uptr_ip_rx_packet) == FALSE)
		{
			if ((sptr_port->config.point_to_point_link == TRUE) && (sptr_port->config.remote_access_enabled != TRUE))	
				continue;
		}

		uptr_ip_packet = get_an_ip_send_packet (port_num, bytes_rxed);
		memcpy (uptr_ip_packet, uptr_ip_rx_packet, bytes_rxed);
		
		send_confirm = send_ip_packet (ip_parameters, uptr_ip_packet, bytes_rxed,
								(IP_ROUTE_CACHE_ENTRY *)NULL, port_num, need_checksum, FALSE, FALSE,	
								(void (*) (USHORT port_number, UNION_IP_PACKET *sptr_txed_packet)) 
								free_an_ip_send_packet, (ULONG) NULL, (IP_UPPER_LAYER_PARAMETERS *)&dummy_parameters);
		
		if (send_confirm == IP_SEND_OK)
		{
/*			printf("IP local broacast is put on the port : %d\n",port_num); */
		}
		else
		{
/*			printf("IP local broacast is not able to put on the port : %d\n",port_num);*/
		}
	}
	
	if (send_confirm == IP_SEND_OK)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
	}
	else
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}
}

static enum BOOLEAN check_if_the_rx_packet_is_an_local_net_broadcast_from_the_client_or_lan_port (IP_PARAMETERS *ip_parameters, USHORT rx_port_number) 
{
	IP_PORT_CLASS *sptr_port;
	ULONG destination_address;

	destination_address = ip_parameters->destination_address;
	sptr_port = &ip.port[rx_port_number];
	
	if((sptr_port->config.point_to_point_link == TRUE) && (sptr_port->config.remote_access_enabled != TRUE))	
	{		
		sptr_port = &ip.port[0];
	
		if ((sptr_port->subnet_broadcast_address == destination_address) ||
				(sptr_port->net_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->subnet_address) || (destination_address == sptr_port->net_address))
		{
				return (TRUE);
		}
	}
	
	return (FALSE);
}

static check_if_the_rx_packet_is_an_unlimited_broadcast(UNION_IP_PACKET *uptr_ip_rx_packet)
{
	/* Add the code to check certain udp port for brodcasting unlimitedly on all the ports */
	return (FALSE);
}


