#include	"defs.h"
/*
 * $Log: /IP/IPTRANSP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iptransp.c$  $version: 1.5$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 09/26/94 ross
1.1 10/10/94 ross added copyrights, udp fixes.
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/20/94 ross
1.4 03/03/95 ross added lsl control.
1.5 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ip.h"
/*************************************************************************/
enum TEST ip_register_upper_layer_protocol (enum IP_PROTOCOL_VALUE protocol_type,
	void (*fptr_receive_packet) (IP_PARAMETERS *sptr_ip_parameters, void *vptr_rx_packet, USHORT packet_size),
	enum TEST (*fptr_find_route_and_update_cache) (ULONG type_of_service, ULONG destination_ip_address,
	void **ptr_to_vptr_route_entry))
{
	if (ip.number_of_other_transport_protocols < MAXIMUM_NUMBER_OF_OTHER_TRANSPORT_PROTOCOLS)
		{
		ip.other_transport_protocols[ip.number_of_other_transport_protocols].protocol =
			(USHORT_ENUM (IP_PROTOCOL_VALUE)) protocol_type;

		ip.other_transport_protocols[ip.number_of_other_transport_protocols].fptr_receive_packet = fptr_receive_packet;

		ip.other_transport_protocols[ip.number_of_other_transport_protocols].fptr_find_route_and_update_cache =
			(enum TEST (*) (ULONG type_of_service, ULONG destination_ip_address, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry))
			fptr_find_route_and_update_cache;

		++ip.number_of_other_transport_protocols;
		}
	else
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: failed to register transport protocol %u\n", protocol_type);
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	return (PASS);
}

