#include	"defs.h"
/*
 * $Log: /IP/RARP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: rarp.c$  $version: 1.6$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 09/26/94 ross
1.1 10/10/94 ross added rarp, proxy arp, remote access functions
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/27/94 ross added better table instrumentation via new snmp.
1.4 12/27/94 ross added copyright.
1.5 01/26/95 ross SNMP name change, printf change.
1.6 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "ip.h"
/*************************************************************************/
static enum TEST check_for_valid_rarp_packet (USHORT port_number, RARP_PACKET *sptr_rarp_packet, USHORT number_of_bytes_rxed);
static RARP_TABLE_ENTRY *find_rarp_entry (MAC_ADDRESS *sptr_mac_address_to_find);
static void rarp_client_received_reply (USHORT port_number, RARP_PACKET *sptr_rarp_packet);
#ifdef __IP_DEBUG__
static void print_rxed_rarp_header (RARP_HEADER *sptr_rarp_header, USHORT port_number);
static void print_txed_rarp_header (RARP_HEADER *sptr_rarp_header, USHORT port_number);
#endif /* __IP__DEBUG__ */
/*************************************************************************/
enum TEST initialize_rarp (void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number > ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		if ((ip.rarp.port[port_number].config.client_enabled == TRUE) &&
			(ip.rarp.port[port_number].config.reply_timeout == 0x0000))
			{
			ip.rarp.port[port_number].config.reply_timeout = DEFAULT_ARP_REPLY_TIMEOUT;
			}
		}

	return (PASS);
}
/*************************************************************************/
enum IP_PACKET_STATE rarp_packet_received (USHORT port_number, RARP_PACKET *sptr_rarp_packet, USHORT number_of_bytes_rxed)
{
	RARP_TABLE_ENTRY *sptr_rarp_table_entry;
	enum IP_PACKET_STATE return_code;

	++ip.rarp.statistics.total_number_of_packets_received;

	if ((sptr_rarp_packet->header.operation_code == ARP_REQUEST) || (sptr_rarp_packet->header.operation_code == ARP_REPLY))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: received ARP packet: forwarded to ARP protocol\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return_code = arp_packet_received (port_number, (ARP_PACKET *) sptr_rarp_packet, number_of_bytes_rxed);

		return (return_code);
		}

#ifdef __IP_DEBUG__
	print_rxed_rarp_header (&sptr_rarp_packet->header, port_number);
#endif /* __IP__DEBUG__ */

	if (check_for_valid_rarp_packet (port_number, sptr_rarp_packet, number_of_bytes_rxed) == FAIL)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

	if ((ip.rarp.port[port_number].config.client_enabled == TRUE) &&
		(sptr_rarp_packet->header.operation_code == REVERSE_ARP_REPLY))
		{
		rarp_client_received_reply (port_number, sptr_rarp_packet);

		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
	else
		{
		sptr_rarp_table_entry = find_rarp_entry (&sptr_rarp_packet->header.target_hardware_address);

		if (sptr_rarp_table_entry == NULL)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP/RARP: failed to find rarp table entry for %x%x\n",
				sptr_rarp_packet->header.target_hardware_address._ulong,
				sptr_rarp_packet->header.target_hardware_address._ushort);
		#endif /* __IP__ALARM_DEBUG__ */

			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}

		++ip.rarp.statistics.total_number_of_incoming_requests;

		/* send reply */

		sptr_rarp_packet->header.operation_code = REVERSE_ARP_REPLY;

		sptr_rarp_packet->header.target_hardware_address = sptr_rarp_packet->header.sender_hardware_address;
		sptr_rarp_packet->header.target_protocol_address = host_to_net_long (sptr_rarp_table_entry->ip_address);

		sptr_rarp_packet->header.sender_hardware_address = ip.port[port_number].mac_address;
		sptr_rarp_packet->header.sender_protocol_address = host_to_net_long (ip.port[port_number].config.ip_address);

	#ifdef __IP_DEBUG__
		print_txed_rarp_header (&sptr_rarp_packet->header, port_number);
	#endif /* __IP__DEBUG__ */

/* Sachin 02/05/1997 */
#if 0
		send_packet_to_lsl (port_number, (UNION_IP_PACKET *) sptr_rarp_packet, number_of_bytes_rxed, TRUE, NULL,
			SNAP_IP_RARP_PACKET, &sptr_rarp_packet->header.target_hardware_address);
#endif
		if (send_packet_to_lsl (port_number, (UNION_IP_PACKET *) sptr_rarp_packet, number_of_bytes_rxed, TRUE, NULL,
			SNAP_IP_RARP_PACKET, &sptr_rarp_packet->header.target_hardware_address) == FAIL)
         return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED) ;
/* Sachin 02/05/1997 */

		++ip.rarp.statistics.total_number_of_replies_sent;

		return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
		}
}
/*************************************************************************/
static enum TEST check_for_valid_rarp_packet (USHORT port_number, RARP_PACKET *sptr_rarp_packet, USHORT number_of_bytes_rxed)
{
	ULONG sender_protocol_address;
	IP_PORT_CLASS *sptr_port;

	if (number_of_bytes_rxed < MINIMUM_ARP_PACKET_LENGTH) 
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: packet too short: packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.total_number_of_short_packets_received;

		return (FAIL);
		}

	if (sptr_rarp_packet->header.protocol != SNAP_IP_RARP_PACKET)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: unsupported proto: packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.unsupported_protocol;

		return (FAIL);
		}

	if ((sptr_rarp_packet->header.hardware_type != ARP_HARDWARE_ETHERNET) &&
		(sptr_rarp_packet->header.hardware_type != ARP_HARDWARE_IEEE_802_NETWORKS))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: unsupported htype: packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.unsupported_hardware;

		return (FAIL);
		}

	sptr_port = &ip.port[port_number];

	if ((sptr_rarp_packet->header.hardware_address_length != sptr_port->hardware_address_length) ||
		(sptr_rarp_packet->header.protocol_address_length != IP_ADDRESS_LENGTH))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: bad haddr field: packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.bad_length_field;

		return (FAIL);
		}

	if (memcmp (&sptr_rarp_packet->header.sender_hardware_address, &sptr_port->mac_address,
		sptr_rarp_packet->header.hardware_address_length) == (int) NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: invalid shaddr (me): packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.total_number_of_packets_from_me_received;

		return (FAIL);
		}

	if (memcmp (&sptr_rarp_packet->header.sender_hardware_address, &ethernet_broadcast_address,
		sptr_rarp_packet->header.hardware_address_length) == (int) NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: invalid shaddr (broadcast): packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.total_number_of_source_broadcasts_received;

		return (FAIL);
		}

	sender_protocol_address = net_to_host_long (sptr_rarp_packet->header.sender_protocol_address);

	if ((sptr_rarp_packet->header.operation_code == REVERSE_ARP_REQUEST) &&
		(ip_match_full_address_to_port (sender_protocol_address) != NO_SUCH_PORT))
		{
		/* received from me */

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RARP: invalid siaddr (me): packet dropped\n");
	#endif /* __IP__ALARM_DEBUG__ */

		++ip.rarp.statistics.total_number_of_packets_from_me_received;

		return (FAIL);
		}

	return (PASS);
}
/*************************************************************************/
static RARP_TABLE_ENTRY *find_rarp_entry (MAC_ADDRESS *sptr_target_mac_address)
{
	RARP_TABLE_ENTRY *sptr_rarp_entry;
	USHORT port_number;

#ifdef __IP_DEBUG__
	rarp_print_table ();
#endif /* __IP__DEBUG__ */

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		sptr_rarp_entry = (RARP_TABLE_ENTRY *) &ip.rarp.port[port_number].config.current_list.sptr_forward_link;

		while (sptr_rarp_entry != NULL)
			{
			if (memcmp (&sptr_rarp_entry->hardware_address, sptr_target_mac_address, sizeof (MAC_ADDRESS)) == 0)
				{
				return (sptr_rarp_entry);
				}

			sptr_rarp_entry = (RARP_TABLE_ENTRY *) sptr_rarp_entry->links.sptr_forward_link;
			}
		}

	return (NULL);
}
/*************************************************************************/
static void rarp_client_received_reply (USHORT port_number, RARP_PACKET *sptr_rarp_packet)
{
	if (ip.port[port_number].config.ip_address == 0x00000000L)
		{
	#ifdef __IP_DEBUG__
		ip_printf (RARP_PRINTF, "IP/RARP: received iaddr for port %u\n", port_number);
	#endif /* __IP__DEBUG__ */

		ip.port[port_number].config.ip_address = sptr_rarp_packet->header.target_protocol_address;

		if (set_up_port_class_data (ip.port[port_number].config.virtual_port_number) == FAIL)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP/RARP: failed to set up port class data for port %u\n",
				ip.port[port_number].config.virtual_port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return;
			}

		if (initialize_virtual_port (ip.port[port_number].config.virtual_port_number) == FAIL)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP/RARP: failed to initialize port %u\n",
				ip.port[port_number].config.virtual_port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return;
			}

		ip.rarp.port[port_number].pending_reply = FALSE;
		}
}
/*************************************************************************/
void rarp_client_timer (void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		if (ip.rarp.port[port_number].pending_reply == TRUE)
			{
			++ip.rarp.port[port_number].second_counter;

			if (ip.rarp.port[port_number].second_counter >= ip.rarp.port[port_number].config.reply_timeout)
				{
				send_rarp_request (port_number);

				ip.rarp.port[port_number].second_counter = 0x0000;
				}
			}
		}
}
/*************************************************************************/
void *add_rarp_table_entry (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address)
{
	RARP_TABLE_ENTRY *sptr_rarp_entry;

	sptr_rarp_entry = find_rarp_entry (sptr_mac_address);

	if (sptr_rarp_entry != NULL)
		{
	#ifdef __IP_DEBUG__
		ip_printf (RARP_PRINTF, "IP/RARP: entry already exists in table\n");
	#endif /* __IP__DEBUG__ */

		return (sptr_rarp_entry);
		}

	sptr_rarp_entry = (RARP_TABLE_ENTRY *) table_malloc (1, sizeof (RARP_TABLE_ENTRY));

	if (sptr_rarp_entry != NULL)
		{
		sptr_rarp_entry->ip_address = ip_address;
		sptr_rarp_entry->hardware_address = *sptr_mac_address;

		add_entry_to_list ((LINK *) &ip.rarp.port[port_number].config.current_list, (LINK *) &sptr_rarp_entry->links);

		++ip.rarp.port[port_number].current_number_of_rarp_entries;

	#ifdef __IP_DEBUG__
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_rarp_entry->ip_address);

		ip_printf (RARP_PRINTF, "IP/RARP: added entry to table %x%x:%s\n", sptr_rarp_entry->hardware_address._ulong,
			sptr_rarp_entry->hardware_address._ushort, &ip.print_buffer[0]);
	#endif /* __IP__DEBUG__ */
		}
	else
		{
	#ifdef __IP_DEBUG__
		ip_printf (RARP_PRINTF, "IP/RARP: table_malloc failed\n");
	#endif /* __IP__DEBUG__ */

		return (NULL);
		}

	return (sptr_rarp_entry);
}
/*************************************************************************/
void send_rarp_request (USHORT port_number)
{
	RARP_PACKET *sptr_rarp_packet;

	sptr_rarp_packet = (RARP_PACKET *) get_an_ip_send_packet (port_number, sizeof (RARP_PACKET));

	if (ip.port[port_number].config.token_ring == FALSE)
		{
		sptr_rarp_packet->mac_header.ethernet.destination_address = ethernet_broadcast_address;
		sptr_rarp_packet->mac_header.ethernet.source_address = ip.port[port_number].mac_address;

		sptr_rarp_packet->header.hardware_type = ARP_HARDWARE_ETHERNET;
		}
	else
		{
		sptr_rarp_packet->mac_header.token_ring.destination_address = ethernet_broadcast_address;
		sptr_rarp_packet->mac_header.token_ring.source_address = ip.port[port_number].mac_address;

		sptr_rarp_packet->header.hardware_type = ARP_HARDWARE_IEEE_802_NETWORKS;
		}

	sptr_rarp_packet->header.protocol = SNAP_IP_RARP_PACKET;
	sptr_rarp_packet->header.hardware_address_length = sizeof (MAC_ADDRESS);
	sptr_rarp_packet->header.protocol_address_length = sizeof (ULONG);

	sptr_rarp_packet->header.operation_code = REVERSE_ARP_REQUEST;

	sptr_rarp_packet->header.sender_hardware_address = ip.port[port_number].mac_address;
	sptr_rarp_packet->header.sender_protocol_address = 0x00000000L;
	sptr_rarp_packet->header.target_hardware_address = ip.port[port_number].mac_address;
	sptr_rarp_packet->header.target_protocol_address = 0x00000000L;

#ifdef __IP_DEBUG__
	print_txed_rarp_header (&sptr_rarp_packet->header, port_number);
#endif /* __IP__DEBUG__ */

	send_packet_to_lsl (port_number, (UNION_IP_PACKET *) sptr_rarp_packet, sizeof (RARP_PACKET), FALSE,
		send_completion_ip_packet, SNAP_IP_RARP_PACKET, &ethernet_broadcast_address);
}
/*************************************************************************/
void rarp_print_table (void)
{
	USHORT port_number;
	RARP_TABLE_ENTRY *sptr_rarp_table_entry;
	char *ptr_to_string;

	if (ip.print_class.rarp_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string, "IP/RARP: rarp table:\n");

		for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
			{
			if (ip.port[port_number].config.port_enabled == FALSE)
				{
				continue;
				}

			sptr_rarp_table_entry = (RARP_TABLE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *)
				&ip.rarp.port[port_number].config.current_list);

			if (sptr_rarp_table_entry == NULL)
				{
				ptr_to_string += sprintf (ptr_to_string, "   has no entries for port number %u\n", port_number);

				ip_printf (RARP_PRINTF, &ip.string_to_print[0]);

				ptr_to_string = &ip.string_to_print[0];
				}
			else
				{
				while (sptr_rarp_table_entry != NULL)
					{
					convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_rarp_table_entry->ip_address);

					ptr_to_string += sprintf (ptr_to_string, "   port:%u, proto address:%s, mac address:%x%x\n", port_number,
						&ip.print_buffer[0], sptr_rarp_table_entry->hardware_address._ulong,
						sptr_rarp_table_entry->hardware_address._ushort);

					ip_printf (RARP_PRINTF, &ip.string_to_print[0]);

					ptr_to_string = &ip.string_to_print[0];

					sptr_rarp_table_entry = (RARP_TABLE_ENTRY *) get_pointer_to_next_entry_in_list (
						(LINK *) sptr_rarp_table_entry);
					}
				}
			}
		}
}
#ifdef __IP_DEBUG__
/*************************************************************************/
static void print_rxed_rarp_header (RARP_HEADER *sptr_rarp_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.rarp_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_rarp_header->sender_protocol_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_rarp_header->target_protocol_address));

		ptr_to_string += sprintf (ptr_to_string, "IP/RARP: rxed packet %x%x:%s --> %x%x:%s on port %u\n",
			net_to_host_long (sptr_rarp_header->sender_hardware_address._ulong),
			net_to_host_short (sptr_rarp_header->sender_hardware_address._ushort), &ip.print_buffer[0],
			net_to_host_long (sptr_rarp_header->target_hardware_address._ulong),
			net_to_host_short (sptr_rarp_header->target_hardware_address._ushort), &ip.print_buffer_2[0],
			port_number);

		ptr_to_string += sprintf (ptr_to_string, "   IP/RARP: header: type:%u,proto:%x,halen:%u,palen:%u,opcode:%u\n",
			sptr_rarp_header->hardware_type,
			net_to_host_short (sptr_rarp_header->protocol), sptr_rarp_header->hardware_address_length,
			sptr_rarp_header->protocol_address_length, net_to_host_short (sptr_rarp_header->operation_code));

		ip_printf (RARP_PRINTF, &ip.string_to_print[0]);
		}
}
/*************************************************************************/
static void print_txed_rarp_header (RARP_HEADER *sptr_rarp_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.rarp_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_rarp_header->sender_protocol_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_rarp_header->target_protocol_address));

		ptr_to_string += sprintf (ptr_to_string, "IP/RARP: txed packet %x%x:%s --> %x%x:%s on port %u\n",
			net_to_host_long (sptr_rarp_header->sender_hardware_address._ulong),
			net_to_host_short (sptr_rarp_header->sender_hardware_address._ushort), &ip.print_buffer[0],
			net_to_host_long (sptr_rarp_header->target_hardware_address._ulong),
			net_to_host_short (sptr_rarp_header->target_hardware_address._ushort), &ip.print_buffer_2[0],
			port_number);

		ptr_to_string += sprintf (ptr_to_string, "   IP/RARP: header: type:%u,proto:%x,halen:%u,palen:%u,opcode:%u\n",
			sptr_rarp_header->hardware_type,
			net_to_host_short (sptr_rarp_header->protocol), (USHORT) sptr_rarp_header->hardware_address_length,
			(USHORT) sptr_rarp_header->protocol_address_length, net_to_host_short (sptr_rarp_header->operation_code));

		ip_printf (RARP_PRINTF, &ip.string_to_print[0]);
		}
}
#endif /* __IP__DEBUG__ */
/*************************************************************************/
void free_ip_rarp_entries (void)
{
	USHORT port_number;
	RARP_TABLE_ENTRY *sptr_rarp_table_entry;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		sptr_rarp_table_entry = (RARP_TABLE_ENTRY *) get_entry_from_list (
			(LINK *) &ip.rarp.port[port_number].config.current_list);

		while (sptr_rarp_table_entry != NULL)
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_MEMORY_PRINTF, "IP: freeing rarp table entry %p\n", sptr_rarp_table_entry);
		#endif /* __IP__DEBUG__ */

			table_free (sptr_rarp_table_entry);

			--ip.rarp.port[port_number].current_number_of_rarp_entries;

			sptr_rarp_table_entry = (RARP_TABLE_ENTRY *) get_entry_from_list (
				(LINK *) &ip.rarp.port[port_number].config.current_list);
			}
		}
}
