#include	"defs.h"
/*
 * $Log: /IP/RIPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: riprx.c$  $version: 1.12$      $date: 10/25/95$   */
/*
*	$lgb$
1.0 03/01/94 yarran
1.1 03/01/94 yarran Add copyright.
1.2 03/02/94 yarran Replace min(). It's non-ANSI.
1.3 03/11/94 yarran Fix flags bug in check_and_add_ip_route().
1.4 03/17/94 yarran Change type_of_service type.
1.5 05/02/94 yarran added rfc1042 changes.
1.6 06/15/94 yarran cosmetic changes.
1.7 09/01/94 ross added BYTE and USHORT_ENUM support.
1.8 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.9 12/20/94 ross
1.10 12/27/94 ross added better table instrumentation via new snmp.
1.11 01/17/95 ross fixed arp problems from snmp
1.12 10/25/95 ross
*	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the					*/
/*	Government is subject to restrictions as set forth in						*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and				*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdlib.h>
#include "ip.h"
/****************************************************************************/
static enum BOOLEAN check_if_version_field_in_rip_header_is_valid (IP_SOCKET *sptr_remote_socket,
	RIP_PACKET *sptr_rip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, RIP_HEADER **ptr_to_sptr_rip_header);
static void process_rip_request_packet (USHORT rx_port_number, RIP_HEADER *sptr_rip_header, RIP_PACKET *sptr_rip_packet,
	USHORT size_of_routes, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, USHORT number_of_bytes);
static enum TEST send_rip_full_response_if_required (USHORT rx_port_number, RIP_ROUTE_ENTRY packet_route_entry,
	ULONG sender_ip_address, USHORT size_of_routes, IP_SOCKET *sptr_remote_socket);
static void process_request_rip_entry (RIP_ROUTE_ENTRY *sptr_rip_entry, RIP_ROUTE_ENTRY *sptr_packet_route_entry);
static enum BOOLEAN rip_check_if_target_is_a_network_directed_broadcast_address (ULONG target);
static enum BOOLEAN rip_check_if_target_is_an_invalid_address (ULONG target);
static enum BOOLEAN check_if_rip_entry_is_a_valid_all_routes_request (RIP_ROUTE_ENTRY *sptr_rip_entry);
static void	processing_for_individual_route_requests (USHORT rx_port_number, RIP_HEADER *sptr_rip_header,
	USHORT rip_rx_data_size, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, USHORT number_of_bytes);
/****************************************************************************/
void rip_receive_packet (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_rxed_packet,
	USHORT rip_packet_size, IP_PARAMETERS *sptr_ip_parameters)
{
	RIP_PACKET *sptr_rip_rx_packet;
	USHORT size_of_rip_data;
	IP_SOCKET local_socket;
	RIP_HEADER *sptr_rip_header;

	++ip.rip.statistics.number_of_packets_received;

	sptr_rip_rx_packet = (RIP_PACKET *) vptr_rxed_packet;

	if (check_if_version_field_in_rip_header_is_valid (sptr_remote_socket, sptr_rip_rx_packet, sptr_ip_parameters,
		&sptr_rip_header) == FALSE)
		{
		return;
		}

	local_socket.ip_address = INTERNET_ADDRESS_ANY;
	local_socket.port = RIP_PORT;

	size_of_rip_data = (USHORT) (rip_packet_size - sizeof (RIP_HEADER));

	switch (sptr_rip_header->type)
		{
		case RIP_REQUEST_PACKET_TYPE:

		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: received request from %s: %u bytes\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address), rip_packet_size);
		#endif /* __IP__DEBUG__ */

			process_rip_request_packet (rx_port_number, sptr_rip_header, sptr_rip_rx_packet, size_of_rip_data, &local_socket,
				sptr_remote_socket, rip_packet_size);

			break;

		case RIP_RESPONSE_PACKET_TYPE:

		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: received response from %s: %u bytes\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address), rip_packet_size);
		#endif /* __IP__DEBUG__ */

			rip_process_response_packet (rx_port_number, sptr_rip_header, size_of_rip_data, sptr_remote_socket);

			break;

		default:

		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP/RIP: received unknown type %lu\n", sptr_rip_header->type);
		#endif /* __IP__ALARM_DEBUG__ */

			++ip.rip.statistics.number_of_unrecongnized_packets_received;

			break;
		}

	return;
}
/****************************************************************************/
static enum BOOLEAN check_if_version_field_in_rip_header_is_valid (IP_SOCKET *sptr_remote_socket,
	RIP_PACKET *sptr_rip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, RIP_HEADER **ptr_to_sptr_rip_header)
{
#ifndef __IP_ALARM_DEBUG__
	PARAMETER_NOT_USED (sptr_remote_socket);
#endif /* __IP__ALARM_DEBUG__ */

	*ptr_to_sptr_rip_header = (RIP_HEADER *) ((ULONG) sptr_rip_rx_packet + sizeof (UNION_MAC_HEADER) +
		sptr_ip_parameters->header_length + sizeof (UDP_HEADER));

	if ((*ptr_to_sptr_rip_header)->version == RIP_VERSION_ZERO)
		{
		++ip.rip.statistics.number_of_bad_versions;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: received bad packet version from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}
	else if (((*ptr_to_sptr_rip_header)->version == RIP_VERSION_ONE) && ((*ptr_to_sptr_rip_header)->reserved != 0x0000))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: received bad 'must be zero' header field from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static void process_rip_request_packet (USHORT rx_port_number, RIP_HEADER *sptr_rip_header, RIP_PACKET *sptr_rip_packet,
	USHORT rip_rx_data_size, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, USHORT number_of_bytes)
{
	RIP_ROUTE_ENTRY packet_route_entry;
	RIP_ROUTE_ENTRY *sptr_rip_entry;
	USHORT number_of_rip_entries;

	PARAMETER_NOT_USED (sptr_rip_packet);

	++ip.rip.statistics.number_of_request_packets_received;

	sptr_rip_entry = (RIP_ROUTE_ENTRY *) ((BYTE *) sptr_rip_header + sizeof (RIP_HEADER));

	number_of_rip_entries = (USHORT) (rip_rx_data_size / sizeof (RIP_ROUTE_ENTRY));

	if (number_of_rip_entries == 1)
		{
		if (check_if_reserved_fields_are_all_zeroes_for_rip_version_one (sptr_rip_header, sptr_rip_entry,
			sptr_remote_socket->ip_address) == FALSE)
			{
			return;
			}

		packet_route_entry.address_family = net_to_host_short (sptr_rip_entry->address_family);
		packet_route_entry.target = net_to_host_long (sptr_rip_entry->target);
		packet_route_entry.metric = net_to_host_long (sptr_rip_entry->metric);

		if (check_if_rip_entry_is_a_valid_all_routes_request (&packet_route_entry) == TRUE)
			{
			if (send_rip_full_response_if_required (rx_port_number, packet_route_entry, sptr_remote_socket->ip_address,
				rip_rx_data_size, sptr_remote_socket) == FAIL)
				{
			#ifdef __IP_DEBUG__
				ip_printf (IP_RIP_PRINTF, "IP/RIP: invalid all routes request packet from %s\n",
					convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
			#endif /* __IP__DEBUG__ */
				}

			return;
			}

	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: request for route to %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], packet_route_entry.target));
	#endif /* __IP__DEBUG__ */
		}

	processing_for_individual_route_requests (rx_port_number, sptr_rip_header, rip_rx_data_size, sptr_local_socket,
		sptr_remote_socket, number_of_bytes);
}
/****************************************************************************/
static void	processing_for_individual_route_requests (USHORT rx_port_number, RIP_HEADER *sptr_rip_header,
	USHORT rip_rx_data_size, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, USHORT number_of_bytes)
{
	BYTE *bptr_type_service;
	RIP_ROUTE_ENTRY packet_route_entry;
	RIP_ROUTE_ENTRY *sptr_rip_entry;
	SERVICE_TYPE_BIT_STRUCTURE type_of_service;
	USHORT number_of_rip_entries;
	RIP_PACKET *sptr_rip_tx_packet;
	RIP_ROUTE_ENTRY *sptr_rip_tx_entry;
	USHORT number_of_rip_tx_entries;
	USHORT overhead;
	enum BOOLEAN processing_done;

	sptr_rip_entry = (RIP_ROUTE_ENTRY *) ((BYTE *) sptr_rip_header + sizeof (RIP_HEADER));

	number_of_rip_entries = (USHORT) (rip_rx_data_size / sizeof (RIP_ROUTE_ENTRY));

	overhead	= (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER) + sizeof (UDP_HEADER));

	number_of_bytes = (USHORT) (number_of_bytes + overhead);

	number_of_rip_tx_entries = number_of_rip_entries;

	compute_rip_packet_size_and_number_of_routes (rx_port_number, &number_of_bytes, &number_of_rip_tx_entries);

	allocate_rip_response_packet_and_build_header (rx_port_number, number_of_bytes, &sptr_rip_tx_packet,
		&number_of_rip_tx_entries, &sptr_rip_tx_entry);

	if (sptr_rip_tx_packet == NULL)
		{
		return;
		}

	processing_done = FALSE;

	while (rip_rx_data_size >= RIP_ROUTE_ENTRY_SIZE)
		{
		packet_route_entry.address_family = net_to_host_short (sptr_rip_entry->address_family);

		while ((check_if_reserved_fields_are_all_zeroes_for_rip_version_one (sptr_rip_header, sptr_rip_entry,
			sptr_remote_socket->ip_address) == FALSE) || (packet_route_entry.address_family != RIP_IP_FAMILY_TYPE))
			{
			/* skip entry in request packet */

			++sptr_rip_entry;

			rip_rx_data_size -= (USHORT) RIP_ROUTE_ENTRY_SIZE;

		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: rip entry from %s is invalid\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
		#endif /* __IP__DEBUG__ */

			if (rip_rx_data_size >= RIP_ROUTE_ENTRY_SIZE)
				{
				packet_route_entry.address_family = net_to_host_short (sptr_rip_entry->address_family);
				}
			else
				{
				processing_done = TRUE;

				break;
				}
			}

		if (processing_done == TRUE)
			{
			break;
			}

		packet_route_entry.target = net_to_host_long (sptr_rip_entry->target);
		packet_route_entry.metric = net_to_host_long (sptr_rip_entry->metric);

		process_request_rip_entry (sptr_rip_tx_entry, &packet_route_entry);

		++sptr_rip_tx_entry;

		++number_of_rip_tx_entries;

		++sptr_rip_entry;

		rip_rx_data_size -= (USHORT) RIP_ROUTE_ENTRY_SIZE;
		}

	if (number_of_rip_tx_entries == 0x00)
		{
/* Sachin 02/05/1997 */
      sptr_rip_tx_packet = normalize_ip_send_packet_header (rx_port_number, sptr_rip_tx_packet) ;
/* Sachin 02/05/1997 */
		free_an_ip_send_packet (rx_port_number, (UNION_IP_PACKET *) sptr_rip_tx_packet);

	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: all requested rip entries from %s were invalid\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
	#endif /* __IP__DEBUG__ */

		return;
		}

	bptr_type_service = (BYTE *) &type_of_service;

	*bptr_type_service = 0x00;

	number_of_bytes = (USHORT) (overhead + sizeof (RIP_HEADER) + (number_of_rip_tx_entries * RIP_ROUTE_ENTRY_SIZE));

	sptr_local_socket->ip_address = ip.port[rx_port_number].config.ip_address;

	send_udp (rx_port_number, sptr_local_socket, sptr_remote_socket, type_of_service, ip.rip.config.minimum_ttl,
		(void *) sptr_rip_tx_packet, 0x0000, FALSE, number_of_bytes, send_completion_ip_packet, NULL);

#ifdef __IP_DEBUG__
	ip_printf (IP_RIP_PRINTF, "IP/RIP: sent reply to %s\n",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
#endif /* __IP__DEBUG__ */
}
/****************************************************************************/
static enum BOOLEAN check_if_rip_entry_is_a_valid_all_routes_request (RIP_ROUTE_ENTRY *sptr_rip_entry)
{
	if ((sptr_rip_entry->address_family == RIP_UNSPECIFIED_FAMILY_TYPE) && (sptr_rip_entry->metric == INFINITY_METRIC_VALUE))
		{
		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
enum BOOLEAN check_if_reserved_fields_are_all_zeroes_for_rip_version_one (RIP_HEADER *sptr_rip_header,
	RIP_ROUTE_ENTRY *sptr_rip_entry, ULONG sender_ip_address)
{
#ifndef __IP_DEBUG__
	PARAMETER_NOT_USED (sender_ip_address);
#endif /* __IP_DEBUG__ */

	if (sptr_rip_header->version == RIP_VERSION_ONE)
		{
		if ((sptr_rip_entry->reserved_field_1 != 0x0000) || (sptr_rip_entry->reserved_field_2 != 0x00000000L) ||
			(sptr_rip_entry->reserved_field_3 != 0x00000000L))
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: receive non-zero reserved field in request packet from %s\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sender_ip_address));
		#endif /* __IP__DEBUG__ */

			++ip.rip.statistics.number_of_bad_request_formats;

			return (FALSE);
			}
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST send_rip_full_response_if_required (USHORT rx_port_number, RIP_ROUTE_ENTRY packet_route_entry,
	ULONG sender_ip_address, USHORT size_of_routes, IP_SOCKET *sptr_remote_socket)
{
#ifndef __IP_DEBUG__
	PARAMETER_NOT_USED (sender_ip_address);
#endif /* __IP_DEBUG__ */

	if ((packet_route_entry.address_family == RIP_UNSPECIFIED_FAMILY_TYPE) &&
		(packet_route_entry.metric == INFINITY_METRIC_VALUE) && (size_of_routes == RIP_ROUTE_ENTRY_SIZE))
		{
		/* A single entry with address family RIP_UNSPECIFIED_FAMILY_TYPE and metric ``infinity'' means ``all routes''.
		 * We respond to routers only if we are acting as a supplier, or to anyone other than a router (eg, query). */

		if ((sptr_remote_socket->port == RIP_PORT) && (ip.rip.port[rx_port_number].send_response_updates != TRUE))
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: all routes request has been dropped\n");
		#endif /* __IP__DEBUG__ */
			}
		else
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_RIP_PRINTF, "IP/RIP: send all routes reply to %s\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sender_ip_address));
		#endif /* __IP__DEBUG__ */

			/* Passing parameters: split horizon is disabled, not a triggered update, include our address in update */

			rip_send_full_response (rx_port_number, sptr_remote_socket, FALSE, FALSE, TRUE);

			return (PASS);
			}
		}

	return (FAIL);
}
/****************************************************************************/
static void process_request_rip_entry (RIP_ROUTE_ENTRY *sptr_rip_tx_entry, RIP_ROUTE_ENTRY *sptr_packet_route_entry)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	ULONG metric;

	sptr_route_entry = rip_search_route_table_with_bits (sptr_packet_route_entry->target, 32);

	if (sptr_route_entry != NULL)
		{
		if ((sptr_route_entry->metric + 1) < INFINITY_METRIC_VALUE)
			{
			metric = sptr_route_entry->metric + 1;
			}
		else
			{
			metric = INFINITY_METRIC_VALUE;
			}
		}
	else
		{
		metric = INFINITY_METRIC_VALUE;
		}

	sptr_rip_tx_entry->metric = host_to_net_long (metric);

	sptr_rip_tx_entry->target = host_to_net_long (sptr_packet_route_entry->target);

	sptr_rip_tx_entry->address_family = host_to_net_short (sptr_packet_route_entry->address_family);

	return; 
}
/****************************************************************************/
enum BOOLEAN rip_check_if_target_is_a_valid_host_or_network_address (ULONG target)
{
	if (target == INTERNET_ADDRESS_LOOPBACK)
		{
		return (FALSE);
		}
	else if (target == INTERNET_ADDRESS_BROADCAST)
		{
		return (FALSE);
		}
	else if (IN_CLASS_D (target))
		{
		return (FALSE);
		}
	else if (IN_EXPERIMENTAL (target))
		{
		return (FALSE);
		}
	else if (IN_BADCLASS (target))
		{
		return (FALSE);
		}

	if ((IN_CLASS_A (target)) || (IN_CLASS_B (target)) || (IN_CLASS_C (target)))
		{
		if (rip_check_if_target_is_an_invalid_address (target) == TRUE)
			{
			return (FALSE);
			}

		if (rip_check_if_target_is_a_network_directed_broadcast_address (target) == TRUE)
			{
			return (FALSE);
			}

		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN rip_check_if_target_is_a_network_directed_broadcast_address (ULONG target)
{
	/* does not check for subnet directed broadcast addresses */

	if (IN_CLASS_A (target))
		{
		if ((target & IN_CLASS_A_HOST) == 0x00ffffffL)
			{
			return (TRUE);
			}
		}
	else if (IN_CLASS_B (target))
	  {
		if ((target & IN_CLASS_B_HOST) == 0x0000ffffL)
			{
			return (TRUE);
			}
	  }
	else if (IN_CLASS_C (target))
	  {
		if ((target & IN_CLASS_C_HOST) == 0x000000ffL)
			{
			return (TRUE);
			}
	  }

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN rip_check_if_target_is_an_invalid_address (ULONG target)
{
	if (target == 0x00000000L)
		{
		return (FALSE);
		}
	else if (IN_CLASS_A (target))
		{
		if ((target & 0xff000000L) == 0x7f000000L)
			{
			return (TRUE);
			}
		else if ((target & 0xff000000L) == 0x00000000L)
			{
			return (TRUE);
			}
		}
	else if (IN_CLASS_B (target))
	  {
		if ((target & 0xffff0000L) == 0xbfff0000L)
			{
			return (TRUE);
			}
		else if ((target & 0xffff0000L) == 0x80000000L)
			{
			return (TRUE);
			}
	  }
	else if (IN_CLASS_C (target))
	  {
		if ((target & 0xffffff00L) == 0xdfffff00L)
			{
			return (TRUE);
			}
		else if ((target & 0xffffff00L) == 0xc0000000L)
			{
			return (TRUE);
			}
	  }

	return (FALSE);
}
