#include	"defs.h"
/*
 * $Log: /IP/RIPRXREP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: riprxrep.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ip.h"
/****************************************************************************/
static enum BOOLEAN check_if_rip_response_packet_is_from_remote_rip_port (IP_SOCKET *sptr_remote_socket);
static enum BOOLEAN check_if_rip_response_packet_is_from_neighbor (IP_SOCKET *sptr_remote_socket);
static IP_PORT_CLASS *match_point_to_point_link_destination_address (ULONG destination_address);
static enum BOOLEAN check_if_response_packet_is_acceptable (IP_SOCKET *sptr_remote_socket, USHORT size_of_rip_data);
static USHORT find_directly_connected_sender (ULONG sender_ip_address);
static enum TEST process_response_rip_entry (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket,
	RIP_HEADER *sptr_rip_header, RIP_ROUTE_ENTRY *sptr_rip_entry, USHORT *usptr_number_of_route_changes);
static enum BOOLEAN check_if_route_entry_is_to_be_rejected (USHORT port_number, RIP_ROUTE_ENTRY packet_route_entry);
/****************************************************************************/
void rip_process_response_packet (USHORT rx_port_number, RIP_HEADER *sptr_rip_header, USHORT size_of_rip_data,
	IP_SOCKET *sptr_remote_socket)
{
	USHORT number_of_route_changes;
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PORT_CLASS *sptr_port;
	RIP_ROUTE_ENTRY *sptr_rip_entry;

#ifdef __IP_DEBUG__
	rip_print_header (sptr_rip_header);
#endif /* __IP__DEBUG__ */

	if (check_if_rip_response_packet_is_from_remote_rip_port (sptr_remote_socket) == FALSE)
		{
		return;
		}

	if (check_if_rip_response_packet_is_from_neighbor (sptr_remote_socket) == FALSE)
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: response packet is not from neighbor\n");
	#endif /* __IP__DEBUG__ */

		return;
		}

	number_of_route_changes = 0x0000;

	/* Update timer for the interface on which the packet was received. */

	sptr_route_entry = rip_search_route_table (sptr_remote_socket->ip_address);

	sptr_port = match_point_to_point_link_destination_address (sptr_remote_socket->ip_address);

	if ((sptr_port != NULL) && ((sptr_route_entry == NULL) || (sptr_route_entry->metric >= sptr_port->config.metric)))
		{
		/* If from other end of a point-to-point link that isn't in the routing tables, add the route.
		 * This is a way of monitoring whether a point-to-point link is up. If the WAN port code does not do it's
		 *	job right by informing IP about link up/down, which IP will add/delete the route, then this code will remedy that. */

		ip_add_route_for_port (sptr_port->config.virtual_port_number);
		}

	if (check_if_response_packet_is_acceptable (sptr_remote_socket, size_of_rip_data) == FALSE)
		{
		return;
		}

	sptr_rip_entry = (RIP_ROUTE_ENTRY *) ((BYTE *) sptr_rip_header + sizeof (RIP_HEADER));

	while (size_of_rip_data >= RIP_ROUTE_ENTRY_SIZE)
		{
	#ifdef __IP_DEBUG__
		rip_print_routing_entry (sptr_rip_entry);
	#endif /* __IP__DEBUG__ */

		process_response_rip_entry (rx_port_number, sptr_remote_socket, sptr_rip_header, sptr_rip_entry,
			&number_of_route_changes);

		size_of_rip_data -= (USHORT) RIP_ROUTE_ENTRY_SIZE;

		++sptr_rip_entry;
		}

#ifdef __IP_DEBUG__
	ip_print_routing_table ();
#endif /* __IP__DEBUG__ */

	if (ip.rip.need_to_send_icmp_address_mask_request == TRUE)
		{
		rip_send_icmp_address_mask_request ();
		}

	if (number_of_route_changes > 0x0000)
		{
		rip_initiate_triggered_broadcast (rx_port_number);
		}

	return;
}
/****************************************************************************/
static enum BOOLEAN check_if_rip_response_packet_is_from_remote_rip_port (IP_SOCKET *sptr_remote_socket)
{
	if (sptr_remote_socket->port != RIP_PORT)
		{
		++ip.rip.statistics.number_of_responses_not_from_rip_port;

	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: response packet is not remote rip port\n");
	#endif /* __IP__DEBUG__ */

		return (FALSE);
		}

	++ip.rip.statistics.number_of_response_packets_received;

	/* see if received from loopback */

	if (ip_match_full_address_to_port (sptr_remote_socket->ip_address) != NO_SUCH_PORT)
		{
		++ip.rip.statistics.number_of_responses_received_from_loopback_interface;

	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: response packet is from loopback interface\n");
	#endif /* __IP__DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum BOOLEAN check_if_rip_response_packet_is_from_neighbor (IP_SOCKET *sptr_remote_socket)
{
	RIP_NEIGHBOR_ENTRY *sptr_neighbor_entry;

	if (ip.rip.config.neighbor_list_enabled == TRUE)
		{
		sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.rip.neighbor_list);

		while (sptr_neighbor_entry != NULL)
			{
			if (sptr_neighbor_entry->ip_address == sptr_remote_socket->ip_address)
				{
				return (TRUE);
				}

			sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_neighbor_entry);
			}

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
/* Find the point-to-point interface with destination address. */
static IP_PORT_CLASS *match_point_to_point_link_destination_address (ULONG destination_address)
{
	USHORT port_number;
	IP_PORT_CLASS *sptr_port;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		sptr_port = &ip.port[port_number];

		if (sptr_port->is_point_to_point == FALSE)
			{
			continue;
			}

		if (sptr_port->config.point_to_point_remote_ip_address == destination_address)
			{
			return (sptr_port);
			}
		}

	return (NULL);
}
/****************************************************************************/
static enum BOOLEAN check_if_response_packet_is_acceptable (IP_SOCKET *sptr_remote_socket, USHORT size_of_rip_data)
{
	USHORT local_port;

	/* Only accept from routers directly connected via broadcast lan, point-to-point link or remote link. */

	local_port = find_directly_connected_sender (sptr_remote_socket->ip_address);

	if (local_port == NO_SUCH_PORT)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: response packet from unknown router %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	if (size_of_rip_data > 500)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: response packet of INVALID size %u from router %s\n", size_of_rip_data,
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));

		ip_printf (IP_ALARM_PRINTF, "IP/RIP: MAX size for a response packet is 512 bytes (with udp header)\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	if ((size_of_rip_data % sizeof (RIP_ROUTE_ENTRY)) != 0)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: response packet of INVALID size %u from router %s\n", size_of_rip_data,
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));

		ip_printf (IP_ALARM_PRINTF, "IP/RIP: size is to be a multiple of 20\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
/* Find an interface having the same address or broadcast address or point-to-point link's destination address or
 *	the same net/subnet. */

static USHORT find_directly_connected_sender (ULONG sender_ip_address)
{
	USHORT port_number;
	USHORT port_found;
	IP_PORT_CLASS *sptr_port;

	port_found = NO_SUCH_PORT;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		sptr_port = &ip.port[port_number];

		if (sptr_port->config.ip_address == sender_ip_address)
			{
			return (port_number);
			}

		if ((sptr_port->allow_broadcast == TRUE) && (sptr_port->subnet_broadcast_address == sender_ip_address))
			{
			return (port_number);
			}

		if ((sptr_port->is_point_to_point == TRUE) && (sptr_port->config.point_to_point_remote_ip_address == sender_ip_address))
			{
			return (port_number);
			}

		if ((port_found == NO_SUCH_PORT) && ((sptr_port->config.subnetmask & sender_ip_address) == sptr_port->subnet_address))
			{
			port_found = port_number; 					/* not sure, keep on checking other interfaces */
			}
		}

	return (port_found);
}
/****************************************************************************/
static enum TEST process_response_rip_entry (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket,
	RIP_HEADER *sptr_rip_header, RIP_ROUTE_ENTRY *sptr_rip_entry, USHORT *usptr_number_of_route_changes)
{
	RIP_ROUTE_ENTRY packet_route_entry;
	USHORT number_of_entries_processed;

	packet_route_entry.address_family = net_to_host_short (sptr_rip_entry->address_family);

	if (check_if_reserved_fields_are_all_zeroes_for_rip_version_one (sptr_rip_header, sptr_rip_entry,
		sptr_remote_socket->ip_address) == FALSE)
		{
		return (FAIL);
		}

	packet_route_entry.target = net_to_host_long (sptr_rip_entry->target);
	packet_route_entry.metric = net_to_host_long (sptr_rip_entry->metric);

	if (packet_route_entry.address_family != RIP_IP_FAMILY_TYPE)
		{
		++ip.rip.statistics.number_of_bad_address_families;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: rxed invalid address family from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_socket->ip_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if ((packet_route_entry.metric == 0x00000000L) || (packet_route_entry.metric > INFINITY_METRIC_VALUE))
		{
		++ip.rip.statistics.number_of_bad_metrics;

		return (FAIL);
		}

	if (check_if_route_entry_is_to_be_rejected (rx_port_number, packet_route_entry) == TRUE)
		{
		return (FAIL);
		}

	number_of_entries_processed = process_rip_entry (rx_port_number, sptr_remote_socket->ip_address, &packet_route_entry);

	*usptr_number_of_route_changes = (USHORT) (*usptr_number_of_route_changes + number_of_entries_processed);

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_if_route_entry_is_to_be_rejected (USHORT port_number, RIP_ROUTE_ENTRY packet_route_entry)
{
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.rip.port[port_number].reject_list);

	if (sptr_destination_entry != NULL)
		{
		while (sptr_destination_entry != NULL)
			{
			if (sptr_destination_entry->ip_address == packet_route_entry.target)
				{
				return (TRUE);
				}

			sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_destination_entry);
			}
		}

	return (FALSE);
}
