#include	"defs.h"
/*
 * $Log: /IP/RIPTXREP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stdlib.h>
#include "ip.h"
/****************************************************************************/
static void include_route_to_oneself_if_necessary (enum BOOLEAN include_routes_to_me, USHORT outgoing_port_number,
	RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, USHORT *usptr_number_of_route_entries);
static void build_rip_route_entry (RIP_ROUTE_ENTRY *sptr_rip_entry, ULONG target, ULONG metric,
	enum BOOLEAN route_needs_to_be_summarized, ULONG net_mask);
static void	include_default_route_if_appropriate (enum BOOLEAN trigger_update, enum BOOLEAN poison_reverse_enabled,
	USHORT outgoing_port_number, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, USHORT *usptr_number_of_route_entries);
static void	process_route_table_entries (IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, USHORT outgoing_port_number, USHORT rip_packet_size, IP_SOCKET local_socket,
	RIP_PACKET **ptr_to_sptr_rip_tx_packet, RIP_ROUTE_ENTRY *sptr_rip_entry, USHORT *usptr_number_of_route_entries,
	USHORT max_entries);
static enum BOOLEAN check_if_the_summarized_route_has_already_been_included (RIP_PACKET *sptr_rip_tx_packet,
	USHORT number_of_route_entries, IP_ROUTE_ENTRY *sptr_route_entry, ULONG netmask);
static void transmit_rip_response_packet (IP_SOCKET *sptr_remote_socket, IP_SOCKET local_socket,
	RIP_PACKET *sptr_rip_tx_packet, USHORT *usptr_number_of_route_entries);
static void	processing_for_split_horizon_and_poison_reverse (enum BOOLEAN poison_reverse_enabled, USHORT outgoing_port_number,
	USHORT *usptr_number_of_route_entries, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, IP_ROUTE_ENTRY *sptr_route_entry,
	enum BOOLEAN route_needs_to_be_summarized, ULONG netmask);
static enum BOOLEAN check_if_route_entry_is_to_be_advertised (USHORT port_number, ULONG destination);
/****************************************************************************/
void send_rip_response_packet (IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, enum BOOLEAN include_routes_to_me, USHORT outgoing_port_number, USHORT rip_packet_size,
	USHORT max_entries, IP_SOCKET local_socket)
{
	RIP_PACKET *sptr_rip_tx_packet;
	RIP_ROUTE_ENTRY *sptr_rip_entry;
	USHORT number_of_route_entries;

	allocate_rip_response_packet_and_build_header (outgoing_port_number, rip_packet_size, &sptr_rip_tx_packet,
		&number_of_route_entries, &sptr_rip_entry);

	if (sptr_rip_tx_packet == NULL)
		{
		return;
		}

	include_route_to_oneself_if_necessary (include_routes_to_me, outgoing_port_number, &sptr_rip_entry,
		&number_of_route_entries);

	include_default_route_if_appropriate (trigger_update, poison_reverse_enabled, outgoing_port_number, &sptr_rip_entry,
		&number_of_route_entries);

	process_route_table_entries (sptr_remote_socket, poison_reverse_enabled, trigger_update, outgoing_port_number,
		rip_packet_size, local_socket, &sptr_rip_tx_packet, sptr_rip_entry, &number_of_route_entries, max_entries);

	if (number_of_route_entries != 0x0000)
		{
		transmit_rip_response_packet (sptr_remote_socket, local_socket, sptr_rip_tx_packet, &number_of_route_entries);
		}
	else
		{
/* Sachin 02/05/1997 */
      sptr_rip_tx_packet = normalize_ip_send_packet_header (outgoing_port_number, sptr_rip_tx_packet) ;
      free_an_ip_send_packet (outgoing_port_number, (UNION_IP_PACKET *) sptr_rip_tx_packet);
		/* free_an_ip_send_packet (sptr_remote_socket->virtual_port_number, (UNION_IP_PACKET *) sptr_rip_tx_packet); */
/* Sachin 02/05/1997 */
		}
}
/****************************************************************************/
void allocate_rip_response_packet_and_build_header (USHORT outgoing_port_number, USHORT rip_packet_size,
	RIP_PACKET **ptr_to_sptr_rip_tx_packet, USHORT *usptr_number_of_route_entries, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry)
{
	*ptr_to_sptr_rip_tx_packet = (RIP_PACKET *) get_an_ip_send_packet (outgoing_port_number, rip_packet_size);

/* Sachin 02/05/1997 */
   if (*ptr_to_sptr_rip_tx_packet == NULL)
   {
      return ;
   }
/* Sachin 02/05/1997 */

	*usptr_number_of_route_entries = 0x0000;

	build_rip_header (&(*ptr_to_sptr_rip_tx_packet)->header, RIP_RESPONSE_PACKET_TYPE);

	*ptr_to_sptr_rip_entry = &(*ptr_to_sptr_rip_tx_packet)->route_entry[0];
}
/****************************************************************************/
static void include_route_to_oneself_if_necessary (enum BOOLEAN include_routes_to_me, USHORT outgoing_port_number,
	RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, USHORT *usptr_number_of_route_entries)
{
	/* normally this is for all-route request */

	if (include_routes_to_me == TRUE)
		{
		build_rip_route_entry (*ptr_to_sptr_rip_entry, ip.port[outgoing_port_number].config.ip_address, 0, FALSE, 0x00000000L);

		++(*ptr_to_sptr_rip_entry);

		++(*usptr_number_of_route_entries);
		}
}
/****************************************************************************/
static enum BOOLEAN check_if_route_entry_is_to_be_advertised (USHORT port_number, ULONG destination)
{
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.rip.port[port_number].advertise_list);

	if (sptr_destination_entry != NULL)
		{
		while (sptr_destination_entry != NULL)
			{
			if (sptr_destination_entry->ip_address == destination)
				{
				return (TRUE);
				}

			sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_destination_entry);
			}

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static void build_rip_route_entry (RIP_ROUTE_ENTRY *sptr_rip_entry, ULONG target, ULONG metric,
	enum BOOLEAN route_needs_to_be_summarized, ULONG net_mask)
{
	sptr_rip_entry->address_family = host_to_net_short (RIP_IP_FAMILY_TYPE);

	if (route_needs_to_be_summarized == FALSE)
		{
		sptr_rip_entry->target = host_to_net_long (target);
		}
	else
		{
		sptr_rip_entry->target = host_to_net_long (target & net_mask);
		}

	sptr_rip_entry->metric = host_to_net_long (metric);

	sptr_rip_entry->reserved_field_1 = 0x0000;
	sptr_rip_entry->reserved_field_2 = 0x00000000L;
	sptr_rip_entry->reserved_field_3 = 0x00000000L;

#ifdef __IP_DEBUG__
	rip_print_routing_entry (sptr_rip_entry);
#endif /* __IP__DEBUG__ */
}
/****************************************************************************/
static void	include_default_route_if_appropriate (enum BOOLEAN trigger_update, enum BOOLEAN poison_reverse_enabled,
	USHORT outgoing_port_number, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, USHORT *usptr_number_of_route_entries)
{
	/* Emit default route, if appropriate. */

	if (((trigger_update == FALSE) || (ip.default_route.flags.route_changed == TRUE)) &&
		(ip.default_route.port_number != NO_SUCH_PORT))
		/* trigger is pending on this route */
		{
		if (ip.rip.port[outgoing_port_number].announce_default_route_enabled == FALSE)
			{
			return;
			}

		if ((poison_reverse_enabled == FALSE) || (outgoing_port_number != ip.default_route.port_number))
			{
			build_rip_route_entry (*ptr_to_sptr_rip_entry, 0x00000000L, ip.default_route.metric, FALSE, 0xffffffffL);

			++(*ptr_to_sptr_rip_entry);

			++(*usptr_number_of_route_entries);
			}
		else if (trigger_update == TRUE)
			{
			/* this route has just been changed and has not sent RIP Update yet */

			build_rip_route_entry (*ptr_to_sptr_rip_entry, 0x00000000L, INFINITY_METRIC_VALUE, FALSE, 0xffffffffL);

			++(*ptr_to_sptr_rip_entry);

			++(*usptr_number_of_route_entries);
			}
		}
}
/****************************************************************************/
static void	process_route_table_entries (IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, USHORT outgoing_port_number, USHORT rip_packet_size, IP_SOCKET local_socket,
	RIP_PACKET **ptr_to_sptr_rip_tx_packet, RIP_ROUTE_ENTRY *sptr_rip_entry, USHORT *usptr_number_of_route_entries,
	USHORT max_entries)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	enum BOOLEAN route_needs_to_be_summarized;
	ULONG netmask;

	sptr_remote_socket->virtual_port_number = outgoing_port_number;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		if (((trigger_update == TRUE) && (sptr_route_entry->flags.route_changed == FALSE)) ||
			((sptr_route_entry->flags.private_route == TRUE) &&
			(ip.rip.port[outgoing_port_number].announce_static_routes_enabled == FALSE)) ||
			((sptr_route_entry->flags.private_route != TRUE) && (sptr_route_entry->flags.host_route == TRUE) &&
			(ip.rip.port[outgoing_port_number].announce_host_routes_enabled == FALSE)))
			{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
			sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
			sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif

			continue;
			}

		if (rip_check_if_target_is_a_valid_host_or_network_address (sptr_route_entry->target) == FALSE)
			{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
			sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
			sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif

			continue;
			}

		if (sptr_route_entry->flags.local_interface_route == FALSE)
			{
			if (check_if_route_entry_is_to_be_advertised (outgoing_port_number, sptr_route_entry->target) == FALSE)
				{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
				sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
				sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif

				continue;
				}
			}

		/* if route is to subnet, check if this route is to be sent to the gateway. */

		route_needs_to_be_summarized = FALSE;

		if (rip_is_it_ok_to_announce_this_route (sptr_route_entry, sptr_remote_socket->ip_address, outgoing_port_number,
			&netmask) == FALSE)
			{
			if (ip.rip.port[outgoing_port_number].route_summarization_enabled == TRUE)
				{
				if (check_if_the_summarized_route_has_already_been_included (*ptr_to_sptr_rip_tx_packet,
					*usptr_number_of_route_entries, sptr_route_entry, netmask) == TRUE)
					{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
					sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
					sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
					continue;
					}
				else
					{
					route_needs_to_be_summarized = TRUE;
					}
				}
			}

		if (*usptr_number_of_route_entries >= max_entries)
			{
			transmit_rip_response_packet (sptr_remote_socket, local_socket, *ptr_to_sptr_rip_tx_packet,
				usptr_number_of_route_entries);

			allocate_rip_response_packet_and_build_header (outgoing_port_number, rip_packet_size, ptr_to_sptr_rip_tx_packet,
				usptr_number_of_route_entries, &sptr_rip_entry);

			if (*ptr_to_sptr_rip_tx_packet == NULL)
				{
				return;
				}
			}

		processing_for_split_horizon_and_poison_reverse (poison_reverse_enabled, outgoing_port_number,
			usptr_number_of_route_entries, &sptr_rip_entry, sptr_route_entry, route_needs_to_be_summarized, netmask);

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}
}
/****************************************************************************/
static enum BOOLEAN check_if_the_summarized_route_has_already_been_included (RIP_PACKET *sptr_rip_tx_packet,
	USHORT number_of_route_entries, IP_ROUTE_ENTRY *sptr_route_entry, ULONG netmask)
{
	RIP_ROUTE_ENTRY *sptr_rip_entry;
	ULONG summarized_target;

	sptr_rip_entry = &sptr_rip_tx_packet->route_entry[0];

	summarized_target = sptr_route_entry->target & netmask;

	summarized_target = host_to_net_long (summarized_target);

	for (; number_of_route_entries > 0; --number_of_route_entries)
		{
		if (sptr_rip_entry->target == summarized_target)
			{
			return (TRUE);
			}

		++sptr_rip_entry;
		}

	return (FALSE);
}
/****************************************************************************/
static void transmit_rip_response_packet (IP_SOCKET *sptr_remote_socket, IP_SOCKET local_socket,
	RIP_PACKET *sptr_rip_tx_packet, USHORT *usptr_number_of_route_entries)
{
	USHORT number_of_bytes_in_packet;
	BYTE *bptr_type_service;
	SERVICE_TYPE_BIT_STRUCTURE type_of_service;

	/* no more space, send this packet and allocate next RIP packet */

	number_of_bytes_in_packet = (USHORT) (sizeof (RIP_PACKET) -
		((MAXIMUM_NUMBER_OF_RIP_ENTRIES - *usptr_number_of_route_entries) * sizeof (RIP_ROUTE_ENTRY)));

	bptr_type_service = (BYTE *) &type_of_service;

	*bptr_type_service = 0x00;

	send_udp (sptr_remote_socket->virtual_port_number, &local_socket, sptr_remote_socket, type_of_service,
		ip.rip.config.minimum_ttl, (void *) sptr_rip_tx_packet, 0, FALSE, number_of_bytes_in_packet,
		send_completion_ip_packet, NULL);

	++ip.rip.statistics.number_of_response_packets_sent;
}
/****************************************************************************/
static void	processing_for_split_horizon_and_poison_reverse (enum BOOLEAN poison_reverse_enabled, USHORT outgoing_port_number,
	USHORT *usptr_number_of_route_entries, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry, IP_ROUTE_ENTRY *sptr_route_entry,
	enum BOOLEAN route_needs_to_be_summarized, ULONG netmask)
{
	RIP_PORT_CLASS *sptr_rip_port;

	sptr_rip_port = &ip.rip.port[outgoing_port_number];

	if (poison_reverse_enabled == TRUE)
		{
		if (outgoing_port_number == sptr_route_entry->port_number)
			{
			/* split horizon with poison reverse when outgoing port is same as the route's port number */

			build_rip_route_entry (*ptr_to_sptr_rip_entry, sptr_route_entry->target, INFINITY_METRIC_VALUE,
				route_needs_to_be_summarized, netmask);
			}
		else if (outgoing_port_number != sptr_route_entry->port_number)
			{
			/* split horizon with poison reverse when outgoing port is not same as the route's port number */

			build_rip_route_entry (*ptr_to_sptr_rip_entry, sptr_route_entry->target, sptr_route_entry->metric,
				route_needs_to_be_summarized, netmask);
			}
		}
	else
		{
		if (outgoing_port_number != sptr_route_entry->port_number)
			{
			build_rip_route_entry (*ptr_to_sptr_rip_entry, sptr_route_entry->target, sptr_route_entry->metric,
				route_needs_to_be_summarized, netmask);
			}
		else if (sptr_rip_port->split_horizon_enabled == TRUE)
			{
			/* split horizon when outgoing port is same as the route's port number */

			return;
			}
		else
			{
			build_rip_route_entry (*ptr_to_sptr_rip_entry, sptr_route_entry->target, sptr_route_entry->metric,
				route_needs_to_be_summarized, netmask);
			}
		}

	++(*ptr_to_sptr_rip_entry);

	++(*usptr_number_of_route_entries);
}
/****************************************************************************/
void rip_print_header (RIP_HEADER *sptr_rip_header)
{
	if (ip.print_class.rip_printing_enabled == TRUE)
		{
		if (sptr_rip_header->type == RIP_REQUEST_PACKET_TYPE)
			{
			ip_printf (IP_RIP_PRINTF, "   IP/RIP: header: type:REQUEST PACKET, version:%u\n", sptr_rip_header->version);
			}
		else if (sptr_rip_header->type == RIP_RESPONSE_PACKET_TYPE)
			{
			ip_printf (IP_RIP_PRINTF, "   IP/RIP: header: type:RESPONSE PACKET, version:%u\n", sptr_rip_header->version);
			}
		}
}
/****************************************************************************/
void rip_print_routing_entry (RIP_ROUTE_ENTRY *sptr_rip_route_entry)
{
	ULONG target_address;

	if (ip.print_class.rip_printing_enabled == TRUE)
		{
		target_address = net_to_host_long (sptr_rip_route_entry->target);

		convert_ip_address_to_dot_format (&ip.print_buffer[0], target_address);

		ip_printf (IP_RIP_PRINTF, "   IP/RIP: route entry: family:%u, target:%s, metric:%u\n",
			net_to_host_short (sptr_rip_route_entry->address_family), &ip.print_buffer[0],
			net_to_host_long (sptr_rip_route_entry->metric));
		}
}

