#include	"defs.h"
/*
 * $Log: /IP/UDPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: udprx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>
#include	<stddef.h>
#include "ip.h"
/****************************************************************************/
static UDP_CONTROL_BLOCK *find_udp_control_block (IP_SOCKET *sptr_socket);
static void add_udp_control_block_to_sorted_list (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_add);
static enum BOOLEAN check_if_udp_packet_size_is_valid (USHORT udp_packet_size);
static enum TEST build_udp_header (UDP_HEADER *sptr_udp_pdu, UDP_HEADER *sptr_udp_header, IP_PARAMETERS *sptr_ip_parameters,
	USHORT udp_packet_size);
static void	set_up_local_ip_socket (USHORT rx_port_number, enum BOOLEAN *eptr_received_broadcast,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_SOCKET *sptr_local_ip_socket, IP_PARAMETERS *sptr_ip_parameters,
	UDP_HEADER *sptr_udp_header);
static enum TEST get_udp_control_block (UNION_IP_PACKET *uptr_ip_rx_packet, IP_SOCKET *sptr_local_ip_socket,
	IP_PARAMETERS *sptr_ip_parameters, UDP_CONTROL_BLOCK **ptr_to_sptr_udp_control_block, enum BOOLEAN received_broadcast);
static enum BOOLEAN check_if_udp_packet_has_any_data (USHORT *usptr_udp_data_length, USHORT udp_packet_size);
static void set_up_remote_ip_socket (IP_PARAMETERS *sptr_ip_parameters, IP_SOCKET *sptr_remote_ip_socket,
	UDP_HEADER *sptr_udp_header, USHORT rx_port_number);
static void set_up_remote_socket_in_udp_control_block (IP_PARAMETERS *sptr_ip_parameters,
	UDP_CONTROL_BLOCK *sptr_udp_control_block, UDP_HEADER *sptr_udp_header, USHORT rx_port_number);
static void determine_number_of_bytes_to_be_copied (USHORT *usptr_count, UDP_BUFFER *sptr_udp_buffer,
	USHORT *usptr_number_of_bytes);
static void copy_data_into_target_buffer_and_delete_receive_queue_buffer (UDP_CONTROL_BLOCK *sptr_udp_control_block,
	IP_SOCKET *sptr_ip_socket, void *vptr_buffer, UDP_BUFFER *sptr_udp_buffer, USHORT number_of_bytes);
static void delete_buffers_on_udp_receive_queue (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_delete);
/****************************************************************************/
enum TEST initialize_udp (void)
{
	ip.udp.mib.udpInDatagrams = 0x00000000L;
	ip.udp.mib.udpNoPorts = 0x00000000L;
	ip.udp.mib.udpInErrors = 0x00000000L;
	ip.udp.mib.udpOutDatagrams = 0x00000000L;

	return (PASS);
}
/****************************************************************************/
void *open_udp (IP_SOCKET *sptr_local_socket,
	void (*fptr_call_udp_user) (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_packet_received,
	USHORT rx_user_data_size, IP_PARAMETERS *sptr_ip_parameters), enum USER_TYPE user_type)
{
	UDP_CONTROL_BLOCK *sptr_udp_control_block; 

	sptr_udp_control_block = find_udp_control_block (sptr_local_socket);

	if (sptr_udp_control_block != NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: failed to open new udp control block (since it already exists)\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
		}

	sptr_udp_control_block = (UDP_CONTROL_BLOCK *) table_malloc (1, sizeof (UDP_CONTROL_BLOCK));

	if (sptr_udp_control_block == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: table_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
		}
	else
		{
		sptr_udp_control_block->local_socket.ip_address = sptr_local_socket->ip_address;
		sptr_udp_control_block->local_socket.port = sptr_local_socket->port;

		if (user_type == SOCKET_USER)
			{
			sptr_udp_control_block->fptr_call_socket_user =
				(void (*) (struct UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT count, void *vptr_user_data,
				IP_SOCKET *sptr_ip_socket)) fptr_call_udp_user;

			sptr_udp_control_block->fptr_call_raw_udp_user = NULL;
			}
		else if (user_type == NATIVE_UDP_USER)
			{
			sptr_udp_control_block->fptr_call_raw_udp_user = fptr_call_udp_user;

			sptr_udp_control_block->fptr_call_socket_user = NULL;
			}

		add_udp_control_block_to_sorted_list (sptr_udp_control_block);
		}

	return (sptr_udp_control_block);
}
/****************************************************************************/
static UDP_CONTROL_BLOCK *find_udp_control_block (IP_SOCKET *sptr_socket)
{
	UDP_CONTROL_BLOCK *sptr_udp_control_block;

	/* find the user matching local port and local ip address */

	for (sptr_udp_control_block = ip.udp.current_control_block_list.sptr_forward_link; sptr_udp_control_block != NULL;
		sptr_udp_control_block = sptr_udp_control_block->links.sptr_forward_link)
		{
		if ((sptr_socket->port == sptr_udp_control_block->local_socket.port) &&
		   ((sptr_socket->ip_address == sptr_udp_control_block->local_socket.ip_address)	||
			(sptr_udp_control_block->local_socket.ip_address == INTERNET_ADDRESS_ANY)))
			{
			return (sptr_udp_control_block);
			}
		}

	return (NULL);
}
/****************************************************************************/
static void add_udp_control_block_to_sorted_list (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_add)
{
	LINKED_LIST_SORT_PARAMETERS linked_list_sort_parameters;

	linked_list_sort_parameters.sptr_list = (LINK *) &ip.udp.current_control_block_list;
	linked_list_sort_parameters.sptr_entry_to_add = (LINK *) sptr_udp_control_block_to_add;

	linked_list_sort_parameters.index[0].offset = (USHORT) offsetof (UDP_CONTROL_BLOCK,local_socket.ip_address);
	linked_list_sort_parameters.index[0].size = sizeof (ULONG);
	linked_list_sort_parameters.index[0]._swap = TRUE;

	linked_list_sort_parameters.index[1].offset = (USHORT) offsetof (UDP_CONTROL_BLOCK,local_socket.port);
	linked_list_sort_parameters.index[1].size = sizeof (USHORT);
	linked_list_sort_parameters.index[1]._swap = TRUE;

	linked_list_sort_parameters.index[2].size = 0x0000;

	add_entry_to_sorted_linked_list (&linked_list_sort_parameters);
}
/****************************************************************************/
void receive_udp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT udp_packet_size)
{
	USHORT udp_data_length;
	IP_SOCKET local_ip_socket;
	UDP_HEADER udp_header;
	UDP_CONTROL_BLOCK *sptr_udp_control_block;
	UDP_HEADER *sptr_udp_pdu;
	enum BOOLEAN received_broadcast;
	IP_SOCKET remote_ip_socket;

	sptr_udp_pdu = (UDP_HEADER *) ((ULONG) uptr_ip_rx_packet + sizeof (UNION_MAC_HEADER) + sptr_ip_parameters->header_length);

	if (check_if_udp_packet_size_is_valid (udp_packet_size) == FALSE)
		{
		return;
		}

	if (build_udp_header (sptr_udp_pdu, &udp_header, sptr_ip_parameters, udp_packet_size) == FAIL)
		{
		return;
		}

	set_up_local_ip_socket (rx_port_number, &received_broadcast, uptr_ip_rx_packet, &local_ip_socket, sptr_ip_parameters,
		&udp_header);

	if (get_udp_control_block (uptr_ip_rx_packet, &local_ip_socket, sptr_ip_parameters, &sptr_udp_control_block,
		received_broadcast) == FAIL)
		{
		return;
		}

	++ip.udp.mib.udpInDatagrams;

	if (check_if_udp_packet_has_any_data (&udp_data_length, udp_packet_size) == FALSE)
		{
		return;
		}

	if (sptr_udp_control_block->fptr_call_socket_user != NULL)
		{
		set_up_remote_ip_socket (sptr_ip_parameters, &remote_ip_socket, &udp_header, rx_port_number);

		(*sptr_udp_control_block->fptr_call_socket_user) (sptr_udp_control_block, udp_data_length,
			(void *) &uptr_ip_rx_packet->udp.data[0], &remote_ip_socket);
		}
	else if (sptr_udp_control_block->fptr_call_raw_udp_user != NULL)
		{
		set_up_remote_socket_in_udp_control_block (sptr_ip_parameters, sptr_udp_control_block, &udp_header, rx_port_number);

		(*sptr_udp_control_block->fptr_call_raw_udp_user) (rx_port_number, &sptr_udp_control_block->remote_socket,
			(void *) uptr_ip_rx_packet, udp_data_length, sptr_ip_parameters);
		}
}
/****************************************************************************/
static enum BOOLEAN check_if_udp_packet_size_is_valid (USHORT udp_packet_size)
{
	if (udp_packet_size < sizeof (UDP_HEADER))
		{
		++ip.udp.mib.udpInErrors;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: rxed packet dropped for invalid packet size\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST build_udp_header (UDP_HEADER *sptr_udp_pdu, UDP_HEADER *sptr_udp_header, IP_PARAMETERS *sptr_ip_parameters,
	USHORT udp_packet_size)
{
	sptr_udp_header->checksum = net_to_host_short (sptr_udp_pdu->checksum);

	if (create_pseudo_header_and_verify_checksum (udp_packet_size, sptr_ip_parameters, sptr_udp_header->checksum,
		(BYTE *) sptr_udp_pdu, UDP_PROTOCOL) == FAIL)
		{
		++ip.udp.mib.udpInErrors;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: rxed packet has bad checksum\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_udp_header->source_port = net_to_host_short (sptr_udp_pdu->source_port);
	sptr_udp_header->destination_port = net_to_host_short (sptr_udp_pdu->destination_port);
	sptr_udp_header->length = net_to_host_short (sptr_udp_pdu->length);

	print_udp_header (sptr_udp_pdu);

	return (PASS);
}
/****************************************************************************/
enum TEST create_pseudo_header_and_verify_checksum (USHORT packet_size, IP_PARAMETERS *sptr_ip_parameters,
	USHORT checksum, BYTE *bptr_to_checksummed_data, BYTE protocol_id)
{
	PSEUDO_IP_PARAMETERS pseudo_header;

	/* Create pseudo-header and verify checksum */

	pseudo_header.length = host_to_net_short (packet_size);
	pseudo_header.source_address = host_to_net_long (sptr_ip_parameters->source_address);
	pseudo_header.destination_address = host_to_net_long (sptr_ip_parameters->destination_address);
	pseudo_header.zero_field = 0x00;
	pseudo_header.protocol = protocol_id;

	if ((checksum != 0x0000) && (calculate_ip_checksum (&pseudo_header, bptr_to_checksummed_data, packet_size) != 0x0000))
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static void	set_up_local_ip_socket (USHORT rx_port_number, enum BOOLEAN *eptr_received_broadcast,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_SOCKET *sptr_local_ip_socket, IP_PARAMETERS *sptr_ip_parameters,
	UDP_HEADER *sptr_udp_header)
{
	*eptr_received_broadcast = received_broadcast_from_interface (rx_port_number, uptr_ip_rx_packet);

	if (*eptr_received_broadcast == TRUE)
		{
		/* pretend the local ip address is the receiving port's ip address */

		sptr_local_ip_socket->ip_address = ip.port[rx_port_number].config.ip_address;
		}
	else
		{
		sptr_local_ip_socket->ip_address = sptr_ip_parameters->destination_address;
		}

	sptr_local_ip_socket->port = sptr_udp_header->destination_port;
}
/****************************************************************************/
static enum TEST get_udp_control_block (UNION_IP_PACKET *uptr_ip_rx_packet, IP_SOCKET *sptr_local_ip_socket,
	IP_PARAMETERS *sptr_ip_parameters, UDP_CONTROL_BLOCK **ptr_to_sptr_udp_control_block, enum BOOLEAN received_broadcast)
{
	*ptr_to_sptr_udp_control_block = find_udp_control_block (sptr_local_ip_socket);

	if (*ptr_to_sptr_udp_control_block == NULL)
		{
/* sudhir 1/1/98
	We don't need to send icmp error packet if it the destination address
	id broadcast */
		if (received_broadcast == FALSE &&
			sptr_ip_parameters->destination_address != INTERNET_ADDRESS_BROADCAST &&
			sptr_ip_parameters->destination_address != ip.port[sptr_ip_parameters->rx_port_number].net_broadcast_address &&
			sptr_ip_parameters->destination_address != ip.port[sptr_ip_parameters->rx_port_number].subnet_broadcast_address)
			{
/* sudhir 1/1/98 */

			send_icmp_error_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
				ICMP_DESTINATION_UNREACHABLE_TYPE, ICMP_PORT_UNREACHABLE_CODE, NULL);
			}

		++ip.udp.mib.udpNoPorts;

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_if_udp_packet_has_any_data (USHORT *usptr_udp_data_length, USHORT udp_packet_size)
{
	*usptr_udp_data_length = (USHORT) (udp_packet_size - sizeof (UDP_HEADER));

	if (*usptr_udp_data_length == 0x0000)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: rxed packet has no data\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static void set_up_remote_ip_socket (IP_PARAMETERS *sptr_ip_parameters, IP_SOCKET *sptr_remote_ip_socket,
	UDP_HEADER *sptr_udp_header, USHORT rx_port_number)
{
	sptr_remote_ip_socket->ip_address = sptr_ip_parameters->source_address;
	sptr_remote_ip_socket->port = sptr_udp_header->source_port;
	sptr_remote_ip_socket->virtual_port_number = rx_port_number;
}
/****************************************************************************/
static void set_up_remote_socket_in_udp_control_block (IP_PARAMETERS *sptr_ip_parameters,
	UDP_CONTROL_BLOCK *sptr_udp_control_block, UDP_HEADER *sptr_udp_header, USHORT rx_port_number)
{
	sptr_udp_control_block->remote_socket.ip_address = sptr_ip_parameters->source_address;
	sptr_udp_control_block->remote_socket.port = sptr_udp_header->source_port;
	sptr_udp_control_block->remote_socket.virtual_port_number = rx_port_number;
}
/****************************************************************************/
enum TEST put_data_into_udp_receive_queue (UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT number_of_data_bytes,
	void *vptr_user_data, IP_SOCKET *sptr_ip_socket)
{
	UDP_BUFFER *sptr_udp_buffer;

	if ((vptr_user_data == NULL) || (number_of_data_bytes == 0x0000))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: failed to put data on receive queue\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_udp_buffer = (UDP_BUFFER *) table_malloc (1, sizeof (UDP_BUFFER));

	if (sptr_udp_buffer == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: table_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	add_entry_to_list ((LINK *) &sptr_udp_control_block->receive_queue, (LINK *) sptr_udp_buffer);

	sptr_udp_buffer->vptr_buffer = (void *) buffer_malloc (number_of_data_bytes);

	if (sptr_udp_buffer->vptr_buffer == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: buffer_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_udp_buffer->vptr_start_of_data = sptr_udp_buffer->vptr_buffer;

	memcpy ((void *) sptr_udp_buffer->vptr_start_of_data, vptr_user_data, number_of_data_bytes);

	sptr_udp_buffer->count = number_of_data_bytes;
	sptr_udp_buffer->size = number_of_data_bytes;

	sptr_udp_control_block->receive_count = (USHORT) (sptr_udp_control_block->receive_count + number_of_data_bytes);

#ifdef __IP_DEBUG__
	ip_printf (UDP_PRINTF, "UDP: %d bytes in receive queue for ip/udp port: %u\n", sptr_udp_control_block->receive_count,
		sptr_udp_control_block->local_socket.port);
#endif /* __IP__DEBUG__ */

	memcpy ((void *) &sptr_udp_buffer->remote_ip_socket, (void *) sptr_ip_socket, sizeof (IP_SOCKET));

	return (PASS);
}
/****************************************************************************/
enum TEST get_data_from_udp_receive_queue (void *vptr_context, IP_SOCKET *sptr_ip_socket, void *vptr_buffer,
	USHORT *usptr_count)
{
	UDP_CONTROL_BLOCK *sptr_udp_control_block;
	USHORT number_of_bytes;
	UDP_BUFFER *sptr_udp_buffer;

	if (sptr_ip_socket != NULL)
		{
		if ((vptr_buffer == NULL) || (*usptr_count == 0x0000))
			{
			return (FAIL);
			}
		else
			{
			sptr_udp_control_block = (UDP_CONTROL_BLOCK *) vptr_context;

			sptr_udp_buffer = get_pointer_to_first_entry_in_list ((LINK *) &sptr_udp_control_block->receive_queue);

			number_of_bytes = 0x0000;

			if (sptr_udp_buffer != NULL)
				{
				determine_number_of_bytes_to_be_copied (usptr_count, sptr_udp_buffer, &number_of_bytes);

				copy_data_into_target_buffer_and_delete_receive_queue_buffer (sptr_udp_control_block, sptr_ip_socket, vptr_buffer,
					sptr_udp_buffer, number_of_bytes);
				}

			*usptr_count = number_of_bytes;

		#ifdef __IP_DEBUG__
			ip_printf (UDP_PRINTF, "UDP: %d bytes in receive queue for ip/udp port: %u\n",
				sptr_udp_control_block->receive_count, sptr_udp_control_block->local_socket.port);
		#endif /* __IP__DEBUG__ */

			return (PASS);
			}
		}

	return (FAIL);
}
/****************************************************************************/
static void determine_number_of_bytes_to_be_copied (USHORT *usptr_count, UDP_BUFFER *sptr_udp_buffer,
	USHORT *usptr_number_of_bytes)
{
	if (*usptr_count > sptr_udp_buffer->count)
		{
		*usptr_number_of_bytes = sptr_udp_buffer->count;
		}
	else
		{
		*usptr_number_of_bytes = *usptr_count;
		}
}
/****************************************************************************/
static void copy_data_into_target_buffer_and_delete_receive_queue_buffer (UDP_CONTROL_BLOCK *sptr_udp_control_block,
	IP_SOCKET *sptr_ip_socket, void *vptr_buffer, UDP_BUFFER *sptr_udp_buffer, USHORT number_of_bytes)
{
	memcpy (vptr_buffer, sptr_udp_buffer->vptr_start_of_data, number_of_bytes);

	sptr_udp_control_block->receive_count = (USHORT) (sptr_udp_control_block->receive_count - sptr_udp_buffer->count);

	memcpy ((void *) sptr_ip_socket, (void *) &sptr_udp_buffer->remote_ip_socket, sizeof (IP_SOCKET));

	delete_entry_from_list ((LINK *) &sptr_udp_control_block->receive_queue, (LINK *) sptr_udp_buffer);

	table_free ((void *) sptr_udp_buffer->vptr_buffer);

	table_free ((void *) sptr_udp_buffer);
}
/****************************************************************************/
void udp_print_control_block (UDP_CONTROL_BLOCK *sptr_udp_control_block)
{
	PARAMETER_NOT_USED (sptr_udp_control_block);
}
/*****************************************************************************/
void free_udp_control_blocks (void)
{
	UDP_CONTROL_BLOCK *sptr_udp_control_block;
	UDP_CONTROL_BLOCK *sptr_udp_control_block_next;

	sptr_udp_control_block = (UDP_CONTROL_BLOCK *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.udp.current_control_block_list);

	while (sptr_udp_control_block != NULL)
		{
		sptr_udp_control_block_next = (UDP_CONTROL_BLOCK *) get_pointer_to_next_entry_in_list ((LINK *) sptr_udp_control_block);

		delete_udp_control_block (sptr_udp_control_block);

		sptr_udp_control_block = sptr_udp_control_block_next;
		}
}
/****************************************************************************/
enum TEST delete_udp_control_block (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_delete)
{
	delete_buffers_on_udp_receive_queue (sptr_udp_control_block_to_delete);

	delete_entry_from_list ((LINK *) &ip.udp.current_control_block_list, (LINK *) &sptr_udp_control_block_to_delete->links);

	table_free ((void *) sptr_udp_control_block_to_delete);

	return (PASS);
}
/*****************************************************************************/
static void delete_buffers_on_udp_receive_queue (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_delete)
{
	UDP_BUFFER *sptr_udp_buffer;
	UDP_BUFFER *sptr_udp_buffer_next;

	sptr_udp_buffer = (UDP_BUFFER *) get_pointer_to_first_entry_in_list (
		(LINK *) &sptr_udp_control_block_to_delete->receive_queue);

	while (sptr_udp_buffer != NULL)
		{
		sptr_udp_buffer_next = (UDP_BUFFER *) get_pointer_to_next_entry_in_list ((LINK *) sptr_udp_buffer);

		table_free ((void *) sptr_udp_buffer->vptr_buffer);

		table_free ((void *) sptr_udp_buffer);

		sptr_udp_buffer = sptr_udp_buffer_next;
		}
}

/* sudhir 11/7/97 for proxy server */

USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port)
{
	UDP_HEADER *sptr_udp_pdu;

	sptr_udp_pdu = (UDP_HEADER *) ((ULONG) uptr_ip_rx_packet + 
		sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);
	*destination_port = sptr_udp_pdu->source_port;
	return sptr_udp_pdu->destination_port;	
}

void set_udp_src_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port)
{
  UDP_HEADER *sptr_udp_pdu;

	sptr_udp_pdu = (UDP_HEADER *) ((ULONG) uptr_ip_rx_packet + 
		sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);
	
	sptr_udp_pdu->source_port = new_port;
	return;
}

void set_udp_dest_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port)
{
	UDP_HEADER *sptr_udp_pdu;

	sptr_udp_pdu = (UDP_HEADER *) ((ULONG) uptr_ip_rx_packet + 
		sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);
	
	sptr_udp_pdu->destination_port = new_port;
	return;
}


BYTE *get_ptr_to_udp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	BYTE *sptr_udp_pdu;

	sptr_udp_pdu = (BYTE *) ((ULONG) uptr_ip_rx_packet + 
		sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);

	return sptr_udp_pdu;
}
/* sudhir 11/7/97 for proxy server */
