#include	"defs.h"
/*
 * $Log: /IP/UDPTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: udptx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ip.h"
#include "..\..\applicat\proxy\kdetip.h"     /* Imran 22 Feb '99 */
/****************************************************************************/
static void	build_pseudo_header (USHORT udp_length, PSEUDO_IP_PARAMETERS *sptr_pseudo_header, ULONG local_ip_address,
	IP_SOCKET *sptr_remote_socket);
static void	build_udp_header_in_packet (IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket,
	PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet);
void	compute_checksum_for_packet (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet, USHORT length);
static void	build_ip_parameters (ULONG local_ip_address, IP_SOCKET *sptr_remote_socket,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_parameters, SERVICE_TYPE_BIT_STRUCTURE type_of_service, BYTE time_to_live,
	USHORT sequence_identifier, enum BOOLEAN do_not_fragment_flag, USHORT transmit_port_number,
	UDP_CONTROL_BLOCK *sptr_udp_control_block);
void allocate_space_and_copy_data_to_udp_packet (UNION_IP_PACKET **ptr_to_sptr_udp_packet,
	USHORT *usptr_size_of_udp_packet, void *vptr_user_data, USHORT number_of_data_bytes);
void send_completion_udp_packet (USHORT port_number, UNION_IP_PACKET *sptr_udp_tx_packet);
static UNION_IP_PACKET *udp_user_get_buffer (USHORT data_and_header_size);
static void udp_user_free_buffer (UNION_IP_PACKET *sptr_udp_tx_packet);
/****************************************************************************/
USHORT send_udp (USHORT tx_port_number, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket,
	SERVICE_TYPE_BIT_STRUCTURE type_of_service,
	BYTE time_to_live, void *vptr_udp_packet, USHORT sequence_identifier, enum BOOLEAN do_not_fragment_flag,
	USHORT number_of_bytes, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet), void *vptr_control_block)
{
	UDP_PACKET *sptr_udp_packet;
	ULONG local_ip_address;
	PSEUDO_IP_PARAMETERS pseudo_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	USHORT pdu_length;

	++ip.udp.mib.udpOutDatagrams;

	sptr_udp_packet = (UDP_PACKET *) vptr_udp_packet;

	local_ip_address = sptr_local_socket->ip_address;

	if ((tx_port_number == NO_SUCH_PORT) && (local_ip_address == INTERNET_ADDRESS_ANY))
		{
		local_ip_address = ip_get_address_of_outgoing_interface (sptr_remote_socket->ip_address);

/* Kamalnath 13/09/1996 */ 
		if (local_ip_address == INTERNET_ADDRESS_ANY)
			tx_port_number = 0 ;
/* Kamalnath 13/09/1996 */
		
		}
	else if ((tx_port_number != NO_SUCH_PORT)	&& (local_ip_address == INTERNET_ADDRESS_ANY))
		{
		if (ip.port[tx_port_number].config.ip_address != 0x00000000L)
			{
			local_ip_address = ip.port[tx_port_number].config.ip_address;
			}
		}

	/* Create IP pseudo-header, compute checksum and send it */

	pdu_length = (USHORT) (number_of_bytes - (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER)));

	build_pseudo_header (pdu_length, &pseudo_header, local_ip_address, sptr_remote_socket);

	build_udp_header_in_packet (sptr_local_socket, sptr_remote_socket, &pseudo_header, sptr_udp_packet);

#ifndef NO_UDP_CHECKSUM
	compute_checksum_for_packet (&pseudo_header, sptr_udp_packet, pdu_length);
#endif

#ifdef __IP_DEBUG__
	print_udp_header (&sptr_udp_packet->header);
#endif /* __IP__DEBUG__ */

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

	build_ip_parameters (local_ip_address, sptr_remote_socket, &ip_upper_layer_parameters, type_of_service, time_to_live,
		sequence_identifier, do_not_fragment_flag, tx_port_number, (UDP_CONTROL_BLOCK *) vptr_control_block);

	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_udp_packet, number_of_bytes,
		(void (*) (USHORT port_number, IP_PACKET *sptr_tx_packet)) fptr_tx_completion);

	if (ip_upper_layer_parameters.vptr_cached_route != NULL)
		{
		if (vptr_control_block != NULL)
			{
			((UDP_CONTROL_BLOCK *) vptr_control_block)->vptr_cached_route = ip_upper_layer_parameters.vptr_cached_route;
			}
		}

	return (0x0000);
}
/****************************************************************************/
static void	build_pseudo_header (USHORT udp_length, PSEUDO_IP_PARAMETERS *sptr_pseudo_header, ULONG local_ip_address,
	IP_SOCKET *sptr_remote_socket)
{
	sptr_pseudo_header->length = host_to_net_short (udp_length);
	sptr_pseudo_header->source_address = host_to_net_long (local_ip_address);
	sptr_pseudo_header->destination_address = host_to_net_long (sptr_remote_socket->ip_address);
	sptr_pseudo_header->zero_field = 0x00;
	sptr_pseudo_header->protocol = UDP_PROTOCOL;
}
/****************************************************************************/
static void	build_udp_header_in_packet (IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket,
	PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet)
{
	sptr_udp_packet->header.source_port = host_to_net_short (sptr_local_socket->port);
	sptr_udp_packet->header.destination_port = host_to_net_short (sptr_remote_socket->port);
	sptr_udp_packet->header.length = sptr_pseudo_header->length;
	sptr_udp_packet->header.checksum = 0x0000;										/* clear checksum */
}
/****************************************************************************/
void	compute_checksum_for_packet (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet, USHORT length)
{
	USHORT checksum;

	checksum = calculate_ip_checksum (sptr_pseudo_header, (BYTE *) &sptr_udp_packet->header, length);

	/*	All zeros and all ones is equivalent in one's complement arithmetic. The spec requires us to change zeros into ones to
	 *	distinguish an all-zero checksum from no checksum at all */

	if (checksum == 0x0000)
		{
		checksum = 0xffff;
		}

	sptr_udp_packet->header.checksum = checksum;
}
/****************************************************************************/
static void	build_ip_parameters (ULONG local_ip_address, IP_SOCKET *sptr_remote_socket,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_parameters, SERVICE_TYPE_BIT_STRUCTURE type_of_service, BYTE time_to_live,
	USHORT sequence_identifier, enum BOOLEAN do_not_fragment_flag, USHORT transmit_port_number,
	UDP_CONTROL_BLOCK *sptr_udp_control_block)
{
	sptr_ip_parameters->source_address = local_ip_address;
	sptr_ip_parameters->destination_address = sptr_remote_socket->ip_address;
	sptr_ip_parameters->do_not_fragment_flag = (BYTE_ENUM (BOOLEAN)) do_not_fragment_flag;
	sptr_ip_parameters->type_of_service = type_of_service;
	sptr_ip_parameters->sequence_id = sequence_identifier;
	sptr_ip_parameters->time_to_live = time_to_live;
	sptr_ip_parameters->protocol = UDP_PROTOCOL;	 
	sptr_ip_parameters->option_length = 0x00; 
	sptr_ip_parameters->virtual_port_number = transmit_port_number;

	if (sptr_udp_control_block != NULL)
		{
		sptr_ip_parameters->vptr_cached_route = sptr_udp_control_block->vptr_cached_route;
		}
	else
		{
		sptr_ip_parameters->vptr_cached_route = NULL;
		}
}
/****************************************************************************/

/* sudhir */
USHORT get_first_active_ip_port ()
{
	USHORT port_number;

	for (port_number = 0; port_number < ip.number_of_ports; port_number++)
	{
		if ((ip.port[port_number].config.point_to_point_link == TRUE) && (ip.port[port_number].port_is_up == TRUE))
			return port_number;
	}

	return NO_SUCH_PORT;
}	
/* sudhir */


USHORT build_and_send_udp_packet (IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, BYTE type_of_service,
	void *vptr_data, USHORT number_of_bytes, UDP_CONTROL_BLOCK *sptr_udp_control_block)
{
	UNION_SERVICE_TYPE_BIT_STRUCTURE structure_type_of_service;
	BYTE time_to_live;
	UNION_IP_PACKET *sptr_ip_packet;
	USHORT size_of_udp_packet, tx_port_number = NO_SUCH_PORT;
	enum BOOLEAN do_not_fragment_flag;
	USHORT sequence_identifier;
	ULONG remote_ip_address;

/* sudhir added to support DNS
	This is to make sure that packet will go to internet 
	in case if RIP is disabled */

	if (sptr_local_socket->port == IPPORT_DOMAIN ||	sptr_remote_socket->port == IPPORT_DOMAIN)
	{
		tx_port_number = get_first_active_ip_port ();
/*		printf ("IP: DNS tx port number is %d\n",tx_port_number);*/
	}
		
/* Imran added to support auto detection of proxy server */
	if ((sptr_local_socket->port == IPPORT_DISCOVER_PROXY_SERVER)
			|| (sptr_remote_socket->port == IPPORT_DISCOVER_PROXY_SERVER))
		tx_port_number = 0;


	structure_type_of_service._byte = type_of_service;

	remote_ip_address = sptr_remote_socket->ip_address;

	if ((remote_ip_address & 0x000000ffL) == 0x000000ffL)
		{
		time_to_live = 0x01;
		}
	else
		{
		time_to_live = 0x00;
		}

	do_not_fragment_flag = TRUE;

	sequence_identifier = 0x0000;

	allocate_space_and_copy_data_to_udp_packet (&sptr_ip_packet, &size_of_udp_packet, vptr_data, number_of_bytes);

/* sudhir */
#if 0
	send_udp ((USHORT) NO_SUCH_PORT, sptr_local_socket, sptr_remote_socket, structure_type_of_service._bit, time_to_live,
		(void *) sptr_ip_packet, sequence_identifier, do_not_fragment_flag, size_of_udp_packet,
		(void (*) (USHORT port_number, void *vptr_tx_packet)) send_completion_udp_packet, (void *) sptr_udp_control_block);
#endif
	send_udp ((USHORT) tx_port_number, sptr_local_socket, sptr_remote_socket, structure_type_of_service._bit, time_to_live,
		(void *) sptr_ip_packet, sequence_identifier, do_not_fragment_flag, size_of_udp_packet,
		(void (*) (USHORT port_number, void *vptr_tx_packet)) send_completion_udp_packet, (void *) sptr_udp_control_block);
/* sudhir */
	
	return (0x0000);
}
/****************************************************************************/
void allocate_space_and_copy_data_to_udp_packet (UNION_IP_PACKET **ptr_to_sptr_udp_packet,
	USHORT *usptr_size_of_udp_packet, void *vptr_user_data, USHORT number_of_data_bytes)
{
	void *vptr_packet_data;

	*usptr_size_of_udp_packet = (USHORT) (sizeof (UDP_HEADER) + number_of_data_bytes);

	*ptr_to_sptr_udp_packet = udp_user_get_buffer (*usptr_size_of_udp_packet);

	vptr_packet_data = (void *) ((ULONG) *ptr_to_sptr_udp_packet + sizeof (UDP_PACKET) - 1);

	memcpy (vptr_packet_data, vptr_user_data, number_of_data_bytes);

	*usptr_size_of_udp_packet += (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER));
}
/*****************************************************************************/
void send_completion_udp_packet (USHORT port_number, UNION_IP_PACKET *sptr_udp_tx_packet)
{
#ifndef __IP_DEBUG__
	PARAMETER_NOT_USED (port_number);
#endif /* __IP__DEBUG__ */
	if (sptr_udp_tx_packet == NULL)
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_DIAGNOSTIC_PRINTF,
			"UDP: send_completion_udp_packet () : called with port number %u, and NULL pointer to packet\n", port_number);
	#endif /* __IP__DEBUG__ */
		}
	else
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_DIAGNOSTIC_PRINTF,
			"UDP: send_completion_udp_packet () : called with port number %u and %p as pointer\n", port_number,
			sptr_udp_tx_packet);

		ip_printf (IP_DIAGNOSTIC_PRINTF, "UDP: txed packet %s,%u -> %s,%u\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0],
				net_to_host_long (sptr_udp_tx_packet->udp.ip_header.source_ip_address)),
			net_to_host_short (sptr_udp_tx_packet->udp.header.source_port),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0],
				net_to_host_long (sptr_udp_tx_packet->udp.ip_header.destination_ip_address)),
			net_to_host_short (sptr_udp_tx_packet->udp.header.destination_port));
	#endif /* __IP__DEBUG__ */

		udp_user_free_buffer (sptr_udp_tx_packet);
		}
}
/*****************************************************************************/
static UNION_IP_PACKET *udp_user_get_buffer (USHORT data_and_header_size)
{
	UNION_IP_PACKET *sptr_udp_tx_packet;
	USHORT reserved_bytes;
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG length;
	ULONG new_offset;

	reserved_bytes = sizeof (UNION_MAC_HEADER) + MINIMUM_IP_HEADER_LENGTH;

	length = data_and_header_size + reserved_bytes + EXTRA_FRAME_HEADER_BYTES;

	bptr_buffer = (BYTE *) buffer_malloc (length);

	if (bptr_buffer == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: buffer_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
		}

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: Allocated buffer at %p of length %ul\n",
		bptr_buffer, length);
#endif /* __IP__DEBUG__ */

	bptr_offset = bptr_buffer + EXTRA_FRAME_HEADER_BYTES/2;

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: bptr_offset : %p, new_offset : %x, bptr_new_offset : %p\n",
		bptr_offset, new_offset, bptr_new_offset);
#endif /* __IP__DEBUG__ */

	memcpy ((void *) bptr_new_offset, (const void *) &bptr_buffer, sizeof (ULONG));

	sptr_udp_tx_packet = (UNION_IP_PACKET *) (bptr_new_offset + EXTRA_FRAME_HEADER_BYTES/2);

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: Pointer to send packet %p\r\n", sptr_udp_tx_packet);
#endif /* __IP__DEBUG__ */

	++ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes;

	return (sptr_udp_tx_packet);
}
/*****************************************************************************/
static void udp_user_free_buffer (UNION_IP_PACKET *sptr_udp_tx_packet)
{
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG new_offset;

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: Freeing packet %p\r\n", sptr_udp_tx_packet);
#endif /* __IP__DEBUG__ */

	bptr_offset = (BYTE *) sptr_udp_tx_packet;

	bptr_offset = (bptr_offset - (EXTRA_FRAME_HEADER_BYTES/4));

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: bptr_offset : %p, new_offset : %x, bptr_new_offset : %p\n",
		bptr_offset, new_offset, bptr_new_offset);
#endif /* __IP__DEBUG__ */

	memcpy ((void *) &bptr_buffer, (const void *) bptr_new_offset, sizeof (ULONG));

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "UDP: Freeing buffer at %p\n", bptr_buffer);
#endif /* __IP__DEBUG__ */

	buffer_free ((void *) bptr_buffer);

	--ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes;
}
/****************************************************************************/
void print_udp_header (UDP_HEADER *sptr_udp_header)
{
	if (ip.print_class.udp_printing_enabled == TRUE)
		{
		ip_printf (UDP_PRINTF, "UDP: header: src.port:%u --> dest.port:%u, length:%u, checksum:%x\n",
			net_to_host_short (sptr_udp_header->source_port), net_to_host_short (sptr_udp_header->destination_port),
			net_to_host_short (sptr_udp_header->length), sptr_udp_header->checksum);
		}
}
