/*
 * $Log: /IP/VARPUSER.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VARPUSER_H_
#define _VARPUSER_H_


typedef	struct	ARP_TABLE_ENTRY_LINK
{
	struct ARP_TABLE_ENTRY		*sptr_forward_link;
	struct ARP_TABLE_ENTRY		*sptr_backward_link;
} ARP_TABLE_ENTRY_LINK;


typedef	struct	UNION_IP_PACKET_LIST_LINK
{
	struct UNION_IP_PACKET_LIST_ELEMENT		*sptr_forward_link;
	struct UNION_IP_PACKET_LIST_ELEMENT		*sptr_backward_link;
} UNION_IP_PACKET_LIST_LINK;


typedef	struct	UNION_IP_PACKET_LIST_ELEMENT
{
	UNION_IP_PACKET_LIST_LINK				links;
	union UNION_IP_PACKET 					*sptr_packet_waiting_to_send;
	USHORT										number_of_bytes_to_send;
} UNION_IP_PACKET_LIST_ELEMENT;


typedef struct ARP_TABLE_ENTRY
{
	ARP_TABLE_ENTRY_LINK						links;
	USHORT	  									timer;
	USHORT	  									number_of_retransmissions;
	UNION_IP_PACKET_LIST_LINK				list_of_packets_waiting_to_be_sent;
	USHORT										number_of_packets_on_list;
	ULONG 										ip_address;
	MAC_ADDRESS									hardware_address;
	USHORT										port_number;
	BYTE_ENUM (ARP_TABLE_ENTRY_TYPE)		type;
	BYTE_ENUM (BOOLEAN)						use_rif;
	BYTE											rif[MAXIMUM_SIZE_OF_RIF];
	BYTE											length_of_rif;
} ARP_TABLE_ENTRY;


#endif /* _VARPUSER_H_ */
