/*
 * $Log: /IP/VICMPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vicmpstr.h$  $version: 1.6$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 05/02/94 yarran added rfc1042 changes.
1.4 09/01/94 ross added BYTE and USHORT_ENUM support.
1.5 12/27/94 ross added better table instrumentation via new snmp.
1.6 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VICMPSTR_H_
#define _VICMPSTR_H_


typedef struct ICMP_MIB 
{
	ULONG 		icmpInMsgs;
	ULONG 		icmpInErrors;
	ULONG 		icmpInDestUnreachs;
	ULONG 		icmpInTimeExcds;
	ULONG 		icmpInParmProbs;
	ULONG 		icmpInSrcQuenchs;
	ULONG 		icmpInRedirects;
	ULONG 		icmpInEchos;
	ULONG 		icmpInEchoReps;
	ULONG 		icmpInTimestamps;
	ULONG 		icmpInTimestampReps;
	ULONG 		icmpInAddrMasks;
	ULONG 		icmpInAddrMaskReps;
	ULONG 		icmpOutMsgs;
	ULONG 		icmpOutErrors;
	ULONG 		icmpOutDestUnreachs;
	ULONG 		icmpOutTimeExcds;
	ULONG 		icmpOutParmProbs;
	ULONG 		icmpOutSrcQuenchs;
	ULONG 		icmpOutRedirects;
	ULONG 		icmpOutEchos;
	ULONG 		icmpOutEchoReps;
	ULONG 		icmpOutTimestamps;
	ULONG 		icmpOutTimestampReps;
	ULONG 		icmpOutAddrMasks;
	ULONG 		icmpOutAddrMaskReps;
} ICMP_MIB;


typedef struct ICMP_UNREACHABLE_MESSAGE
{
	USHORT 			unused;
	USHORT 			mtu;
	IP_HEADER 		ip_data;
}ICMP_UNREACHABLE_MESSAGE;


typedef struct ICMP_PARAM_PROBLEM_MESSAGE
{
	BYTE				pointer;
	BYTE				unused[3];
	IP_HEADER 		ip_data;
} ICMP_PARAM_PROBLEM_MESSAGE;


typedef struct ICMP_REDIRECT_MESSAGE
{
	ULONG				gateway;
	IP_HEADER 		ip_data;
} ICMP_REDIRECT_MESSAGE;


typedef struct ICMP_ECHO_MESSAGE
{
	USHORT 		identifier;
	USHORT 		sequence_number;
} ICMP_ECHO_MESSAGE;


typedef struct ICMP_SOURCE_QUENCH_MESSAGE
{
	ULONG				unused;
	IP_HEADER 		ip_data;
} ICMP_SOURCE_QUENCH_MESSAGE;


typedef struct ICMP_TIME_EXCEEDED_MESSAGE
{
	ULONG				unused;
	IP_HEADER 		ip_data;
/* Sachin 07/10/1996 */
	BYTE     		data[8] ;
/* Sachin 07/10/1996 */
} ICMP_TIME_EXCEEDED_MESSAGE;


typedef struct ICMP_TIMESTAMP_MESSAGE
{
	USHORT 		identifier;
	USHORT 		sequence_number;
	ULONG			orginate_timestamp;
	ULONG			receive_timestamp;
	ULONG			transmit_timestamp;
} ICMP_TIMESTAMP_MESSAGE;


typedef struct ICMP_ADDRESS_MASK_MESSAGE
{
	USHORT 		identifier;
	USHORT 		sequence_number;
	ULONG			mask;
} ICMP_ADDRESS_MASK_MESSAGE;


typedef struct ECHO_PARAMETER
{
	USHORT 		identifier;
	USHORT 		sequence_number;
} ECHO_PARAMETER;


typedef union UNION_ICMP_PARAMETER
{
	ULONG 					unused;
	USHORT 					mtu;					/* rfc792 does not require mtu */
	ULONG 					gateway_address;
	ULONG 					address_mask;
	BYTE 						pointer;
	ECHO_PARAMETER 		echo;
} UNION_ICMP_PARAMETER;


typedef union UNION_ICMP_PACKET_OPTIONS
{
	ICMP_UNREACHABLE_MESSAGE 			unreachable_message;
	ICMP_PARAM_PROBLEM_MESSAGE 		parameter_problem_message;
	ICMP_REDIRECT_MESSAGE 				redirect_message;
	ICMP_ECHO_MESSAGE 					echo_message;
	ICMP_SOURCE_QUENCH_MESSAGE 		source_quench_message;
	ICMP_TIME_EXCEEDED_MESSAGE 		time_exceeded_message;
	ICMP_TIMESTAMP_MESSAGE 				timestamp_message;
	ICMP_ADDRESS_MASK_MESSAGE 			address_mask_message;
	ULONG										unused;
} UNION_ICMP_PACKET_OPTIONS;


typedef	union	UNION_ICMP_CODES
{
	BYTE_ENUM (ICMP_UNREACHABLE_CODE)			unreachable;
	BYTE_ENUM (ICMP_TIME_EXCEEDED_CODE)			time_to_exceed;
	BYTE_ENUM (ICMP_REDIRECT_CODE)				redirect;
	BYTE													generic;
} UNION_ICMP_CODES;


typedef struct ICMP_PARAMETERS 
{
	BYTE_ENUM (ICMP_MESSAGE_TYPE)			type;
	UNION_ICMP_CODES 							code;
 	UNION_ICMP_PARAMETER 					icmp_options;
} ICMP_PARAMETERS;


typedef	struct	ICMP_HEADER
{
	BYTE_ENUM (ICMP_MESSAGE_TYPE)			type;
	UNION_ICMP_CODES 							code;
	USHORT 										checksum;
	UNION_ICMP_PACKET_OPTIONS 				option;
} ICMP_HEADER;


typedef struct ICMP_PACKET
{
	UNION_MAC_HEADER 			mac_header;
	IP_HEADER					ip_header;
	ICMP_HEADER					header;
} ICMP_PACKET;


typedef struct ICMP_UPSTREAM_SWITCH
{
	BYTE 			protocol;
	void 			(*receive_function) (ULONG sender_ip_address, ULONG error_source_address, ULONG error_destination_address,
						BYTE icmp_type, BYTE icmp_code, void *vptr_icmp_frame);
} ICMP_UPSTREAM_SWITCH;


typedef struct ICMP_CLASS
{
	ICMP_MIB							mib;
	BYTE_ENUM (BOOLEAN) 			wait_for_echo_reply;
	USHORT							echo_request_id;
	USHORT							echo_sequence_number;
	BYTE_ENUM (BOOLEAN) 			wait_for_address_mask_reply;
	USHORT							mask_request_id;
	USHORT							mask_sequence_number;
	USHORT							periodic_mask_request_timer;
	USHORT							mask_request_timeout;
} ICMP_CLASS;



#endif /* _VICMPSTR_H_ */
