/*
 * $Log: /IP/VIPKTSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vipktstr.h$  $version: 1.8$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/09/94 yarran
1.1 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.2 03/17/94 yarran Move IP_HEADER from vipstr.h to here.
1.3 03/17/94 yarran Change type_of_service type.
1.4 03/17/94 yarran Change checksum type to USHORT from short.
1.5 05/02/94 yarran added rfc1042 changes.
1.6 12/27/94 ross added better table instrumentation via new snmp.
1.7 06/29/95 ross new snmp access routine
1.8 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VIPKTSTR_H_
#define _VIPKTSTR_H_

/* The bit fields are allocated from low-order to high-order bits within a word in Borland C++ for INTEL 80x86*/
/* WARNING: The bit fields are machine dependent! */


typedef struct VERSION_LENGTH_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned char		header_length:4;
	unsigned char		version:4;
#else
	unsigned char		version:4;
	unsigned char		header_length:4;
#endif
} VERSION_LENGTH_BIT_STRUCTURE;


typedef struct FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned char		fragment_offset_most_significant_part:5;
	unsigned char		more_fragment_flag:1;
	unsigned char		do_not_fragment_flag:1;
	unsigned char		unused_bit:1;
#else
	unsigned char		unused_bit:1;
	unsigned char		do_not_fragment_flag:1;
	unsigned char		more_fragment_flag:1;
	unsigned char		fragment_offset_most_significant_part:5;
#endif
} FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE;


typedef struct IP_HEADER
{
	VERSION_LENGTH_BIT_STRUCTURE 					version_header_length;
	SERVICE_TYPE_BIT_STRUCTURE						service_type;
	USHORT												total_length;
	USHORT												identifier;
	FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE 			flags_fragment_offset;
	BYTE													fragment_offset_least_significant_part;
	BYTE													time_to_live;
	BYTE													protocol;
	USHORT												header_checksum;
	ULONG													source_ip_address;
	ULONG													destination_ip_address;
} IP_HEADER;


typedef struct IP_HEADER_WITH_OPTIONS
{
	VERSION_LENGTH_BIT_STRUCTURE 					version_header_length;
	SERVICE_TYPE_BIT_STRUCTURE						service_type;
	USHORT												total_length;
	USHORT												identifier;
	FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE 			flags_fragment_offset;
	BYTE													fragment_offset_least_significant_part;
	BYTE													time_to_live;
	BYTE													protocol;
	USHORT												header_checksum;
	ULONG													source_ip_address;
	ULONG													destination_ip_address;
	BYTE													ip_options;
} IP_HEADER_WITH_OPTIONS;


typedef	union	UNION_OPTIONS_OR_DATA
{
	BYTE 			data;
	BYTE			ip_options;
} UNION_OPTIONS_OR_DATA;


typedef	struct	IP_PACKET
{
	UNION_MAC_HEADER				mac_header;
	IP_HEADER						header;
	UNION_OPTIONS_OR_DATA 		options_or_data;
} IP_PACKET;


typedef	struct	IP_FUNCTION_POINTERS
{
	USHORT 	 		(*fptr_get_ip_mtu) (ULONG destination_address);

	enum TEST 		(*fptr_check_ip_address) (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length);

	void 		 		(*fptr_send_ip_packet_from_upper_layer) (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request,
							enum BOOLEAN forwarded_packet, IP_PACKET *sptr_ip_packet, USHORT number_of_bytes,
							void (*fptr_tx_completion) (USHORT port_number, IP_PACKET *sptr_ip_packet));
} IP_FUNCTION_POINTERS;


#endif /* _VIPKTSTR_H_ */
