/*
 * $Log: /IP/VIPRTSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: viprtstr.h$  $version: 1.8$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/28/94 yarran Change route flags from bit map to enum BOOLEAN.
1.4 05/02/94 yarran added rfc1042 changes.
1.5 06/15/94 yarran snmp mib variables added.
1.6 12/27/94 ross added better table instrumentation via new snmp.
1.7 01/17/95 ross fixed arp problems from snmp
1.8 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VIPRTSTR_H_
#define _VIPRTSTR_H_


typedef	struct	ROUTE_FLAGS
{
	unsigned char					local_interface_route:1;		/* route is for local network interface */
	unsigned char 					route_down:1;						/* local net/subnet route is down due to local port down */
	unsigned char					private_route:1;					/* do not include in RIP update: eg. a static route or loopback */
	unsigned char					overriding_allowed:1;			/* this flag is applicable only to static routes.
																						if set, the static route can be overridden by a
																						learned route */
	unsigned char					host_route:1;						/* route to a host,
																						i.e. to a remote end of a p-to-p link or a loopback */
	unsigned char					do_no_aging:1;						/* do not apply aging timer */
	unsigned char					route_changed:1;					/* route changed and wait for RIP Update message to send */
	unsigned char					no_subnet_mask:1;					/* route is awaiting icmp address mask reply from destination */
} ROUTE_FLAGS;


typedef	struct	IP_ROUTE_ENTRY_LINK
{
	struct IP_ROUTE_ENTRY 		*sptr_forward_link;
	struct IP_ROUTE_ENTRY 		*sptr_backward_link;
} IP_ROUTE_ENTRY_LINK;


/* IP routing table entry */

typedef struct IP_ROUTE_ENTRY
{
	IP_ROUTE_ENTRY_LINK 							links;
	ULONG 											target;								/* net, subnet or full host ip address */
	ULONG 											mask;
	ULONG 											gateway;								/* 0: local attached subnet, or point-to-point link */
	USHORT 											port_number;
	ULONG 											use_count;
	BYTE												number_of_subnet_mask_bits;
/*	BYTE 												metric;*/
	ULONG 												metric;
	ROUTE_FLAGS										flags;
	USHORT 											aging_timer;						/* aging timeout value in seconds */
	BYTE_ENUM (IP_ROUTE_TYPE)					ipRouteType;
	BYTE_ENUM (IP_ROUTE_PROTOCOL_TYPE) 		ipRouteProto;

	/* Srikar, Mar 18, 1997. Added the following two fields to show -1 for unused metrics and 0 for */
	/* ipRouteInfo */
	ULONG					metric2;		/* For unused metric. */
	ULONG					ipRouteInfo;	/* Null object id for ipRouteInfo variable. */
} IP_ROUTE_ENTRY;


typedef	struct	IP_ROUTE_CACHE_LINK
{
	struct IP_ROUTE_CACHE_ENTRY 		*sptr_forward_link;
	struct IP_ROUTE_CACHE_ENTRY 		*sptr_backward_link;
} IP_ROUTE_CACHE_LINK;


/* IP route cache entry */

typedef struct IP_ROUTE_CACHE_ENTRY
{
	IP_ROUTE_CACHE_LINK 							links;
	ULONG 											target;
	ULONG 											mask;
	ULONG 											gateway;
	USHORT 											port_number;
	ULONG 											*ulptr_to_route_table_entry_use_count;
} IP_ROUTE_CACHE_ENTRY;


/* IP route cache entry */

typedef struct IP_ROUTE_CACHE_HASH_BUCKET
{
	IP_ROUTE_CACHE_LINK 							links;
	ULONG 											use_count;
	BYTE 												number_of_entries;
} IP_ROUTE_CACHE_HASH_BUCKET;


#endif /* _VIPRTSTR_H_ */
