#include	"defs.h"
/*	$Modname: ipxendst.c$  $version: 1.8$      $date: 03/23/95$   */
/*
* 	$lgb$
1.0 08/08/94 ross
1.1 08/08/94 ross Added copyright
1.2 08/25/94 ross fixed timer call bug.  Courtesy of Bill.
1.3 10/11/94 ross sockets.
1.4 10/12/94 ross general fixes.
1.5 11/07/94 ross fixed source node address.  Courtesy of Danny.
1.6 11/21/94 ross changed to compile under C++.
1.7 02/21/95 ross ipx open socket forgot to return the dynamic socket.  Courtesy of Don.
1.8 03/23/95 ross changed port address to router address in get local target.  Courtesy of Danny.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	<stdlib.h>
#include	"ipxendst.h"
/*************************************************************************/
static enum RX_PACKET_STATE ipx_end_station_packet_received (void *vptr_buffer,USHORT number_of_bytes);
static SOCKET_LIST_ENTRY *find_socket (USHORT socket);
static void ipx_end_station_timer_routine (void);
static void call_ecb_event_service_routine (EVENT_CONTROL_BLOCK *sptr_ecb);
static void ipx_end_station_send_completion (USHORT virtual_port_number,IPX_PACKET *sptr_tx_packet);
static EVENT_CONTROL_BLOCK *find_matching_tx_ecb (IPX_PACKET *sptr_txed_packet);
/*************************************************************************/
enum TEST register_end_station_to_ipx (char *cptr_end_station_name,
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void))
{
	strcpy (ipx_class.end_station.name,cptr_end_station_name);

	ipx_class.end_station.fptr_rx_routine = fptr_rx_routine;
	ipx_class.end_station.fptr_timer_routine = fptr_timer_routine;

	return (PASS);
}
/*************************************************************************/
enum TEST register_transport_to_ipx (char *cptr_transport_name,enum TRANSPORT_TYPE type,
	void (*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes),
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void *vptr_context[NUMBER_OF_IPX_PORTS],
	USHORT *usptr_return_transport_id)
{
	strcpy (ipx_class.transport.name,cptr_transport_name);

	ipx_class.transport.type = type;

	ipx_class.transport.fptr_packet_transmitted = fptr_packet_transmitted;
	ipx_class.transport.fptr_rx_routine = fptr_rx_routine;
	ipx_class.transport.fptr_timer_routine = fptr_timer_routine;
	ipx_class.transport.fptr_control_routine = fptr_control_routine;

	memcpy (&ipx_class.transport.vptr_context[0],&vptr_context[0],sizeof (ipx_class.transport.vptr_context));

	*usptr_return_transport_id = ipx_class.number_of_transports;

	++ipx_class.number_of_transports;

	return (PASS);
}
/*************************************************************************/
enum TEST register_ncp_to_ipx (char *cptr_ncp_name,enum TRANSPORT_TYPE type,
	void (*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes),
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void *vptr_context[NUMBER_OF_IPX_PORTS],
	USHORT *usptr_return_transport_id)
{
	strcpy (ipx_class.ncp.name,cptr_ncp_name);

	ipx_class.ncp.type = type;

	ipx_class.ncp.fptr_packet_transmitted = fptr_packet_transmitted;
	ipx_class.ncp.fptr_rx_routine = fptr_rx_routine;
	ipx_class.ncp.fptr_timer_routine = fptr_timer_routine;
	ipx_class.ncp.fptr_control_routine = fptr_control_routine;

	memcpy (&ipx_class.ncp.vptr_context[0],&vptr_context[0],sizeof (ipx_class.ncp.vptr_context));

	*usptr_return_transport_id = ipx_class.number_of_transports;

	++ipx_class.number_of_transports;

	return (PASS);
}
/*************************************************************************/
void initialize_end_station_ipx (void)
{
	register_end_station_to_ipx ("Internal End Station",ipx_end_station_packet_received,ipx_end_station_timer_routine);
}
/*************************************************************************/
enum TEST ipx_end_station_send_packet (EVENT_CONTROL_BLOCK *sptr_tx_ecb,enum BOOLEAN override_source_address)
{
	USHORT dummy_transport_time;
	USHORT virtual_port_number;
	SAP_ID *sptr_internal_sap_id;
	SOCKET_LIST_ENTRY *sptr_socket_entry;
	IPX_PACKET *sptr_ipx_packet;

	sptr_socket_entry = find_socket (sptr_tx_ecb->socket_number);

	if (sptr_socket_entry == NULL)
		{
		sptr_tx_ecb->in_use = FALSE;
		sptr_tx_ecb->completion_code = IPX_END_STATION_FAIL;

		call_ecb_event_service_routine (sptr_tx_ecb);

		return (FAIL);
		}

	sptr_ipx_packet = (IPX_PACKET *) sptr_tx_ecb->fragment_descriptor[0].type.vptr_buffer;

	if (ipx_get_local_target (&sptr_ipx_packet->ipx_header.destination,
		(MAC_ADDRESS *) &sptr_ipx_packet->ethernet_header.destination_address,&dummy_transport_time,
		&virtual_port_number) == IPX_END_STATION_OK)
		{
		sptr_ipx_packet->ethernet_header.source_address = ipx_class.port[virtual_port_number].ethernet_address;
		sptr_ipx_packet->ethernet_header.length = RAW_8023_IPX;

		sptr_ipx_packet->ipx_header.checksum = 0xffff;
		sptr_ipx_packet->ipx_header.length = 
			swap ((USHORT) (sptr_tx_ecb->fragment_descriptor[0].size_of_buffer - sizeof (MAC_HEADER)));

		sptr_ipx_packet->ipx_header.packet_type = PACKET_EXCHANGE_PACKET;

		if (override_source_address == FALSE)
			{
			sptr_internal_sap_id = get_ipx_internal_SAP_id ();

			sptr_ipx_packet->ipx_header.source.network = sptr_internal_sap_id->ipx_address.network;
			sptr_ipx_packet->ipx_header.source.node_address = sptr_internal_sap_id->ipx_address.node_address;
			sptr_ipx_packet->ipx_header.source.socket = sptr_tx_ecb->socket_number;
			}

		add_entry_to_list ((LINK *) &ipx_class.end_station.tx_ecb_list,(LINK *) &sptr_tx_ecb->sptr_forward_ecb);

		sptr_tx_ecb->in_use = TRUE;

		if (send_ipx_packet (virtual_port_number,(IPX_PACKET *) sptr_ipx_packet,
			sptr_tx_ecb->fragment_descriptor[0].size_of_buffer,FALSE,
			(void (*) (USHORT port_number,IPX_PACKET *sptr_tx_packet)) ipx_end_station_send_completion) ==
			DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED)
			{
			sptr_tx_ecb->completion_code = IPX_USER_TX_OK;

			return (PASS);
			}
		else
			{
			sptr_tx_ecb->in_use = FALSE;
			sptr_tx_ecb->completion_code = IPX_USER_TX_FAIL;

			/* Will be posted by IPX layer */
			return FAIL;
			}
		}

	sptr_tx_ecb->in_use = FALSE;
	sptr_tx_ecb->completion_code = IPX_TARGET_NOT_FOUND;

	call_ecb_event_service_routine (sptr_tx_ecb); 

	return (FAIL);
}
/*************************************************************************/
static void ipx_end_station_send_completion (USHORT virtual_port_number,IPX_PACKET *sptr_tx_packet)
{
	EVENT_CONTROL_BLOCK *sptr_txed_ecb;

	sptr_txed_ecb = find_matching_tx_ecb (sptr_tx_packet);

	if (sptr_txed_ecb == NULL)
		{
		ipx_printf (ALARM_PRINTF,"No matching ecb for user transmit completion routine\r\n",virtual_port_number);
		}
	else
		{
		sptr_txed_ecb->in_use = FALSE;
		sptr_txed_ecb->completion_code = IPX_USER_TX_OK;

		call_ecb_event_service_routine (sptr_txed_ecb);
		}
}
/*************************************************************************/
static EVENT_CONTROL_BLOCK *find_matching_tx_ecb (IPX_PACKET *sptr_txed_packet)
{
	EVENT_CONTROL_BLOCK *sptr_txed_ecb;
	ULONG upper_limit;
	ULONG lower_limit;

	for (sptr_txed_ecb = (EVENT_CONTROL_BLOCK *) &ipx_class.end_station.tx_ecb_list.sptr_forward_link; sptr_txed_ecb != NULL;
		sptr_txed_ecb = sptr_txed_ecb->sptr_forward_ecb)
		{
		upper_limit = (ULONG) sptr_txed_ecb->fragment_descriptor[0].type.vptr_buffer + LIMIT_ADDRESS;
		lower_limit = (ULONG) sptr_txed_ecb->fragment_descriptor[0].type.vptr_buffer - LIMIT_ADDRESS;

		if ((lower_limit < (ULONG) sptr_txed_packet) && ((ULONG) sptr_txed_packet < upper_limit))
			{
			delete_entry_from_list ((LINK *) &ipx_class.end_station.tx_ecb_list,(LINK *) &sptr_txed_ecb->sptr_forward_ecb);

			return (sptr_txed_ecb);
			}
		}

	return (NULL);
}
/*************************************************************************/
static enum RX_PACKET_STATE ipx_end_station_packet_received (void *vptr_buffer,USHORT number_of_bytes)
{
	IPX_PACKET *sptr_ipx_packet;
	SOCKET_LIST_ENTRY *sptr_socket_entry;
	EVENT_CONTROL_BLOCK *sptr_rx_ecb;

	sptr_ipx_packet = (IPX_PACKET *) vptr_buffer;

	sptr_socket_entry = find_socket (sptr_ipx_packet->ipx_header.destination.socket);

	if (sptr_socket_entry != NULL)
		{
		sptr_rx_ecb = (EVENT_CONTROL_BLOCK *) get_entry_from_list ((LINK *) &sptr_socket_entry->rx_ecb_list);

		if (sptr_rx_ecb != NULL)
			{
			sptr_rx_ecb->in_use = FALSE;
			sptr_rx_ecb->completion_code = IPX_END_STATION_OK;

			memcpy (sptr_rx_ecb->fragment_descriptor[0].type.vptr_buffer,sptr_ipx_packet,number_of_bytes);

			sptr_rx_ecb->fragment_descriptor[0].size_of_buffer = number_of_bytes;

			call_ecb_event_service_routine (sptr_rx_ecb);
			}
		}

	return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
}
/*************************************************************************/
static void ipx_end_station_timer_routine (void)
{
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_open_socket (USHORT *usptr_socket)
{
	SOCKET_LIST_ENTRY *sptr_socket_list_entry;
	USHORT dynamic_socket;

	if (*usptr_socket == ALLOCATE_DYNAMIC_SOCKET)
		{
		dynamic_socket = DYNAMIC_SOCKET_START;

		while (find_socket (dynamic_socket) != NULL)
			{
			dynamic_socket = swap ((USHORT) (swap (dynamic_socket) + 1));
			}
		}
	else
		{
		sptr_socket_list_entry = find_socket (*usptr_socket);

		if (sptr_socket_list_entry != NULL)
			{
			return (IPX_SOCKET_IN_USE);
			}

		dynamic_socket = *usptr_socket;
		}

	sptr_socket_list_entry = (SOCKET_LIST_ENTRY *) table_malloc (sizeof (SOCKET_LIST_ENTRY),1);

	if (sptr_socket_list_entry != NULL)
		{
		sptr_socket_list_entry->socket = dynamic_socket;

		add_entry_to_list (&ipx_class.end_station.socket_list,&sptr_socket_list_entry->links);

		*usptr_socket = dynamic_socket;

		return (IPX_END_STATION_OK);
		}
	else
		{
		return (IPX_SOCKET_TABLE_FULL);
		}
}
/*************************************************************************/
static SOCKET_LIST_ENTRY *find_socket (USHORT socket)
{
	SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	for (sptr_socket_list_entry = (SOCKET_LIST_ENTRY *) ipx_class.end_station.socket_list.sptr_forward_link;
		sptr_socket_list_entry != NULL; sptr_socket_list_entry =
		(SOCKET_LIST_ENTRY *) sptr_socket_list_entry->links.sptr_forward_link)
		{
		if (sptr_socket_list_entry->socket == socket)
			{
			return (sptr_socket_list_entry);
			}
		}

	return (NULL);
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_close_socket (USHORT socket)
{
	SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	sptr_socket_list_entry = find_socket (socket);

	if (sptr_socket_list_entry->socket != 0x0000)
		{
		delete_entry_from_list (&ipx_class.end_station.socket_list,&sptr_socket_list_entry->links);

		table_free (sptr_socket_list_entry);

		return (IPX_SOCKET_CLOSED);
		}
	else
		{
		return (IPX_SOCKET_NOT_FOUND);
		}
}
/*************************************************************************/
static void call_ecb_event_service_routine (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	if (sptr_ecb->fptr_event_service_routine != NULL)
		{
		(*sptr_ecb->fptr_event_service_routine) (sptr_ecb);
		}
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_cancel_packet (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	PARAMETER_NOT_USED (sptr_ecb);
#ifdef COMMENT
	enum BOOLEAN return_code;
	IPX_SESSION_CLASS *sptr_session;

	sptr_session = ecb_in_session (sptr_ecb);

	if (sptr_session != NULL)
		{
		ipx_abort_connection (sptr_session->connection_number);

		return (IPX_SUCCESSFUL);
		}
	else
		{
		return (IPX_ECB_NOT_FOUND);
		}
#endif
		return (IPX_END_STATION_OK);
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_check_socket (USHORT socket)
{
	SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	sptr_socket_list_entry = find_socket (socket);

	if (sptr_socket_list_entry->socket != 0x0000)
		{
		return (IPX_END_STATION_OK);
		}
	else
		{
		return (IPX_SOCKET_NOT_FOUND);
		}
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_get_local_target (IPX_ADDRESS *sptr_ipx_address,MAC_ADDRESS *sptr_destination_mac_address,
	USHORT *sptr_transport_time,USHORT *usptr_virtual_port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	USHORT	local_port_number;

	/* first check for a locally attached route */

	for (local_port_number = ipx_class.starting_port_number; local_port_number < ipx_class.number_of_ports; ++local_port_number)
		{
		if (sptr_ipx_address->network == ipx_class.port[local_port_number].network)
			{
			*sptr_transport_time = ipx_class.port[local_port_number].transport_time;
			*sptr_destination_mac_address = *((MAC_ADDRESS *) &sptr_ipx_address->node_address);
			*usptr_virtual_port_number = local_port_number;

			return (IPX_END_STATION_OK);
			}
		}

	/* now check other routers for route to destination network */

	for (sptr_primary_route_entry = ipx_class.router_list.sptr_forward_link; sptr_primary_route_entry != NULL;
		sptr_primary_route_entry = sptr_primary_route_entry->links.sptr_forward_link)
		{
		if (sptr_primary_route_entry->route_entry.network == sptr_ipx_address->network)
			{
			*usptr_virtual_port_number = sptr_primary_route_entry->port_number;
			*sptr_destination_mac_address = *((MAC_ADDRESS *) &sptr_primary_route_entry->router_address);
			*sptr_transport_time = sptr_primary_route_entry->route_entry.transport_time;

			return (IPX_END_STATION_OK);
			}
		}

	return (IPX_TARGET_NOT_FOUND);
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_cancel_event (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	PARAMETER_NOT_USED (sptr_ecb); /* not implemented yet */

	return (IPX_END_STATION_OK);
}
/*************************************************************************/
void ipx_get_internetwork_address (IPX_ADDRESS *sptr_ipx_address)
{
	SAP_ID *sptr_sap_id;

	sptr_sap_id = get_ipx_internal_SAP_id ();

	*sptr_ipx_address = sptr_sap_id->ipx_address;
}
/*************************************************************************/
char *ipx_get_internal_name(void)
{
        SAP_ID *sptr_sap_id;

        sptr_sap_id = get_ipx_internal_SAP_id ();

        return sptr_sap_id.SAP_name;
}
/*************************************************************************/
enum IPX_COMPLETION_CODE ipx_listen_for_packet (EVENT_CONTROL_BLOCK *sptr_ecb,void *vptr_context)
{
	SOCKET_LIST_ENTRY *sptr_socket_entry;

	sptr_ecb->vptr_context = vptr_context;

	sptr_socket_entry = find_socket (sptr_ecb->socket_number);

	if (sptr_socket_entry != NULL)
		{
		add_entry_to_list ((LINK *) &sptr_socket_entry->rx_ecb_list,(LINK *) &sptr_ecb->sptr_forward_ecb);

		return (IPX_END_STATION_OK);
		}
	else
		{
		return (IPX_SOCKET_NOT_FOUND);
		}
}
