#include	"defs.h"
/*	$Modname: ipxsock.c$  $version: 1.3$      $date: 11/21/94$   */
/*
* 	$lgb$
1.0 10/11/94 ross
1.1 10/11/94 ross sockets.
1.2 10/12/94 ross general fixes.
1.3 11/21/94 ross changed to compile under C++.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include "\rtrware\socket\socklib.h"
#include "ipxendst.h"
#include "visktstr.h"
/*****************************************************************************************/
IPX_SOCKET_CLASS ipx_socket;

static void build_listen_ecbs (IPX_ECB_SOCKET_CLASS *sptr_ipx_socket);
static void convert_socket_address_to_ipx_address (IPX_ADDRESS *sptr_ipx_address,SOCKADDR_IPX *sptr_socket_ipx_address);
static IPX_ECB_SOCKET_CLASS *find_matching_ipx_socket (IPX_ADDRESS *sptr_ipx_address);
static EVENT_CONTROL_BLOCK *build_ipx_send_packet (IPX_ECB_SOCKET_CLASS *sptr_ipx_socket,void *vptr_data,USHORT length,
	IPX_ADDRESS *sptr_source_address,IPX_ADDRESS *sptr_destination_address);
static void tx_completion_routine (EVENT_CONTROL_BLOCK *sptr_tx_ecb);
static void socket_ipx_receive_call (EVENT_CONTROL_BLOCK *sptr_ecb);
/*****************************************************************************************/
enum TEST socket_ipx (USER_SOCKET *sptr_user_socket, USHORT protocol)
{
	PARAMETER_NOT_USED (protocol);

	ipx_socket.buffer_size = 1518;

	sptr_user_socket->socket_type_of_service = TYPE_IPX;

	initialize_end_station_ipx ();

	return (PASS);
}
/*********************************************************************************/
enum TEST socket_ipx_bind (USER_SOCKET *sptr_user_socket)
{
	IPX_ECB_SOCKET_CLASS *sptr_ipx_socket;

	sptr_ipx_socket = (IPX_ECB_SOCKET_CLASS *) table_malloc (1,sizeof (IPX_ECB_SOCKET_CLASS));

	if (sptr_ipx_socket == NULL)
		{
		return (FAIL);
		}

	sptr_ipx_socket->socket_descriptor = sptr_user_socket->socket_descriptor;
	sptr_ipx_socket->sptr_user_socket = sptr_user_socket;

	memcpy (&sptr_ipx_socket->local_address,&((SOCKADDR_IPX *) sptr_user_socket->vptr_address)->ipx_address[0],
		sizeof (sptr_ipx_socket->local_address.network) + sizeof (sptr_ipx_socket->local_address.node_address));

	sptr_ipx_socket->local_address.socket = ((SOCKADDR_IPX *) sptr_user_socket->vptr_address)->port;

	if (ipx_open_socket (&sptr_ipx_socket->local_address.socket) == IPX_END_STATION_OK)
		{
		add_entry_to_list (&ipx_socket.socket_list,&sptr_ipx_socket->links);
		}
	else
		{
		table_free (sptr_ipx_socket);

		return (FAIL);
		}

	sptr_user_socket->vptr_protocol_control_block = sptr_ipx_socket;

	build_listen_ecbs (sptr_ipx_socket);
	build_listen_ecbs (sptr_ipx_socket);
	build_listen_ecbs (sptr_ipx_socket);
	build_listen_ecbs (sptr_ipx_socket);

	return (PASS);
}
/****************************************************************************/
static void build_listen_ecbs (IPX_ECB_SOCKET_CLASS *sptr_ipx_socket)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) buffer_malloc (sizeof (ECB_WITH_PACKET) + ipx_socket.buffer_size);

	if (sptr_ecb_with_packet == NULL)
		{
		return;
		}

 	ipx_printf (DATA_PRINTF,"IPX SOCKET: Build listen \r\n");

	sptr_ecb_with_packet->vptr_user_handle = sptr_ipx_socket;

	sptr_ecb_with_packet->ecb.sptr_forward_ecb = NULL;

	sptr_ecb_with_packet->ecb.in_use = FALSE;
	sptr_ecb_with_packet->ecb.completion_code = IPX_END_STATION_OK;

	sptr_ecb_with_packet->ecb.socket_number = sptr_ipx_socket->local_address.socket;

	sptr_ecb_with_packet->ecb.fragment_count = 1;

	sptr_ecb_with_packet->ecb.fragment_descriptor[0].type.vptr_buffer = &sptr_ecb_with_packet->mac_header;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer =
		(USHORT) (sizeof (ECB_WITH_PACKET) + ipx_socket.buffer_size);

	sptr_ecb_with_packet->ecb.fptr_event_service_routine = (void (*) (EVENT_CONTROL_BLOCK *)) socket_ipx_receive_call;

	sptr_ecb_with_packet->current_byte_index = 0x0000;

	ipx_listen_for_packet (&sptr_ecb_with_packet->ecb,sptr_ipx_socket);
}
/*********************************************************************************/
enum TEST socket_ipx_connect (USER_SOCKET *sptr_user_socket)
{
	PARAMETER_NOT_USED (sptr_user_socket);

	return (PASS);
}
/*****************************************************************************************/
USHORT socket_ipx_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error)
{
	IPX_ADDRESS source_ipx_address;
	IPX_ADDRESS destination_ipx_address;
	IPX_ECB_SOCKET_CLASS *sptr_ipx_socket;
	EVENT_CONTROL_BLOCK *sptr_tx_ecb;

	*eptr_error = PASS;

	convert_socket_address_to_ipx_address (&source_ipx_address,(SOCKADDR_IPX *) sptr_user_socket->vptr_address);

	sptr_ipx_socket = find_matching_ipx_socket (&source_ipx_address);

	if (sptr_ipx_socket == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}

	convert_socket_address_to_ipx_address (&destination_ipx_address,(SOCKADDR_IPX *) sptr_sockaddr);

	sptr_tx_ecb = build_ipx_send_packet (sptr_ipx_socket,vptr_data,length,&source_ipx_address,&destination_ipx_address);

	if (sptr_tx_ecb == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}

	if (ipx_end_station_send_packet (sptr_tx_ecb,TRUE) == PASS)
		{
		return (length);
		}
	else
		{
		*eptr_error = FAIL;

		return (0x0000);
		}
}
/*************************************************************************/
static void convert_socket_address_to_ipx_address (IPX_ADDRESS *sptr_ipx_address,SOCKADDR_IPX *sptr_socket_ipx_address)
{
	memcpy (sptr_ipx_address,&sptr_socket_ipx_address->ipx_address,sizeof (sptr_socket_ipx_address->ipx_address));

	sptr_ipx_address->socket = sptr_socket_ipx_address->port;
}
/*************************************************************************/
static IPX_ECB_SOCKET_CLASS *find_matching_ipx_socket (IPX_ADDRESS *sptr_ipx_address)
{
	IPX_ECB_SOCKET_CLASS *sptr_ipx_socket;

	for (sptr_ipx_socket = (IPX_ECB_SOCKET_CLASS *) ipx_socket.socket_list.sptr_forward_link; sptr_ipx_socket != NULL;
		sptr_ipx_socket = (IPX_ECB_SOCKET_CLASS *) sptr_ipx_socket->links.sptr_forward_link)
		{
		if (memcmp (&sptr_ipx_socket->local_address,sptr_ipx_address,sizeof (IPX_ADDRESS)) == (int) NULL)
			{
			break;
			}
		}

	return (sptr_ipx_socket);
}
/*************************************************************************/
static EVENT_CONTROL_BLOCK *build_ipx_send_packet (IPX_ECB_SOCKET_CLASS *sptr_ipx_socket,void *vptr_data,USHORT length,
	IPX_ADDRESS *sptr_source_address,IPX_ADDRESS *sptr_destination_address)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) buffer_malloc (sizeof (ECB_WITH_PACKET) + length);

	if (sptr_ecb_with_packet == NULL)
		{
		return (NULL);
		}

	sptr_ecb_with_packet->vptr_user_handle = sptr_ipx_socket;

	memcpy (&sptr_ecb_with_packet->data[0],vptr_data,length);

 	ipx_printf (DATA_PRINTF,"IPX SOCKET: Send Packet\r\n");

	sptr_ecb_with_packet->ecb.sptr_forward_ecb = NULL;

	sptr_ecb_with_packet->ecb.in_use = TRUE;
	sptr_ecb_with_packet->ecb.completion_code = IPX_END_STATION_OK;

	sptr_ecb_with_packet->ecb.socket_number = sptr_destination_address->socket;

	sptr_ecb_with_packet->ecb.fragment_count = 1;

	sptr_ecb_with_packet->ecb.fragment_descriptor[0].type.vptr_buffer = &sptr_ecb_with_packet->mac_header;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer =
		(USHORT) (length + sizeof (IPX_HEADER) + sizeof (UNION_MAC_HEADER));

	sptr_ecb_with_packet->ecb.fptr_event_service_routine = (void (*) (EVENT_CONTROL_BLOCK *)) tx_completion_routine;

	sptr_ecb_with_packet->ipx_header.source = *sptr_source_address;
	sptr_ecb_with_packet->ipx_header.destination = *sptr_destination_address;

	return (&sptr_ecb_with_packet->ecb);
}
/*****************************************************************************************/
static void tx_completion_routine (EVENT_CONTROL_BLOCK *sptr_tx_ecb)
{
	sptr_tx_ecb = (EVENT_CONTROL_BLOCK *) ((ULONG) sptr_tx_ecb - sizeof (ECB_WITH_PACKET_LINKS));

	buffer_free (sptr_tx_ecb);
}
/*****************************************************************************************/
USHORT socket_ipx_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error)
{
	IPX_ADDRESS remote_ipx_address;
	IPX_ECB_SOCKET_CLASS *sptr_ipx_socket;
	ECB_WITH_PACKET *sptr_ecb_with_packet;
	USHORT current_length;
	SOCKADDR_IPX *sptr_sockaddr_ipx;

	*eptr_error = PASS;

	sptr_sockaddr_ipx = (SOCKADDR_IPX *) sptr_sockaddr;

	sptr_ipx_socket = (IPX_ECB_SOCKET_CLASS *) sptr_user_socket->vptr_protocol_control_block;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) sptr_ipx_socket->rx_ecb_list.sptr_forward_link;

	if (sptr_ecb_with_packet == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}

	remote_ipx_address = sptr_ecb_with_packet->ipx_header.source;

	current_length = length;

	while (current_length != 0x0000)
		{
		if (current_length >= sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer)
			{
			sptr_ecb_with_packet = (ECB_WITH_PACKET *) get_entry_from_list (&sptr_ipx_socket->rx_ecb_list);

			memcpy (vptr_data,&sptr_ecb_with_packet->data[sptr_ecb_with_packet->current_byte_index],
				sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer);

			current_length -= sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer;

			vptr_data = (void *) ((ULONG) vptr_data + sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer);

			buffer_free (sptr_ecb_with_packet);

			build_listen_ecbs (sptr_ipx_socket);
			}
		else
			{
			memcpy (vptr_data,&sptr_ecb_with_packet->data[sptr_ecb_with_packet->current_byte_index],current_length);

			sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer -= current_length;

			sptr_ecb_with_packet->current_byte_index += current_length;

			current_length = 0x0000;

			break;
			}

		sptr_ecb_with_packet = (ECB_WITH_PACKET *) sptr_ipx_socket->rx_ecb_list.sptr_forward_link;

		if (sptr_ecb_with_packet == NULL)
			{
			break;
			}

		sptr_ecb_with_packet->current_byte_index = 0x0000;
		}

	if ((sptr_sockaddr_ipx != NULL) && (usptr_sockaddr_length != NULL) && (*usptr_sockaddr_length >= sizeof (SOCKADDR_IPX)))
		{
		sptr_sockaddr_ipx->family = AF_INET;

		memcpy (&sptr_sockaddr_ipx->ipx_address[0],&remote_ipx_address,sizeof (sptr_sockaddr_ipx->ipx_address));

		sptr_sockaddr_ipx->port = remote_ipx_address.socket;

		*usptr_sockaddr_length = sizeof (SOCKADDR_IPX);
		}

	return ((USHORT) (length - current_length));
}
/*****************************************************************************************/
USHORT socket_ipx_queue_length (USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error)
{
	USHORT length;

	*eptr_error = PASS;

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}

	switch (queue_type)
		{
		case RECEIVE_QUEUE:

			length =	(USHORT) 
				(((IPX_ECB_SOCKET_CLASS *) sptr_user_socket->vptr_protocol_control_block)->total_number_of_bytes_in_rx_packets);

			return (length);

		case SEND_QUEUE:

			return (0x0000);

		default:

			*eptr_error = FAIL;

			return (0x0000);
		}
}
/*********************************************************************************/
enum TEST socket_ipx_shut (USER_SOCKET *sptr_user_socket, USHORT channel)
{
	PARAMETER_NOT_USED (sptr_user_socket);
	PARAMETER_NOT_USED (channel);

	return (PASS);
}
/*********************************************************************************/
enum TEST socket_ipx_close (USER_SOCKET *sptr_user_socket)
{
	if (((IPX_ECB_SOCKET_CLASS *) sptr_user_socket->vptr_protocol_control_block) != NULL)
		{
		table_free (((IPX_ECB_SOCKET_CLASS *) sptr_user_socket->vptr_protocol_control_block));
		}

	return (PASS);
}
/*********************************************************************************/
static void socket_ipx_receive_call (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	IPX_ECB_SOCKET_CLASS *sptr_ipx_socket;
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) ((ULONG) sptr_ecb - sizeof (ECB_WITH_PACKET_LINKS));

	sptr_ipx_socket = (IPX_ECB_SOCKET_CLASS *) sptr_ecb_with_packet->vptr_user_handle;

	sptr_ecb->fragment_descriptor[0].size_of_buffer -= (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IPX_HEADER)); 

	add_entry_to_list (&sptr_ipx_socket->rx_ecb_list,(LINK *) &sptr_ecb_with_packet->links);
}
/*********************************************************************************/
enum TEST socket_ipx_status (USER_SOCKET *sptr_user_socket)
{
	PARAMETER_NOT_USED (sptr_user_socket);

	return (PASS);
}
/*****************************************************************************************/
enum TEST check_ipx_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length)
{
	SOCKADDR_IPX *sptr_sockaddr_ipx;

	sptr_sockaddr_ipx = (SOCKADDR_IPX *) sptr_sockaddr;

	if ((sptr_sockaddr_ipx->family != AF_NETWARE) || (sockaddr_length < sizeof (SOCKADDR_IPX)))
		{
		return (FAIL);
		}

	return (PASS);
}
