#include	"defs.h"
/*	$Modname: ipxconfg.c$  $version: 1.9$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 03/09/94 ross new version.
1.1 03/09/94 ross added copyright.
1.2 03/14/94 ross cleaned up braces and white spaces for release.
1.3 05/09/94 ross modified wan class for ipxwan and non-ipxwan configurations
1.4 08/08/94 ross finishing end station support.
1.5 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.6 04/05/95 ross nlsp changes.
1.7 06/27/95 ross mib and nlsp changes
1.8 09/25/95 ross added changes for dynamic loading
1.9 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660	*/
/************************************************************************/
#include	<string.h>
#include	<stddef.h>
#include	"ipx.h"
#include	<vnvrmstr.h>
#include	"vnvipx.h"
/****************************************************************************/
void ipx_configuration (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1)
{
	switch (command)
		{
		case IS_PROTOCOL_STACK_ENABLED:
			*((BYTE_ENUM (BOOLEAN) *) parameter_1) = ipx_class.enabled;
			break;
		case GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS:
			*((USHORT *) parameter_1) = ipx_class.number_of_ports;
			break;
		case GET_PROTOCOL_STACK_TYPE:
			*((BYTE_ENUM (PROTOCOL_STACK_TYPE) *) parameter_1) = IPX_PROTOCOL_STACK;
			break;
		case GET_PROTOCOL_STACK_PROTOCOL_ID:
			*((USHORT_ENUM (SNAP_PROTOCOL_ID) *) parameter_1) = SNAP_IPX_PROTOCOL_ID;
			break;
		case GET_PROTOCOL_STACK_SSAP:
			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = NOVELL_SAP_FOR_IPX;
			break;
		case GET_PROTOCOL_STACK_DSAP:
			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = NOVELL_SAP_FOR_IPX;
			break;
		case GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE:
			*((USHORT_ENUM (LSL_PACKET_TYPE) *) parameter_1) = ipx_class.port[parameter_0].tx_frame_type;
			break;
		case GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER:
			*((USHORT *) parameter_1) = ipx_class.port[parameter_0].real_port_number;
			break;
		}
}
/****************************************************************************/
void map_ipx_network_numbers (char *cptr_port_number_ipx_network_address_string)
{
	USHORT port_number;
	ULONG network_number;

	network_number = get_port_number_and_hex_value (cptr_port_number_ipx_network_address_string,&port_number);

	network_number = swap_long (network_number);

	ipx_class.port[port_number].virtual_port_number = port_number;
	ipx_class.port[port_number].network = network_number;

	ipx_class.port[port_number].lan_circuit_mib.ipxCircIndex = port_number;
	ipx_class.port[port_number].lan_circuit_mib.ipxCircSysInstance = 0x00000001L;
}
/****************************************************************************/
void set_ipx_tx_frame_type (char *cptr_port_number_and_tx_frame_type_string)
{
	USHORT port_number;
	char tx_frame_type_string[20];

	port_number = get_port_number_and_string (cptr_port_number_and_tx_frame_type_string,&tx_frame_type_string[0]);

	if (strstr (strlwr (tx_frame_type_string),"raw") != NULL)
		{
		ipx_class.port[port_number].tx_frame_type = RAW_8023_IPX;
		}
	else if (strstr (strlwr (tx_frame_type_string),"llc") != NULL)
		{
		ipx_class.port[port_number].tx_frame_type = LLC_IPX;
		}
	else if (strstr (strlwr (tx_frame_type_string),"snap") != NULL)
		{
		ipx_class.port[port_number].tx_frame_type = SNAP_IPX;
		}
	else if (strstr (strlwr (tx_frame_type_string),"type_ii") != NULL)
		{
		ipx_class.port[port_number].tx_frame_type = ETHERNET_TYPE_II_IPX;
		}
	else if (strstr (strlwr (tx_frame_type_string),"same_type_as_rx_frame") != NULL)
		{
		ipx_class.port[port_number].tx_frame_type = SAME_TYPE_AS_RX_FRAME;
		}
}
/****************************************************************************/
void set_ipx_real_port_numbers (char *cptr_port_number_and_tx_frame_type_string)
{
	USHORT real_port_number;
	USHORT virtual_port_number;

	real_port_number = (USHORT) get_port_number_and_value (cptr_port_number_and_tx_frame_type_string,&virtual_port_number);

	ipx_class.port[virtual_port_number].real_port_number = real_port_number;

	if (ipx_class.virtual_port_number_array.virtual_port_number[real_port_number] == 0xffff)
		{
		ipx_class.virtual_port_number_array.virtual_port_number[real_port_number] = virtual_port_number;
		}
}
/****************************************************************************/
void get_router_name (char *cptr_start_of_configuration_string)
{
	char *cptr_line_feed;

	strcpy (ipx_class.internal_SAP_id.SAP_name,cptr_start_of_configuration_string);

	cptr_line_feed = strchr (ipx_class.internal_SAP_id.SAP_name,0x0a);

	if (cptr_line_feed != NULL)
		{
		*cptr_line_feed = (char) 0x00;
		}
}
/****************************************************************************/
void set_router_internal_network (char *cptr_start_of_configuration_string)
{
	ipx_class.internal_SAP_id.ipx_address.network = swap_long (get_ulong_hex_value (cptr_start_of_configuration_string));
}
/****************************************************************************/
void set_ipx_gap_time (char *cptr_start_of_configuration_string)
{
	BYTE value;

	value = (BYTE) get_decimal_value (cptr_start_of_configuration_string);

	set_ipx_gap_time_counter (value);
}
/****************************************************************************/
void turn_ipx_printing_on (char *cptr_start_of_configuration_string)
{
	enum BOOLEAN printing_enabled;

	printing_enabled = is_parameter_enabled (cptr_start_of_configuration_string);

	enable_or_disable_ipx_printing (printing_enabled);
}
/****************************************************************************/
void turn_ipx_subgroup_printing_on (char *cptr_start_of_configuration_string,ULONG printf_type)
{
	enum BOOLEAN printing_enabled;

	printing_enabled = is_parameter_enabled (cptr_start_of_configuration_string);

	enable_or_disable_ipx_group_printing (printing_enabled,(enum PRINTF_GROUPS) printf_type);
}
/****************************************************************************/
ULONG ipx_get_configuration_table_address (void)
{
	return ((ULONG) &ipx_configuration_table);
}


