#include	"defs.h"
/*	$Modname: ipxdiag.c$  $version: 1.9$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 05/13/93 ross initial release.
1.1 05/13/93 ross
1.2 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
1.3 01/31/94 ross Fixed release problem.  Courtesy of Ken.
1.4 02/15/94 ross While putting in Ishwar's fix for ipx header length added the free if packet is
1.5 03/09/94 ross added cast for previous fix.
1.6 03/14/94 ross cleaned up braces and white spaces for release.
1.7 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.8 09/25/95 ross added changes for dynamic loading
1.9 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	"ipx.h"
/****************************************************************************/
static void initialize_diagnostic_packet (USHORT port_number,DIAGNOSTIC_RESPONSE_PACKET *sptr_diagnostic_response_packet);
/****************************************************************************/
enum IPX_PACKET_STATE diagnostic_packet_received (USHORT port_number,DIAGNOSTIC_REQUEST_PACKET *sptr_diagnostic_rx_packet,
	USHORT size_of_packet)
{
	DIAGNOSTIC_RESPONSE_PACKET *sptr_diagnostic_response_packet;
	USHORT extended_component_port_number;
	USHORT	outgoing_port_number;
	ETHERNET_ADDRESS	*sptr_hop_routers_ethernet_address;

	if (sptr_diagnostic_rx_packet->ipx_header.destination.node_address._ushort == 0xffff &&
		sptr_diagnostic_rx_packet->ipx_header.destination.node_address._ulong == 0xffffffffL)
		{
		size_of_packet = (USHORT) (((ipx_class.number_of_ports - 1) * sizeof (EXTENDED_COMPONENT)) +
			sizeof (DIAGNOSTIC_RESPONSE_PACKET));

		sptr_diagnostic_response_packet = (DIAGNOSTIC_RESPONSE_PACKET *) get_a_send_packet (port_number,size_of_packet);

		if (sptr_diagnostic_response_packet == NULL)
			{
			return (OUT_OF_TX_PACKET_MEMORY);
			}

		initialize_diagnostic_packet (port_number,sptr_diagnostic_response_packet);

		sptr_diagnostic_response_packet->ipx_header.length = (USHORT) (swap ((USHORT) (size_of_packet - sizeof (ETHERNET_HEADER))));

		sptr_diagnostic_response_packet->ipx_header.destination = sptr_diagnostic_rx_packet->ipx_header.source;

		for (extended_component_port_number = 0x0000; extended_component_port_number < ipx_class.number_of_ports;
			++extended_component_port_number)
			{
			sptr_diagnostic_response_packet->extended_component[extended_component_port_number].type = LAN_BOARD;

			sptr_diagnostic_response_packet->extended_component[extended_component_port_number].network = 
				ipx_class.port[extended_component_port_number].network;

			sptr_diagnostic_response_packet->extended_component[extended_component_port_number].node_address = 
				ipx_class.port[extended_component_port_number].ethernet_address;
			}

		sptr_hop_routers_ethernet_address = get_next_hop_router_address (
			sptr_diagnostic_response_packet->ipx_header.destination.network,&outgoing_port_number);

		if (sptr_hop_routers_ethernet_address == ON_OTHER_PORTS_NETWORK)
			{
			sptr_diagnostic_response_packet->ethernet_header.destination_address =
				sptr_diagnostic_response_packet->ipx_header.destination.node_address;
			}
		else
			{
			sptr_diagnostic_response_packet->ethernet_header.destination_address = *sptr_hop_routers_ethernet_address;
			}

		sptr_diagnostic_response_packet->ethernet_header.source_address = ipx_class.port[outgoing_port_number].ethernet_address;

		if (sptr_hop_routers_ethernet_address != CANT_FIND_NETWORK)
			{
/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
			send_ipx_packet (outgoing_port_number,(IPX_PACKET *) sptr_diagnostic_response_packet,size_of_packet,FALSE,
				send_completion_ipx_packet);
			}
		else
			{
			sptr_diagnostic_response_packet = (DIAGNOSTIC_RESPONSE_PACKET *)
				normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_diagnostic_response_packet);

			free_a_send_packet ((IPX_PACKET *) sptr_diagnostic_response_packet);
			}
		}

	return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
}
/****************************************************************************/
static void initialize_diagnostic_packet (USHORT port_number,DIAGNOSTIC_RESPONSE_PACKET *sptr_diagnostic_response_packet)
{
	sptr_diagnostic_response_packet->ipx_header.checksum = 0xffff;
	sptr_diagnostic_response_packet->ipx_header.transport_control_hop_count = 0x00;
	sptr_diagnostic_response_packet->ipx_header.packet_type = PACKET_EXCHANGE_PACKET;

	sptr_diagnostic_response_packet->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_diagnostic_response_packet->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address; 
	sptr_diagnostic_response_packet->ipx_header.source.socket = DIAGNOSTICS_SOCKET;

	sptr_diagnostic_response_packet->major_version = (BYTE) ipx_class.major_version;
	sptr_diagnostic_response_packet->minor_version = (BYTE) ipx_class.minor_version;
	sptr_diagnostic_response_packet->spx_socket = SPX_DIAGNOSTIC_SOCKET;

	sptr_diagnostic_response_packet->component_count = 1;
	sptr_diagnostic_response_packet->extended_component_type[0] = ROUTER_COMPONENT;

	sptr_diagnostic_response_packet->number_of_networks = (BYTE) ipx_class.number_of_ports;
}
