#include	"defs.h"
/*	$Modname: ipxecho.c$  $version: 3.10$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 12/26/92 ross
3.0 12/26/92 ross
3.1 01/22/93 ross added the clearing of type to ECHO_REPLY.
3.2 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.3 04/12/93 ross made variable name change to vipxstr.h
3.4 04/13/93 ross added stats etc. for Novell's ipx mib v0.9
3.5 05/13/93 ross added stack parameter for tunnel software
3.6 06/30/93 ross fixed internetting echo packet bug. Courtesy of Fred S.
3.7 06/30/93 ross made function definition 1 line instead of 2.
3.8 12/16/93 ross change mac header checking to node address checking.  Courtesy of Rick.
3.9 03/12/94 ross removed some redundant lines.
3.10 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include "ipx.h"	  
/****************************************************************************/
enum IPX_PACKET_STATE ipx_echo_packet_received (USHORT port_number,ECHO_PACKET *sptr_rx_packet,USHORT size_of_packet)
{
	enum IPX_PACKET_STATE return_code;
	IPX_ADDRESS ipx_address;

	if (sptr_rx_packet->type == ECHO_REQUEST)
		{
		if ((sptr_rx_packet->ipx_header.destination.node_address._ulong ==
			ipx_class.port[port_number].ethernet_address._ulong) &&
			(sptr_rx_packet->ipx_header.destination.node_address._ushort ==
			ipx_class.port[port_number].ethernet_address._ushort))
			{
			sptr_rx_packet->type = ECHO_REPLY;

			++ipx_class.port[port_number].statistics.number_of_echo_request_packets_received;

			ipx_address = sptr_rx_packet->ipx_header.destination;

			sptr_rx_packet->ipx_header.destination = sptr_rx_packet->ipx_header.source;

			sptr_rx_packet->ipx_header.source = ipx_address;
			}

		return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
		}
	else
		{
		if ((sptr_rx_packet->ipx_header.destination.node_address._ulong ==
			ipx_class.port[port_number].ethernet_address._ulong) &&
			(sptr_rx_packet->ipx_header.destination.node_address._ushort ==
			ipx_class.port[port_number].ethernet_address._ushort))
			{
			++ipx_class.port[port_number].statistics.number_of_echo_reply_packets_received;

			return_code = DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED;
			}
		else
			{
			return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
			}
		}

	return (return_code);
}
