#include "defs.h"
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>
#include "ipx.h"	  
#include "\rtrware\lsl\vbufstr.h"
#include "ipxfilt.h"

/*#define PRINTF*/

str_ipx_filter_class ipx_filter_class ;


enum TEST match_ipx_address (FULL_IPX_ADDRESS *ipx_address, IPX_FILTERING_ENTRY *filter)
{

   if (filter->mask.network_number == 0L)
      goto L1 ;
   if (ipx_address->network_number != filter->ipx_address.network_number)
      return (FAIL) ;

L1 :
   if ((filter->mask.node_number_ulong == 0L) &&
       (filter->mask.node_number_ushort == 0))
       goto L2 ;

   if ((ipx_address->node_number_ulong != filter->ipx_address.node_number_ulong) ||
       (ipx_address->node_number_ushort != filter->ipx_address.node_number_ushort))
       return (FAIL) ;

L2 :
   if (filter->mask.socket_number == 0)
      goto L3 ;

   if (ipx_address->socket_number != filter->ipx_address.socket_number)
      return (FAIL) ;

L3 :
   return (PASS) ;
}


void read_ipx_filter (char *address_string, IPX_FILTERING_ENTRY *filter)
{
   unsigned char ipx_address_array[50] ;
   unsigned char *temp, *ipx_address = &ipx_address_array[0] ;
#if 0
   unsigned int i ;
#endif

   memset (&filter->mask.network_number, 0xFF, sizeof (FULL_IPX_ADDRESS)) ;
   if (*address_string == 'X')
   {
      filter->ipx_address.network_number = 0L ;
      filter->mask.network_number = 0L ;
   }
   else
   {
      sscanf (address_string, "%02jX%02jX%02jX%02jX", (int *)(ipx_address+0),
                                                      (int *)(ipx_address+1),
                                                      (int *)(ipx_address+2),
                                                      (int *)(ipx_address+3)) ;
      temp = (unsigned char *)&filter->ipx_address.network_number ;
      *temp++ = (unsigned char) ipx_address[0] ;
      *temp++ = (unsigned char) ipx_address[1] ;
      *temp++ = (unsigned char) ipx_address[2] ;
      *temp++ = (unsigned char) ipx_address[3] ;
   }
   
   while (*address_string != ' ') address_string++ ;
   address_string++ ;

   if (*address_string == 'X')
   {
      filter->ipx_address.node_number_ulong = 0L ;
      filter->ipx_address.node_number_ushort = 0 ;
      filter->mask.node_number_ulong = 0L ;
      filter->mask.node_number_ushort = 0 ;
   }
   else
   {
      sscanf (address_string, "%02jx%02jx%02jx%02jx%02jx%02jx",
                              (int *)(ipx_address+4),
                              (int *)(ipx_address+5),
                              (int *)(ipx_address+6),
                              (int *)(ipx_address+7),
                              (int *)(ipx_address+8),
                              (int *)(ipx_address+9)) ;
      temp = (unsigned char *)&filter->ipx_address.node_number_ulong ;
      *temp++ = (unsigned char) ipx_address[4] ;
      *temp++ = (unsigned char) ipx_address[5] ;
      *temp++ = (unsigned char) ipx_address[6] ;
      *temp++ = (unsigned char) ipx_address[7] ;
      *temp++ = (unsigned char) ipx_address[8] ;
      *temp++ = (unsigned char) ipx_address[9] ;
   }

   while (*address_string != ' ') address_string++ ;
   address_string++ ;

   if (*address_string == 'X')
   {
      filter->ipx_address.socket_number = 0 ;
      filter->mask.socket_number = 0 ;
   }
   else
   {
      sscanf (address_string, "%002jx%002jx",
                              (int *)(ipx_address+10), (int *)(ipx_address+11)) ;

      temp = (unsigned char *)&filter->ipx_address.socket_number ;
      *temp++ = (unsigned char) ipx_address[10] ;
      *temp++ = (unsigned char) ipx_address[11] ;
   }

#if 0

   printf ("\nFilter IPX Address : ") ;
   temp = (unsigned char *)&filter->mask.network_number ;
   temp1 = (unsigned char *)&filter->ipx_address.network_number ;

   for (i = 0 ; i < sizeof (FULL_IPX_ADDRESS) ; i++)
   {
      if (*temp++ != 0)
      {
         j = *temp1++ ;
         printf ("%02X", j) ;
      }
      else
      {
         temp1++ ;
         printf ("XX") ;
      }
   }

#endif

   return ;
}


void ipx_set_filtering_table_size (char *cfg_string)
{
   ULONG max_size ;
   int i ;

   sscanf (cfg_string, "%d", &max_size) ;

   ipx_filter_class.ipx_filtering_table = (IPX_FILTERING_ENTRY *)
             malloc (max_size * sizeof (IPX_FILTERING_ENTRY)) ;

   if (ipx_filter_class.ipx_filtering_table == NULL)
   {
      ipx_filter_class.ipx_filtering_inited = FALSE ;
#ifdef PRINTF
		if (max_size)
      	printf ("\nIPX Filtering : malloc failed") ;
#endif
      return ;
   }

   for (i = 0 ; i < max_size ; i++)
      ipx_filter_class.ipx_filtering_table[i].type = IPX_INVALID_FILTER ;

   ipx_filter_class.ipx_filtering_inited = TRUE ;
   ipx_filter_class.ipx_filter_table_size = max_size ;

   ipx_filter_class.ipx_number_of_dest_filter_entries = ipx_filter_class.ipx_number_of_src_filter_entries = 0 ;
   ipx_filter_class.ipx_src_filter_chain = ipx_filter_class.ipx_dest_filter_chain = NULL ;
   ipx_filter_class.ipx_filter_default_rx_action = ipx_filter_class.ipx_filter_default_tx_action = ipx_filter_class.ipx_filter_default_action =
                    IPX_FILTER_DEFAULT_ACTION_FORWARD ;

   return ;
}


void ipx_set_filtering_default_action (char *cfg_string)
{
   if (strstr (cfg_string, "forward"))
      ipx_filter_class.ipx_filter_default_action =
      ipx_filter_class.ipx_filter_default_rx_action =
      ipx_filter_class.ipx_filter_default_tx_action = IPX_FILTER_DEFAULT_ACTION_FORWARD ;
   else
      ipx_filter_class.ipx_filter_default_action =
      ipx_filter_class.ipx_filter_default_rx_action =
      ipx_filter_class.ipx_filter_default_tx_action = IPX_FILTER_DEFAULT_ACTION_FILTER ;

   return ;
}


IPX_FILTERING_ENTRY *ipx_get_free_filtering_entry ()
{
   int i ;
   IPX_FILTERING_ENTRY *temp_ptr = ipx_filter_class.ipx_filtering_table ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
   {
      return (NULL) ;
   }

   for (i = 0 ; i < ipx_filter_class.ipx_filter_table_size ; temp_ptr++, i++)
   {
      if (temp_ptr->type == IPX_INVALID_FILTER)
         return (temp_ptr) ;
   }

   return (NULL) ;
}


void ipx_free_filtering_entry (IPX_FILTERING_ENTRY *ipx_filtering_entry)
{
   if (ipx_filter_class.ipx_filtering_inited == FALSE)
      return ;

   ipx_filtering_entry->type = IPX_INVALID_FILTER ;
}


void ipx_filter_source_address (char *cfg_string)
{
   IPX_FILTERING_ENTRY *new_filter ;
   USHORT port_number ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
      return ;

   sscanf (cfg_string, "%02hu", &port_number) ;

   while (*cfg_string != ',') cfg_string++ ;
   cfg_string++ ;

   while (1)
   {
      new_filter = ipx_get_free_filtering_entry () ;
      if (new_filter == NULL)
         return ;

      read_ipx_filter (cfg_string, new_filter) ;
      new_filter->forward_link = ipx_filter_class.ipx_src_filter_chain ;
      new_filter->port = port_number ;
      new_filter->type = IPX_FILTER_ON_SOURCE_ADDRESS ;
      ipx_filter_class.ipx_src_filter_chain = new_filter ;
      ipx_filter_class.ipx_number_of_src_filter_entries++ ;

      cfg_string = strstr (cfg_string, ",") ;
      if (cfg_string == NULL)
         break ;
      cfg_string++ ;
   }

   return ;
}


void ipx_filter_destination_address (char *cfg_string)
{
   IPX_FILTERING_ENTRY *new_filter ;
   USHORT port_number ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
      return ;

   sscanf (cfg_string, "%02hu", &port_number) ;
   cfg_string = strstr (cfg_string, ",") ;
   cfg_string++ ;

   while (1)
   {
      new_filter = ipx_get_free_filtering_entry () ;
      if (new_filter == NULL)
         return ;

      read_ipx_filter (cfg_string, new_filter) ;
      new_filter->forward_link = ipx_filter_class.ipx_dest_filter_chain ;
      new_filter->port = port_number ;
      new_filter->type = IPX_FILTER_ON_DESTINATION_ADDRESS ;
      ipx_filter_class.ipx_dest_filter_chain = new_filter ;
      ipx_filter_class.ipx_number_of_dest_filter_entries++ ;

      cfg_string = strstr (cfg_string, ",") ;
      if (cfg_string == NULL)
         break ;
      cfg_string++ ;
   }

   return ;
}


void ipx_forward_source_address (char *cfg_string)
{
   IPX_FILTERING_ENTRY *new_filter ;
   USHORT port_number ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
      return ;

   sscanf (cfg_string, "%02hu", &port_number) ;
   cfg_string = strstr (cfg_string, ",") ;
   cfg_string++ ;

   while(1)
   {
      new_filter = ipx_get_free_filtering_entry () ;
      if (new_filter == NULL)
         return ;

      read_ipx_filter (cfg_string, new_filter) ;
      new_filter->forward_link = ipx_filter_class.ipx_src_filter_chain ;
      new_filter->port = port_number ;
      new_filter->type = IPX_FORWARD_ON_SOURCE_ADDRESS ;
      ipx_filter_class.ipx_src_filter_chain = new_filter ;
      ipx_filter_class.ipx_number_of_src_filter_entries++ ;

      cfg_string = strstr (cfg_string, ",") ;
      if (cfg_string == NULL)
         break ;
      cfg_string++ ;
   }

   return ;
}

void ipx_forward_destination_address (char *cfg_string)
{
   IPX_FILTERING_ENTRY *new_filter ;
   USHORT port_number ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
      return ;

   sscanf (cfg_string, "%02hu", &port_number) ;
   cfg_string = strstr (cfg_string, ",") ;
   cfg_string++ ;

   while (1)
   {
      new_filter = ipx_get_free_filtering_entry () ;
      if (new_filter == NULL)
         return ;

      read_ipx_filter (cfg_string, new_filter) ;
      new_filter->forward_link = ipx_filter_class.ipx_dest_filter_chain ;
      new_filter->port = port_number ;
      new_filter->type = IPX_FORWARD_ON_DESTINATION_ADDRESS ;
      ipx_filter_class.ipx_dest_filter_chain = new_filter ;
      ipx_filter_class.ipx_number_of_dest_filter_entries++ ;

      cfg_string = strstr (cfg_string, ",") ;
      if (cfg_string == NULL)
         break ;
      cfg_string++ ;
   }

   return ;
}

enum BOOLEAN ipx_rx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_rx_packet, USHORT size_of_packet)
{
   IPX_FILTERING_ENTRY *next_filter ;
   IPX_PACKET *ipx_packet_ptr = (IPX_PACKET *)sptr_rx_packet ;

#if 0
   printf ("\nIN IPX_RX_FILTER, port number : %d", port_number) ;
#endif

	if (ipx_filter_class.ipx_filtering_inited == FALSE)
	{
		return (FALSE) ;
	}

   next_filter = ipx_filter_class.ipx_src_filter_chain ;
   while (next_filter != NULL)
   {
      if (port_number != next_filter->port)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      if (match_ipx_address (&ipx_packet_ptr->ipx_header.source, next_filter) == FAIL)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      switch (next_filter->type)
      {
         case (IPX_FILTER_ON_SOURCE_ADDRESS) :
         {
#ifdef PRINTF
            ipx_printf (IPX_FILTER_PRINTF, "\nIPX Packet filtered off in SOURCE FILTER") ;
#endif
            return (TRUE) ;
         }

         case (IPX_FORWARD_ON_SOURCE_ADDRESS) :
         {
#ifdef PRINTF
            ipx_printf (IPX_FILTER_PRINTF, "\nIPX Packet forwarded off in SOURCE FILTER") ;
#endif
            return (FALSE) ;
         }

         default :
            break ;
      }
      next_filter = next_filter->forward_link ;
   }
   
   if (ipx_filter_class.ipx_filter_default_rx_action == IPX_FILTER_DEFAULT_ACTION_FILTER)
   {
      return (TRUE) ;
   }
   else
   {
      return (FALSE) ;
   }
}


enum BOOLEAN ipx_tx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_tx_packet, USHORT size_of_packet)
{
   IPX_FILTERING_ENTRY *next_filter ;
   IPX_PACKET *ipx_packet_ptr = (IPX_PACKET *)sptr_tx_packet ;

#if 0
   printf ("\nIN IPX_TX_FILTER, port number : %d", port_number) ;
#endif

	if (ipx_filter_class.ipx_filtering_inited == FALSE)
	{
		return (FALSE) ;
	}

   next_filter = ipx_filter_class.ipx_dest_filter_chain ;
   while (next_filter != NULL)
   {
      if (port_number != next_filter->port)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      if (match_ipx_address (&ipx_packet_ptr->ipx_header.destination, next_filter) == FAIL)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      switch (next_filter->type)
      {
         case (IPX_FILTER_ON_DESTINATION_ADDRESS) :
         {
#ifdef PRINTF
            ipx_printf (IPX_FILTER_PRINTF, "\nIPX Packet filtered off in DESTINATION FILTER") ;
#endif
            return (TRUE) ;
         }

         case (IPX_FORWARD_ON_DESTINATION_ADDRESS) :
         {
#ifdef PRINTF
            ipx_printf (IPX_FILTER_PRINTF, "\nIPX Packet forwarded off in DESTINATION FILTER") ;
#endif
            return (FALSE) ;
         }

         default :
            break ;
      }
      next_filter = next_filter->forward_link ;
   }
   
   if (ipx_filter_class.ipx_filter_default_tx_action == IPX_FILTER_DEFAULT_ACTION_FILTER)
   {
      return (TRUE) ;
   }
   else
   {
      return (FALSE) ;
   }
}

#if 0
enum BOOLEAN ipx_rx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_rx_packet, USHORT size_of_packet)
{
   IPX_FILTERING_ENTRY *next_filter ;
   IPX_PACKET *ipx_packet_ptr = (IPX_PACKET *)sptr_rx_packet ;

	if (ipx_filter_class.ipx_filtering_inited == FALSE)
	{
		return (FALSE) ;
	}

   next_filter = ipx_filter_class.ipx_src_filter_chain ;
   while (next_filter != NULL)
   {
      if (port_number != next_filter->port)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      if (match_ipx_address (&ipx_packet_ptr->ipx_header.source, next_filter) == FAIL)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      switch (next_filter->type)
      {
         case (IPX_FILTER_ON_SOURCE_ADDRESS) :
         {
            printf ("\nIPX Packet filtered off in SOURCE FILTER") ;
            return (TRUE) ;
         }

         case (IPX_FORWARD_ON_SOURCE_ADDRESS) :
         {
            printf ("\nIPX Packet forwarded off in SOURCE FILTER") ;
            return (FALSE) ;
         }

         default :
            break ;
      }
      next_filter = next_filter->forward_link ;
   }
   
   if (ipx_filter_class.ipx_filter_default_rx_action == IPX_FILTER_DEFAULT_ACTION_FILTER)
   {
      return (TRUE) ;
   }
   else
   {
      return (FALSE) ;
   }
}


enum BOOLEAN ipx_tx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_tx_packet, USHORT size_of_packet)
{
   IPX_FILTERING_ENTRY *next_filter ;
   IPX_PACKET *ipx_packet_ptr = (IPX_PACKET *)sptr_tx_packet ;

	if (ipx_filter_class.ipx_filtering_inited == FALSE)
	{
		return (FALSE) ;
	}

   next_filter = ipx_filter_class.ipx_dest_filter_chain ;
   while (next_filter != NULL)
   {
      if (port_number != next_filter->port)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      if (match_ipx_address (&ipx_packet_ptr->ipx_header.destination, next_filter) == FAIL)
      {
         next_filter = next_filter->forward_link ;
         continue ;
      }

      switch (next_filter->type)
      {
         case (IPX_FILTER_ON_DESTINATION_ADDRESS) :
         {
            printf ("\nIPX Packet filtered off in DESTINATION FILTER") ;
            return (TRUE) ;
         }

         case (IPX_FORWARD_ON_DESTINATION_ADDRESS) :
         {
            printf ("\nIPX Packet forwarded off in DESTINATION FILTER") ;
            return (FALSE) ;
         }

         default :
            break ;
      }
      next_filter = next_filter->forward_link ;
   }
   
   if (ipx_filter_class.ipx_filter_default_tx_action == IPX_FILTER_DEFAULT_ACTION_FILTER)
   {
      return (TRUE) ;
   }
   else
   {
      return (FALSE) ;
   }
}
#endif

#if 0


void display_ipx_filtering_table ()
{
   int i, j, k ;
   IPX_FILTERING_ENTRY *next_filter ;
   unsigned char *temp1, *temp2 ;
   unsigned char address_string[50], *address_string_ptr ;

   if (ipx_filter_class.ipx_filtering_inited == FALSE)
   {
      ipx_printf (IPX_FILTER_PRINTF, "\nIPX Filtering not initialized\n") ;
      return ;
   }
   ipx_printf (IPX_FILTER_PRINTF, "\nDisplaying IPX Filtering Configuration......") ;

   ipx_printf (IPX_FILTER_PRINTF, "\nIPX Filtering Table Size : %d", ipx_filter_class.ipx_filter_table_size) ;
   ipx_printf (IPX_FILTER_PRINTF, "\nIPX Filtering Default Action : %s",
          (ipx_filter_class.ipx_filter_default_action == IPX_FILTER_DEFAULT_ACTION_FILTER) ?
          "filter" : "forward") ;
   ipx_printf (IPX_FILTER_PRINTF, "\nIPX Number of Filters : %d",
           ipx_filter_class.ipx_number_of_src_filter_entries +
           ipx_filter_class.ipx_number_of_dest_filter_entries) ;

   for ( i = 0 ; i < 2 ; i++)
   {
      if (i == 0)
      {
         next_filter = ipx_filter_class.ipx_src_filter_chain ;
         if (next_filter != NULL)
            ipx_printf (IPX_FILTER_PRINTF, "\n\nIPX Source Filtering Table.....") ;
      }
      else
      {
         next_filter = ipx_filter_class.ipx_dest_filter_chain ;
         if (next_filter != NULL)
            ipx_printf (IPX_FILTER_PRINTF, "\n\nIPX Destination Filtering Table.....") ;
      }

      while (next_filter != NULL)
      {
         ipx_printf (IPX_FILTER_PRINTF, "\nFilter Address : ") ;
         temp1 = (unsigned char *)&next_filter->ipx_address.network_number ;
         temp2 = (unsigned char *)&next_filter->mask.network_number ;
         
         address_string_ptr = &address_string[0] ;
         for (j = 0 ; j < sizeof (FULL_IPX_ADDRESS) ; j++, temp1++, temp2++)
         {
            if (*temp2 == 0)
               sprintf (address_string_ptr, "XX") ;
            else
            {
               k = *temp1 ;
               sprintf (address_string_ptr, "%02X", k) ;
            }
            address_string_ptr += 2 ;
            if ((j == 3) || (j == 9))
               sprintf (address_string_ptr++, " ") ;
         }
         *address_string_ptr = 0 ;
         ipx_printf (IPX_FILTER_PRINTF, "%s", address_string) ;

         switch (next_filter->type)
         {
            case (IPX_FILTER_ON_SOURCE_ADDRESS) :
               ipx_printf (IPX_FILTER_PRINTF, ", Type Filter on source address") ;
               break ;

            case (IPX_FILTER_ON_DESTINATION_ADDRESS) :
               ipx_printf (IPX_FILTER_PRINTF, ", Type Filter on destination address") ;
               break ;

            case (IPX_FORWARD_ON_SOURCE_ADDRESS) :
               ipx_printf (IPX_FILTER_PRINTF, ", Type Forward on source address") ;
               break ;

            case (IPX_FORWARD_ON_DESTINATION_ADDRESS) :
               ipx_printf (IPX_FILTER_PRINTF, ", Type Forward on destination address") ;
               break ;
         }
         next_filter = next_filter->forward_link ;
      }
   }
   ipx_printf (IPX_FILTER_PRINTF, "\n") ;
}



#endif
