#include	"defs.h"
/*	$Modname: ipxripls.c$  $version: 3.37$      $date: 11/03/95$   */
/*
* 	$lgb$
1.0 01/21/93 ross
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 01/31/93 ross added support for netware lite routing
3.2 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.3 03/11/93 ross working with all novell certification tests
3.4 03/15/93 ross x86 version now works in real mode -just enough memory
3.5 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.6 04/12/93 ross made variable name change in vipxstr.h
3.7 05/13/93 ross added stack parameter for tunnel software
3.8 05/15/93 ross added several new functions for management.
3.9 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.10 05/24/93 ross fixed some problems will loops going down.
3.11 10/09/93 ross Added changes for ipxwan
3.12 10/19/93 ross secondary list with wrong link name.  Courtesy of Ken.
3.13 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.14 11/08/93 ross fixed some secondary rip and sap problems.  Courtesy of Rick.
3.15 11/08/93 ross update send added in delete route entry from list.
3.16 11/09/93 ross SAP and rip down port and global functions bugs fixed.  Courtesy of Ken.
3.17 11/10/93 ross made change in delete route to check before deleting SAPs.  Courtesy of Ken.
3.18 11/29/93 ross transport time wan fixed.
3.19 02/02/94 ross adding transport time in big-endian instead of host-endian.
3.20 03/09/94 ross in add route entry, we will go ahead and age the entry - wan.
3.21 03/09/94 ross removing the wan_port dependency on rip and sap aging.
3.22 03/11/94 ross changed router ids to route entries.
3.23 03/11/94 ross removed the check for periodic rips in update routine.
3.24 03/14/94 ross cleaned up braces and white spaces for release.
3.25 04/04/94 ross added do_not_age check for bad configuration in check_if_in_primary... Courtesy of Ishwar.
3.26 05/20/94 ross added better support for disabled port, and added add rip/sap function pointers.  Courtest of Fred and Don.
3.27 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.28 07/07/94 ross Fixed port_number bug in update routes for all ports.  Courtesy of Fred.
3.29 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.30 11/23/94 ross Added remote access. Added auto-configuration.
3.31 03/26/95 ross nlsp changes.
3.32 04/05/95 ross nlsp changes.
3.33 09/25/95 ross added changes for dynamic loading
3.34 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.35 10/20/95 nishit Changed copyright
3.36 10/25/95 nishit In check_if_in_primary_route_list, DEFAULT_ROUTE_NETWORK_NUMBER swapped, and secondary is checked only if primary is not an NLSP route
3.37 11/03/95 nishit Fixed a bug in send_route_update_packet introduced by NLSP changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>

#include	"ipx.h"
/****************************************************************************/
static enum LIST_ENTRY_TYPE check_if_in_secondary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	ROUTE_ENTRY *sptr_rx_route_entry,ETHERNET_ADDRESS *sptr_source_address,USHORT port_number,
	enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp);
static void delete_secondary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry);
static void check_for_down_secondary_routes (ROUTE_LIST_ENTRY *sptr_primary_route_entry);
static enum IPX_PACKET_STATE send_route_update_packet (USHORT port_number);
static enum BOOLEAN check_for_already_existing_route (ROUTE_ENTRY *sptr_route_entry);
/*************************************************************************/
enum LIST_ENTRY_TYPE check_if_in_primary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	ROUTE_ENTRY *sptr_rx_route_entry,ETHERNET_ADDRESS *sptr_source_address,USHORT port_number,
	enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp)
{
	if (sptr_rx_route_entry->network != sptr_primary_route_entry->route_entry.network)
		{
		return (MATCHING_ENTRY_NOT_FOUND);
		}
	else
		{
		if (swap_long (sptr_rx_route_entry->network) == DEFAULT_ROUTE_NETWORK_NUMBER)
			{
			if ((sptr_primary_route_entry->type == RIP_IPX_ROUTE) && (route_type == NLSP_IPX_ROUTE))
				{
				if (sptr_rx_route_entry->hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
					{
					delete_secondary_route_list (sptr_primary_route_entry);

					sptr_primary_route_entry->route_entry = *sptr_rx_route_entry;
					sptr_primary_route_entry->router_address = *sptr_source_address;
					sptr_primary_route_entry->port_number = port_number;
					sptr_primary_route_entry->timer_value = router_timer;
					sptr_primary_route_entry->new_primary_route = TRUE;
					sptr_primary_route_entry->type = NLSP_IPX_ROUTE;
					sptr_primary_route_entry->vptr_lsp = vptr_lsp;

					return (MATCHING_ENTRY_FOUND_UPDATE);
					}
				}
			}
			
		if ((memcmp (sptr_rx_route_entry,&sptr_primary_route_entry->route_entry,sizeof (ROUTE_ENTRY)) == (int) NULL) &&
			(memcmp (sptr_source_address,&sptr_primary_route_entry->router_address,sizeof (ETHERNET_ADDRESS)) == (int) NULL) && 
			(sptr_primary_route_entry->port_number == port_number) &&
			sptr_primary_route_entry->route_entry.hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			sptr_primary_route_entry->timer_value = router_timer;
			return (MATCHING_ENTRY_FOUND_NO_UPDATE);
			}
		else if (swap (sptr_rx_route_entry->transport_time) < swap (sptr_primary_route_entry->route_entry.transport_time)
			&& sptr_rx_route_entry->hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			if (sptr_primary_route_entry->do_not_age == TRUE)
				{
				return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
				}

			delete_secondary_route_list (sptr_primary_route_entry);

			sptr_primary_route_entry->route_entry = *sptr_rx_route_entry;
			sptr_primary_route_entry->router_address = *sptr_source_address;
			sptr_primary_route_entry->port_number = port_number;
			sptr_primary_route_entry->timer_value = router_timer;
			sptr_primary_route_entry->new_primary_route = TRUE;
			sptr_primary_route_entry->type = (BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)) route_type;
			sptr_primary_route_entry->vptr_lsp = vptr_lsp;

			return (MATCHING_ENTRY_FOUND_UPDATE);
			}
		else if ((memcmp (&sptr_primary_route_entry->router_address,sptr_source_address,sizeof (ETHERNET_ADDRESS)) != (int) NULL) &&
			(swap (sptr_rx_route_entry->transport_time) > swap (sptr_primary_route_entry->route_entry.transport_time)) &&
			(sptr_rx_route_entry->hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT))
			{
			if (sptr_primary_route_entry->do_not_age == TRUE)
				{
				return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
				}
			
			if (sptr_primary_route_entry->route_entry.hops == SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				sptr_primary_route_entry->route_entry = *sptr_rx_route_entry;
				sptr_primary_route_entry->router_address = *sptr_source_address;
				sptr_primary_route_entry->port_number = port_number;
				sptr_primary_route_entry->timer_value = router_timer;
				sptr_primary_route_entry->new_primary_route = TRUE;
				sptr_primary_route_entry->type = (BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)) route_type;
				sptr_primary_route_entry->vptr_lsp = vptr_lsp;

				return (MATCHING_ENTRY_FOUND_UPDATE);
				}
			else
				{
				++ipx_class.port[port_number].statistics.rx_number_of_RIP_packets_with_worse_info; 

				return (MATCHING_ENTRY_FOUND_NO_UPDATE); /* ignore the route entry */
				}
			}
		else if	(((memcmp (sptr_source_address,&sptr_primary_route_entry->router_address,sizeof (ETHERNET_ADDRESS)) == (int) NULL) && /* hop count is different */
	 		(sptr_primary_route_entry->port_number == port_number)))	/* takes care of SERVER_OR_ROUTER_DOWN_HOP_COUNT case */
			{
			if (sptr_primary_route_entry->do_not_age == TRUE)
				{
				return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
				}

			sptr_primary_route_entry->route_entry = *sptr_rx_route_entry;
			sptr_primary_route_entry->timer_value = router_timer;
			sptr_primary_route_entry->new_primary_route = TRUE;
			sptr_primary_route_entry->vptr_lsp = vptr_lsp;

			if (sptr_rx_route_entry->hops == SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				delete_all_SAPs_with_network_address (sptr_rx_route_entry->network);
				}

			return (MATCHING_ENTRY_FOUND_UPDATE);
			}
		else 
			{
			if (sptr_primary_route_entry->type != NLSP_IPX_ROUTE)
				{
				check_if_in_secondary_route_list (sptr_primary_route_entry,sptr_rx_route_entry,
					sptr_source_address,port_number,route_type,vptr_lsp);
				}
				
			return (MATCHING_ENTRY_FOUND_NO_UPDATE); /* force this even if a secondary list has an update */
			}
		}
}
/*************************************************************************/
static enum LIST_ENTRY_TYPE check_if_in_secondary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	ROUTE_ENTRY *sptr_rx_route_entry,ETHERNET_ADDRESS *sptr_source_address,USHORT port_number,
	enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp)
{
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;
	ROUTE_LIST_ENTRY *sptr_free_secondary_route_entry;

	for (sptr_secondary_route_entry =  sptr_primary_route_entry->network_links.sptr_forward_link;
		sptr_secondary_route_entry !=  0x00000000L;
		sptr_secondary_route_entry =  sptr_secondary_route_entry->links.sptr_forward_link)
		{
		if ((memcmp (sptr_rx_route_entry,&sptr_secondary_route_entry->route_entry,sizeof (ROUTE_ENTRY)) == (int) NULL) &&
			(memcmp (sptr_source_address,&sptr_secondary_route_entry->router_address,sizeof (ETHERNET_ADDRESS)) == (int) NULL) && 
			(sptr_secondary_route_entry->port_number == port_number))
			{
			sptr_secondary_route_entry->timer_value = router_timer;

			return (MATCHING_ENTRY_FOUND_NO_UPDATE);
			}
		else if	((memcmp (sptr_source_address,&sptr_secondary_route_entry->router_address,
			sizeof (ETHERNET_ADDRESS)) == (int) NULL) && /* hop count is different */
			(sptr_secondary_route_entry->port_number == port_number)) /* takes care of SERVER_OR_ROUTER_DOWN_HOP_COUNT case */
			{
			if (sptr_secondary_route_entry->route_entry.hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
		 		delete_entry_from_list ((LINK *) &sptr_primary_route_entry->network_links,(LINK *) sptr_secondary_route_entry);
				}
			else
				{
				sptr_secondary_route_entry->route_entry = *sptr_rx_route_entry;
				sptr_secondary_route_entry->timer_value = router_timer;
				sptr_secondary_route_entry->type = (BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)) route_type;
				sptr_secondary_route_entry->vptr_lsp = vptr_lsp;
				}

			return (MATCHING_ENTRY_FOUND_UPDATE);
			}
		}

	if	((memcmp (sptr_source_address,&sptr_primary_route_entry->router_address,sizeof (ETHERNET_ADDRESS)) == (int) NULL) && /* same router */
		(sptr_primary_route_entry->port_number == port_number)) /* NO SECONDARY ROUTES FROM THE SAME ROUTER ON THE SAME PORT */
		{
		return (MATCHING_ENTRY_FOUND_NO_UPDATE);  
		}

	if	((memcmp (sptr_source_address,&sptr_primary_route_entry->router_address,sizeof (ETHERNET_ADDRESS)) != (int) NULL) &&
		(sptr_rx_route_entry->hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT))
		{
		sptr_primary_route_entry->new_primary_route = TRUE;

		update_routes_for_all_ports ();

		return (MATCHING_ENTRY_FOUND_NO_UPDATE);  
		}

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	if ((sptr_free_secondary_route_entry = (ROUTE_LIST_ENTRY *) table_malloc (sizeof (ROUTE_LIST_ENTRY),1)) != NULL)
#else
	if ((sptr_free_secondary_route_entry = get_entry_from_list (&ipx_class.free_router_list_entries)) != NULL)
#endif
		{
		sptr_free_secondary_route_entry->route_entry = *sptr_rx_route_entry;
		sptr_free_secondary_route_entry->router_address = *sptr_source_address;
		sptr_free_secondary_route_entry->port_number = port_number;
		sptr_free_secondary_route_entry->timer_value = router_timer;
		sptr_free_secondary_route_entry->new_primary_route = FALSE;
		sptr_free_secondary_route_entry->type = (BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)) route_type;
		sptr_free_secondary_route_entry->vptr_lsp = vptr_lsp;

		add_entry_to_list ((LINK *) &sptr_primary_route_entry->network_links,(LINK *) &sptr_free_secondary_route_entry->links);
		}
	else
		{
		ipx_management_alarm (OUT_OF_ROUTE_LIST_ENTRIES,port_number);
		}

	return (MATCHING_ENTRY_FOUND_UPDATE); /* add a new entry only to network links */
}
/*************************************************************************/
static void delete_secondary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry)
{
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;
	ROUTE_LIST_ENTRY *sptr_next_secondary_route_entry;

	for (sptr_secondary_route_entry =  sptr_primary_route_entry->network_links.sptr_forward_link;
		sptr_secondary_route_entry !=  NULL;)
		{
		sptr_next_secondary_route_entry = sptr_secondary_route_entry->links.sptr_forward_link;

 		delete_entry_from_list ((LINK *) &sptr_primary_route_entry->network_links,(LINK *) &sptr_secondary_route_entry->links);

		memset (sptr_secondary_route_entry, (int) NULL, sizeof (ROUTE_LIST_ENTRY));

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
		table_free (&sptr_secondary_route_entry->links);
#else
		add_entry_to_list ((LINK *) &ipx_class.free_router_list_entries,(LINK *) &sptr_secondary_route_entry->links);
#endif
		sptr_secondary_route_entry = sptr_next_secondary_route_entry;
		}
}
/*************************************************************************/
enum BOOLEAN is_route_the_best_information (ROUTE_LIST_ENTRY *sptr_primary_route_list_entry,USHORT outgoing_port_number)
{
	ROUTE_LIST_ENTRY *sptr_secondary_route_list_entry;

	if (outgoing_port_number == sptr_primary_route_list_entry->port_number)
		{
		return (FALSE);
		}

	for (sptr_secondary_route_list_entry =  sptr_primary_route_list_entry->network_links.sptr_forward_link;
		sptr_secondary_route_list_entry !=  0x00000000L;
		sptr_secondary_route_list_entry =  sptr_secondary_route_list_entry->links.sptr_forward_link)
		{
		if ((outgoing_port_number == sptr_secondary_route_list_entry->port_number) &&
			(sptr_secondary_route_list_entry->route_entry.transport_time ==
			sptr_primary_route_list_entry->route_entry.transport_time))
			{
			break;
			}
		}

	if (sptr_secondary_route_list_entry == NULL)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/*************************************************************************/
enum IPX_PACKET_STATE send_periodic_route_information (USHORT port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	BYTE	number_of_route_entries;
	GAP_TIME_ROUTE_INFORMATION	*sptr_route_information;

	if (ipx_class.port[port_number].enable_periodic_RIP_broadcasts == FALSE)
		{
		return (RIP_PERIODIC_BROADCASTS_DISABLED);
		}

	sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_rip_packet + sizeof (LINK));

	if (sptr_route_information	== NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_route_entries = 0x00;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if ((sptr_primary_route_entry->route_entry.network != ipx_class.port[port_number].network) && 
			(is_route_the_best_information (sptr_primary_route_entry,port_number) == TRUE))
			{
			sptr_route_information->route_entry_list[number_of_route_entries] = sptr_primary_route_entry->route_entry;
			sptr_route_information->route_entry_list[number_of_route_entries].transport_time =
				swap ((USHORT) (swap (sptr_route_information->route_entry_list[number_of_route_entries].transport_time) +
				ipx_class.port[port_number].transport_time));

			number_of_route_entries = (BYTE) (number_of_route_entries + 1);

			if (number_of_route_entries >= ipx_class.port[port_number].maximum_number_of_rip_entries)
				{
				initialize_router_periodic_information_packet (port_number,
					(ROUTE_INFORMATION *) &sptr_route_information->ethernet_header);

				sptr_route_information->ipx_header.length =
					swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER)));

/* Sanjays code */
				++ipx_class.port[port_number].statistics.RIP_tx.number_of_packets;
/* Sanjays code */
				add_entry_to_list ((LINK *) &ipx_class.port[port_number].periodic_RIP_list,
					&sptr_route_information->links);

				if ((sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *)
					get_a_send_packet (port_number,ipx_class.port[port_number].maximum_size_of_rip_packet + sizeof (LINK))) == NULL)
					{
					return (OUT_OF_TX_PACKET_MEMORY);
					}

				number_of_route_entries = 0x00;
				}
			}
		}

	if (number_of_route_entries > 0x00)
		{
		initialize_router_periodic_information_packet (port_number,
			(ROUTE_INFORMATION *) &sptr_route_information->ethernet_header);

		sptr_route_information->ipx_header.length =
			swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER) -
			((ipx_class.port[port_number].maximum_number_of_rip_entries - number_of_route_entries) * sizeof(ROUTE_ENTRY) )));

/* Sanjays code */
		++ipx_class.port[port_number].statistics.RIP_tx.number_of_packets;
/* Sanjays code */

		add_entry_to_list ((LINK *) &ipx_class.port[port_number].periodic_RIP_list,&sptr_route_information->links);
		}
	else
		{
		sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_route_information);

		free_a_send_packet ((IPX_PACKET *) sptr_route_information);
		}

	return (GENERAL_ROUTE_INFORMATION);
}
/*************************************************************************/
void check_for_down_routers (void)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	ROUTE_LIST_ENTRY *sptr_next_primary_route_entry;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;)
		{
		sptr_next_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link;

		check_for_down_secondary_routes (sptr_primary_route_entry);

		if (sptr_primary_route_entry->route_entry.hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			delete_route_entry (sptr_primary_route_entry,RIP_IPX_ROUTE,NULL);
			}

		sptr_primary_route_entry = sptr_next_primary_route_entry;
		}
}
/*************************************************************************/
static void check_for_down_secondary_routes (ROUTE_LIST_ENTRY *sptr_primary_route_entry)
{
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;
	ROUTE_LIST_ENTRY *sptr_next_secondary_route_entry;

	for (sptr_secondary_route_entry =  sptr_primary_route_entry->network_links.sptr_forward_link;
		sptr_secondary_route_entry != NULL;)
		{
		sptr_next_secondary_route_entry =  sptr_secondary_route_entry->links.sptr_forward_link;

		if (sptr_secondary_route_entry->route_entry.hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
 			delete_entry_from_list ((LINK *) &sptr_primary_route_entry->network_links,(LINK *) &sptr_secondary_route_entry->links);

			memset (sptr_secondary_route_entry, (int) NULL, sizeof (ROUTE_LIST_ENTRY));

	#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
			table_free (&sptr_secondary_route_entry->links);
	#else
			add_entry_to_list ((LINK *) &ipx_class.free_router_list_entries,(LINK *) &sptr_secondary_route_entry->links);
	#endif
			}

 		sptr_secondary_route_entry = sptr_next_secondary_route_entry;
		}
}
/*************************************************************************/
void delete_route_entry (ROUTE_LIST_ENTRY *sptr_primary_route_entry,enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp)
{
	ULONG network_address;
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;
	enum BOOLEAN new_primary_route;

	PARAMETER_NOT_USED (route_type);
	PARAMETER_NOT_USED (vptr_lsp);

	network_address = sptr_primary_route_entry->route_entry.network;
	new_primary_route = FALSE;

	if (sptr_primary_route_entry->network_links.sptr_forward_link != NULL)
		{
		sptr_secondary_route_entry = sptr_primary_route_entry->network_links.sptr_forward_link;

	 	delete_entry_from_list ((LINK *) &sptr_primary_route_entry->network_links.sptr_forward_link,
			(LINK *) sptr_secondary_route_entry);

		sptr_secondary_route_entry->network_links.sptr_forward_link = sptr_primary_route_entry->network_links.sptr_forward_link; 
		sptr_secondary_route_entry->network_links.sptr_backward_link = sptr_primary_route_entry->network_links.sptr_backward_link; 

		add_entry_to_list ((LINK *) &ipx_class.router_list.sptr_forward_link,(LINK *) &sptr_secondary_route_entry->links);

		sptr_secondary_route_entry->new_primary_route = TRUE;
		new_primary_route = TRUE;
		}

	--ipx_class.number_of_route_entries;
/* Sanjays code */
	--ipx_class.ipxAdvSysEntry[0].ipxAdvSysDestCount;
/* Sanjays code */

 	delete_entry_from_list ((LINK *) &ipx_class.router_list.sptr_forward_link,(LINK *) &sptr_primary_route_entry->links);

	memset (sptr_primary_route_entry, (int) NULL, sizeof (ROUTE_LIST_ENTRY));

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	table_free (&sptr_primary_route_entry->links);
#else
	add_entry_to_list ((LINK *) &ipx_class.free_router_list_entries,(LINK *) &sptr_primary_route_entry->links);
#endif

	if (new_primary_route == TRUE)
		{
		update_routes_for_all_ports ();
		}
	else
		{
		delete_all_SAPs_with_network_address (network_address);
		}
}
/*************************************************************************/
void update_routes_for_all_ports (void)
{
	USHORT port_number;
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		if ((ipx_class.port[port_number].rip_compatibility == RIP_ON) || ((ipx_class.port[port_number].rip_compatibility == RIP_AUTO) 
			&& (ipx_class.port[port_number].auto_rip_compatibility_activated == TRUE)))
			{
			send_route_update_packet (port_number);
			}
		}

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
			sptr_primary_route_entry != NULL;
			sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
			{
			if ((sptr_primary_route_entry->route_entry.network != ipx_class.port[port_number].network) && 
				(is_route_the_best_information (sptr_primary_route_entry,port_number) == TRUE))
				{
				if (sptr_primary_route_entry->new_primary_route == TRUE)
					{
					sptr_primary_route_entry->new_primary_route = FALSE;
					}
				}
			}
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_route_update_packet (USHORT port_number)
{
	BYTE	number_of_route_entries;
	ROUTE_INFORMATION	*sptr_route_information;
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;

	sptr_route_information =
		(ROUTE_INFORMATION *) get_a_send_packet (port_number,ipx_class.port[port_number].maximum_size_of_rip_packet);

	if (sptr_route_information == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_route_entries = 0x00;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if ((sptr_primary_route_entry->route_entry.network != ipx_class.port[port_number].network) && 
			(is_route_the_best_information (sptr_primary_route_entry,port_number) == TRUE))
			{
			if (ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry != NULL)
				{
				if ((*ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry) (sptr_primary_route_entry, FALSE) == 
					VALID_ENTRY_ON_DESIGNATED_ROUTER)
					{
					if (sptr_primary_route_entry->new_primary_route == TRUE)
						{
						sptr_route_information->route_entry_list[number_of_route_entries] = sptr_primary_route_entry->route_entry;

						sptr_route_information->route_entry_list[number_of_route_entries].transport_time =
							swap ((USHORT) (swap (sptr_route_information->route_entry_list[number_of_route_entries].transport_time) + 
							ipx_class.port[port_number].transport_time));

						number_of_route_entries = (BYTE) (number_of_route_entries + 1);

						if (number_of_route_entries >= ipx_class.port[port_number].maximum_number_of_rip_entries)
							{
							initialize_router_periodic_information_packet (port_number,sptr_route_information);

							sptr_route_information->ipx_header.length =
								swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER)));

				 			++ipx_class.port[port_number].statistics.number_of_periodic_router_broadcasts;

/* Sanjays code */
							++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
							 send_ipx_packet (port_number,(IPX_PACKET *) sptr_route_information,(USHORT) (sizeof (ETHERNET_HEADER) +
								swap (sptr_route_information->ipx_header.length)),FALSE,send_completion_ipx_packet);

							if ((sptr_route_information = (ROUTE_INFORMATION *)
								get_a_send_packet (port_number,ipx_class.port[port_number].maximum_size_of_rip_packet)) == NULL)
								{
								return (OUT_OF_TX_PACKET_MEMORY);
								}

							number_of_route_entries = 0x00;
							}
						}
					}
				}
			else
				{
				if (sptr_primary_route_entry->new_primary_route == TRUE)
					{
					sptr_route_information->route_entry_list[number_of_route_entries] = sptr_primary_route_entry->route_entry;

					sptr_route_information->route_entry_list[number_of_route_entries].transport_time =
						swap ((USHORT) (swap (sptr_route_information->route_entry_list[number_of_route_entries].transport_time) + 
						ipx_class.port[port_number].transport_time));

					number_of_route_entries = (BYTE) (number_of_route_entries + 1);

					if (number_of_route_entries >= ipx_class.port[port_number].maximum_number_of_rip_entries)
						{
						initialize_router_periodic_information_packet (port_number,sptr_route_information);

						sptr_route_information->ipx_header.length =
							swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER)));

			 			++ipx_class.port[port_number].statistics.number_of_periodic_router_broadcasts;

/* Sanjays code */
						++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
						 send_ipx_packet (port_number,(IPX_PACKET *) sptr_route_information,(USHORT) (sizeof (ETHERNET_HEADER) +
							swap (sptr_route_information->ipx_header.length)),FALSE,send_completion_ipx_packet);

						if ((sptr_route_information = (ROUTE_INFORMATION *)
							get_a_send_packet (port_number,ipx_class.port[port_number].maximum_size_of_rip_packet)) == NULL)
							{
							return (OUT_OF_TX_PACKET_MEMORY);
							}

						number_of_route_entries = 0x00;
						}
					}
				}
			}
		}

	if (number_of_route_entries > 0x00)
		{
		initialize_router_periodic_information_packet (port_number,sptr_route_information);

		sptr_route_information->ipx_header.length =
			swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER) -
			((ipx_class.port[port_number].maximum_number_of_rip_entries - number_of_route_entries) * sizeof(ROUTE_ENTRY) )));

		++ipx_class.port[port_number].statistics.number_of_update_router_broadcasts;

/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_route_information,(USHORT) (sizeof (ETHERNET_HEADER) +
			swap (sptr_route_information->ipx_header.length)),FALSE,send_completion_ipx_packet);
		}
	else
		{
		sptr_route_information = (ROUTE_INFORMATION *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_route_information);

		free_a_send_packet ((IPX_PACKET *) sptr_route_information);
		}

	return (GENERAL_ROUTE_INFORMATION);
}
/*************************************************************************/
ROUTE_ENTRY *get_route_entry_from_network_address (ULONG network_address)
{
	ROUTE_LIST_ENTRY	*sptr_primary_route_entry;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if (sptr_primary_route_entry->route_entry.network == network_address)
			{
			return (&sptr_primary_route_entry->route_entry);
			}
		}

	return (NULL);
}
/*************************************************************************/
enum TEST add_route_entry (USHORT port_number,ROUTE_ENTRY *sptr_route_entry,ETHERNET_ADDRESS *sptr_ethernet_address,
	enum BOOLEAN new_primary_route,enum BOOLEAN static_entry,enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp)
{
	ROUTE_LIST_ENTRY *sptr_route_list_entry;

	if (ipx_class.fptr_route_added != NULL)
		{
		(*ipx_class.fptr_route_added) (port_number,sptr_route_entry,sptr_ethernet_address,new_primary_route,static_entry);
		}

	if (check_for_already_existing_route (sptr_route_entry) == TRUE) /* to catch erroneous management additions or wan oscillations */
		{
		ipx_management_alarm (TRYING_TO_ADD_DUPLICATE_ROUTE,port_number);	

		return (FAIL);	
		}

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	if ((sptr_route_list_entry = (ROUTE_LIST_ENTRY *) table_malloc (sizeof (ROUTE_LIST_ENTRY),1)) != NULL)
#else
	if ((sptr_route_list_entry =
		 get_entry_from_list (&ipx_class.free_router_list_entries)) != NULL)
#endif
		{
/* Sanjays code */
		sptr_route_list_entry->ipx_instance = 1;
/* Sanjays code */
		sptr_route_list_entry->route_entry = *sptr_route_entry;
		sptr_route_list_entry->router_address = *sptr_ethernet_address;
		sptr_route_list_entry->port_number = port_number;
/* Sanjays code */
		sptr_route_list_entry->next_hop_network_number = ipx_class.port[port_number].network;
/* Sanjays code */
		sptr_route_list_entry->timer_value = router_timer;
		sptr_route_list_entry->new_primary_route = (BYTE_ENUM (BOOLEAN)) new_primary_route;
		sptr_route_list_entry->type = (BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)) route_type;
		sptr_route_list_entry->vptr_lsp = vptr_lsp;

		if (static_entry == TRUE)
			{
			sptr_route_list_entry->do_not_age = TRUE;
			}

		if ((ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry != NULL) &&
			((*ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry) (sptr_route_list_entry, FALSE) != 
			VALID_ENTRY_ON_DESIGNATED_ROUTER))
			{
			table_free (sptr_route_list_entry);

			return (FAIL);
			}

		++ipx_class.number_of_route_entries;
/* Sanjays code */
		++ipx_class.ipxAdvSysEntry[0].ipxAdvSysDestCount;
/* Sanjays code */

		add_entry_to_list ((LINK *) &ipx_class.router_list,(LINK *) &sptr_route_list_entry->links);

		return (PASS);
		}
	else
		{
		ipx_management_alarm (OUT_OF_ROUTE_LIST_ENTRIES,port_number);

		return (FAIL);
		}
}
/****************************************************************************/
static enum BOOLEAN check_for_already_existing_route (ROUTE_ENTRY *sptr_route_entry)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;

	for (sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,
		ipx_class.router_list.sptr_forward_link);
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,sptr_primary_route_entry))
		{
		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
ROUTE_LIST_ENTRY *get_route_list_entry_using_network (ULONG network,ROUTE_LIST_ENTRY *sptr_route_list_entry)
{
	if (sptr_route_list_entry == NULL)
		return (NULL);

	for (; sptr_route_list_entry != NULL; sptr_route_list_entry = sptr_route_list_entry->links.sptr_forward_link)
		{
		if (sptr_route_list_entry->route_entry.network == network)
			{
			break;
			}
		}

	return (sptr_route_list_entry);
}
/****************************************************************************/
ROUTE_LIST_ENTRY *get_route_list_entry_using_hops (USHORT hops,ROUTE_LIST_ENTRY *sptr_route_list_entry)
{
	if (sptr_route_list_entry == NULL)
		return (NULL);

	for (; sptr_route_list_entry != NULL; sptr_route_list_entry = sptr_route_list_entry->links.sptr_forward_link)
		{
		if (sptr_route_list_entry->route_entry.hops == hops)
			{
			break;
			}
		}

	return (sptr_route_list_entry);
}
/****************************************************************************/
ROUTE_LIST_ENTRY *get_route_list_entry_using_router_address (ETHERNET_ADDRESS *sptr_router_address,
	ROUTE_LIST_ENTRY *sptr_route_list_entry)
{
	if (sptr_route_list_entry == NULL)
		return (NULL);

	for (; sptr_route_list_entry != NULL; sptr_route_list_entry = sptr_route_list_entry->links.sptr_forward_link)
		{
		if (sptr_route_list_entry->router_address._ulong == sptr_router_address->_ulong && 
			sptr_route_list_entry->router_address._ushort == sptr_router_address->_ushort)
			{
			break;
			}
		}

	return (sptr_route_list_entry);
}
/****************************************************************************/
ROUTE_LIST_ENTRY *get_route_list_entry_using_port_number (USHORT port_number,ROUTE_LIST_ENTRY *sptr_route_list_entry)
{
	if (sptr_route_list_entry == NULL)
		return (NULL);

	for (; sptr_route_list_entry != NULL; sptr_route_list_entry = sptr_route_list_entry->links.sptr_forward_link)
		{
		if (sptr_route_list_entry->port_number == port_number)
			{
			break;
			}
		}

	return (sptr_route_list_entry);
}
/****************************************************************************/
void shut_ipx_rip_port_down (USHORT port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_list_entry;
	ROUTE_LIST_ENTRY	*sptr_secondary_route_list_entry;

	sptr_primary_route_list_entry = ipx_class.router_list.sptr_forward_link;

	while (TRUE)
		{
		sptr_primary_route_list_entry = get_route_list_entry_using_port_number (port_number,sptr_primary_route_list_entry);

		if (sptr_primary_route_list_entry == NULL)
			{
			break;
			}

		for (sptr_secondary_route_list_entry = sptr_primary_route_list_entry->network_links.sptr_forward_link;
			sptr_secondary_route_list_entry != NULL;
			sptr_secondary_route_list_entry = sptr_secondary_route_list_entry->links.sptr_forward_link)
			{
 			sptr_secondary_route_list_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			}

		sptr_primary_route_list_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;

		sptr_primary_route_list_entry = sptr_primary_route_list_entry->links.sptr_forward_link;
		}

	update_routes_for_all_ports ();
}
