#include	"defs.h"
/*	$Modname: ipxsapls.c$  $version: 3.36$      $date: 11/03/95$   */
/*
* 	$lgb$
1.0 01/21/93 ross
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 02/01/93 ross fixes to ipxsap better sap entry problem.  courtesy of JO.
3.2 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.3 03/15/93 ross x86 version now works in real mode -just enough memory
3.4 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.5 04/12/93 ross made variable name change in vipxstr.h
3.6 04/30/93 ross delete_all_SAP_with_net... freed the primary entry before using the forward link.
3.7 05/13/93 ross added stack parameter for tunnel software
3.8 05/15/93 ross added several new management functions.
3.9 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.10 05/24/93 ross fixed some problems will loops going down.
3.11 06/02/93 ross added router address to primary and secondary sap functions. Courtesy of YR.
3.12 06/23/93 ross fixed a secondary SAP function
3.13 07/18/93 ross changed the stricmp to strcmp, since this was not ansi c.  Coutesy of don.
3.14 10/09/93 ross Added changes for ipxwan
3.15 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.16 11/08/93 ross fixed some secondary rip and sap problems.  Courtesy of Rick.
3.17 11/08/93 ross update sent out when secondary moves to primary sap.
3.18 11/08/93 ross moved update down in delete function.
3.19 11/09/93 ross SAP and rip down port and global functions bugs fixed.  Courtesy of Ken.
3.20 11/10/93 ross change links to SAP_links in delete SAP entry.  Courtesy of Ken.
3.21 02/02/94 ross added line in check_if_in_primary... to check for excessive server down updates.
3.22 03/09/94 ross took out do_not_age = TRUE for wan cases.
3.23 03/09/94 ross removing the wan_port dependency on rip and sap aging.
3.24 03/14/94 ross cleaned up braces and white spaces for release.
3.25 04/04/94 ross added check for do_not_age in check_if_in_primary... for bad configuration.  Courtesy of Ishwar.
3.26 05/20/94 ross added better support for disabled port, and added add rip/sap function pointers.  Courtest of Fred and Don.
3.27 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.28 07/07/94 ross update saps for all ports had a port number bug.  Courtesy of Fred.
3.29 08/16/94 ross Delete secondary entries used the main sap list when getting deleted.  Courtesy of Fred.
3.30 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.31 11/23/94 ross Added remote access. Added auto-configuration.
3.32 03/26/95 ross nlsp changes.
3.33 09/25/95 ross added changes for dynamic loading
3.34 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.35 10/20/95 nishit Changed copyright
3.36 11/03/95 nishit Added check for source address for worse case in  check_in_in_primary_SAP_list
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>
#include	"ipx.h"
/****************************************************************************/
static enum LIST_ENTRY_TYPE check_if_in_secondary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry,SAP_ID *sptr_SAP_ID,
	ETHERNET_ADDRESS *sptr_router_address,USHORT port_number,enum IPX_SAP_PROTOCOL_TYPE SAP_type,void *vptr_lsp);
static void delete_secondary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry);
static void check_for_down_secondary_SAP_paths (SAP_LIST_ENTRY *sptr_primary_SAP_entry);
static enum IPX_PACKET_STATE send_SAP_update_packet (USHORT port_number);
static enum BOOLEAN SAP_ids_are_equal (SAP_ID *sptr_SAP_id_1,SAP_ID *sptr_SAP_id_2);
/*************************************************************************/
enum LIST_ENTRY_TYPE check_if_in_primary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry,SAP_ID *sptr_SAP_ID,
	ETHERNET_ADDRESS *sptr_router_address,USHORT port_number,enum IPX_SAP_PROTOCOL_TYPE SAP_type,void *vptr_lsp)
{
	if (SAP_ids_are_equal (&sptr_primary_SAP_entry->SAP_ID,sptr_SAP_ID) == FALSE)
		{
		return (MATCHING_ENTRY_NOT_FOUND);
		}
	else if (swap (sptr_SAP_ID->intervening_networks) < swap (sptr_primary_SAP_entry->SAP_ID.intervening_networks)) /* better path to SAP */
		{
		if (sptr_primary_SAP_entry->do_not_age == TRUE)
			{
			return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
			}

		delete_secondary_SAP_list (sptr_primary_SAP_entry);

 		sptr_primary_SAP_entry->port_number = port_number;
		sptr_primary_SAP_entry->SAP_ID.intervening_networks = sptr_SAP_ID->intervening_networks;
		sptr_primary_SAP_entry->timer_value = router_timer;
		sptr_primary_SAP_entry->new_primary_SAP = TRUE;
		sptr_primary_SAP_entry->type = (BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)) SAP_type;
		sptr_primary_SAP_entry->vptr_lsp = vptr_lsp;

		return (MATCHING_ENTRY_FOUND_UPDATE);
		}
	else if ((memcmp (&sptr_primary_SAP_entry->SAP_ID.ipx_address,&sptr_SAP_ID->ipx_address,sizeof (IPX_ADDRESS)) == (int) NULL) &&
 		(sptr_primary_SAP_entry->port_number == port_number))
		{
		if (sptr_primary_SAP_entry->SAP_ID.intervening_networks == sptr_SAP_ID->intervening_networks) /* the default case */
			{
			sptr_primary_SAP_entry->timer_value = router_timer;
			return (MATCHING_ENTRY_FOUND_NO_UPDATE);
			}
		else if ((swap (sptr_SAP_ID->intervening_networks) > swap (sptr_primary_SAP_entry->SAP_ID.intervening_networks)) /* worse */
			&& (memcmp (&sptr_primary_SAP_entry->router_address,sptr_router_address,sizeof (ETHERNET_ADDRESS)) == (int) NULL))
			{
			if (sptr_primary_SAP_entry->do_not_age == TRUE)
				{
				return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
				}

			delete_secondary_SAP_list (sptr_primary_SAP_entry);

	 		sptr_primary_SAP_entry->port_number = port_number;
			sptr_primary_SAP_entry->SAP_ID.intervening_networks = sptr_SAP_ID->intervening_networks;
			sptr_primary_SAP_entry->timer_value = router_timer;
			sptr_primary_SAP_entry->new_primary_SAP = TRUE;
			sptr_primary_SAP_entry->type = (BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)) SAP_type;
			sptr_primary_SAP_entry->vptr_lsp = vptr_lsp;

			return (MATCHING_ENTRY_FOUND_UPDATE);
			}
		}
	else if (sptr_SAP_ID->intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT) /* SAP is going down, or has been timed out by another router */
		{
		if (sptr_primary_SAP_entry->do_not_age == TRUE ||
			sptr_primary_SAP_entry->SAP_ID.intervening_networks == SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			return (MATCHING_ENTRY_FOUND_NO_UPDATE); 
			}

		sptr_primary_SAP_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT; /* for the case of router going down, this insures we will */
		sptr_primary_SAP_entry->timer_value = router_timer;
		sptr_primary_SAP_entry->new_primary_SAP = TRUE;

		return (MATCHING_ENTRY_FOUND_UPDATE);
		}
	else
		{
		check_if_in_secondary_SAP_list (sptr_primary_SAP_entry,sptr_SAP_ID,sptr_router_address,port_number,SAP_type,vptr_lsp);

		return (MATCHING_ENTRY_FOUND_NO_UPDATE); /* force no update, although secondary update may have occurred */
		}
}
/*************************************************************************/
static enum LIST_ENTRY_TYPE check_if_in_secondary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry,SAP_ID *sptr_SAP_ID,
	ETHERNET_ADDRESS *sptr_router_address,USHORT port_number,enum IPX_SAP_PROTOCOL_TYPE SAP_type,void *vptr_lsp)
{
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;
	SAP_LIST_ENTRY *sptr_free_secondary_SAP_entry;

	for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link; sptr_secondary_SAP_entry != NULL;
		sptr_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link)
		{
		if ((memcmp (sptr_SAP_ID,&sptr_secondary_SAP_entry->SAP_ID,sizeof (SAP_ID)) == (int) NULL) &&
			(sptr_secondary_SAP_entry->port_number == port_number))
			{
			sptr_secondary_SAP_entry->timer_value = router_timer;

			return (MATCHING_ENTRY_FOUND_NO_UPDATE);
			}
		else if (sptr_secondary_SAP_entry->port_number == port_number) 
			{
			sptr_secondary_SAP_entry->SAP_ID = *sptr_SAP_ID;
			sptr_secondary_SAP_entry->timer_value = router_timer;
			sptr_secondary_SAP_entry->type = (BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)) SAP_type;
			sptr_secondary_SAP_entry->vptr_lsp = vptr_lsp;

			return (MATCHING_ENTRY_FOUND_UPDATE);
			}
		}

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	if ((sptr_free_secondary_SAP_entry = (SAP_LIST_ENTRY *) table_malloc (sizeof (SAP_LIST_ENTRY),1)) != NULL)
#else
	if ((sptr_free_secondary_SAP_entry = (SAP_LIST_ENTRY *) get_entry_from_list (&ipx_class.free_SAP_list_entries)) != NULL)
#endif
		{
		sptr_free_secondary_SAP_entry->router_address = *sptr_router_address;
		sptr_free_secondary_SAP_entry->SAP_ID = *sptr_SAP_ID;
		sptr_free_secondary_SAP_entry->timer_value = router_timer;
		sptr_free_secondary_SAP_entry->port_number = port_number;
		sptr_free_secondary_SAP_entry->new_primary_SAP = FALSE;
		sptr_free_secondary_SAP_entry->type = (BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)) SAP_type;
		sptr_free_secondary_SAP_entry->vptr_lsp = vptr_lsp;

		add_entry_to_list ((LINK *) &sptr_primary_SAP_entry->SAP_links,(LINK *) &sptr_free_secondary_SAP_entry->links);
		}
	else
		{
		ipx_management_alarm (OUT_OF_SAP_LIST_ENTRIES,port_number);
		}

	return (MATCHING_ENTRY_FOUND_UPDATE); /* add a new entry only to SAP links */
}
/*************************************************************************/
static void delete_secondary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry)
{
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_secondary_SAP_entry;

	for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;
		sptr_secondary_SAP_entry != NULL;)
		{
		sptr_next_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link;

/*		delete_entry_from_list ((LINK *) &ipx_class.SAP_list.sptr_forward_link,(LINK *) &sptr_secondary_SAP_entry->links); */

		delete_entry_from_list ((LINK *) &sptr_primary_SAP_entry->SAP_links.sptr_forward_link,
			(LINK *) &sptr_secondary_SAP_entry->links); 

		memset (sptr_secondary_SAP_entry, (int) NULL, sizeof (SAP_LIST_ENTRY));
#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
		table_free (&sptr_secondary_SAP_entry->links);
#else
		add_entry_to_list ((LINK *) &ipx_class.free_SAP_list_entries,(LINK *) &sptr_secondary_SAP_entry->links);
#endif
		sptr_secondary_SAP_entry = sptr_next_secondary_SAP_entry;
		}
}
/*************************************************************************/
enum BOOLEAN is_SAP_the_best_information (SAP_LIST_ENTRY *sptr_primary_SAP_entry,USHORT outgoing_port_number)
{
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;

	if (sptr_primary_SAP_entry->port_number == outgoing_port_number)
		{
		return (FALSE);
		}

	for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;
		sptr_secondary_SAP_entry != NULL;
		sptr_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link)
		{
		if ((outgoing_port_number == sptr_secondary_SAP_entry->port_number) &&
			(sptr_secondary_SAP_entry->SAP_ID.intervening_networks == sptr_primary_SAP_entry->SAP_ID.intervening_networks))
			{
			break;
			}
		}

	if (sptr_secondary_SAP_entry == NULL)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/*************************************************************************/
enum IPX_PACKET_STATE send_SAP_periodic_broadcast (USHORT port_number)
{
	USHORT	number_of_SAP_IDs;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	GAP_TIME_SAP_RESPONSE_PACKET	*sptr_SAP_periodic_broadcast;

	if (ipx_class.port[port_number].enable_periodic_SAP_broadcasts == FALSE)
		{
		return (SAP_PERIODIC_BROADCASTS_DISABLED);
		}


	sptr_SAP_periodic_broadcast = (GAP_TIME_SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_SAP_packet + sizeof (LINK));

	if (sptr_SAP_periodic_broadcast == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_SAP_IDs = 0x00;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
		{
		if (is_SAP_the_best_information (sptr_primary_SAP_entry,port_number) == TRUE)
			{
			sptr_SAP_periodic_broadcast->SAP_ID[number_of_SAP_IDs] = sptr_primary_SAP_entry->SAP_ID;

			if (++number_of_SAP_IDs >= ipx_class.port[port_number].maximum_number_of_SAP_entries)
				{
				initialize_SAP_periodic_response (port_number,(SAP_RESPONSE_PACKET *) &sptr_SAP_periodic_broadcast->ethernet_header);

				sptr_SAP_periodic_broadcast->ipx_header.length =
					swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet - sizeof (UNION_MAC_HEADER)));

				add_entry_to_list ((LINK *) &ipx_class.port[port_number].periodic_SAP_list,
					&sptr_SAP_periodic_broadcast->links);

/* Sanjays code */
				/* One more SAP packet sent */
				++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;
/* Sanjays code */		
				sptr_SAP_periodic_broadcast = (GAP_TIME_SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
					ipx_class.port[port_number].maximum_size_of_SAP_packet + sizeof (LINK));

				if (sptr_SAP_periodic_broadcast == NULL)
					{
					return (OUT_OF_TX_PACKET_MEMORY);
					}

				number_of_SAP_IDs = 0x00;
				}
			}
		}

	if (number_of_SAP_IDs > 0x00)
		{
		initialize_SAP_periodic_response (port_number,(SAP_RESPONSE_PACKET *) &sptr_SAP_periodic_broadcast->ethernet_header);

		sptr_SAP_periodic_broadcast->ipx_header.length = swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet -
			((ipx_class.port[port_number].maximum_number_of_SAP_entries - number_of_SAP_IDs) * sizeof(SAP_ID)) -
			sizeof (UNION_MAC_HEADER)));

		add_entry_to_list ((LINK *) &ipx_class.port[port_number].periodic_SAP_list,&sptr_SAP_periodic_broadcast->links);
/* Sanjays code */
		/* One more SAP packet sent */
		++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;
/* Sanjays code */		
		}
	else
		{
		sptr_SAP_periodic_broadcast = (GAP_TIME_SAP_RESPONSE_PACKET *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_SAP_periodic_broadcast);

		free_a_send_packet ((IPX_PACKET *)sptr_SAP_periodic_broadcast);
		}

	return (GENERAL_SAP_INFORMATION);
}
/*************************************************************************/
void check_for_down_SAPs (void)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_SAP_list_entry;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;)
		{
		sptr_next_SAP_list_entry = sptr_primary_SAP_entry->links.sptr_forward_link;

		check_for_down_secondary_SAP_paths (sptr_primary_SAP_entry);

		if (sptr_primary_SAP_entry->SAP_ID.intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			delete_SAP_list_entry (sptr_primary_SAP_entry);
			}

		sptr_primary_SAP_entry = sptr_next_SAP_list_entry;
		}
}
/*************************************************************************/
static void check_for_down_secondary_SAP_paths (SAP_LIST_ENTRY *sptr_primary_SAP_entry)
{
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_secondary_SAP_entry;

	for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;
		sptr_secondary_SAP_entry != NULL;)
		{
		sptr_next_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link;

		if (sptr_secondary_SAP_entry->SAP_ID.intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
 			delete_entry_from_list ((LINK *) &sptr_primary_SAP_entry->SAP_links,(LINK *) &sptr_secondary_SAP_entry->links);

			memset (sptr_secondary_SAP_entry, (int) NULL, sizeof (SAP_LIST_ENTRY));

	#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
			table_free (&sptr_secondary_SAP_entry->links);
	#else
			add_entry_to_list ((LINK *) &ipx_class.free_SAP_list_entries,(LINK *) &sptr_secondary_SAP_entry->links);
	#endif
			}

		sptr_secondary_SAP_entry = sptr_next_secondary_SAP_entry;
		}
}
/*************************************************************************/
void delete_SAP_list_entry (SAP_LIST_ENTRY *sptr_primary_SAP_entry)
{
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;
	enum BOOLEAN new_primary_SAP;

	new_primary_SAP = FALSE;

	if (sptr_primary_SAP_entry->SAP_links.sptr_forward_link != NULL)
		{
		sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;

	 	delete_entry_from_list ((LINK *) &sptr_primary_SAP_entry->SAP_links.sptr_forward_link,
			(LINK *) sptr_secondary_SAP_entry);

		sptr_secondary_SAP_entry->SAP_links.sptr_forward_link = sptr_primary_SAP_entry->SAP_links.sptr_forward_link; 
		sptr_secondary_SAP_entry->SAP_links.sptr_backward_link = sptr_primary_SAP_entry->SAP_links.sptr_backward_link; 

		add_entry_to_list ((LINK *) &ipx_class.SAP_list.sptr_forward_link,(LINK *) &sptr_secondary_SAP_entry->links);

		sptr_secondary_SAP_entry->new_primary_SAP = TRUE;

		new_primary_SAP = TRUE;
		}

	--ipx_class.number_of_SAP_entries;
/* Sanjays code */
	--ipx_class.ipxAdvSysEntry[0].ipxAdvSysServCount;
/* Sanjays code */


 	delete_entry_from_list ((LINK *) &ipx_class.SAP_list.sptr_forward_link,(LINK *) &sptr_primary_SAP_entry->links);

	memset (sptr_primary_SAP_entry, (int) NULL, sizeof (SAP_LIST_ENTRY));

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	table_free (&sptr_primary_SAP_entry->links);
#else
	add_entry_to_list ((LINK *) &ipx_class.free_SAP_list_entries,&sptr_primary_SAP_entry->links);
#endif

	if (new_primary_SAP == TRUE)
		{
		update_SAPs_for_all_ports ();
		}
}
/*************************************************************************/
void update_SAPs_for_all_ports (void)
{
	USHORT port_number;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		send_SAP_update_packet (port_number);
		}

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link;
			sptr_primary_SAP_entry != NULL;
			sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
			{
			if (is_SAP_the_best_information (sptr_primary_SAP_entry,port_number) == TRUE)
				{
				if (sptr_primary_SAP_entry->new_primary_SAP == TRUE)
					{
					sptr_primary_SAP_entry->new_primary_SAP = FALSE;
					}
				}
			}
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_SAP_update_packet (USHORT port_number)
{
	USHORT	number_of_SAP_IDs;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_RESPONSE_PACKET	*sptr_SAP_periodic_broadcast;

	sptr_SAP_periodic_broadcast = (SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_SAP_packet);

	if (sptr_SAP_periodic_broadcast == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_SAP_IDs = 0x00;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
		{
		if (is_SAP_the_best_information (sptr_primary_SAP_entry,port_number) == TRUE)
			{
			if (ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id != NULL)
				{
				if ((*ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id) (sptr_primary_SAP_entry, FALSE) == PASS)
					{
					if (sptr_primary_SAP_entry->new_primary_SAP == TRUE)
						{
						sptr_SAP_periodic_broadcast->SAP_ID[number_of_SAP_IDs] = sptr_primary_SAP_entry->SAP_ID;

						if (++number_of_SAP_IDs >= ipx_class.port[port_number].maximum_number_of_SAP_entries)
							{
							initialize_SAP_periodic_response (port_number,sptr_SAP_periodic_broadcast);

							sptr_SAP_periodic_broadcast->ipx_header.length =
								swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet - sizeof (UNION_MAC_HEADER)));

							++ipx_class.port[port_number].statistics.number_of_SAP_periodic_broadcasts;

/* Sanjays code */
							++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
							send_ipx_packet (port_number,(IPX_PACKET *) sptr_SAP_periodic_broadcast,(USHORT) (sizeof (UNION_MAC_HEADER) +
								swap (sptr_SAP_periodic_broadcast->ipx_header.length)),FALSE,send_completion_ipx_packet);

							sptr_SAP_periodic_broadcast = (SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
								ipx_class.port[port_number].maximum_size_of_SAP_packet);

							if (sptr_SAP_periodic_broadcast == NULL)
								{
								return (OUT_OF_TX_PACKET_MEMORY);
								}

							number_of_SAP_IDs = 0x00;
							}
						}
					}
					
				}
			else
				{
				if (sptr_primary_SAP_entry->new_primary_SAP == TRUE)
					{
					sptr_SAP_periodic_broadcast->SAP_ID[number_of_SAP_IDs] = sptr_primary_SAP_entry->SAP_ID;

					if (++number_of_SAP_IDs >= ipx_class.port[port_number].maximum_number_of_SAP_entries)
						{
						initialize_SAP_periodic_response (port_number,sptr_SAP_periodic_broadcast);

						sptr_SAP_periodic_broadcast->ipx_header.length =
							swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet - sizeof (UNION_MAC_HEADER)));

						++ipx_class.port[port_number].statistics.number_of_SAP_periodic_broadcasts;

/* Sanjays code */
						++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
						send_ipx_packet (port_number,(IPX_PACKET *) sptr_SAP_periodic_broadcast,(USHORT) (sizeof (UNION_MAC_HEADER) +
							swap (sptr_SAP_periodic_broadcast->ipx_header.length)),FALSE,send_completion_ipx_packet);

						sptr_SAP_periodic_broadcast = (SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
							ipx_class.port[port_number].maximum_size_of_SAP_packet);

						if (sptr_SAP_periodic_broadcast == NULL)
							{
							return (OUT_OF_TX_PACKET_MEMORY);
							}

						number_of_SAP_IDs = 0x00;
						}
					}
				}
			}
		}

	if (number_of_SAP_IDs > 0x00)
		{
		initialize_SAP_periodic_response (port_number,sptr_SAP_periodic_broadcast);

		sptr_SAP_periodic_broadcast->ipx_header.length = swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet -
			((ipx_class.port[port_number].maximum_number_of_SAP_entries - number_of_SAP_IDs) * sizeof(SAP_ID)) -
			sizeof (UNION_MAC_HEADER)));

		++ipx_class.port[port_number].statistics.number_of_SAP_update_broadcasts;

/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_SAP_periodic_broadcast,(USHORT) (sizeof (UNION_MAC_HEADER) +
			swap (sptr_SAP_periodic_broadcast->ipx_header.length)),FALSE,send_completion_ipx_packet);
		}
	else
		{
		sptr_SAP_periodic_broadcast = (SAP_RESPONSE_PACKET *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_SAP_periodic_broadcast);

		free_a_send_packet ((IPX_PACKET *)sptr_SAP_periodic_broadcast);
		}

	return (GENERAL_SAP_INFORMATION);
}
/*************************************************************************/
void delete_all_SAPs_with_network_address (ULONG network_address)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_primary_SAP_entry;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link;
		sptr_primary_SAP_entry != NULL;)
		{
		sptr_next_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link;

		if (sptr_primary_SAP_entry->SAP_ID.ipx_address.network == network_address)
			{
			delete_SAP_list_entry (sptr_primary_SAP_entry);
			}

		sptr_primary_SAP_entry = sptr_next_primary_SAP_entry;
		}
}
/****************************************************************************/
enum TEST add_SAP_entry (USHORT port_number,SAP_ID *sptr_SAP_ID,ETHERNET_ADDRESS *sptr_router_address,
	enum BOOLEAN new_primary_SAP,enum BOOLEAN static_entry,enum IPX_SAP_PROTOCOL_TYPE SAP_type,void *vptr_lsp)
{
	SAP_LIST_ENTRY *sptr_SAP_list_entry;

	if (ipx_class.fptr_SAP_added != NULL)
		{
		(*ipx_class.fptr_SAP_added) (port_number,sptr_SAP_ID,sptr_router_address,new_primary_SAP,static_entry);
		}

#ifdef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	if ((sptr_SAP_list_entry = (SAP_LIST_ENTRY *) table_malloc (sizeof (SAP_LIST_ENTRY),1)) != NULL)
#else
	if ((sptr_SAP_list_entry = (SAP_LIST_ENTRY *) get_entry_from_list (&ipx_class.free_SAP_list_entries)) != NULL)
#endif
		{
/* Sanjays code */
		sptr_SAP_list_entry->ipx_instance = 1;
/* Sanjays code */
		sptr_SAP_list_entry->SAP_ID = *sptr_SAP_ID;

		if (sptr_SAP_ID->ipx_address.network == 0x00000000L)
			{
			sptr_SAP_ID->ipx_address.network = ipx_class.port[port_number].network;
			}

		sptr_SAP_list_entry->router_address = *sptr_router_address;
		sptr_SAP_list_entry->port_number = port_number;
		sptr_SAP_list_entry->timer_value = router_timer;
		sptr_SAP_list_entry->new_primary_SAP = (BYTE_ENUM (BOOLEAN)) new_primary_SAP;
		sptr_SAP_list_entry->type = (BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)) SAP_type;
		sptr_SAP_list_entry->vptr_lsp = vptr_lsp;

		/* Srikar, Mar 24, 1997. Added the initialization of protocol type. Anything other than static */
		/* entry is set to SAP type. */
		if (static_entry == TRUE)
			sptr_SAP_list_entry->type = STATIC_SAP;
		else
			sptr_SAP_list_entry->type = IPX_SAP;

		if (static_entry == TRUE)
			{
			sptr_SAP_list_entry->do_not_age = TRUE;
			}

		++ipx_class.number_of_SAP_entries;
/* Sanjays code */
		++ipx_class.ipxAdvSysEntry[0].ipxAdvSysServCount;
/* Sanjays code */

		add_entry_to_list ((LINK *) &ipx_class.SAP_list,(LINK *) &sptr_SAP_list_entry->links);

		if ((ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id != NULL) &&
			((*ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id) (sptr_SAP_list_entry, FALSE) == FAIL))
			{
			--ipx_class.number_of_SAP_entries;
/* Sanjays code */
			--ipx_class.ipxAdvSysEntry[0].ipxAdvSysServCount;
/* Sanjays code */

			delete_entry_from_list ((LINK *) &ipx_class.SAP_list,(LINK *) &sptr_SAP_list_entry->links);

			table_free (sptr_SAP_list_entry);

			return (FAIL);
			}
		}
	else
		{
		ipx_management_alarm (OUT_OF_SAP_LIST_ENTRIES,port_number);

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
SAP_LIST_ENTRY *get_SAP_list_entry_using_type (enum SAP_PACKET_TYPE SAP_packet_type,SAP_LIST_ENTRY *sptr_SAP_list_entry)
{
	if (sptr_SAP_list_entry == NULL)
		{
		return (NULL);
		}

	for (; sptr_SAP_list_entry != NULL;	sptr_SAP_list_entry = sptr_SAP_list_entry->links.sptr_forward_link)
		{
		if (sptr_SAP_list_entry->SAP_ID.SAP_type == SAP_packet_type)
			{
			break;
			}
		}

	return (sptr_SAP_list_entry);
}
/****************************************************************************/
SAP_LIST_ENTRY *get_SAP_list_entry_using_network (ULONG network,SAP_LIST_ENTRY *sptr_SAP_list_entry)
{
	if (sptr_SAP_list_entry == NULL)
		{
		return (NULL);
		}

	for (; sptr_SAP_list_entry != NULL;	sptr_SAP_list_entry = sptr_SAP_list_entry->links.sptr_forward_link)
		{
		if (sptr_SAP_list_entry->SAP_ID.ipx_address.network == network)
			{
			break;
			}
		}

	return (sptr_SAP_list_entry);
}
/****************************************************************************/
SAP_LIST_ENTRY *get_SAP_list_entry_using_name (char const *cptr_SAP_name,SAP_LIST_ENTRY *sptr_SAP_list_entry)
{
	if (sptr_SAP_list_entry == NULL)
		{
		return (NULL);
		}

	for (; sptr_SAP_list_entry != NULL;	sptr_SAP_list_entry = sptr_SAP_list_entry->links.sptr_forward_link)
		{
		if (strcmp (sptr_SAP_list_entry->SAP_ID.SAP_name,cptr_SAP_name) == STRINGS_MATCH)
			{
			break;
			}
		}

	return (sptr_SAP_list_entry);
}
/****************************************************************************/
SAP_LIST_ENTRY *get_SAP_list_entry_using_router_address (ETHERNET_ADDRESS *sptr_router_address,
	SAP_LIST_ENTRY *sptr_SAP_list_entry)
{
	if (sptr_SAP_list_entry == NULL)
		{
		return (NULL);
		}

	for (; sptr_SAP_list_entry != NULL;	sptr_SAP_list_entry = sptr_SAP_list_entry->links.sptr_forward_link)
		{
		if (sptr_SAP_list_entry->router_address._ulong == sptr_router_address->_ulong && 
			sptr_SAP_list_entry->router_address._ushort == sptr_router_address->_ushort)
			{
			break;
			}
		}

	return (sptr_SAP_list_entry);
}
/****************************************************************************/
SAP_LIST_ENTRY *get_SAP_list_entry_using_port_number (USHORT port_number,SAP_LIST_ENTRY *sptr_SAP_list_entry)
{
	if (sptr_SAP_list_entry == NULL)
		{
		return (NULL);
		}

	for (; sptr_SAP_list_entry != NULL;	sptr_SAP_list_entry = sptr_SAP_list_entry->links.sptr_forward_link)
		{
		if (sptr_SAP_list_entry->port_number == port_number)
			{
			break;
			}
		}

	return (sptr_SAP_list_entry);
}
/****************************************************************************/
void shut_ipx_SAP_port_down (USHORT port_number)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_list_entry;
	SAP_LIST_ENTRY *sptr_secondary_SAP_list_entry;

	sptr_primary_SAP_list_entry = ipx_class.SAP_list.sptr_forward_link;

	while (TRUE)
		{
		sptr_primary_SAP_list_entry = get_SAP_list_entry_using_port_number (port_number,sptr_primary_SAP_list_entry);

		if (sptr_primary_SAP_list_entry == NULL)
			{
			break;
			}

		for (sptr_secondary_SAP_list_entry = sptr_primary_SAP_list_entry->SAP_links.sptr_forward_link;
			sptr_secondary_SAP_list_entry != NULL;
			sptr_secondary_SAP_list_entry = sptr_secondary_SAP_list_entry->links.sptr_forward_link)
			{
			sptr_secondary_SAP_list_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			}

		sptr_primary_SAP_list_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
		sptr_primary_SAP_list_entry->new_primary_SAP = TRUE;

		sptr_primary_SAP_list_entry = sptr_primary_SAP_list_entry->links.sptr_forward_link;
		}

	update_SAPs_for_all_ports ();

	check_for_down_SAPs ();
}
/****************************************************************************/
static enum BOOLEAN SAP_ids_are_equal (SAP_ID *sptr_SAP_id_1,SAP_ID *sptr_SAP_id_2)
{
	if (sptr_SAP_id_1->SAP_type != sptr_SAP_id_2->SAP_type)
		{
		return (FALSE);
		}

	if (strcmp (sptr_SAP_id_1->SAP_name,sptr_SAP_id_2->SAP_name) == STRINGS_MATCH)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
