#include	"defs.h"
/*	$Modname: ipxserlz.c$  $version: 1.6$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 05/01/93 ross
1.1 05/13/93 ross added stack parameter for tunnel software
1.2 05/13/93 ross added counter
1.3 11/09/93 ross Fixed swap function in ipxrip.c ipxsap.c
1.4 02/02/94 ross move enable_serialization_spoofing out of if statement.
1.5 07/14/94 ross Serialization fix.  Courtesy of Fred.
1.6 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	"ipx.h"
/****************************************************************************/
enum IPX_PACKET_STATE serialization_packet_received (USHORT port_number,SERIALIZATION_PACKET *sptr_serialization_rx_packet,
	USHORT size_of_packet)
{
	enum IPX_PACKET_STATE return_code;

	if (ipx_class.port[port_number].enable_serialization_spoofing == FALSE)
		{
		return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_serialization_rx_packet,size_of_packet,FALSE);

		return (return_code);
		}

	++ipx_class.port[port_number].statistics.number_of_serialization_packets_received;

	if (swap (sptr_serialization_rx_packet->ipx_header.length) != sizeof (IPX_SERIALIZATION_PACKET))
		{
		return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_serialization_rx_packet,size_of_packet,FALSE);
		}
	else
		{
		return_code = DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED;
		}

	return (return_code);
}
