#include	"defs.h"
/*	$Modname: ipxtimer.c$  $version: 3.19$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 01/21/93 ross when a primary route or SAP entry is aged out, then we immediately broadcast this fact.
3.0 01/21/93 ross
3.1 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.2 03/15/93 ross x86 version now works in real mode -just enough memory
3.3 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.4 03/30/93 ross added netbios name caching.
3.5 04/12/93 ross made variable name change in vipxstr.h
3.6 05/13/93 ross added stack parameter for tunnel software
3.7 05/14/93 ross changed timer routine to put rips ahead of saps.  courtesy of ken.
3.8 05/24/93 ross fixed some problems will loops going down.
3.9 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
3.10 03/14/94 ross cleaned up braces and white spaces for release.
3.11 05/09/94 ross modified wan class for ipxwan and non-ipxwan configurations
3.12 08/08/94 ross finishing end station support.
3.13 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.14 11/23/94 ross Added remote access. Added auto-configuration.
3.15 01/26/95 ross changes for spx spoofing.
3.16 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.17 10/20/95 nishit Another fix for NLSP RIP compatibility
3.18 10/20/95 nishit Changed copyright
3.19 10/20/95 nishit Cleanup debug printfs; ready for release
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	"ipx.h"
/****************************************************************************/
static void check_age_of_SAP_entries (void);
static void check_age_of_router_entries (void);
static void check_for_gap_time_SAP_or_RIP_packets_to_send (void);
static void ipx_periodic_tx_completion (USHORT port_number,IPX_PACKET *sptr_tx_packet);
static void upper_layer_timer (void);
/****************************************************************************/
void IPX_router_timer (void)
{
	USHORT port_number;

	if (ipx_class.timer_enabled == FALSE)
		{
		return;
		}

	if (++ipx_class._1_second_counter >= ipx_class.clock_ticks_per_second)
		{
		for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
			{
			/* THIS MODIFICATION FOR DETECTION OF SERVERS */
				if (ipx_class.port[port_number].number_of_RIP_clock_ticks >= 1000){

				if (ipx_class.port[port_number].enable_periodic_RIP_broadcasts == FALSE)
					{
						ipx_class.port[port_number].enable_periodic_RIP_broadcasts =  TRUE;
						send_periodic_route_information (port_number);
						ipx_class.port[port_number].enable_periodic_RIP_broadcasts = FALSE;
					}else send_periodic_route_information (port_number);

					issue_router_info_request (port_number); 

				if (ipx_class.port[port_number].enable_periodic_SAP_broadcasts == FALSE)
					{
						ipx_class.port[port_number].enable_periodic_SAP_broadcasts = TRUE;
						send_SAP_periodic_broadcast (port_number);
						ipx_class.port[port_number].enable_periodic_SAP_broadcasts = FALSE;
					}else send_SAP_periodic_broadcast (port_number);

					send_SAP_query (GENERAL_SERVICE_QUERY,port_number); 
					ipx_class.port[port_number].number_of_RIP_clock_ticks = 0x0000;
					ipx_class.port[port_number].number_of_SAP_clock_ticks = 0x0000;
				}
			if ((ipx_class.port[port_number].periodic_RIP_tx_timer != NO_PERIODIC_BROADCASTS)
				&& (++ipx_class.port[port_number].number_of_RIP_clock_ticks >=
				ipx_class.port[port_number].periodic_RIP_tx_timer))
				{
				ipx_class.port[port_number].number_of_RIP_clock_ticks = 0x0000;

				send_periodic_route_information (port_number);
				}

			if ((ipx_class.port[port_number].periodic_SAP_tx_timer != NO_PERIODIC_BROADCASTS)
				&& (++ipx_class.port[port_number].number_of_SAP_clock_ticks >=
				ipx_class.port[port_number].periodic_SAP_tx_timer))
				{
				ipx_class.port[port_number].number_of_SAP_clock_ticks = 0x0000;

				send_SAP_periodic_broadcast (port_number);
				}

			if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
				(ipx_class.port[port_number].network_address_learned == FALSE) &&
				(ipx_class.port[port_number].port_enabled == TRUE))
				{
					learn_ipx_network_address (port_number);
				}

			if (ipx_class.port[port_number].netbios_name_caching_enabled == TRUE)
				{
				check_age_of_netbios_names (port_number);
				}

			if ((ipx_class.port[port_number].rip_compatibility == RIP_AUTO) &&
				(ipx_class.port[port_number].auto_rip_compatibility_activated == TRUE))
				{
				if ((ipx_class.port[port_number].rip_auto_deactivation_timer + ipx_class.port[port_number].RIP_age_timer) < router_timer)
					{
					ipx_class.port[port_number].auto_rip_compatibility_activated = FALSE;
					}
				}
				

			if (ipx_class.port[port_number].enable_spx_watchdog_spoofing == TRUE)
				{
				spx_connection_timer (port_number);
				}

/*			issue_periodic_client_watchdog (port_number); CURRENTLY TESTING */

#ifdef IPX_WAN_ENABLED
			if (ipx_class.port[port_number].wan.enable_ipx_wan_packets == TRUE)
				{
				check_wan_connection_to_routers (port_number);
				}
#endif
			}

		check_age_of_SAP_entries ();
		check_age_of_router_entries ();
		check_for_down_SAPs ();
		check_for_down_routers ();

		ipx_class._1_second_counter = 0x00000000L;
		}

	ipx_class.gap_timer_counter = (BYTE) (ipx_class.gap_timer_counter + 1);

	if (ipx_class.gap_timer_counter >= ipx_class.gap_time_limit)
		{
		ipx_class.gap_timer_counter = 0x00;

		check_for_gap_time_SAP_or_RIP_packets_to_send ();
		}

	upper_layer_timer ();
}
/****************************************************************************/
static void check_age_of_SAP_entries (void)
{
	SAP_LIST_ENTRY	*sptr_primary_SAP_entry;
	SAP_LIST_ENTRY 	*sptr_secondary_SAP_entry;
	USHORT	number_of_SAP_entries_aged_out;

	for (number_of_SAP_entries_aged_out = 0x0000,sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link;
		sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
		{
		if ((sptr_primary_SAP_entry->do_not_age == FALSE) && 
			((sptr_primary_SAP_entry->timer_value + ipx_class.port[sptr_primary_SAP_entry->port_number].SAP_age_timer) < router_timer) &&
			(sptr_primary_SAP_entry->type != NLSP_SAP) &&
			ipx_class.port[sptr_primary_SAP_entry->port_number].SAP_age_timer != DO_NOT_AGE)
			{
			sptr_primary_SAP_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			sptr_primary_SAP_entry->new_primary_SAP = TRUE;

			++ipx_class.port[sptr_primary_SAP_entry->port_number].statistics.total_number_of_SAP_entries_aged_out;
			++number_of_SAP_entries_aged_out;
			}

		for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;
			sptr_secondary_SAP_entry != NULL;
			sptr_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link)
			{
			if ((sptr_secondary_SAP_entry->do_not_age == FALSE) && 
				((sptr_secondary_SAP_entry->timer_value +
				ipx_class.port[sptr_secondary_SAP_entry->port_number].SAP_age_timer) < router_timer) &&
				(sptr_secondary_SAP_entry->type != NLSP_SAP) &&
				ipx_class.port[sptr_secondary_SAP_entry->port_number].SAP_age_timer != DO_NOT_AGE)
				{
				sptr_secondary_SAP_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;

				++ipx_class.port[sptr_primary_SAP_entry->port_number].statistics.total_number_of_SAP_entries_aged_out;
				}
			}
		}

	if (number_of_SAP_entries_aged_out > 0x0000)
		{
		update_SAPs_for_all_ports ();
		}
}
/****************************************************************************/
static void check_age_of_router_entries (void)
{
	ROUTE_LIST_ENTRY	*sptr_primary_route_entry;
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;
	USHORT number_of_route_entries_aged_out;

	for (number_of_route_entries_aged_out = 0x0000,
		sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link; sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if ((sptr_primary_route_entry->do_not_age == FALSE) && 
			((sptr_primary_route_entry->timer_value +
			ipx_class.port[sptr_primary_route_entry->port_number].RIP_age_timer) < router_timer) &&
			(sptr_primary_route_entry->type != NLSP_IPX_ROUTE) &&
			ipx_class.port[sptr_primary_route_entry->port_number].RIP_age_timer != DO_NOT_AGE)
			{
			sptr_primary_route_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			sptr_primary_route_entry->new_primary_route = TRUE;

			if (ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps != NULL)
				{
				(*ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps) (sptr_primary_route_entry->port_number);
				}
			
			++ipx_class.port[sptr_primary_route_entry->port_number].statistics.total_number_of_route_entries_aged_out;
			++number_of_route_entries_aged_out;
			}

		for (sptr_secondary_route_entry =  sptr_primary_route_entry->network_links.sptr_forward_link;
			sptr_secondary_route_entry != NULL;
			sptr_secondary_route_entry =  sptr_secondary_route_entry->links.sptr_forward_link)
			{
			if ((sptr_secondary_route_entry->do_not_age == FALSE) && 
				((sptr_secondary_route_entry->timer_value +
				ipx_class.port[sptr_secondary_route_entry->port_number].RIP_age_timer) < router_timer) &&
				(sptr_secondary_route_entry->type != NLSP_IPX_ROUTE) &&
				ipx_class.port[sptr_secondary_route_entry->port_number].RIP_age_timer != DO_NOT_AGE)
				{
				sptr_secondary_route_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;

				++ipx_class.port[sptr_secondary_route_entry->port_number].statistics.total_number_of_route_entries_aged_out;
				}
			}
		}

	if (number_of_route_entries_aged_out > 0x0000)
		{
		update_routes_for_all_ports ();
		}
}
/****************************************************************************/
static void check_for_gap_time_SAP_or_RIP_packets_to_send (void)
{
	GAP_TIME_SAP_RESPONSE_PACKET *sptr_SAP_periodic_broadcast;
	GAP_TIME_SAP_RESPONSE_PACKET *sptr_SAP_response_packet;
	USHORT port_number;
	GAP_TIME_ROUTE_INFORMATION *sptr_route_information;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		if (ipx_class.port[port_number].rip_compatibility == RIP_OFF)
			{
			continue;
			}

		if ((ipx_class.port[port_number].rip_compatibility == RIP_AUTO) &&
			(ipx_class.port[port_number].auto_rip_compatibility_activated == FALSE))
			{
			continue;
			}

		if (ipx_class.port[port_number].periodic_RIP_list.sptr_forward_link != NULL)
			{
			++ipx_class.port[port_number].statistics.number_of_periodic_router_broadcasts;

#ifdef TIMER_DEBUG
			ipx_printf (RIP_PRINTF,"Periodic RIP Information %08lx: ",ipx_class.port[port_number].network);
#endif

			sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *)
				get_entry_from_list (&ipx_class.port[port_number].periodic_RIP_list);

/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
			send_ipx_packet (port_number,(IPX_PACKET *) &sptr_route_information->ethernet_header,(USHORT) (sizeof (ETHERNET_HEADER) +
				swap (sptr_route_information->ipx_header.length)),FALSE,ipx_periodic_tx_completion);
			}

		if (ipx_class.port[port_number].response_RIP_list.sptr_forward_link != NULL)
			{
			++ipx_class.port[port_number].statistics.RIP_tx.number_of_general_responses;

#ifdef TIMER_DEBUG
			ipx_printf (RIP_PRINTF,"Response RIP Information %08lx: ",ipx_class.port[port_number].network);
#endif

			sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *)
				get_entry_from_list (&ipx_class.port[port_number].response_RIP_list);

/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
			send_ipx_packet (port_number,(IPX_PACKET *) &sptr_route_information->ethernet_header,
				(USHORT) (sizeof (ETHERNET_HEADER) + swap (sptr_route_information->ipx_header.length)),FALSE,
				ipx_periodic_tx_completion);
			}

		if (ipx_class.port[port_number].periodic_SAP_list.sptr_forward_link != NULL)
			{
#ifdef TIMER_DEBUG
			ipx_printf (SAP_PRINTF,"Periodic SAP Broadcast Information %08lx: ",ipx_class.port[port_number].network);
#endif

			++ipx_class.port[port_number].statistics.number_of_SAP_periodic_broadcasts;

			sptr_SAP_periodic_broadcast = (GAP_TIME_SAP_RESPONSE_PACKET *)
				get_entry_from_list (&ipx_class.port[port_number].periodic_SAP_list);

/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
			send_ipx_packet (port_number,(IPX_PACKET *) &sptr_SAP_periodic_broadcast->ethernet_header,
				(USHORT) (sizeof (UNION_MAC_HEADER) +
				swap (sptr_SAP_periodic_broadcast->ipx_header.length)),FALSE,ipx_periodic_tx_completion);
			}

		if (ipx_class.port[port_number].response_SAP_list.sptr_forward_link != NULL)
			{
#ifdef TIMER_DEBUG
			ipx_printf (SAP_PRINTF,"Response SAP Information %08lx: ",ipx_class.port[port_number].network);
#endif

			++ipx_class.port[port_number].statistics.SAP_tx.number_of_general_responses;

			sptr_SAP_response_packet =	(GAP_TIME_SAP_RESPONSE_PACKET *)
				get_entry_from_list (&ipx_class.port[port_number].response_SAP_list);

/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
			send_ipx_packet (port_number,(IPX_PACKET *) &sptr_SAP_response_packet->ethernet_header,
				(USHORT) (sizeof (UNION_MAC_HEADER) +
				swap (sptr_SAP_response_packet->ipx_header.length)),FALSE,ipx_periodic_tx_completion);
			}
		}
}
/****************************************************************************/
static void ipx_periodic_tx_completion (USHORT port_number,IPX_PACKET *sptr_tx_packet)
{
	++ipx_class.port[port_number].statistics.number_of_send_completions;

	sptr_tx_packet = (IPX_PACKET *) ((ULONG) sptr_tx_packet - (ULONG) sizeof (LINK));

	free_a_send_packet (sptr_tx_packet);
}
/****************************************************************************/
static void upper_layer_timer (void)
{
	if (ipx_class.transport.fptr_timer_routine != NULL)
		{
		(*ipx_class.transport.fptr_timer_routine) ();
		}

	if (ipx_class.ncp.fptr_timer_routine != NULL)
		{
		(*ipx_class.ncp.fptr_timer_routine) ();
		}

	if (ipx_class.end_station.fptr_timer_routine != NULL)
		{
		(*ipx_class.end_station.fptr_timer_routine) ();
		}
}
