/*	$Modname: vipxstr.h$  $version: 3.57$      $date: 11/03/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross added new send_packet prototype to let driver release buffer
2.5 01/26/92 ross
2.6 02/28/92 ross added 2 new functions in ipx.c and ipxsap.c to detect down secondary routes, they were lines of code in send_periodics but moved them out for readability.
2.7 04/10/92 ross change you to your in pragma comment.
2.8 08/05/92 ross
2.9 10/20/92 ross
2.10 11/02/92 ross made ipx_printf take 1 parameter
2.11 11/02/92 ross made most lines 132 columns now.
2.12 11/03/92 ross the amazing malloc bug catching version!
2.13 11/03/92 ross backed out bug catching version.
2.14 11/24/92 ross added token_ring_enabled parameter and modified send_ipx_packet
2.15 11/24/92 ross deleted token_ring_enabled parameter and unmodified send_ipx_packet.
2.16 11/24/92 ross
2.17 11/24/92 ross
2.18 12/05/92 ross general clean-up moved some globals in #ifdefs
2.19 12/05/92 ross changed structure comment delineators.
2.20 12/06/92 ross implemented ipx class structure - no algorithm changes
2.21 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
2.22 12/22/92 ross added new filtering counters
2.23 12/26/92 ross changed BYTE packet_type to enums since all compilers now work with enums.
2.24 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.25 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
2.26 01/17/93 ross fixed SNAP addition bug.
2.27 01/21/93 ross added prototypes for ipxtimer.c
2.28 01/21/93 ross got rid of packet type in send periodic SAP function.
2.29 01/21/93 ross added a line feed.
2.30 01/21/93 ross added filler for SAP and RIP entries.
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 01/22/93 ross renamed ipxmstub ipxutil
3.2 01/22/93 ross moved prototypes for name change.
3.3 01/23/93 ross changed proto for store_dlci.
3.4 01/30/93 ross delete references to ipx dlci
3.5 01/31/93 ross added support for netware lite routing
3.6 01/31/93 ross added netware_lite_enabled to ipx_class
3.7 02/08/93 ross added ifdef wrapper for BIG_ENDIAN around swap.  courtesy of YR.
3.8 02/13/93 ross delete EVENT_CONTROL_BLOCK stuff from header, not used.
3.9 02/20/93 ross added unknown netbios counter.
3.10 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.11 03/15/93 ross x86 version now works in real mode -just enough memory
3.12 03/22/93 ross moved STATISTICS into port class
3.13 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.14 03/30/93 ross added netbios name caching.
3.15 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.16 04/10/93 ross took out _ipx from some of the statistics fields since this info was redundant.
3.17 04/13/93 ross added stats etc. for Novell's ipx mib v0.9
3.18 05/13/93 ross added stack parameter for tunnel software
3.19 05/15/93 ross added more printf booleans.
3.20 05/15/93 ross changed BYTE to char in SAP_ID for consistency.
3.21 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.22 05/24/93 ross fixed some problems will loops going down.
3.23 06/23/93 ross fixed a secondary SAP function
3.24 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
3.25 07/28/93 ross added statistic path not found.
3.26 07/28/93 ross added maximum packet sizes.
3.27 10/09/93 ross added 2 new counters for the send packet routine in ipxutil.c
3.28 10/09/93 ross moved wan counter to ipxwan where it belongs.
3.29 10/09/93 ross Added changes for ipxwan
3.30 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.31 11/29/93 ross adding snmp statistics.
3.32 12/09/93 ross added more snmp stats.
3.33 12/09/93 ross added rip/sap mib support.
3.34 12/10/93 ross big endian prototype problem. Courtesy of Rick.
3.35 01/08/94 ross More lsl version 3 changes
3.36 02/02/94 ross deleted white space in stucture.
3.37 02/07/94 ross removed NLSP conditional compile.  Not needed for NLSP.
3.38 03/09/94 ross removing the wan_port dependency on rip and sap aging.
3.39 03/11/94 ross removed packed pragma, look in kstart.h
3.40 03/14/94 ross cleaned up braces and white spaces for release.
3.41 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.42 05/09/94 ross modified wan class for ipxwan and non-ipxwan configurations
3.43 05/20/94 ross added functions pointers for rip and sap add functions.
3.44 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.45 08/08/94 ross finishing end station support.
3.46 08/25/94 ross added support for BYTE_ENUM and USHORT_ENUM
3.47 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.48 11/23/94 ross Added remote access. Added auto-configuration.
3.49 01/26/95 ross spx spoofing and nlsp changes.
3.50 03/26/95 ross nlsp changes.
3.51 04/06/95 ross more nlsp changes.
3.52 04/17/95 ross remove send_packet prototype.  It's already in lslproto.h
3.53 06/27/95 ross mib and nlsp changes
3.54 09/25/95 ross added changes for dynamic loading
3.55 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.56 10/20/95 nishit Changed copyright
3.57 11/03/95 nishit Replaced reference to RIP_COMPATIBILITY by NLSP_RIP_COMPATIBILITY
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
/*******************IPX,SAP and NetBIOS Structures **********************/
/**********************Header Prototypes*********************************/
/************************************************************************/
#ifndef _VIPXSTR_H_
#define _VIPXSTR_H_

#ifndef ETHERNET_HEADER_FILE
#define ETHERNET_HEADER_FILE

	typedef	struct	IPX_CRC
	{
		BYTE	crc[4];
	} IPX_CRC;

	typedef	struct	ETHERNET_ADDRESS_USHORT
	{
		USHORT	node[3];
	} ETHERNET_ADDRESS_USHORT;

	typedef	struct	ETHERNET_ADDRESS
	{
		ULONG	_ulong;
		USHORT	_ushort;
	} ETHERNET_ADDRESS;

	typedef	struct	ETHERNET_HEADER
	{
		ETHERNET_ADDRESS	destination_address;
		ETHERNET_ADDRESS	source_address;
		USHORT				length;
	}ETHERNET_HEADER;

	typedef	struct	ETHERNET_BUFFER
	{
		ETHERNET_HEADER	mac_header;
		BYTE					data[1518 - sizeof (ETHERNET_HEADER)];
	} ETHERNET_BUFFER;

#endif
/****************************************************************************/

#ifndef IPX_HEADER_FILE

#define IPX_HEADER_FILE

	typedef struct IPX_ADDRESS
	{
		ULONG							network;	
		ETHERNET_ADDRESS			node_address;	
		USHORT						socket; 	
	} IPX_ADDRESS;	


	typedef struct IPX_HEADER
	{
		USHORT								checksum;			/* Big Endian */
		USHORT								length; 				/* Big Endian */
		BYTE									transport_control_hop_count;
		BYTE_ENUM (IPX_PACKET_TYPES)	packet_type;		/* see kipx.h */
		IPX_ADDRESS							destination;		
		IPX_ADDRESS							source;
	} IPX_HEADER;
#endif

/****************************************************************************/

typedef	struct	NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS
{
	BYTE_ENUM (NLSP_RIP_COMPATIBILITY) 			rip_compatibility[NUMBER_OF_IPX_PORTS];
	BYTE_ENUM (NLSP_SAP_COMPATIBILITY) 			sap_compatibility[NUMBER_OF_IPX_PORTS];
} NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS;

typedef struct NETWARE_CORE_PROTOCOL_PACKET
{
	ETHERNET_HEADER						ethernet_header;
	IPX_HEADER								ipx_header;
	USHORT_ENUM (NCP_REQUEST_TYPE)	request_type;
	BYTE										sequence_number;
	BYTE										connection_number;
	USHORT									task_number;
	BYTE										connection_number_high;
	BYTE										reserved;
	USHORT									function_code;
	BYTE										data[1];						
} NETWARE_CORE_PROTOCOL_PACKET;

/****************************************************************************/

#ifndef LINK_TYPEDEF_DEFINED

	#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

/****************************************************************************/

typedef struct	SAP_ID
{
	USHORT_ENUM (SAP_PACKET_TYPE)		SAP_type;				/* Big Endian*/
	char										SAP_name[48];
	IPX_ADDRESS								ipx_address;
	USHORT									intervening_networks; /* Big Endian*/
} SAP_ID;

/* this version below will supercede above definition in future releases */

typedef	struct	SAP_SNMP_ID
{
	USHORT_ENUM (SAP_PACKET_TYPE)		ipxServType;				/* Big Endian*/
	char										ipxServName[48];
	IPX_ADDRESS								ipx_address;
	ULONG										ipxServHopCount; 			/* Big Endian*/
} SAP_SNMP_ID;

typedef	struct	SAP_SNMP_DEST_ID
{
	char										ipxDestServName[48];
	USHORT_ENUM (SAP_PACKET_TYPE)		ipxDestServType;			/* Big Endian*/
	IPX_ADDRESS								ipx_address;
	ULONG										ipxDestServHopCount; 	/* Big Endian*/
} SAP_SNMP_DEST_ID;

typedef	struct	SAP_SNMP_STATIC_ID
{
	char										ipxStaticServName[48];
	USHORT_ENUM (SAP_PACKET_TYPE)		ipxStaticServType;		/* Big Endian*/
	IPX_ADDRESS								ipx_address;
	ULONG										ipxStaticServHopCount; 	/* Big Endian*/
} SAP_SNMP_STATIC_ID;

/****************************************************************************/

typedef	struct	SAP_LINK
{
	struct	SAP_LIST_ENTRY	*sptr_forward_link;
	struct	SAP_LIST_ENTRY	*sptr_backward_link;
} SAP_LINK;

typedef	union	UNION_SNMP_SAP_ID
{
	SAP_SNMP_ID			 		 	snmp_SAP_ID;
	SAP_SNMP_DEST_ID		 		snmp_SAP_dest_ID;
	SAP_SNMP_STATIC_ID		 	snmp_SAP_static_ID;
} UNION_SNMP_SAP_ID;

typedef struct	SAP_LIST_ENTRY
{
	SAP_LINK										links;
	SAP_LINK										SAP_links;
	ULONG											ipx_instance;
	SAP_ID										SAP_ID;
	USHORT										port_number;
	ULONG											timer_value;
	ETHERNET_ADDRESS							router_address;
	BYTE_ENUM (BOOLEAN)						do_not_age;		 /* ipxStaticServExistState */
	BYTE_ENUM (BOOLEAN)						new_primary_SAP;
	USHORT_ENUM (IPX_FRAME_TYPE)			frame_type;
	BYTE_ENUM (IPX_SAP_PROTOCOL_TYPE)	type;				 /* ipxServProtocol */
	void 											*vptr_lsp;


	ULONG											ipxServSysInstance;
	ULONG_ENUM (IPX_SAP_PROTOCOL_TYPE)	ipxServProtocol;

	ULONG											ipxDestServSysInstance;
	ULONG_ENUM (IPX_SAP_PROTOCOL_TYPE)	ipxDestServProtocol;

	ULONG											ipxStaticServSysInstance;
	ULONG											ipxStaticServCircIndex;
	ULONG_ENUM (BOOLEAN)						ipxStaticServExistState;

	UNION_SNMP_SAP_ID							snmp_sap_id;
} SAP_LIST_ENTRY;

/****************************************************************************/

typedef struct SAP_QUERY_PACKET
{
	USHORT_ENUM (QUERY_TYPE)		query_type;		/* Big Endian, General = 1 or Nearest = 3 */
	USHORT_ENUM (SAP_PACKET_TYPE)	SAP_type;		/* Big Endian, see kipx.h */
} SAP_QUERY_PACKET;

/****************************************************************************/

typedef struct	SAP_ID_PACKET
{
	USHORT_ENUM (RESPONSE_TYPE)	type;	/* Big Endian, General = 2 or Nearest = 4*/
	SAP_ID								SAP_ID[MAXIMUM_NUMBER_OF_SAP_IDS_PER_PACKET];
} SAP_ID_PACKET;

/****************************************************************************/

typedef struct	SAP_SEND_QUERY_PACKET
{
	ETHERNET_HEADER			ethernet_header;
	IPX_HEADER					ipx_header;
	SAP_QUERY_PACKET			service_query_packet;
} SAP_SEND_QUERY_PACKET;

/****************************************************************************/

typedef struct	SAP_NEAREST_RESPONSE_PACKET
{
	ETHERNET_HEADER					ethernet_header;
	IPX_HEADER							ipx_header;
	USHORT_ENUM (RESPONSE_TYPE)	type;	/* Big Endian*/
	SAP_ID								SAP_ID;
} SAP_NEAREST_RESPONSE_PACKET;

/****************************************************************************/

typedef struct	SAP_RESPONSE_PACKET
{
	ETHERNET_HEADER					ethernet_header;
	IPX_HEADER							ipx_header;
	USHORT_ENUM (RESPONSE_TYPE)  	type;	/* Big Endian*/
	SAP_ID								SAP_ID[MAXIMUM_NUMBER_OF_SAP_IDS_PER_PACKET];
} SAP_RESPONSE_PACKET;

typedef struct	GAP_TIME_SAP_RESPONSE_PACKET
{
	LINK									links;
	ETHERNET_HEADER					ethernet_header;
	IPX_HEADER							ipx_header;
	USHORT_ENUM (RESPONSE_TYPE)	type;	/* Big Endian*/
	SAP_ID								SAP_ID[MAXIMUM_NUMBER_OF_SAP_IDS_PER_PACKET];
} GAP_TIME_SAP_RESPONSE_PACKET;

/****************************************************************************/

typedef union	SAP_QUERY_OR_ID
{
	SAP_ID_PACKET		ID_packet;
	SAP_QUERY_PACKET	query_packet;
} SAP_QUERY_OR_ID;

/****************************************************************************/

typedef struct	SAP_RECEIVE_PACKET
{
	ETHERNET_HEADER		ethernet_header;
	IPX_HEADER				ipx_header;
	SAP_QUERY_OR_ID		rx_SAP;
} SAP_RECEIVE_PACKET;

/****************************************************************************/

typedef struct	LOCAL_TARGET_BUFFER
{
	ETHERNET_HEADER		ethernet_header;
	IPX_HEADER				ipx_header;
	BYTE						data[1518 - sizeof(IPX_HEADER) - sizeof (ETHERNET_HEADER)];
} LOCAL_TARGET_BUFFER;
/****************************************************************************/

typedef struct	ROUTE_ENTRY
{
	/* to be replaced eventually */
	ULONG		network; /* by ipxDestNetNum, ipxStaticRouteNetNum */
	USHORT	hops; /* by ipxDestHopCount, ipxStaticRouteHopCount */
	USHORT	transport_time; /* by ipxDestTicks, ipxStaticRouteTicks */
} ROUTE_ENTRY;

typedef	struct	SNMP_ROUTE_ENTRY
{
	ULONG 	ipxDestNetNum;
	ULONG 	ipxDestTicks;
	ULONG 	ipxDestHopCount;
} SNMP_ROUTE_ENTRY;

typedef	struct	STATIC_SNMP_ROUTE_ENTRY
{
	ULONG 	ipxStaticRouteNetNum;
	ULONG 	ipxStaticRouteTicks;
	ULONG 	ipxStaticRouteHopCount;
} STATIC_SNMP_ROUTE_ENTRY;

typedef	union	UNION_ROUTE_ENTRY
{
	SNMP_ROUTE_ENTRY 						route_entry;
	STATIC_SNMP_ROUTE_ENTRY			 	static_route_entry;
} UNION_ROUTE_ENTRY;
/****************************************************************************/
typedef struct		ROUTE_INFORMATION
{
	ETHERNET_HEADER						ethernet_header;
	IPX_HEADER								ipx_header;
	USHORT_ENUM (ROUTE_PACKET_TYPE)	operation;		/* 2 = information */
	ROUTE_ENTRY								route_entry_list[MAXIMUM_NUMBER_OF_ROUTE_ENTRIES_PER_PACKET];
} ROUTE_INFORMATION;

typedef struct		GAP_TIME_ROUTE_INFORMATION
{
	LINK										links;
	ETHERNET_HEADER						ethernet_header;
	IPX_HEADER								ipx_header;
	USHORT_ENUM (ROUTE_PACKET_TYPE)	operation;		/* 2 = information */
	ROUTE_ENTRY								route_entry_list[MAXIMUM_NUMBER_OF_ROUTE_ENTRIES_PER_PACKET];
} GAP_TIME_ROUTE_INFORMATION;

/****************************************************************************/

typedef	struct	ROUTE_REQUEST
{
	ETHERNET_HEADER						ethernet_header;
	IPX_HEADER								ipx_header;
	USHORT_ENUM (ROUTE_PACKET_TYPE)	operation;		/* 1 = request */
	ROUTE_ENTRY			request;
}ROUTE_REQUEST;
/****************************************************************************/

typedef	struct	ROUTE_LINK
{
	struct	ROUTE_LIST_ENTRY	*sptr_forward_link;
	struct	ROUTE_LIST_ENTRY	*sptr_backward_link;
} ROUTE_LINK;

typedef	struct	ROUTE_LIST_ENTRY
{
	ROUTE_LINK										links;
	ROUTE_LINK										network_links;

	ULONG												ipx_instance;
	ROUTE_ENTRY										route_entry;
	ETHERNET_ADDRESS								router_address;		/* by ipxDestNextHopNICAddress */
	USHORT											port_number;
	ULONG												next_hop_network_number;
	ULONG												timer_value;

	BYTE_ENUM (BOOLEAN)	 						do_not_age;
	BYTE_ENUM (BOOLEAN)	 						new_primary_route;
	USHORT_ENUM (IPX_FRAME_TYPE)				frame_type;
	BYTE_ENUM (IPX_ROUTING_PROTOCOL_TYPE)	type;						/* by ipxDestProtocol */
	void 												*vptr_lsp;

	ULONG												ipxDestSysInstance;
	ULONG_ENUM (IPX_ROUTING_PROTOCOL_TYPE)	ipxDestProtocol;
	ULONG												ipxDestNextHopCircIndex;
	ETHERNET_ADDRESS								ipxDestNextHopNICAddress;

	ULONG												ipxStaticRouteSysInstance;
	ULONG												ipxStaticRouteCircIndex;
	ULONG_ENUM (BOOLEAN)	 						ipxStaticRouteExistState;

	UNION_ROUTE_ENTRY								snmp_route_entry;
} ROUTE_LIST_ENTRY;

/****************************************************************************/

#ifdef MAC_HEADER_FILE
	typedef struct		IPX_8022_PACKET
	{
		UNION_MAC_HEADER	 	mac_header;
		LLC_HEADER				llc_header; 
		IPX_HEADER				ipx_header;
		BYTE						data[1];
	} IPX_8022_PACKET;

	typedef	struct	CONVERTED_IPX_8022_PACKET
	{
		LLC_HEADER							llc_header; 
		MAC_ADDRESS							destination;
		MAC_ADDRESS							source;
		USHORT_ENUM (IPX_FRAME_TYPE)	frame_type;
		IPX_HEADER							ipx_header;
		BYTE									data[1];
	} CONVERTED_IPX_8022_PACKET;

	typedef struct		IPX_8022_SNAP_PACKET
	{
		UNION_MAC_HEADER		mac_header;
		SNAP_HEADER				snap_header;	/* 0xaa,0xaa,0x03 */
		IPX_HEADER				ipx_header;
		BYTE						data[1];
	} IPX_8022_SNAP_PACKET;

	typedef	struct	CONVERTED_IPX_8022_SNAP_PACKET
	{
		SNAP_HEADER							snap_header;	/* 0xaa,0xaa,0x03 */
		MAC_ADDRESS							destination;
		MAC_ADDRESS							source;
		USHORT_ENUM (IPX_FRAME_TYPE)	frame_type;
		IPX_HEADER							ipx_header;
		BYTE									data[1];
	} CONVERTED_IPX_8022_SNAP_PACKET;
#endif
/****************************************************************************/
typedef	struct	WATCHDOG_PACKET
{
	ETHERNET_HEADER						ethernet_header;
	IPX_HEADER								ipx_header;
	BYTE										connection_number;
	BYTE_ENUM (WATCHDOG_SIGNATURE)	request_or_response;
} WATCHDOG_PACKET;

typedef	struct	IPX_WATCHDOG_PACKET
{
	IPX_HEADER								ipx_header;
	BYTE										connection_number;
	BYTE_ENUM (WATCHDOG_SIGNATURE)	request_or_response;
} IPX_WATCHDOG_PACKET;
/****************************************************************************/
#if !defined (__SPX_HEADER_FILE__)
	typedef	struct	SPX_CONNECTION_CONTROL
	{
	#ifndef BIG_ENDIAN
		unsigned	int	reserved:4;

		unsigned	int	end_of_message:1;
		unsigned	int	attention:1;
		unsigned	int	ack_required:1;
		unsigned	int	system_packet:1;
	#else
		unsigned	int	system_packet:1;
		unsigned	int	ack_required:1;
		unsigned	int	attention:1;
		unsigned	int	end_of_message:1;

		unsigned	int	reserved:4;
	#endif
	} SPX_CONNECTION_CONTROL;

	typedef	union	UNION_SPX_CONNECTION_CONTROL
	{
		SPX_CONNECTION_CONTROL	_bit;
		BYTE							_byte;
	} UNION_SPX_CONNECTION_CONTROL;

	typedef	struct	SPX_HEADER
	{
		UNION_SPX_CONNECTION_CONTROL		connection_control;
		BYTE_ENUM (SPX_DATASTREAM_TYPE)	datastream_type;

		/* all below are big endian */

		USHORT									source_connection_id;	
		USHORT									destination_connection_id;

		USHORT									sequence_number;	
		USHORT									ack_number;			
		USHORT									allocation_number;		
	} SPX_HEADER;

	typedef	struct	SPX_PACKET
	{
		ETHERNET_HEADER	ethernet_header;
		IPX_HEADER			ipx_header;
		SPX_HEADER			spx_header;
	} SPX_PACKET;

#endif
typedef	struct	SPX_CONNECTION_LINKS
{
	struct SPX_CONNECTION_ENTRY *sptr_forward_link;
	struct SPX_CONNECTION_ENTRY *sptr_backward_link;

} SPX_CONNECTION_LINKS;

typedef	struct	SPX_CONNECTION_CLASS
{
	USHORT 			port_number;
	USHORT 			connection_id;
	USHORT 			sequence_number;
	USHORT 			ack_number;
	USHORT 			allocation_number;

	BYTE				hop_count;

	ULONG				number_of_packets_rxed;

	IPX_ADDRESS		ipx_address;
} SPX_CONNECTION_CLASS;

typedef	struct	SPX_CONNECTION_ENTRY
{
	SPX_CONNECTION_LINKS	links;

	SPX_CONNECTION_CLASS	source;
	SPX_CONNECTION_CLASS	destination;

	ULONG						current_session_time;

} SPX_CONNECTION_ENTRY;
/****************************************************************************/
typedef	struct	SERIALIZATION_PACKET
{
	ETHERNET_HEADER	ethernet_header;
	IPX_HEADER			ipx_header;
	BYTE					serial_number[6];
} SERIALIZATION_PACKET;

typedef	struct	IPX_SERIALIZATION_PACKET
{
	IPX_HEADER	ipx_header;
	BYTE			serial_number[6];
} IPX_SERIALIZATION_PACKET;
/****************************************************************************/
typedef	struct	DIAGNOSTIC_REQUEST_PACKET
{
	ETHERNET_HEADER	ethernet_header;
	IPX_HEADER			ipx_header;
	BYTE					exclusion_address_count;
	ETHERNET_ADDRESS	address_to_exclude[1];
} DIAGNOSTIC_REQUEST_PACKET;

typedef	struct	IPX_DIAGNOSTIC_REQUEST_PACKET
{
	IPX_HEADER			ipx_header;
	BYTE					exclusion_address_count;
	ETHERNET_ADDRESS	address_to_exclude[1];
} IPX_DIAGNOSTIC_REQUEST_PACKET;

typedef	struct	EXTENDED_COMPONENT
{
	BYTE_ENUM (LOCAL_NETWORK_TYPE)	type;
	ULONG										network;
	ETHERNET_ADDRESS						node_address;						
} EXTENDED_COMPONENT;

typedef	struct	DIAGNOSTIC_RESPONSE_PACKET
{
	ETHERNET_HEADER							ethernet_header;
	IPX_HEADER									ipx_header;

	BYTE											major_version;
	BYTE											minor_version;
	USHORT										spx_socket;

	BYTE											component_count;
	BYTE_ENUM (EXTENDED_COMPONENT_TYPE)	extended_component_type[1]; /*	enum SIMPLE_COMPONENT_TYPE		simple_component[1]; */
	BYTE											number_of_networks;
	EXTENDED_COMPONENT						extended_component[1];

} DIAGNOSTIC_RESPONSE_PACKET;

typedef	struct	IPX_DIAGNOSTIC_RESPONSE_PACKET
{
	IPX_HEADER			ipx_header;
} IPX_DIAGNOSTIC_RESPONSE_PACKET;
/****************************************************************************/
typedef struct	ECHO_PACKET
{
	ETHERNET_HEADER				ethernet_header;
	IPX_HEADER						ipx_header;
	USHORT_ENUM (ECHO_TYPES)	type;
} ECHO_PACKET;
/****************************************************************************/

typedef	struct	NETWARE_NETWORK_ADDRESS
{
	ULONG	network_address;
} NETWARE_NETWORK_ADDRESS;

typedef struct	IPX_PACKET
{
	ETHERNET_HEADER		ethernet_header;
	IPX_HEADER				ipx_header;
	BYTE						data[1];
} IPX_PACKET;

/****************************************************************************/

typedef	struct	NETBIOS_NAME_ENTRY
{	
	LINK					links;

	char 					name[16];

	ULONG					timer_value;

	ETHERNET_ADDRESS	netbios_name_address;

	BYTE_ENUM (BOOLEAN)		do_not_age;
	BYTE_ENUM (BOOLEAN)		new_netbios_name;
	BYTE_ENUM (BOOLEAN)		challenge_issued;
	BYTE					filler;
} NETBIOS_NAME_ENTRY;

typedef	struct	NAME_TYPE_FLAG
{
	unsigned	int	name_deregistered:1;
	unsigned	int	name_duplicated:1;
	unsigned	int	registered_name:1;
	unsigned	int	reserved:3;
	unsigned	int	name_used:1;
	unsigned	int	group_name:1;
} NAME_TYPE_FLAG;

typedef	union	UNION_NAME_TYPE_FLAG
{
	NAME_TYPE_FLAG	_bit;
	BYTE	_byte;
} UNION_NAME_TYPE_FLAG;

typedef struct	NOVELL_NETBIOS_PACKET
{
	ETHERNET_HEADER					ethernet_header;
	IPX_HEADER							ipx_header;
	ULONG									netbios_network_number[MAXIMUM_NUMBER_OF_NETBIOS_LANS];
	UNION_NAME_TYPE_FLAG				name_type_flag;
	BYTE_ENUM (DATASTREAM_TYPE)	datastream_type;

	char 									name[16]; /* padded on the right with spaces null terminated */

	BYTE									data[1];
} NOVELL_NETBIOS_PACKET;

typedef struct	NOVELL_NETBIOS_NAME_CHALLENGE_PACKET
{
	ETHERNET_HEADER					ethernet_header;
	IPX_HEADER							ipx_header;
	ULONG									netbios_network_number[MAXIMUM_NUMBER_OF_NETBIOS_LANS];
	UNION_NAME_TYPE_FLAG				name_type_flag;
	BYTE_ENUM (DATASTREAM_TYPE)	datastream_type;

	char 									name[16]; /* padded on the right with spaces null terminated */
} NOVELL_NETBIOS_NAME_CHALLENGE_PACKET;

/*********************IPX PORT STRUCTURES***********************************/

typedef	struct	IPX_COUNTERS
{
	ULONG	number_of_packets;

	ULONG	number_of_general_queries;
	ULONG	number_of_nearest_queries;
	ULONG	number_of_general_responses;
	ULONG	number_of_nearest_responses;

} IPX_COUNTERS;

typedef	struct	IPX_MIB_COUNTERS
{
	ULONG	major_version;
	ULONG	minor_version;

	ULONG	number_of_rx_header_errors;
	ULONG	number_of_unknown_sockets_rxed;
	ULONG	number_of_rx_basic_system_discards;
	ULONG number_of_bad_checksums_rxed;
	ULONG number_of_local_rx_packets;
	ULONG number_of_path_not_found_packets;
	ULONG number_of_local_tx_packets;
	ULONG number_of_bad_local_tx_packets;
	ULONG number_of_tx_basic_system_discards;
	ULONG number_of_open_socket_failures;

	ULONG	number_of_state_changes; 
	ULONG	number_of_initialization_failures;
	ULONG	number_of_milliseconds_to_send_1_byte;

	ULONG	number_of_rx_decompression_errors;
	ULONG	number_of_tx_compression_errors;
} IPX_MIB_COUNTERS;

typedef	struct	IPX_STATISTICS
{
	/* RIP Counters */

	ULONG	number_of_packets_to_route;

	ULONG	number_of_hop_counts_too_large;
	ULONG	number_of_netbios_hop_counts_too_large;

	ULONG number_of_RIP_packets_with_no_network_address_rxed;
	ULONG number_of_path_not_found_packets;

	IPX_COUNTERS	RIP_tx;
	IPX_COUNTERS	RIP_rx;

	ULONG total_number_of_route_entries_aged_out;

	ULONG number_of_periodic_router_broadcasts;
	ULONG number_of_update_router_broadcasts;
	ULONG number_of_RIP_packets_with_wrong_network_address;
	ULONG rx_number_of_RIP_packets_with_worse_info;
	ULONG	rx_number_of_unknown_router_general_queries;
	ULONG	rx_number_of_unknown_router_nearest_queries;
	ULONG	number_of_unknown_general_router_rx_responses;
	ULONG	number_of_unknown_nearest_router_rx_responses;

	/* SAP Counters */

	IPX_COUNTERS	SAP_tx;
	IPX_COUNTERS	SAP_rx;

	ULONG total_number_of_SAP_entries_aged_out;

	ULONG number_of_SAP_periodic_broadcasts;
	ULONG number_of_SAP_update_broadcasts;
	ULONG number_of_SAP_packets_with_wrong_network_address;
	ULONG rx_number_of_SAP_packets_with_worse_info;
	ULONG	rx_number_of_unknown_SAP_general_queries;
	ULONG	rx_number_of_unknown_SAP_nearest_queries;
	ULONG	number_of_unknown_rx_SAP_general_responses;
	ULONG	number_of_unknown_rx_SAP_nearest_responses;

	/* Netbios Counters */

	ULONG	number_of_netbios_packets_received;
	ULONG	number_of_netbios_packets_sent;
	ULONG	number_of_unknown_netbios_packets_received;

	/* Netware lite Counters */

	ULONG	number_of_lite_packets_received;
	ULONG	number_of_lite_packets_sent;

	/* watchdog counters */

	ULONG number_of_watchdog_request_packets_received;
	ULONG number_of_watchdog_response_packets_received;

	/* serialization counters */

	ULONG number_of_serialization_packets_received;

	/* Generic Counters */

	ULONG number_of_packets_sent;
	ULONG number_of_send_completions;

	ULONG number_of_packets_received;
	ULONG number_of_non_ipx_packets_received;

	ULONG	number_of_out_of_memory_send_calls;

	ULONG number_of_tx_packets_filtered;
	ULONG number_of_rx_packets_filtered;
	ULONG	number_packets_forwarded;

	ULONG number_of_echo_request_packets_received;
	ULONG number_of_echo_reply_packets_received;

	ULONG number_of_error_type_packets_received;
	ULONG number_of_packets_to_send_discarded;

	ULONG number_of_packets_too_large_received;

	IPX_MIB_COUNTERS	ipx_mib;

} IPX_STATISTICS;

/*********************Real to Virtual Port Number Array ***********************************/

typedef	struct	VIRTUAL_PORT_NUMBER_ARRAY
{
	USHORT								virtual_port_number[MAXIMUM_NUMBER_OF_IPX_VIRTUAL_PORTS];
	BYTE_ENUM (BOOLEAN)				token_ring_or_ethernet[MAXIMUM_NUMBER_OF_IPX_VIRTUAL_PORTS];
	USHORT_ENUM (IPX_FRAME_TYPE) 	frame_type[MAXIMUM_NUMBER_OF_IPX_VIRTUAL_PORTS];
} VIRTUAL_PORT_NUMBER_ARRAY;

/*********************SNMP MIB Parameters ***********************************/

typedef	struct	IPX_SNMP_MIB
{
	ULONG 									maximum_number_of_open_sockets;

	/* to be removed - created somewhere else */
	char										circuit_name[48];
	BYTE_ENUM (IPX_CIRCUIT_TYPE)		circuit_type;
	BYTE_ENUM (IPX_CIRCUIT_STATUS)	circuit_status;
	BYTE										media_type[2];
	ULONG										throughput_in_bits_per_second;
	/* Srikar, Mar 17, 1997. Added another variable to store the exist state */
	/* information used for ipxCircExistState */
	/* Srikar, Apr 11, 1997. Removed variable exist_state */
#if 0
	BYTE_ENUM (BOOLEAN)					exist_state;
#endif
	/* Srikar, Apr 11, 1997. Added another variable to store the operational state */
	/* information used for ipxCircOperState */
	BYTE_ENUM (BOOLEAN)					ipxCircOperState;
} IPX_SNMP_MIB;

typedef	struct	RIP_CIRCUIT_ENTRY
{
	ULONG									ripCircSysInstance;
	ULONG									ripCircIndex;
	BYTE_ENUM (BOOLEAN)				ripCircState;
	ULONG									ripCircPace;
	ULONG									ripCircUpdate;
	ULONG									ripCircAgeMultiplier;
	USHORT								ripCircPacketSize;
	ULONG									ripCircOutPackets;
	ULONG									ripCircInPackets;

} RIP_CIRCUIT_ENTRY;

typedef	struct	SAP_CIRCUIT_ENTRY
{
	ULONG									sapCircSysInstance;
	ULONG									sapCircIndex;
	BYTE_ENUM (BOOLEAN)				sapCircState;
	ULONG									sapCircPace;
	ULONG									sapCircUpdate;
	ULONG									sapCircAgeMultiplier;
	USHORT								sapCircPacketSize;
	BYTE_ENUM (BOOLEAN) 				sapCircGetNearestServerReply;
	ULONG									sapCircOutPackets;
	ULONG									sapCircInPackets;

} SAP_CIRCUIT_ENTRY;

typedef	struct	RIP_SAP_MIB
{
	ULONG 	rip_packets_per_second;
	ULONG 	rip_holding_timer;
	USHORT	rip_packet_size;


	ULONG 	SAP_packets_per_second;
	ULONG 	SAP_holding_timer;
	USHORT	SAP_packet_size;

	BYTE_ENUM (BOOLEAN) respond_to_SAP_nearest_queries;
} RIP_SAP_MIB;

/*********************Watchdog structs ***********************************/

typedef	struct	WATCHDOG_CONNECTION_LINK
{
	struct WATCHDOG_CONNECTION 	*sptr_forward_link;
	struct WATCHDOG_CONNECTION 	*sptr_backward_link;
} WATCHDOG_CONNECTION_LINK;

typedef	struct	WATCHDOG_CONNECTION
{
	WATCHDOG_CONNECTION_LINK		links;

	ULONG									current_watchdog_time;

	MAC_ADDRESS							server_mac_address;
	MAC_ADDRESS							client_mac_address;

	BYTE									connection_number;
	BYTE_ENUM (BOOLEAN)				server_side;
} WATCHDOG_CONNECTION;

/********************* SNMP version of Port class ***********************************/

typedef	struct	IPX_LAN_CIRCUIT_ENTRY
{
	ULONG										ipxCircSysInstance;
	ULONG										ipxCircIndex;
	ULONG_ENUM (BOOLEAN)					ipxCircExistState;
	ULONG_ENUM (BOOLEAN)					ipxCircOperState;
	ULONG										ipxCircIfIndex;
	char										ipxCircName[48];
	ULONG_ENUM (IPX_CIRCUIT_TYPE)		ipxCircType;
	ULONG										ipxCircLocalMaxPacketSize;
	ULONG_ENUM (IPX_CIRCUIT_STATUS) 	ipxCircStaticStatus;
	ULONG										ipxCircMediaType[2];
	ULONG										ipxCircNetNumber;
	ULONG										ipxCircStateChanges;
	ULONG										ipxCircInitFails;
	ULONG										ipxCircDelay;
	ULONG										ipxCircThroughput;
} IPX_LAN_CIRCUIT_ENTRY;

/*********************IPX Meta STRUCTURE ***********************************/
#ifndef IPX_WAN
typedef struct IPX_DUMMY_WAN_MIB
{
	char			ipxCircDialName[48];
	ULONG			ipxCircCompressState;
	ULONG			ipxCircCompressSlots;
	ULONG			ipxCircCompressedSent;
	ULONG			ipxCircCompressedInitSent;
	ULONG			ipxCircCompressedRejectsSent;
	ULONG			ipxCircUncompressedSent;
	ULONG			ipxCircCompressedReceived;
	ULONG			ipxCircCompressedInitReceived;
	ULONG			ipxCircCompressedRejectsReceived;
	ULONG			ipxCircUncompressedReceived;
	char			ipxCircNeighRouterName[48];
	ULONG			ipxCircNeighInternalNetNum;
} IPX_DUMMY_WAN_MIB;

typedef struct IPX_DUMMY_WAN_CLASS
{
	/* The only field in this struct is SNMP variables */
	IPX_DUMMY_WAN_MIB		ipx_mib;
} IPX_DUMMY_WAN_CLASS;
#endif

typedef	struct	IPX_PORT_CLASS
{
	ULONG											ipx_instance;
	USHORT										virtual_port_number;				 /* by ipxCircIndex */		
	USHORT										real_port_number;					 /* by ipxCircIfIndex */	

	BYTE_ENUM (BOOLEAN)						port_enabled;						 /* enable/disable the port by ipxCircExistState */

	BYTE_ENUM (BOOLEAN)						wan_port;
	BYTE_ENUM (BOOLEAN)						remote_access;  

	ETHERNET_ADDRESS 							ethernet_address;             
	ULONG											network;									/* 32-bit Novell IPX network address */
	USHORT										transport_time;				   	/* set to 1 for LAN links, > 1 for wide area links. 1 tick -> 55ms */

	USHORT										maximum_number_of_hops;

	USHORT_ENUM (IPX_FRAME_TYPE) 			tx_frame_type;
	BYTE_ENUM (BOOLEAN)						token_ring_enabled;					

	BYTE_ENUM (BOOLEAN)						enable_periodic_SAP_broadcasts;  
	BYTE_ENUM (BOOLEAN)						enable_periodic_RIP_broadcasts;
	BYTE_ENUM (BOOLEAN)						enable_SAP_broadcasts;  
	BYTE_ENUM (BOOLEAN)						enable_RIP_broadcasts;

	BYTE_ENUM (BOOLEAN)						netbios_enabled;						/* enable/disable netbios forwarding */
	BYTE_ENUM (BOOLEAN)						netbios_name_caching_enabled;		

	BYTE_ENUM (BOOLEAN)						netware_lite_enabled;				/* enable/disable netware lite forwarding */

	BYTE_ENUM (BOOLEAN)						enable_watchdog_spoofing;
	BYTE_ENUM (BOOLEAN)						enable_watchdog_connection_spoofing;
	BYTE_ENUM (BOOLEAN)						enable_serialization_spoofing;

	BYTE_ENUM (BOOLEAN)						enable_diagnostic_packets;
	BYTE_ENUM (BOOLEAN)						enable_spx_watchdog_spoofing;
	

	ULONG											maximum_number_of_rip_entries;
	ULONG											maximum_size_of_rip_packet;
	ULONG											periodic_RIP_tx_timer;
	ULONG											RIP_age_timer;							/* 0 = don't age */
	ULONG 										number_of_RIP_clock_ticks;

	LINK											periodic_RIP_list; 
	LINK											response_RIP_list;

	ULONG											maximum_number_of_SAP_entries;
	ULONG											maximum_size_of_SAP_packet;
	ULONG											periodic_SAP_tx_timer;
	ULONG											SAP_age_timer;							/* 0 = don't age */
	ULONG 										number_of_SAP_clock_ticks;

	LINK											periodic_SAP_list;	 
	LINK											response_SAP_list;	 

	USHORT										maximum_number_of_netbios_hops;
	USHORT										maximum_transmission_unit;

	LINK											netbios_name_list;
	ULONG											netbios_name_cache_timer;

	ULONG											maximum_packet_size_including_header;	/* by ipxCircLocalMaxPacketSize */

	BYTE_ENUM (BOOLEAN)						learn_network_address;
	BYTE_ENUM (BOOLEAN)						network_address_learned;

	ULONG											learning_holding_time;							
	ULONG 										number_of_learning_clock_ticks;
	ULONG											current_number_of_learning_retries;							
	ULONG 										maximum_number_of_learning_retries;

	WATCHDOG_CONNECTION_LINK				watchdog_connection_list;
	ULONG											watchdog_holding_time;

	SPX_CONNECTION_LINKS						spx_connection_list;
	ULONG											spx_connection_timeout;

#ifdef IPX_WAN_ENABLED
	IPX_WAN_PORT_CLASS						wan;
#else
	IPX_DUMMY_WAN_CLASS				wan;
#endif

	IPX_STATISTICS								statistics;

	ULONG											major_version;
	ULONG											minor_version;

	IPX_SNMP_MIB								ipx_mib;

	RIP_CIRCUIT_ENTRY							ripCircEntry;

	SAP_CIRCUIT_ENTRY							sapCircEntry;

	IPX_LAN_CIRCUIT_ENTRY 					lan_circuit_mib;

	BYTE_ENUM (NLSP_RIP_COMPATIBILITY)	rip_compatibility;                  /* NLSP 8-1 */          
	BYTE_ENUM (BOOLEAN)						auto_rip_compatibility_activated;	/* NLSP 8-1 */
	BYTE_ENUM (NLSP_SAP_COMPATIBILITY)	sap_compatibility;                  /* NLSP 8-1 */
	BYTE_ENUM (BOOLEAN)						auto_sap_compatibility_activated;   /* NLSP 8-1 */

	ULONG											rip_auto_deactivation_timer;
	ULONG											sap_auto_deactivation_timer;

	/* ### to be removed later on */
	RIP_SAP_MIB									rip_sap_mib;
} IPX_PORT_CLASS;

typedef	struct	IPX_END_STATION_CLASS
{
	char								name[30];

	BYTE_ENUM (BOOLEAN)			enabled;

	LINK								socket_list;

	LINK								tx_ecb_list;

	enum RX_PACKET_STATE 		(*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes);
	void 								(*fptr_timer_routine) (void);

} IPX_END_STATION_CLASS;

typedef	struct	IPX_TRANSPORT_CLASS
{
	char								name[30];

	BYTE_ENUM (TRANSPORT_TYPE)	type; 

	USHORT							id;

	BYTE_ENUM (BOOLEAN)					enabled;

	void 								(*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes);
	enum RX_PACKET_STATE 		(*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes);
	void 								(*fptr_timer_routine) (void);
	enum TEST 						(*fptr_control_routine)
											(enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);

	void								*vptr_context[NUMBER_OF_IPX_PORTS];

} IPX_TRANSPORT_CLASS;

typedef	struct	IPX_NLSP_CLASS
{
	BYTE_ENUM (BOOLEAN)						enabled;

	enum IPX_PACKET_STATE 					(*fptr_nlsp_rx_routine) (ULONG port_number,void *sptr_dlsw_rx_packet,USHORT size_of_packet);
	enum NLSP_VALID_ENTRY_RETURN_TYPE 	(*fptr_nlsp_check_for_valid_route_entry) (ROUTE_LIST_ENTRY *sptr_route_list_entry, 
														enum BOOLEAN rxed_rip_packet);
	enum TEST 									(*fptr_nlsp_check_for_valid_SAP_id) (SAP_LIST_ENTRY *sptr_SAP_entry, 
														enum BOOLEAN rxed_sap_packet);
	ETHERNET_ADDRESS 							*(*fptr_nlsp_find_valid_route) (ULONG network_number,USHORT *usptr_next_hop_port_number);
	void 											(*fptr_copy_ipx_parameters_into_nlsp) (void *sptr_ipx_interface_parameters);
	void 											(*fptr_copy_rip_sap_compatibility_info_in_ipx) 
														(NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS *sptr_nlsp_rip_sap_compatibility_parameters);
	void											(*fptr_nlsp_send_pseudonode_lsps) (USHORT port_number);
} IPX_NLSP_CLASS;

typedef	struct	IPX_BASIC_SYS_ENTRY
{
	ULONG										ipxBasicSysInstance;
	BYTE_ENUM (BOOLEAN)					ipxBasicSysExistState;
	ULONG										ipxBasicSysNetNumber;
	ETHERNET_ADDRESS						ipxBasicSysNode;
	char										ipxBasicSysName[48];
	ULONG										ipxBasicSysInReceives;
	ULONG										ipxBasicSysInHdrErrors;
	ULONG										ipxBasicSysInUnknownSockets;
	ULONG										ipxBasicSysInDiscards;
	ULONG										ipxBasicSysInBadChecksums;
	ULONG										ipxBasicSysInDelivers;
	ULONG										ipxBasicSysNoRoutes;
	ULONG										ipxBasicSysOutRequests;
	ULONG										ipxBasicSysOutMalformedRequests;
	ULONG										ipxBasicSysOutDiscards;
	ULONG										ipxBasicSysOutPackets;
	ULONG										ipxBasicSysConfigSockets;
	ULONG										ipxBasicSysOpenSocketFails;
} IPX_BASIC_SYS_ENTRY;

typedef	struct	IPX_ADV_SYS_ENTRY
{
	ULONG										ipxAdvSysInstance;
	ULONG										ipxAdvSysMaxPathSplits;
	ULONG										ipxAdvSysMaxHops;
	ULONG										ipxAdvSysInTooManyHops;
	ULONG										ipxAdvSysInFiltered;
	ULONG										ipxAdvSysInCompressDiscards;
	ULONG										ipxAdvSysNETBIOSPackets;
	ULONG										ipxAdvSysForwPackets;
	ULONG										ipxAdvSysOutFiltered;
	ULONG										ipxAdvSysOutCompressDiscards;
	ULONG 									ipxAdvSysCircCount;
	ULONG 									ipxAdvSysDestCount;
	ULONG 									ipxAdvSysServCount;
} IPX_ADV_SYS_ENTRY;

typedef	struct	IPX_RIP_SYS_ENTRY
{
	ULONG										ripSysInstance;
	BYTE_ENUM (BOOLEAN)					ripSysState;
	ULONG										ripSysIncorrectPackets;
} IPX_RIP_SYS_ENTRY;

typedef	struct	IPX_SAP_SYS_ENTRY
{
	ULONG										sapSysInstance;
	BYTE_ENUM (BOOLEAN)					sapSysState;
	ULONG										sapSysIncorrectPackets;
} IPX_SAP_SYS_ENTRY;

typedef	struct	IPX_CLASS
{
	USHORT 									starting_port_number;
	USHORT 									number_of_ports;

	IPX_PORT_CLASS							port[NUMBER_OF_IPX_PORTS];

	VIRTUAL_PORT_NUMBER_ARRAY			virtual_port_number_array;

	ROUTE_LINK								router_list; 					/* doubly linked list of - initially only has our port route entries, - later all routes */

	SAP_LINK									SAP_list;				  /* doubly linked list of - initially has nothing, - later all SAP IDs */
#ifndef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	/* array of route entries, initially on the ipx_class.free_router_list_entries linked list */
	ROUTE_LIST_ENTRY						route_list_entry[MAXIMUM_NUMBER_OF_NETWARE_LANS]; 	
	LINK										free_router_list_entries; /* doubly linked list of our free router list entries */

	/* array of SAP entries, initially on the ipx_class.free_SAP_list_entries linked list */
	SAP_LIST_ENTRY							SAP_list_entry[MAXIMUM_NUMBER_OF_NETWARE_LANS]; 			
	LINK										free_SAP_list_entries;	  /* doubly linked list of our free SAP list entries */
#endif

	ULONG										_1_second_counter;
	BYTE										gap_timer_counter;
	BYTE										gap_time_limit;

	BYTE_ENUM (BOOLEAN) 					ipx_printing_enabled;
	BYTE_ENUM (BOOLEAN)					SAP_printing_enabled;
	BYTE_ENUM (BOOLEAN)					RIP_printing_enabled;
	BYTE_ENUM (BOOLEAN)					memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)					alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN)					snap_printing_enabled;
	BYTE_ENUM (BOOLEAN)					snmp_printing_enabled;
	BYTE_ENUM (BOOLEAN)					data_printing_enabled;
	BYTE_ENUM (BOOLEAN)					ipx_wan_timer_printing_enabled;
	BYTE_ENUM (BOOLEAN)					ipx_wan_rip_sap_printing_enabled;
	BYTE_ENUM (BOOLEAN)					echo_printing_enabled;
	BYTE_ENUM (BOOLEAN)					netbios_printing_enabled;
	BYTE_ENUM (BOOLEAN)					netware_lite_printing_enabled;
	BYTE_ENUM (BOOLEAN)					dlsx_printing_enabled;
	BYTE_ENUM (BOOLEAN)					watchdog_printing_enabled;
	BYTE_ENUM (BOOLEAN)					diagnostic_printing_enabled;
	BYTE_ENUM (BOOLEAN)					serialization_printing_enabled;

#ifdef IPX_FILTERING
   BYTE_ENUM (BOOLEAN)					ipx_filter_printing_enabled;
#endif

	BYTE_ENUM (BOOLEAN)					timer_enabled;

	void 										(*fptr_snmp_trap_function) (USHORT port_number,void *vptr_packet,USHORT length);

	void 										(*fptr_route_added) (USHORT port_number,ROUTE_ENTRY *sptr_route_entry,
													ETHERNET_ADDRESS *sptr_ethernet_address,enum BOOLEAN new_primary_route,
													enum BOOLEAN static_entry);

	void 										(*fptr_SAP_added) (USHORT port_number,SAP_ID *sptr_SAP_ID,
													ETHERNET_ADDRESS *sptr_router_address,enum BOOLEAN new_primary_SAP,
													enum BOOLEAN static_entry);

	ULONG										number_of_non_ipx_packets_received;

	ULONG										stack_id;
	ULONG										clock_ticks_per_second;

	/* mib IPXBasicSysEntry */
	IPX_BASIC_SYS_ENTRY					ipxBasicSysEntry[1];
	ULONG										number_of_basic_system_entries;

	/* mib IPXAdvSysEntry */
	IPX_ADV_SYS_ENTRY						ipxAdvSysEntry[1];
	ULONG										number_of_adv_system_entries;

	/* mib RIPSysEntry */
	IPX_RIP_SYS_ENTRY						ripSysEntry[1];
	ULONG										number_of_rip_sys_entries;

	/* mib SAPSysEntry */
	IPX_SAP_SYS_ENTRY						sapSysEntry[1];
	ULONG										number_of_sap_sys_entries;


	/* mib IPXAdvSysEntry */

	ULONG										ipxAdvSysInstance;
	ULONG										ipxAdvSysMaxPathSplits;
	ULONG										ipxAdvSysInTooManyHops;
	ULONG										ipxAdvSysInFiltered;
	ULONG										ipxAdvSysInCompressDiscards;
	ULONG										ipxAdvSysOutCompressDiscards;

	ULONG										number_of_route_entries;
	ULONG										number_of_SAP_entries;

	/* ipx wan parameters */

	SAP_ID									internal_SAP_id;
	SAP_SNMP_ID								snmp_internal_SAP_id;
	ULONG										major_version;
	ULONG										minor_version;

	BYTE_ENUM (BOOLEAN)					enabled;

	USHORT									number_of_transports;

	IPX_END_STATION_CLASS				end_station;

	IPX_TRANSPORT_CLASS					transport;

	IPX_TRANSPORT_CLASS					ncp;

	BYTE_ENUM (BOOLEAN)					remote_access_enabled;

	LINK										remote_access_list;

	IPX_NLSP_CLASS							nlsp;

	ULONG										number_of_circuit_system_entries;
	ULONG										number_of_circuit_entries;
} IPX_CLASS;

typedef	struct	IPX_FRAME_RELAY_HEADER
{
	BYTE								filler[18];
} IPX_FRAME_RELAY_HEADER;

typedef	struct	NLSP_TO_IPX_INTERFACE_PARAMETERS
{
	BYTE_ENUM (BOOLEAN) 				wan_port[NUMBER_OF_IPX_PORTS];
	ULONG 								network[NUMBER_OF_IPX_PORTS];
	ETHERNET_ADDRESS 					ethernet_address[NUMBER_OF_IPX_PORTS];
	BYTE_ENUM (BOOLEAN) 				token_ring_enabled[NUMBER_OF_IPX_PORTS];
	USHORT								maximum_number_of_hops[NUMBER_OF_IPX_PORTS];
	USHORT								transport_time[NUMBER_OF_IPX_PORTS]; 
	USHORT_ENUM (IPX_FRAME_TYPE) 	tx_frame_type[NUMBER_OF_IPX_PORTS];
	ULONG									SAP_age_timer[NUMBER_OF_IPX_PORTS];
	ULONG									RIP_age_timer[NUMBER_OF_IPX_PORTS];

	SAP_ID					internal_SAP_id;
	SAP_LINK					*sptr_SAP_list;
	ROUTE_LINK				*sptr_router_list;
	ULONG						stack_id;
} NLSP_TO_IPX_INTERFACE_PARAMETERS;


/* ipxinit.c */

enum TEST initialize_IPX_router (ULONG clock_ticks_per_second);
void initialize_router_request_packet (USHORT port_number,ROUTE_REQUEST *sptr_router_request);
void initialize_router_periodic_information_packet (USHORT port_number,ROUTE_INFORMATION *sptr_route_information);
void initialize_route_information_packet (USHORT port_number,ROUTE_INFORMATION *sptr_route_information_packet,
	ETHERNET_ADDRESS *sptr_destination_address,USHORT ipx_header_length,IPX_ADDRESS *sptr_ipx_destination_address);
void shut_down_ipx_router (void);
void delete_ipx_entries_and_send_farewell_broadcast (void);
void initialize_SAP_query (USHORT port_number,SAP_SEND_QUERY_PACKET	*sptr_SAP_query);
void initialize_SAP_periodic_response (USHORT port_number,SAP_RESPONSE_PACKET *sptr_SAP_response_packet);
void initialize_SAP_response (USHORT port_number,SAP_RESPONSE_PACKET *sptr_SAP_response_packet,
	ETHERNET_ADDRESS *sptr_destination_address,USHORT ipx_header_length,IPX_ADDRESS *sptr_ipx_destination_address,
	enum RESPONSE_TYPE response_type);
void delete_SAP_entries_and_send_farewell_broadcast (void);
enum TEST IPX_control (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);
_EXTERN void register_nlsp (enum IPX_PACKET_STATE (*fptr_nlsp_rx_routine)
	(ULONG port_number,void *sptr_dlsw_rx_packet,USHORT size_of_packet),
	enum NLSP_VALID_ENTRY_RETURN_TYPE (*fptr_nlsp_check_for_valid_route_entry) (ROUTE_LIST_ENTRY *sptr_route_list_entry, 
		enum BOOLEAN rxed_rip_packet),
	enum TEST (*fptr_nlsp_check_for_valid_SAP_id) (SAP_LIST_ENTRY *sptr_SAP_list_entry, enum BOOLEAN rxed_sap_packet),
	ETHERNET_ADDRESS *(*fptr_nlsp_find_valid_route) (ULONG network_number,USHORT *usptr_next_hop_port_number),
	void (*fptr_copy_ipx_parameters_into_nlsp) (void *sptr_ipx_interface_parameters),
	void (*fptr_copy_rip_sap_compatibility_info_in_ipx) 
		(NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS *sptr_nlsp_rip_sap_compatibility_parameters),
	void (*fptr_nlsp_send_pseudonode_lsps) (USHORT port_number));

_EXTERN ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);

/* ipxsnmp.c */

_EXTERN void ipx_management_alarm (enum IPX_PACKET_STATE alarm,USHORT port_number);
void set_trap_function (void (*fptr_snmp_trap_function) (USHORT port_number,void *vptr_packet,USHORT length));
#ifdef DEBUG
	void display_ipx_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
#endif
void display_route_entry (ROUTE_ENTRY *sptr_route_entry);
void display_ipx_address (IPX_ADDRESS *sptr_ipx_address);
USHORT get_number_of_ipx_ports (void);
ULONG get_ipx_network_for_port (USHORT port_number);
void *get_route_list (void);
void *get_sap_list (void);
void *get_ipx_port_class (USHORT port_number);
void *get_ipx_port_statistics (USHORT port_number);

enum BOOLEAN is_this_a_converted_ipx_packet (USHORT port_number,IPX_PACKET *sptr_rx_packet);
#ifdef IPX_WAN_ENABLED
	_EXTERN void display_wan_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
#endif

/* ipxutil.c */

_EXTERN IPX_PACKET *get_a_send_packet (USHORT port_number,ULONG size_of_packet);
void free_a_send_packet (IPX_PACKET *sptr_tx_packet);
_EXTERN enum IPX_PACKET_STATE send_ipx_packet (USHORT port_number,IPX_PACKET *sptr_tx_packet,USHORT number_of_bytes,
	enum BOOLEAN forwarded_packet,void (*fptr_tx_completion) (USHORT port_number,IPX_PACKET *sptr_tx_packet));
IPX_PACKET *normalize_send_packet_header (USHORT port_number,IPX_PACKET *sptr_ipx_packet);
_EXTERN void send_completion_ipx_packet (USHORT port_number,IPX_PACKET *sptr_tx_packet);
void clear_all_counters (void);
_EXTERN void ipx_printf (enum PRINTF_GROUPS printf_groups,const char *cptr_format, ...);
void add_entry_to_list (LINK *sptr_link,LINK *sptr_link_to_add);
void *get_entry_from_list (LINK *sptr_link);
void delete_entry_from_list (LINK *sptr_list_link,LINK *sptr_link_to_delete);
void enable_or_disable_ipx_printing (enum BOOLEAN enable_or_disable);
void enable_or_disable_ipx_group_printing (enum BOOLEAN enable_or_disable,enum PRINTF_GROUPS printf_group);
void set_ipx_gap_time_counter (BYTE gap_time_counter);
void set_ipx_internal_SAP_id (SAP_ID *sptr_SAP_id);
SAP_ID *get_ipx_internal_SAP_id (void);

#ifndef BIG_ENDIAN
	USHORT swap (USHORT ushort_to_swap_bytes_with);
	ULONG swap_long (ULONG ulong_to_swap_bytes_with);
#endif

/* ipxrout.c */

enum RX_PACKET_STATE IPX_router_rx_packet (USHORT port_number,ETHERNET_BUFFER *sptr_rx_packet,USHORT size_of_packet);
ETHERNET_ADDRESS *get_next_hop_router_address (ULONG destination_network,USHORT *usptr_return_local_router_port_number);
enum IPX_PACKET_STATE ipx_data_to_route (USHORT port_number,IPX_PACKET *sptr_rx_packet,USHORT size_of_packet,
	enum BOOLEAN stack_packet);
enum BOOLEAN is_this_an_ipx_packet (USHORT port_number,IPX_PACKET *sptr_rx_packet);

/* ipxrip.c */

enum IPX_PACKET_STATE ipx_router_packet_received (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number);
_EXTERN enum IPX_PACKET_STATE issue_router_info_request (USHORT port_number);
_EXTERN enum IPX_PACKET_STATE send_periodic_route_information (USHORT port_number);

/* ipxripls.c */

void check_for_down_routers (void);
void update_routes_for_all_ports (void);
enum LIST_ENTRY_TYPE check_if_in_primary_route_list (ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	ROUTE_ENTRY *sptr_rx_route_entry,ETHERNET_ADDRESS *sptr_source_address,USHORT port_number,
	enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp);
enum BOOLEAN is_route_the_best_information (ROUTE_LIST_ENTRY *sptr_primary_route_entry,USHORT outgoing_port_number);
ROUTE_ENTRY *get_route_entry_from_network_address (ULONG network);
enum TEST add_route_entry (USHORT port_number,ROUTE_ENTRY *sptr_route_entry,ETHERNET_ADDRESS *sptr_ethernet_address,
	enum BOOLEAN new_primary_route,enum BOOLEAN static_entry,enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp);
ROUTE_LIST_ENTRY *get_route_list_entry_using_network (ULONG network,ROUTE_LIST_ENTRY *sptr_route_list_entry);
void delete_route_entry (ROUTE_LIST_ENTRY *sptr_primary_route_entry,enum IPX_ROUTING_PROTOCOL_TYPE route_type,void *vptr_lsp);
ROUTE_LIST_ENTRY *get_route_list_entry_using_hops (USHORT hops,ROUTE_LIST_ENTRY *sptr_route_list_entry);
ROUTE_LIST_ENTRY *get_route_list_entry_using_router_address (ETHERNET_ADDRESS *sptr_router_address,
	ROUTE_LIST_ENTRY *sptr_route_list_entry);
ROUTE_LIST_ENTRY *get_route_list_entry_using_port_number (USHORT port_number,ROUTE_LIST_ENTRY *sptr_route_list_entry);
_EXTERN void shut_ipx_rip_port_down (USHORT port_number);

/* ipxsnap.c */

ETHERNET_BUFFER *convert_ipx_header_for_tx (USHORT *usptr_port_number,FRAME *sptr_tx_frame,USHORT *usptr_size_of_tx_packet);
ETHERNET_BUFFER *convert_ipx_header_in_rx_frame (USHORT *usptr_port_number,FRAME *sptr_rx_frame,USHORT *usptr_size_of_rx_packet);
_EXTERN USHORT get_size_of_frame_type_header (USHORT port_number);

/* ipxsap.c */

_EXTERN enum IPX_PACKET_STATE send_SAP_query (enum QUERY_TYPE query_type,USHORT port_number);
enum IPX_PACKET_STATE ipx_SAP_packet_received (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number);
enum IPX_PACKET_STATE send_SAP_periodic_broadcast (USHORT port_number);

/* ipxsapls.c */

void check_for_down_SAPs (void);
void update_SAPs_for_all_ports (void);
enum LIST_ENTRY_TYPE check_if_in_primary_SAP_list (SAP_LIST_ENTRY *sptr_primary_SAP_entry,SAP_ID *sptr_SAP_ID,
	ETHERNET_ADDRESS *sptr_router_address,USHORT port_number,enum IPX_SAP_PROTOCOL_TYPE route_type,void *vptr_lsp);
enum BOOLEAN is_SAP_the_best_information (SAP_LIST_ENTRY *sptr_primary_SAP_entry,USHORT outgoing_port_number);
void delete_all_SAPs_with_network_address (ULONG network_address);

void delete_SAP_list_entry (SAP_LIST_ENTRY *sptr_primary_SAP_entry);
enum TEST add_SAP_entry (USHORT port_number,SAP_ID *sptr_SAP_ID,ETHERNET_ADDRESS *sptr_router_address,
	enum BOOLEAN new_primary_SAP,enum BOOLEAN static_entry,enum IPX_SAP_PROTOCOL_TYPE SAP_type,void *vptr_lsp);
SAP_LIST_ENTRY *get_SAP_list_entry_using_type (enum SAP_PACKET_TYPE SAP_packet_type,SAP_LIST_ENTRY *sptr_starting_SAP_entry);
SAP_LIST_ENTRY *get_SAP_list_entry_using_network (ULONG network,SAP_LIST_ENTRY *sptr_SAP_list_entry);
SAP_LIST_ENTRY *get_SAP_list_entry_using_name (char const *cptr_SAP_name,SAP_LIST_ENTRY *sptr_SAP_list_entry);
SAP_LIST_ENTRY *get_SAP_list_entry_using_router_address (ETHERNET_ADDRESS *sptr_router_address,
	SAP_LIST_ENTRY *sptr_SAP_list_entry);
SAP_LIST_ENTRY *get_SAP_list_entry_using_port_number (USHORT port_number,SAP_LIST_ENTRY *sptr_SAP_list_entry);
_EXTERN void shut_ipx_SAP_port_down (USHORT port_number);

/* ipxnetbs.c */

enum IPX_PACKET_STATE netbios_packet_received (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet,
	USHORT size_of_frame,enum BOOLEAN stack_packet);
void check_age_of_netbios_names (USHORT port_number);
void free_all_netbios_names_in_lists (void);

/* ipxecho.c */

enum IPX_PACKET_STATE ipx_echo_packet_received (USHORT port_number,ECHO_PACKET *sptr_rx_packet,
	USHORT size_of_packet);

/* ipxtimer.c */

void IPX_router_timer (void);

/* ipxwan.c */

#ifdef IPX_WAN_ENABLED
	_EXTERN enum TEST initialize_ipx_wan (IPX_CLASS *sptr_ipx_class);
#endif

/* ipxwatch.c */

enum IPX_PACKET_STATE watchdog_packet_received (USHORT port_number,WATCHDOG_PACKET *sptr_watchdog_rx_packet,
	USHORT size_of_packet);

void issue_periodic_client_watchdog (USHORT port_number);
void ipx_ncp_packet_received (USHORT port_number,NETWARE_CORE_PROTOCOL_PACKET *sptr_ncp_rx_packet);

/* ipxserlz */

enum IPX_PACKET_STATE serialization_packet_received (USHORT port_number,SERIALIZATION_PACKET *sptr_serialization_rx_packet,
	USHORT size_of_packet);

/* ipxdiag.c */

enum IPX_PACKET_STATE diagnostic_packet_received (USHORT port_number,DIAGNOSTIC_REQUEST_PACKET *sptr_diagnostic_rx_packet,
	USHORT size_of_packet);

/* ipxlearn.c */

void learn_ipx_network_address (USHORT port_number);
void check_to_see_if_network_address_is_learned (USHORT port_number,IPX_PACKET *sptr_rx_packet);

/* ipxremac.c */

#ifdef IPX_WAN_ENABLED
	_EXTERN enum BOOLEAN get_remote_access_destination_port_number (USHORT *usptr_port_number,IPX_PACKET *sptr_tx_packet);
	_EXTERN enum BOOLEAN ipx_remote_access_enabled (void);
	_EXTERN void add_remote_access_station (USHORT *usptr_rx_port_number,IPX_PACKET *sptr_rx_packet);
#endif

/* ipxspxw.c */

#if !defined (__SPX_HEADER_FILE__)
	enum IPX_PACKET_STATE spx_packet_received (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_rx_packet,
		USHORT size_of_packet);
#endif
void spx_connection_timer (USHORT port_number);

/* ipxnlsp.c */

_EXTERN enum TEST add_nlsp_route_entry (USHORT port_number,ROUTE_ENTRY *sptr_route_entry,ETHERNET_ADDRESS *sptr_ethernet_address,
	enum BOOLEAN new_primary_route,enum BOOLEAN static_entry,void *vptr_lsp);

_EXTERN void delete_nlsp_route_entry (void *sptr_lsp,ULONG network_number);

_EXTERN enum TEST add_nlsp_SAP_entry (USHORT port_number,SAP_ID *sptr_SAP_entry,ETHERNET_ADDRESS *sptr_ethernet_address,
	void *vptr_lsp);

_EXTERN void delete_nlsp_SAP_entry (void *vptr_lsp,enum SAP_PACKET_TYPE SAP_type,BYTE length_of_name_of_service,
	char const *cptr_SAP_name);

_EXTERN void add_standby_routes_to_ipx_route_list (ROUTE_LIST_ENTRY *sptr_standby_route_list_entry);

_EXTERN void add_standby_SAPs_to_ipx_SAP_list (SAP_LIST_ENTRY *sptr_standby_SAP_list_entry);


/* ipxcfg.c */

void ipx_configuration (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1); /* ipxconfg.c */
ULONG ipx_get_configuration_table_address (void);
#endif /* _VIPXSTR_H_ */


