#include	"defs.h"
/*	$Modname: macbrcfg.c$  $version: 1.4$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 03/23/94 ross added configuration file for nvram support.
1.1 03/23/94 ross added copyright.
1.2 04/05/94 ross added port state configuration.
1.3 06/15/94 ross cosmetic changes and snmp access routines.
1.4 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	<kstart.h>
#include	"macbridg.h"
#include "vmacbr.h"
#include	<vnvrmstr.h>
#include	<lslproto.h>
#include	"vnvstp.h"
/****************************************************************************/
enum TEST mac_bridge_control (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1)
{
	switch (command)
		{
		case IS_PROTOCOL_STACK_ENABLED:
			*((enum BOOLEAN *) parameter_1) = (enum BOOLEAN) stp_class.enabled;
			break;
		case GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS:
			*((USHORT *) parameter_1) = stp_class.number_of_spanning_tree_ports;
			break;
		case GET_PROTOCOL_STACK_TYPE:
			*((BYTE_ENUM (PROTOCOL_STACK_TYPE) *) parameter_1) = SPANNING_TREE_STACK;
			break;
		case GET_PROTOCOL_STACK_PROTOCOL_ID:
			*((USHORT_ENUM (SNAP_PROTOCOL_ID) *) parameter_1) = (USHORT_ENUM (SNAP_PROTOCOL_ID)) SNAP_8023_BRIDGED_PACKET_WITH_CRC; 
			break;
		case GET_PROTOCOL_STACK_SSAP:
			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = (BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;
			break;
		case GET_PROTOCOL_STACK_DSAP:
			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = (BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;
			break;
		case GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE:
			*((USHORT_ENUM (LSL_PACKET_TYPE) *) parameter_1) = (USHORT_ENUM (LSL_PACKET_TYPE)) RAW_8023;
			break;
		case GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER:
			*((USHORT *) parameter_1) = (USHORT) parameter_0;
			break;
		}

	return (PASS);
}
/****************************************************************************/
void turn_stp_printing_on (char *cptr_start_of_configuration_string)
{
	if (is_parameter_enabled (cptr_start_of_configuration_string) == TRUE)
		enable_or_disable_stp_printing (TRUE);
	else
		enable_or_disable_stp_printing (FALSE);
}
/****************************************************************************/
void turn_stp_subgroup_printing_on (char *cptr_start_of_configuration_string,ULONG printf_type)
{
	if (is_parameter_enabled (cptr_start_of_configuration_string) == TRUE)
		{
		enable_or_disable_stp_group_printing (TRUE,(enum STP_PRINTF_GROUPS) printf_type);
		}
	else
		{
		enable_or_disable_stp_group_printing (FALSE,(enum STP_PRINTF_GROUPS) printf_type);
		}
}
/****************************************************************************/
void set_spanning_tree_port_forwarding_state (char *cptr_port_number_and_port_state_type_string)
{
	USHORT port_number;
	char port_state_type_string[20];

	port_number = get_port_number_and_string (cptr_port_number_and_port_state_type_string,&port_state_type_string[0]);

	if (strstr (strlwr (port_state_type_string),"disabled") != NULL)
		{
		stp_class.port[port_number].state = DISABLED;
		}
	else if (strstr (strlwr (port_state_type_string),"listening") != NULL)
		{
		stp_class.port[port_number].state = LISTENING;
		}
	else if (strstr (strlwr (port_state_type_string),"learning") != NULL)
		{
		stp_class.port[port_number].state = LEARNING;
		}
	else if (strstr (strlwr (port_state_type_string),"forwarding") != NULL)
		{
		stp_class.port[port_number].state = FORWARDING;
		}
	else if (strstr (strlwr (port_state_type_string),"blocking") != NULL)
		{
		stp_class.port[port_number].state = BLOCKING;
		}
}

