#include	"defs.h"
/*	$Modname: macbrmgr.c$  $version: 1.11$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 07/30/92 ross
1.3 07/30/92 ross
1.4 07/30/92 ross
1.5 08/05/92 ross
1.6 08/22/92 ross Added support for multiple instances of stp_class
1.7 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic - cosmetic
1.8 01/15/93 ross
1.9 07/16/93 ross added some mib statistics
1.10 06/15/94 ross cosmetic changes and snmp access routines.
1.11 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include <lslproto.h>
/****************************************************************************/
void	enable_port (USHORT port_number)
{
	initialize_port (port_number);

	port_state_selection ();
}
/****************************************************************************/
void	disable_port (USHORT port_number)
{
	enum	BOOLEAN	previous_root_state;

	previous_root_state = root_bridge ();

	become_designated_port (port_number);

	stp_class.port[port_number].state = DISABLED;
	stp_class.port[port_number].dot1dStpPortEnable = FALSE;

	stp_class.port[port_number].topology_change_acknowledgement = FALSE;

	stp_class.port[port_number].configuration_pending = FALSE;

	set_timer (&stp_class.port[port_number].message_age,STOP_TIMER);

	set_timer (&stp_class.port[port_number].forward_delay,STOP_TIMER);

	configuration_update ();

	port_state_selection ();

	if ((root_bridge () == TRUE) && previous_root_state == FALSE)
		{
		stp_class.this_bridge.max_age = stp_class.this_bridge.bridge_max_age; 
		stp_class.this_bridge.hello_time = stp_class.this_bridge.bridge_hello_time; 
		stp_class.this_bridge.forward_delay = stp_class.this_bridge.bridge_forward_delay;

		topology_change_detection ();

		configuration_BPDU_generation ();

		set_timer (&stp_class.topology_change_notification_timer,STOP_TIMER);
		
		set_timer (&stp_class.hello_timer,START_TIMER);
		}
}
/****************************************************************************/
void	set_bridge_priority (USHORT priority)
{
	enum	BOOLEAN	previous_root_state;
	BYTE	port_number;

	previous_root_state = root_bridge ();

	for (port_number = 0x01; port_number <= stp_class.number_of_spanning_tree_ports ; port_number += (BYTE) 1)
		{
		if (designated_port (port_number) == TRUE)
			stp_class.port[port_number].designated_bridge_id.priority = priority;
		}

	stp_class.this_bridge.bridge_id.priority = priority;

	configuration_update ();

	port_state_selection ();

	if ((root_bridge () == TRUE) && previous_root_state == FALSE)
		{
		stp_class.this_bridge.max_age = stp_class.this_bridge.bridge_max_age; 
		stp_class.this_bridge.hello_time = stp_class.this_bridge.bridge_hello_time; 
		stp_class.this_bridge.forward_delay = stp_class.this_bridge.bridge_forward_delay;

		topology_change_detection ();

		configuration_BPDU_generation ();

		set_timer (&stp_class.topology_change_notification_timer,STOP_TIMER);
		
		set_timer (&stp_class.hello_timer,START_TIMER);
		}
}
/****************************************************************************/
void	set_port_priority (USHORT port_number,BYTE priority)
{
	if (designated_port (port_number) == TRUE)
		stp_class.port[port_number].designated_port_id.priority = priority;

	stp_class.port[port_number].port_id.priority = priority;

	if (compare_identifiers (&stp_class.this_bridge.bridge_id,&stp_class.port[port_number].designated_bridge_id) == EQUAL_TO && 
		stp_class.port[port_number].port_id.number < stp_class.port[port_number].designated_port_id.number)
		{
		become_designated_port (port_number);

		port_state_selection ();
		}
}
/****************************************************************************/
void	set_path_cost (USHORT port_number, ULONG path_cost)
{
	stp_class.port[port_number].path_cost = path_cost;

	configuration_update ();

	port_state_selection ();
}
