#include	"defs.h"
/*	$Modname: macbrtx.c$  $version: 1.15$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 07/30/92 ross
1.3 08/05/92 ross
1.4 08/21/92 ross
1.5 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.6 01/15/93 ross
1.7 01/29/93 ross added store_dlci call.
1.8 01/29/93 ross changed constants in macbrrx.c and macbrdb.c to better match snmp, fixed frame relay bug.
1.9 01/30/93 ross eliminate frame relay references.
1.10 07/16/93 ross added some mib statistics
1.11 10/11/93 ross update for changes in LSL, bug in frame relay receive.
1.12 10/28/93 ross in convert tr to ethernet added length field.
1.13 02/02/94 ross took out frame relay header and fixed big endian problems.  Courtesy of Rick.
1.14 05/09/94 ross added changes for configuring forwarding state for SRT
1.15 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<kstart.h>
#include "macbridg.h"
#include	<lslproto.h>
#include "vmacbr.h"
/****************************************************************************/
void send_mac_bridge_PDU (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_tx_buffer,USHORT size_of_buffer)
{
	sptr_tx_buffer->mac_header.source_address = stp_class.port[port_number].mac_address; /* added for wan */

	if (stp_class.port[port_number].token_ring == FALSE)
		{
		sptr_tx_buffer->mac_header.destination_address = bridge_group_address; 

		sptr_tx_buffer->mac_header.length = swap ((USHORT) (size_of_buffer - sizeof (ETHERNET_HEADER)));
		}
	else
		{
		sptr_tx_buffer->mac_header.destination_address = token_ring_bridge_group_address; 

		convert_ethernet_header_to_token_ring ((ETHERNET_HEADER *) &sptr_tx_buffer->mac_header);
		}

	big_endianize_packet ((BRIDGE_CONFIGURATION_BPDU *) sptr_tx_buffer);

#ifdef DEBUG
	stp_printf(STP_DATA_PRINTF, "STP: Pkt Tx ");
	display_spanning_tree_packet (port_number,(ETHERNET_BUFFER *) &sptr_tx_buffer->mac_header,size_of_buffer); 
#endif

	if (stp_class.port[port_number].state != DISABLED && stp_class.stp_algorithm_enabled == TRUE)
		{
 		++stp_class.port[port_number].number_of_bridge_pdus_sent;
		send_packet (stp_class.stack_id,(USHORT) (port_number - 1),(ETHERNET_BUFFER *) &sptr_tx_buffer->mac_header,
			size_of_buffer,FALSE,FALSE,NULL);   
		}
}
/****************************************************************************/
void convert_ethernet_header_to_token_ring (ETHERNET_HEADER *sptr_tx_buffer)
{
	ETHERNET_ADDRESS source_address;
	ETHERNET_ADDRESS destination_address;

	source_address = sptr_tx_buffer->source_address;
	destination_address = sptr_tx_buffer->destination_address;

	*((BYTE *) sptr_tx_buffer) = 0x10;
	*((BYTE *) sptr_tx_buffer + 1) = 0x40;

	sptr_tx_buffer = (ETHERNET_HEADER *) ((ULONG) sptr_tx_buffer + 2);

	sptr_tx_buffer->source_address = source_address;
	sptr_tx_buffer->destination_address = destination_address;
}
/****************************************************************************/
void convert_token_ring_header_to_ethernet (ETHERNET_BUFFER *sptr_tx_buffer,USHORT size_of_buffer)
{
	ETHERNET_ADDRESS source;
	ETHERNET_ADDRESS destination;
	USHORT length;

	sptr_tx_buffer = (ETHERNET_BUFFER *) ((ULONG) sptr_tx_buffer + 2);

	source = sptr_tx_buffer->mac_header.source_address;
	destination = sptr_tx_buffer->mac_header.destination_address;

	sptr_tx_buffer = (ETHERNET_BUFFER *) ((ULONG) sptr_tx_buffer - 2);

	length = (USHORT) (size_of_buffer - sizeof (UNION_MAC_HEADER));

	sptr_tx_buffer->mac_header.source_address = source;
	sptr_tx_buffer->mac_header.destination_address = destination;
	sptr_tx_buffer->mac_header.length = swap (length);
}
