/*
** MACBSNMP.C -- Has code providing SNMP support for Spanning Tree Bridge
*/

/* General Notes:
**	1. The "dot1dStatic" group is not implemented. This is because the
**		meaning of this group (it is meant to get the destination-address
**		filtering table and is used to make a forwarding decision) does not 
**		clearly match information that we have in our tables.
*/
#include	"defs.h"
#include	<stddef.h>
#include	<string.h>
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include	<lslproto.h>
#include	<visnpstr.h>
#include "vmacsnmp.h"


/* Local prototypes */
/* Srikar, Mar 20, 1997. Changed the function prototype, due to change in the object id type from */
/* BYTE to OBJECT_ID */
static void set_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	enum MIB_OPERATION mib_operation, char *cptr_mib_string,	BYTE *bptr_variable_value,	USHORT *usptr_size_of_variable_value,
	USHORT *usptr_number_of_subids_in_table_indices,	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name);
static enum BOOLEAN check_if_snmp_table_entry_is_valid (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST process_stp_scalar_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
/* Srikar 6 Jan 97 */
static enum TEST process_stp_table_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, enum BOOLEAN *eptr_good_value);
/* Srikar 6 Jan 97 */
/* Srikar, Mar 20, 1997. Changed the function prototype, due to change in the object id type from */
/* BYTE to OBJECT_ID */
static void	build_indices_for_scalar_mib_variable (OBJECT_ID *bptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices);
enum BOOLEAN check_if_stp_mib_table_exists (void);
void create_stp_mib_table_sorted_on_indices (void);
enum TEST find_pointer_to_row_in_stp_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	void **ptr_to_vptr_row_in_table, BYTE indice_type);
/* Srikar, Mar 20, 1997. Changed the function prototype, due to change in the object id type from */
/* BYTE to OBJECT_ID */
static enum BOOLEAN get_stp_mib_table_indices (OBJECT_ID *sptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices,
	enum BOOLEAN *eptr_received_indices, MAC_ADDRESS *ulptr_mac_address);
static FILTERING_DATABASE_ENTRY *stp_calculate_pointer_to_next_row_in_mib_table (FILTERING_DATABASE_ENTRY *sptr_fd_entry);
enum TEST stp_apply_mib_operation_on_current_instance_of_mib_variable (void *vptr_row_in_table,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
/* Srikar, Mar 20, 1997. Changed the function prototype, due to change in the object id type from */
/* BYTE to OBJECT_ID */
enum TEST build_stp_table_indices_for_current_instance_of_mib_variable (void *vptr_row_in_table,
	OBJECT_ID *sptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices, BYTE indice_type);
static SNMP_TABLE_ENTRY *get_next_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters);
static void clear_pointer_to_next_variable_name (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters);
static void	adjust_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);


/*-- Code -----------------------------------------------------------------*/
/* Srikar, 6 Jan 97 */
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST 
get_spanning_tree_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string, BYTE *bptr_variable_value, 
	USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST found_variable;
	enum BOOLEAN good_value;
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry;
	MIB_ACCESS_PARAMETERS mib_access_parameters;

	sptr_snmp_table_entry = (SNMP_TABLE_ENTRY *)&stp_snmp_table[0x00];
	set_mib_access_parameters(&mib_access_parameters, mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_number_of_subids_in_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name);

	while (check_if_snmp_table_entry_is_valid(sptr_snmp_table_entry) == TRUE)
	{
		if (strcmp(sptr_snmp_table_entry->mib_name, mib_access_parameters.cptr_mib_string) == STRINGS_MATCH)
			{
			if (sptr_snmp_table_entry->sptr_parameters->is_a_table_entry == FALSE)
				{
				found_variable = process_stp_scalar_mib_variable (&mib_access_parameters, sptr_snmp_table_entry);
				return (found_variable);
				}
			else
				{
				found_variable = process_stp_table_mib_variable (&mib_access_parameters, sptr_snmp_table_entry, &good_value);

				if (found_variable == PASS)
					{
					if(good_value == TRUE)
						return (PASS);
					else
						return (FAIL);
					}

				adjust_mib_access_parameters (&mib_access_parameters, sptr_snmp_table_entry);
				}
			}

		sptr_snmp_table_entry = get_next_mib_variable (sptr_snmp_table_entry, &mib_access_parameters);
		}

	clear_pointer_to_next_variable_name (&mib_access_parameters);
	
	return (FAIL);
}
/* Srikar, 6 Jan 97 */

/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
static void 
set_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	enum MIB_OPERATION mib_operation, char *cptr_mib_string,	BYTE *bptr_variable_value,	USHORT *usptr_size_of_variable_value,
	USHORT *usptr_number_of_subids_in_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name)
{
	sptr_mib_access_parameters->mib_operation = mib_operation;
	sptr_mib_access_parameters->cptr_mib_string = cptr_mib_string;
	sptr_mib_access_parameters->bptr_variable_value = bptr_variable_value;
	sptr_mib_access_parameters->usptr_size_of_variable_value = usptr_size_of_variable_value;
	sptr_mib_access_parameters->usptr_size_of_table_indices = usptr_number_of_subids_in_table_indices;
	sptr_mib_access_parameters->sptr_table_indices = sptr_table_indices;
	sptr_mib_access_parameters->eptr_end_of_table = eptr_end_of_table;
	sptr_mib_access_parameters->ptr_to_cptr_next_variable_name = ptr_to_cptr_next_variable_name;
}

static enum BOOLEAN 
check_if_snmp_table_entry_is_valid (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	if (sptr_snmp_table_entry->fptr_mib_access_function != NULL)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}

/* Srikar, 6 Jan 97 */
static enum TEST 
process_stp_scalar_mib_variable(MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT arg_not_used;
	enum TEST return_code;

	arg_not_used = 0x0000;

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	return_code = (sptr_snmp_table_entry->fptr_mib_access_function) (arg_not_used, sptr_mib_access_parameters->mib_operation,
		sptr_snmp_table_entry->offset_of_mib_variable,
		sptr_snmp_table_entry->sptr_parameters->address_of_structure_containing_mib_variable,
		(ULONG) arg_not_used,
		sptr_mib_access_parameters->bptr_variable_value, sptr_mib_access_parameters->usptr_size_of_variable_value);

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	if (sptr_snmp_table_entry->need_to_swap == TRUE)
		{
		*((ULONG *) sptr_mib_access_parameters->bptr_variable_value) =
			swap_long (*((ULONG *) sptr_mib_access_parameters->bptr_variable_value));
		}

	build_indices_for_scalar_mib_variable (sptr_mib_access_parameters->sptr_table_indices,
		sptr_mib_access_parameters->usptr_size_of_table_indices);

	return (return_code);
}
/* Srikar, 6 Jan 97 */

/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
static void	build_indices_for_scalar_mib_variable (OBJECT_ID *sptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices)
{
	*sptr_table_indices = 0x00000000;

	*usptr_number_of_subids_in_table_indices = 0x0001;
}

/* Notes: process_stp_table_mib_variable()
** 1. There are three kinds of tables -- those that are ordered or indexed
**		based on port numbers, those that are indexed on mac address and
**		those that are indexed on mac addresses again. The first kind are
**		distinguished by the presence of the substring "dot1d...Port" in the mib
**    string. The second have the substring "dot1dTpFdb" and the third have the
**		substring "dot1dStatic". For now this much of demux code will do.
*/
/* Srikar, 6 Jan 97 */
static enum TEST process_stp_table_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, enum BOOLEAN *eptr_good_value)
{
	BYTE indice_type;
	void *vptr_row_in_table;
	enum BOOLEAN table_does_exist;

	table_does_exist = check_if_stp_mib_table_exists ();

	if (table_does_exist == FALSE)
		{
		create_stp_mib_table_sorted_on_indices ();
		}

	if (strstr(sptr_mib_access_parameters->cptr_mib_string, "dot1dBasePort") != NULL ||
		strstr(sptr_mib_access_parameters->cptr_mib_string, "dot1dStpPort") != NULL ||
		strstr(sptr_mib_access_parameters->cptr_mib_string, "dot1dTpPort") != NULL)
	{
		indice_type = 0;
	}
	else if (strstr(sptr_mib_access_parameters->cptr_mib_string, "dot1dTpFdb") != NULL)
	{
		indice_type = 1;
	}
	else	/* "Static" */
	{
		indice_type = 2;
		return FAIL;	/* No support for dot1dStatic group */
	}


	if (find_pointer_to_row_in_stp_mib_table (sptr_snmp_table_entry, sptr_mib_access_parameters, &vptr_row_in_table, indice_type) == FAIL)
		{

		return (FAIL);
		}

	if (stp_apply_mib_operation_on_current_instance_of_mib_variable (vptr_row_in_table, 
		sptr_mib_access_parameters, sptr_snmp_table_entry) == PASS)
		*eptr_good_value = TRUE;
	else
		*eptr_good_value = FALSE;

	build_stp_table_indices_for_current_instance_of_mib_variable (vptr_row_in_table,
		sptr_mib_access_parameters->sptr_table_indices,	sptr_mib_access_parameters->usptr_size_of_table_indices, indice_type);

	return (PASS);
}
/* Srikar, 6 Jan 97 */
enum BOOLEAN check_if_stp_mib_table_exists (void)
{
	return (TRUE);
}

void	create_stp_mib_table_sorted_on_indices (void)
{

}

enum TEST find_pointer_to_row_in_stp_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	void **ptr_to_vptr_row_in_table, BYTE indice_type)
{
	ULONG stpport;
	MAC_ADDRESS mac_address;
	enum BOOLEAN received_indices;
	enum BOOLEAN valid_table_indices;
	FILTERING_DATABASE_ENTRY *sptr_stp_fde_ptr;


	PARAMETER_NOT_USED(sptr_snmp_table_entry);

	if (indice_type == 0)
	{
		/* Table accessed on port numbers */

		/* Srikar, Mar 20, 1997. Changed the check for size of table indices to check for the number of */
		/* sub ids expected, instead of checking for the number  of bytes. */
		if (*sptr_mib_access_parameters->usptr_size_of_table_indices == 0 ||
			*sptr_mib_access_parameters->usptr_size_of_table_indices != 1)
		{
			/* No or bad indices passed, so use port number 0 */
			stpport = 1; /* Port numbers are 1 based in spanning tree code */
			received_indices = FALSE;
		}
		else
		{
			/* Srikar, Mar 20, 1997. Code changed due to change in object id type from BYTE to ULONG */
			stpport = *sptr_mib_access_parameters->sptr_table_indices;
			received_indices = TRUE;
		}

		if (received_indices == TRUE && sptr_mib_access_parameters->mib_operation == GET_NEXT_OPERATION)
		{
			stpport++;
			if (stpport > stp_class.number_of_spanning_tree_ports)
			{
				*ptr_to_vptr_row_in_table = NULL;
				return FAIL;
			}
		}

		*ptr_to_vptr_row_in_table = (void *) (&stp_class.port[stpport]);
		return PASS;
	}

	if (indice_type == 1)
	{
		/* Mib table of the second kind */

		valid_table_indices = get_stp_mib_table_indices (sptr_mib_access_parameters->sptr_table_indices,
			sptr_mib_access_parameters->usptr_size_of_table_indices, &received_indices, &mac_address);

		if (valid_table_indices == FALSE)
		{
			return (FAIL);
		}

		if (received_indices == FALSE)
		{
			/* no indices have been received, so we will be accessing first instance of mib variable */
			*ptr_to_vptr_row_in_table = (void *)
 				stp_calculate_pointer_to_next_row_in_mib_table((FILTERING_DATABASE_ENTRY *) NULL);

			if (*ptr_to_vptr_row_in_table == NULL)
				{
				return (FAIL);
				}

			return (PASS);
		}
		else
		{
			sptr_stp_fde_ptr = (FILTERING_DATABASE_ENTRY *)	NULL;
			while ((sptr_stp_fde_ptr = stp_calculate_pointer_to_next_row_in_mib_table(sptr_stp_fde_ptr)) != NULL)
			{
				/* Srikar, Mar 17, 1997. Changed code for lexicographic behaviour of the get next operator */
				int compare_result = compare_addresses(&sptr_stp_fde_ptr->source_address, &mac_address);
				if (compare_result == EQUAL_TO)
				{
					if (sptr_mib_access_parameters->mib_operation == GET_NEXT_OPERATION)
						*ptr_to_vptr_row_in_table = stp_calculate_pointer_to_next_row_in_mib_table(sptr_stp_fde_ptr);
					else
						*ptr_to_vptr_row_in_table = (void *) sptr_stp_fde_ptr;
					if (*ptr_to_vptr_row_in_table == NULL)
						return (FAIL);
					return (PASS);
				}
				else if (compare_result == GREATER_THAN)
				{
					switch(sptr_mib_access_parameters->mib_operation)
					{
						case GET_OPERATION :
						case SET_OPERATION :
							*ptr_to_vptr_row_in_table = NULL;
							return (FAIL);
						case GET_NEXT_OPERATION:
							*ptr_to_vptr_row_in_table = sptr_stp_fde_ptr;
							return (PASS);
					}
				}
			}
			return (FAIL);
		}
	}

	if (indice_type == 2)
	{
		/* Not implemented yet */
		return FAIL;
	}
}

/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
static enum BOOLEAN get_stp_mib_table_indices (OBJECT_ID *sptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices,
	enum BOOLEAN *eptr_received_indices, MAC_ADDRESS *ulptr_mac_address)
{
	enum BOOLEAN valid_table_indices;
	USHORT i;


	valid_table_indices = TRUE;
	*eptr_received_indices = TRUE;

	if (*usptr_number_of_subids_in_table_indices == 0x0000)
		{
		*eptr_received_indices = FALSE;
		}
	/* Srikar, Mar 20, 1997. Changed the check for the number of bytes in the table indices to 1 + sizeof(MAC_ADDRESS) */
	/* since the length of the mac address is the first byte in the table index. Also the extraction of the mac address */
	/* changed to start with the second byte in the received table index. */
	/* Changed the code to due to change in the object id type from BYTE to OBJECT_ID */
	else if (*usptr_number_of_subids_in_table_indices == 1 + (sizeof (MAC_ADDRESS)))
		{
		if (*sptr_table_indices != sizeof(MAC_ADDRESS))
			valid_table_indices = FALSE;
		else
			{
			sptr_table_indices++;
			for(i = 0; i < sizeof(MAC_ADDRESS); i++)
				{
				*((BYTE *)ulptr_mac_address) = (BYTE)*sptr_table_indices;
				sptr_table_indices++;
				ulptr_mac_address = (MAC_ADDRESS *)((BYTE *)ulptr_mac_address + 1);
				}
			}
		}
	else
		{
		valid_table_indices = FALSE;
		}

	return (valid_table_indices);
}

/* Srikar, Mar 18, 1997. The earlier implementation was wrong. It would not get the next */
/* mac address entry under lexicographic ordering. */

static FILTERING_DATABASE_ENTRY *stp_calculate_pointer_to_next_row_in_mib_table(FILTERING_DATABASE_ENTRY *sptr_fd_prev_entry)
{
	static	MAC_ADDRESS	zero_mac_address;

	FILTERING_DATABASE_ENTRY	*next_filter_entry;
	FILTERING_DATABASE_ENTRY	*filter_entry;
	MAC_ADDRESS		*mac_addr_ptr;
	USHORT	index;

	if (sptr_fd_prev_entry == NULL)
		mac_addr_ptr = &zero_mac_address;		/* Assume an address with all zeros. */
	else
		mac_addr_ptr = &sptr_fd_prev_entry->source_address;

	next_filter_entry = NULL;		/* Assume no next entry found. */
	if (stp_class.sptr_fd_table == NULL)
		return(NULL);

	filter_entry = &stp_class.sptr_fd_table->entry[0];		/* Start with the first entry in the table. */
	for (index = 0; index < stp_class.number_of_fd_entries; index++, filter_entry++)
		{
		if (compare_addresses(mac_addr_ptr, &filter_entry->source_address) == LESS_THAN)
			{
			if (next_filter_entry == NULL)
				{
				/* This is the first entry we see higher than the given entry. */

				next_filter_entry = filter_entry;
				}
			else
				{
				/* We have already found one entry higher than the given entry. If this entry is between the */
				/* given entry and the next higher entry found so far, update the next higher entry to this. */

				if (compare_addresses(&filter_entry->source_address, &next_filter_entry->source_address) == LESS_THAN)
					next_filter_entry = filter_entry;
				}
			}
		}
	return(next_filter_entry);
}

enum TEST 
stp_apply_mib_operation_on_current_instance_of_mib_variable (void *vptr_row_in_table,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT arg_not_used;


	arg_not_used = 0x0000;
	if ((sptr_snmp_table_entry->fptr_mib_access_function) (arg_not_used,
		sptr_mib_access_parameters->mib_operation, sptr_snmp_table_entry->offset_of_mib_variable,
		(ULONG) vptr_row_in_table, (ULONG) arg_not_used, sptr_mib_access_parameters->bptr_variable_value,
		sptr_mib_access_parameters->usptr_size_of_variable_value) == FAIL)
		{
		return (FAIL);
		}

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	return (PASS);
}

/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST 
build_stp_table_indices_for_current_instance_of_mib_variable (void *vptr_row_in_table,
	OBJECT_ID *sptr_table_indices, USHORT *usptr_number_of_subids_in_table_indices, BYTE indice_type)
{
	USHORT i;

	switch (indice_type)
	{
	case 0:
		/* First kind of table where port number is the index */

		/* Srikar, Mar 20, 1997. Changed the code due to change in object id type from BYTE to OBJECT_ID */
		*sptr_table_indices = ((STP_PORT_CLASS *) vptr_row_in_table)->port_id.number;

		*usptr_number_of_subids_in_table_indices = 1;
		break;

	case 1:
		/* Second kind of table where there are mac address is the index */

		/* Srikar, Mar 20, 1997. Changed the code as object id's type is no longer BYTE. Hence memcpy cannot be used */
		*sptr_table_indices = sizeof(MAC_ADDRESS);
		sptr_table_indices++;
		for(i = 0; i < sizeof(MAC_ADDRESS); i++)
		{
			*sptr_table_indices = ((BYTE *) &(((FILTERING_DATABASE_ENTRY *) vptr_row_in_table)->source_address))[i];
			sptr_table_indices++;
		}
		*usptr_number_of_subids_in_table_indices = 1 + sizeof (MAC_ADDRESS);
		break;
	case 2:
		break;
	default:
		break;
	}
	return PASS;
}

enum TEST snmp_get_or_set_mac_bridge_timed_ushort (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,
	ULONG _class,ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (usptr_length_of_mib_obtained);

/* Srikar, 6 Jan 97 */
	if (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		value = (value * 100) / 256;

		*(ULONG *) vptr_mib_value = swap_long (value);
		}
/* Srikar, 6 Jan 97 */
	else if (mib_operation == SET_OPERATION)
		{
		value = swap_long (*(ULONG *) vptr_mib_value);

		value = (value * 256) / 100;

		*(USHORT *) (_class + offset + (size * port_number)) = (USHORT) value;
		}

	return (PASS);
}

enum TEST snmp_get_or_set_mac_bridge_timed_ushort_max_age (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,
	ULONG _class,ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (usptr_length_of_mib_obtained);

/* Srikar, 6 Jan 97 */
	if (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		value = (value * 100) / 256;

		*(ULONG *) vptr_mib_value = swap_long (value);
		}
/* Srikar, 6 Jan 97 */
	else if (mib_operation == SET_OPERATION)
		{
		/* Srikar, Mar 23, 1997. Removed the call to swap_long. */
		value = (*(ULONG *) vptr_mib_value);

/* Srikar, 6 Jan 97 */
		if (value < 600 || value > 4000)	/* Range 600 - 4000 */
			return FAIL;
/* Srikar, 6 Jan 97 */

		value = (value * 256) / 100;

		*(USHORT *) (_class + offset + (size * port_number)) = (USHORT) value;
		}
	/* Srikar, Mar 23, 1997. Added the following to set the length of the returned value. */
	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}

enum TEST snmp_get_or_set_mac_bridge_timed_ushort_hello_time (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,
	ULONG _class,ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (usptr_length_of_mib_obtained);

/* Srikar, 6 Jan 97 */
	if (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		value = (value * 100) / 256;

		*(ULONG *) vptr_mib_value = swap_long (value);
		}
/* Srikar, 6 Jan 97 */
	else if (mib_operation == SET_OPERATION)
		{
		/* Srikar, Mar 23, 1997. Removed the call to swap_long. */
		value = (*(ULONG *) vptr_mib_value);

/* Srikar, 6 Jan 97 */
		if (value < 100 || value > 1000)	/* Range 100 - 1000 */
			return FAIL;
/* Srikar, 6 Jan 97 */

		value = (value * 256) / 100;

		*(USHORT *) (_class + offset + (size * port_number)) = (USHORT) value;
		}
	/* Srikar, Mar 23, 1997. Added the following to set the length of the returned value. */
	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}

enum TEST snmp_get_or_set_mac_bridge_timed_ushort_forward_delay (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,
	ULONG _class,ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (usptr_length_of_mib_obtained);

/* Srikar, 6 Jan 97 */
	if (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		value = (value * 100) / 256;

		*(ULONG *) vptr_mib_value = swap_long (value);
		}
/* Srikar, 6 Jan 97 */
	else if (mib_operation == SET_OPERATION)
		{
		/* Srikar, Mar 23, 1997. Removed the call to swap_long. */
		value = (*(ULONG *) vptr_mib_value);

/* Srikar, 6 Jan 97 */
		if (value < 400 || value > 3000)	/* Range 400 - 3000 */
			return FAIL;
/* Srikar, 6 Jan 97 */

		value = (value * 256) / 100;

		*(USHORT *) (_class + offset + (size * port_number)) = (USHORT) value;
		}
	/* Srikar, Mar 23, 1997. Added the following to set the length of the returned value. */
	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}

static SNMP_TABLE_ENTRY *get_next_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters)
{
	PARAMETER_NOT_USED (sptr_mib_access_parameters);

	++sptr_snmp_table_entry;

	return (sptr_snmp_table_entry);
}

static void clear_pointer_to_next_variable_name (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters)
{
	*(sptr_mib_access_parameters->ptr_to_cptr_next_variable_name) = NULL;

	*(sptr_mib_access_parameters->eptr_end_of_table) = TRUE;
}

static void	adjust_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	*(sptr_mib_access_parameters->eptr_end_of_table) = (enum BOOLEAN) sptr_snmp_table_entry->sptr_parameters->is_a_table_entry;

	*(sptr_mib_access_parameters->usptr_size_of_table_indices) = 0x0000;

	++sptr_snmp_table_entry;

	sptr_mib_access_parameters->cptr_mib_string = sptr_snmp_table_entry->mib_name;

	*(sptr_mib_access_parameters->ptr_to_cptr_next_variable_name) = sptr_snmp_table_entry->mib_name;

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;
}

enum TEST snmp_get_or_set_fdb_status(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;


	value = 0x00000000;
	if ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
	{
		value = *(USHORT *) (_class + offset + (size * port_number));
 
		/* For the purpose of SNMP, though we have umpteen different types
		** of filtering entries, we will tell him that all those types (other
		** than the ones that SNMP defines) are all "mgmt" types.
		*/
		if (value > (USHORT) DELETE_ENTRY_ON_TIMEOUT)
			value = (USHORT) DELETE_ENTRY_ON_RESET;

		value++;		/* We keep info 0 based and SNMP wants it 1 based */

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
	}
	else if (mib_operation == SET_OPERATION)
	{
		/* No SET request should be coming */
	}

	*usptr_length_of_mib_obtained = sizeof (ULONG);
	return PASS;
}

enum TEST snmp_get_or_set_stp_port_state(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;
	USHORT set_port;


	value = 0x00000000;
	if  ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
	{
		value = *(USHORT *) (_class + offset + (size * port_number));

		if (value == TRUE)
		{
			value = SNMP_BOOLEAN_ENABLED;
		}
		else
		{
			value = SNMP_BOOLEAN_DISABLED;
		}

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
	}
	else if (mib_operation == SET_OPERATION)
	{
		set_port = (USHORT) ((STP_PORT_CLASS *)(_class + (size * port_number)))->port_id.number;
		value = *(ULONG *) vptr_mib_value_obtained;
			
		if (value == (ULONG) SNMP_BOOLEAN_ENABLED)
		{
			enable_port(set_port);
		}
		if (value == (ULONG) SNMP_BOOLEAN_DISABLED)
		{
			disable_port(set_port);
		}
	}

	*usptr_length_of_mib_obtained = sizeof (ULONG);
	return PASS;
}

enum TEST snmp_get_or_set_stp_priority(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;


	value = 0x00000000;
	if  ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
	{
		value = *(USHORT *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
	}
	else if (mib_operation == SET_OPERATION)
	{
		value = *(ULONG *) vptr_mib_value_obtained;
/* Srikar, 6 Jan 97 */
		if (value > 65535)
			return FAIL;
/* Srikar, 6 Jan 97 */
		set_bridge_priority((USHORT) value);
	}			
	/* Srikar, Mar 18, 1997. Added the following to set the length of the returned value. */
	*usptr_length_of_mib_obtained = sizeof (ULONG);
	return PASS;
}

enum TEST snmp_get_or_set_stp_port_priority(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;
	USHORT set_port;


	value = 0x00000000;
	if  ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
	{
		value = *(BYTE *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
	}
	else if (mib_operation == SET_OPERATION)
	{
		set_port = (USHORT) ((STP_PORT_CLASS *)(_class + (size * port_number)))->port_id.number;
		value = *(ULONG *) vptr_mib_value_obtained;
/* Srikar, 6 Jan 97 */
		if (value > 255)
			return FAIL;
/* Srikar, 6 Jan 97 */
		set_port_priority(set_port, (BYTE) value);
	}		
	return PASS;
}

enum TEST snmp_get_or_set_stp_port_path_cost(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;
	USHORT set_port;


	value = 0x00000000;
	if  ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
	{
		value = *(ULONG *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
	}
	else if (mib_operation == SET_OPERATION)
	{
		set_port = (USHORT) ((STP_PORT_CLASS *)(_class + (size * port_number)))->port_id.number;
		value = *(ULONG *) vptr_mib_value_obtained;
/* Srikar, 6 Jan 97 */
		if (value > 65535)
			return FAIL;
/* Srikar, 6 Jan 97 */
		set_path_cost(set_port, value);
	}
	return PASS;
}

enum TEST snmp_get_or_set_tp_aging_time(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;


	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value_obtained = *(ULONG *) (_class + offset + (size * port_number));
		*(ULONG *) vptr_mib_value_obtained = swap_long (*(ULONG *) vptr_mib_value_obtained);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

/* Srikar, 6 Jan 97 */
		if (value < 10 || value > 1000000)	/* Range 10 - 1000000 */
			return FAIL;
/* Srikar, 6 Jan 97 */

		*(ULONG *) (_class + offset + (size * port_number)) = value;
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}

/* Srikar, Mar 23, 1997. Added the following function to support the proper encoding of */
/* the base port circuit. */
enum TEST snmp_get_or_set_base_port_circuit(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	USHORT value;

	value = 0x0000;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		*(OBJECT_ID *) vptr_mib_value_obtained = 0x00000000;
		*((OBJECT_ID *)vptr_mib_value_obtained + 1) = *(BYTE *) (_class + offset + (size * port_number));
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = (BYTE) *((OBJECT_ID *)vptr_mib_value_obtained + 1);
		*(USHORT *) (_class + offset + (size * port_number)) = value;
		}

	PARAMETER_NOT_USED (value);

	*usptr_length_of_mib_obtained = sizeof(OBJECT_ID) * 2;
	return (PASS);
}

