/*	$Modname: vfdtstr.h$  $version: 1.13$      $date: 04/17/95$   */
/*
* 	$lgb$
1.0 08/21/92 ross
1.1 08/21/92 ross
1.2 08/22/92 ross Added support for multiple instances of stp_class
1.3 08/22/92 ross added copyright and pragma noalign at top.
1.4 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.5 01/10/93 ross added dlci to FD table.
1.6 01/20/93 ross
1.7 01/30/93 ross delete references to stp dlci
1.8 03/29/93 ross added some mib statistics
1.9 10/11/93 ross update for changes in LSL, bug in frame relay receive.
1.10 08/25/94 ross added support for BYTE_ENUM and USHORT_ENUM
1.11 03/31/95 ross Changes for new rwutils library.
1.12 04/17/95 ross remove pragmas.  Courtesy of Hung.
1.13 04/17/95 ross remove some more pragmas.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
/* for database filtering */

#ifndef SMALL_ENTRY

#ifndef LINK_TYPEDEF_DEFINED
	#define LINK_TYPEDEF_DEFINED

	typedef	struct	LINK
	{
		struct	LINK	*sptr_forward_link;
		struct	LINK	*sptr_backward_link;
	} LINK;

	typedef	struct	SINGLE_LINK
	{
		struct	SINGLE_LINK	*sptr_forward_link;
	} SINGLE_LINK;
#endif

	typedef	struct	FILTERING_DATABASE_ENTRY
	{
		LINK									links;   			
	
		MAC_ADDRESS							source_address;	
		USHORT								timer_value;		

		BYTE								  	port_number;		
		enum	FD_TABLE_ENTRY_TYPE  	type;
	} FILTERING_DATABASE_ENTRY;

	typedef	struct	FILTERING_DATABASE_TABLE
	{
		FILTERING_DATABASE_ENTRY	entry[NUMBER_OF_FILTERING_DATABASE_ENTRIES];
	} FILTERING_DATABASE_TABLE;

	typedef	struct	LOOKUP_TABLE_POINTERS
	{
		FILTERING_DATABASE_ENTRY	*sptr_forward_link;
		FILTERING_DATABASE_ENTRY	*sptr_backward_link;
	} LOOKUP_TABLE_POINTERS;

	typedef	struct	HASH_TABLE
	{
		LOOKUP_TABLE_POINTERS	entry[NUMBER_OF_ENTRIES_IN_HASH_TABLE];
	} HASH_TABLE;

#else

	/* for database filtering */

	typedef	struct	USHORT_LINK
	{
		USHORT	next_entry_index;					/* 0 */
		USHORT	previous_entry_index;			/* 2 */
	} USHORT_LINK;

	typedef	struct	FILTERING_DATABASE_ENTRY
	{
		USHORT_LINK									links;
		BYTE											port_number;				/* 4 */
		enum FD_TABLE_ENTRY_TYPE				type;		/* 5 */
		USHORT										timer_value;

		MAC_ADDRESS							source_address;			/* 8 */
		enum FILTERING_DATABASE_ENTRY_TYPE	type;
	} FILTERING_DATABASE_ENTRY;

	typedef	struct	FILTERING_DATABASE_TABLE
	{
		FILTERING_DATABASE_ENTRY	entry[NUMBER_OF_FILTERING_DATABASE_ENTRIES]; 
	} FILTERING_DATABASE_TABLE; 

	typedef	struct	HASH_TABLE		 /* used to quickly access FDT's source address */
	{
		USHORT_LINK entry[NUMBER_OF_ENTRIES_IN_HASH_TABLE];
	} HASH_TABLE; 

	#define sptr_forward_link next_entry_index
	#define sptr_backward_link previous_entry_index

#endif



