/*	$Modname: vmacbstr.h$  $version: 2.33$      $date: 04/17/95$   */
/*
* 	$lgb$
2.0 01/05/92 ross
2.1 01/25/92 ross changed prototype for send_packet, added port_number to tx_completion call
2.2 04/22/92 ross
2.3 07/30/92 ross
2.4 07/30/92 ross
2.5 08/05/92 ross
2.6 08/21/92 ross
2.7 08/22/92 ross Added support for multiple instances of stp_class
2.8 08/22/92 ross made as many functions as possible static
2.9 11/20/92 ross tabs around USHORT were fixed (cosmetic).
2.10 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
2.11 01/15/93 ross
2.12 01/18/93 ross delete redundant aging_time in stp_class, still in this_bridge.
2.13 01/20/93 ross changed NUMBER_OF_SPANNING_TREE_PORTS to NUMBER_OF_SPANNING_TREE_PORTS + 1 courtesy of MW.
2.14 01/29/93 ross added dlci to PORT_STATUS.
2.15 01/29/93 ross added prototype for store_dlci.
2.16 01/29/93 ross changed constants in macbrrx.c and macbrdb.c to better match snmp, fixed frame relay bug.
2.17 01/30/93 ross delete references to frame relay.
2.18 01/30/93 ross delete references to stp dlci
2.19 03/29/93 ross added more snmp stuff
2.20 07/16/93 ross added some mib statistics
2.21 07/23/93 ross added mtu size to port class.
2.22 10/11/93 ross update for changes in LSL, bug in frame relay receive.
2.23 10/28/93 ross changes for ethernet to token ring bridging/translation
2.24 12/29/93 ross big endian fix.  Courtesy of Rick.
2.25 02/02/94 ross took out frame relay header and fixed big endian problems.  Courtesy of Rick.
2.26 03/07/94 ross removed external references to mac_address, function used instead.
2.27 05/09/94 ross added changes for configuring forwarding state for SRT
2.28 06/15/94 ross cosmetic changes and snmp access routines.
2.29 07/21/94 ross fixed path cost bug, from ushort to ulong.  Courtesy of Sanjeev.
2.30 08/19/94 ross added BIG_ENDIAN to topology change structure.
2.31 08/25/94 ross added support for BYTE_ENUM and USHORT_ENUM
2.32 03/31/95 ross Changes for new rwutils library.
2.33 04/17/95 ross removed pragma.  Courtesy of Hung.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	TIMER
{
	enum	TIMER_COMMAND	active;
	USHORT					value;
} TIMER;

typedef	struct	BRIDGE_IDENTIFIER
{
	USHORT				priority;
	MAC_ADDRESS	address;
} BRIDGE_IDENTIFIER;

typedef	struct	PORT_IDENTIFIER
{
	BYTE				priority;
	BYTE				number;
} PORT_IDENTIFIER;

typedef	struct	BRIDGE_CONFIGURATION_FLAGS
{
#ifndef BIG_ENDIAN
	unsigned	topology_change:1;
	unsigned	:6;
	unsigned	topology_change_acknowledgement:1;
#else
	unsigned	topology_change_acknowledgement:1;
	unsigned	:6;
	unsigned	topology_change:1;
#endif
} BRIDGE_CONFIGURATION_FLAGS;

typedef	struct	BRIDGE_CONFIGURATION_BPDU
{
	MAC_HEADER						mac_header; 												/* 14 bytes | 14,0xe  01-80-c2-00-00-00,source,0x3c*/

	LLC_HEADER						LLC_header; 												/* 3 bytes  | 17,0x11 |	1 42 42 03*/
	
	USHORT							protocol_ID; 									 			/* 2 bytes  | 19,0x12 |	3 00 00*/

	BYTE								protocol_version_ID;										/* 1 byte   | 20,0x14 |	4 00*/

	BYTE_ENUM (BPDU_TYPE)		type; /* CONFIGURATION  */								/* 1 byte   | 21,0x15 |	5 00*/

	BRIDGE_CONFIGURATION_FLAGS	flags;														/* 1 byte   | 22,0x16 |	6 00*/

	BRIDGE_IDENTIFIER				root_id; 													/* 8 bytes  | 30,0x1e |	7 80 00, lowest ethernet address*/
	ULONG								root_path_cost;											/* 4 bytes  | 34,0x23 |	15 00 00 00 00*/

	BRIDGE_IDENTIFIER				bridge_id;													/* 8 bytes  | 42,0x2s |	19 80 00, lowest ethernet address*/

	PORT_IDENTIFIER				port_id; 													/* 2 bytes  | 44,0x2c |	27 80 02 or 01*/

	USHORT							message_age;												/* 2 byte   | 46,0x2e |	29 00 00*/
	USHORT							max_age;  													/* 2 byte   | 48,0x30 |	31 14 00*/
	USHORT							hello_time; 												/* 2 byte   | 50,0x32 |	33 02 00*/
	USHORT							forward_delay;												/* 2 byte   | 52,0x34 |	35 0f 00*/

} BRIDGE_CONFIGURATION_BPDU;


typedef	struct	BRIDGE_TOPOLOGY_CHANGE_NOTIFICATION
{
	MAC_HEADER						mac_header; 												/* 14 bytes | 14,0xe */

	LLC_HEADER						LLC_header; 												/* 3 bytes  | 17,0x11 |	1*/
	
	USHORT							protocol_ID; 									 			/* 2 bytes  | 19,0x12 |	3*/

	BYTE								protocol_version_ID;										/* 1 byte   | 20,0x14 |	4*/

	BYTE_ENUM (BPDU_TYPE)		type; /* TOPOLOGY_CHANGE */ 							/* 1 byte   | 21,0x15 |	5*/

} BRIDGE_TOPOLOGY_CHANGE_NOTIFICATION;

#ifndef TURN_OFF_ALIGNMENT
	/* #pragma align 16 */
#endif

typedef	struct	THIS_BRIDGE
{
	BRIDGE_IDENTIFIER	root_id;				/* value of bridge assumed to be the root (maybe me) */
	USHORT				root_path_cost;	/* cost of the path to the root from this bridge (me) */
	PORT_IDENTIFIER	root_port_id;		/* port which offers the lower cost path to the root i.e. designated_cost + path_cost */

	USHORT				max_age;				/* maximum age of protocol info before it is discarded */
	USHORT				hello_time;			/* time interval between the tx of config BPDUs by a bridge attempting or is the root */
	USHORT				forward_delay;		/* time between states or the value used to age out entries when topology is changing */

	BRIDGE_IDENTIFIER	bridge_id;					/* my id */

	USHORT				bridge_max_age;			/* my max age, when I'm the root */
	USHORT				bridge_hello_time;		/* my hello time, when I'm the root */
	USHORT				bridge_forward_delay;	/* my forward delay when I'm the root */

	enum	BOOLEAN		topology_change_detected;	/* topology change detected or sent to the me, if not the root then I send periodic (hello time) tcn BPDU towards the root */
	enum	BOOLEAN		topology_change;				/* records the value of the topology change flag in config BPDUs to be tx, ageing timer = forward delay when TRUE */
	USHORT				topology_change_time;		/* length of time the tcns are sent if I'm the root = bridge_max_age + bridge_forward_delay */
	USHORT				hold_time;						/* config BPDUs are space apart at least hold_time */
/* management members */
	char					name[32];
	ULONG					time_up;
	ULONG					number_of_topology_changes;
	ULONG					timer_topology_tick;
	ULONG					number_of_frames_received_while_database_is_full;
	ULONG					aging_time_for_fd;
} THIS_BRIDGE;

#ifndef TURN_OFF_ALIGNMENT
	/* #pragma align 16 */
#endif

typedef	struct	STP_PORT_CLASS
{
	PORT_IDENTIFIER	port_id; 						/* my port priority and number  */

	enum	PORT_STATE	state;							/* state i.e. FORWARDING */
	BYTE_ENUM (BOOLEAN)		token_ring;
	BYTE_ENUM (BOOLEAN)		wan_port;
	MAC_ADDRESS			mac_address;

	ULONG					path_cost;						/* when the Root Port, the (my port's) portion of the total path cost to the Root */

	BRIDGE_IDENTIFIER	designated_root_id;			/* the root bridge, used in tx config BPDUs */
	ULONG					designated_root_path_cost;	/* cost of the path to the root offered by the designated port (maybe my port) */
	BRIDGE_IDENTIFIER	designated_bridge_id;		/* the designated bridge priority and address, (maybe me) */
	PORT_IDENTIFIER	designated_port_id; 			/* the designated port priority and number, (maybe me) */

	enum	BOOLEAN		topology_change_acknowledgement;	/* value of the next tx config BPDU flag, for reply to tcn */
	enum	BOOLEAN		configuration_pending;				/* when hold timer expires, tx config BPDU */

	TIMER					message_age;					/* timer to measure the age of rxed protocol info, timeout is max_age */
	TIMER					forward_delay;					/* monitors the time spent in listening and learning states */
	TIMER					hold_time;						/* ensures that config BPDUs are tx too often uses hold time */

/* management members */

	char					name[32];

	ULONG					dot1dBasePortDelayExceededDiscards;
	ULONG					dot1dBasePortMtuExceededDiscards;

	ULONG					number_of_forward_transitions;
	ULONG					number_of_frames_forwarded;
	ULONG					dot1dTpPortInFrames;
	ULONG					number_of_frames_discarded;
	ULONG					number_of_frames_received_while_database_is_full;

	ULONG					number_of_rx_frames_filtered;
	ULONG					number_of_tx_frames_filtered;
	ULONG					number_of_bridge_pdus_sent;

	USHORT				maximum_packet_size;

	enum BOOLEAN 		dot1dStpPortEnable;

} STP_PORT_CLASS;

typedef	struct	STP_CLASS
{
	USHORT 										number_of_spanning_tree_ports;
	USHORT										number_of_fd_entries;
	ULONG											number_of_hash_table_entries;
	USHORT										hash_mask;
	USHORT										size_of_hash_key;
	STP_PORT_CLASS								port[NUMBER_OF_SPANNING_TREE_PORTS + 1];
	BRIDGE_CONFIGURATION_BPDU				bridge_configuration_BPDU[NUMBER_OF_SPANNING_TREE_PORTS + 1];
	BRIDGE_TOPOLOGY_CHANGE_NOTIFICATION	bridge_topology_change_notification[NUMBER_OF_SPANNING_TREE_PORTS + 1];

	enum STP_BASE_TYPE						dot1dBaseType;
	enum STP_TYPE								dot1dStpProtocolSpecification;

	TIMER											hello_timer;
	TIMER											topology_change_notification_timer;
	TIMER											topology_change_timer;

	THIS_BRIDGE									this_bridge;

#ifndef SMALL_ENTRY
	LINK											free_fd_entries_queue;
#else
	USHORT_LINK									free_fd_entries_queue;
	#define LINK USHORT_LINK /* for prototypes */
#endif

	FILTERING_DATABASE_TABLE 				*sptr_fd_table;
	HASH_TABLE 									*sptr_hash_table;

	FILTERING_DATABASE_ENTRY 				*sptr_first_entry_in_fd_table;

	FILTERING_DATABASE_TABLE 				*sptr_filters_table;

	LINK											free_filtering_entries_queue;

	LINK											filtering_entries_queue;

	enum	BOOLEAN								mac_bridge_enabled;

	ULONG 										current_entry_to_check_age;
	ULONG 										upper_limit_on_number_of_entries;
	ULONG 										number_of_entries_timed_out;

	void 											(*fptr_topology_change_detection) (void);
	void 											(*fptr_new_root) (void);

	enum BOOLEAN								filtering_database_table_is_full;
	BYTE_ENUM (BOOLEAN)								enabled;
	enum BOOLEAN 								timer_enabled;
	BYTE_ENUM (BOOLEAN)								stp_algorithm_enabled;

	ULONG											stack_id;
	ULONG											clock_ticks_per_second;
	ULONG 										number_of_bridge_clock_ticks;

	enum BOOLEAN 								stp_printing_enabled;
	enum BOOLEAN								memory_printing_enabled;
	enum BOOLEAN								alarm_printing_enabled;
	enum BOOLEAN								snmp_printing_enabled;
	enum BOOLEAN								data_printing_enabled;

} STP_CLASS;

/* brouter.c */
enum	SORT_RETURN	compare_addresses (MAC_ADDRESS *sptr_address_1,MAC_ADDRESS *sptr_address_2);

/* macbrini.c */

enum TEST initialize_bridge (ULONG clock_ticks_per_second);
void initialize_bridge_configuration_bpdu (void);
void big_endianize_packet (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU);
void little_endianize_packet (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU);
enum	SORT_RETURN	compare_identifiers (BRIDGE_IDENTIFIER *sptr_address_1,BRIDGE_IDENTIFIER *sptr_address_2);
enum SORT_RETURN compare_port_identifiers (PORT_IDENTIFIER *sptr_address_1,PORT_IDENTIFIER *sptr_address_2);

#ifndef BIG_ENDIAN
	ULONG swap_long (ULONG ulong_to_swap_bytes_with);
	USHORT swap (USHORT ushort_to_swap_bytes_with);
#endif

/* macbrspn.c */

void initialize_bridge_spanning_tree (void);
void initialize_port (USHORT port_number);
void	transmit_configuration (USHORT port_number);
enum BOOLEAN root_bridge (void);
void	configuration_BPDU_generation (void);
enum	BOOLEAN designated_port (USHORT port_number);
void	transmit_topology_change_notification (void);
void	configuration_update (void);
void become_designated_port (USHORT port_number);
void port_state_selection (void);
void	topology_change_detection (void);
void	bridge_protocol_message_received (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_rx_buffer);

/* macbrrx.c */

enum RX_PACKET_STATE mac_bridge_rx (USHORT port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer);

/* macbrtx.c */
void send_mac_bridge_PDU (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_tx_buffer,USHORT size_of_buffer);
void convert_ethernet_header_to_token_ring (ETHERNET_HEADER *sptr_tx_buffer);
void convert_token_ring_header_to_ethernet (ETHERNET_BUFFER *sptr_tx_buffer,USHORT size_of_buffer);

/* macbrdb.c */

void	initialize_hashing_table (void);
enum FD_TABLE_ENTRY_TYPE add_entry_to_filtering_database (USHORT source_mac_address_ushort,
	ULONG source_mac_address_ulong,USHORT port_number,enum FD_TABLE_ENTRY_TYPE type);
FILTERING_DATABASE_ENTRY *find_source_address (LINK *sptr_queue_entry,USHORT source_mac_address_ushort,
	ULONG source_mac_address_ulong);
void	database_entry_timer_check (void);
void add_bridge_addresses_to_static_forwarding_table (void);
FILTERING_DATABASE_ENTRY *get_destination_address_database_entry (USHORT destination_mac_address_ushort,
	ULONG destination_mac_address_ulong);


void delete_entry_from_queue (LINK *sptr_queue_link,LINK *sptr_link_to_delete);
void *get_entry_from_queue (LINK *sptr_link);
void add_entry_to_queue (LINK *sptr_link,LINK *sptr_link_to_add);

/* macbrtim.c */

void mac_bridge_timer (void);
void set_timer (TIMER *sptr_timer,enum TIMER_COMMAND start_or_stop);
void start_message_age_timer (TIMER *sptr_timer,enum TIMER_COMMAND start_or_stop,USHORT timer_value);

/* macbrmgr.c */

void	enable_port (USHORT port_number);
void	disable_port (USHORT port_number);
void	set_bridge_priority (USHORT priority);
void	set_port_priority (USHORT port_number,BYTE priority);
void	set_path_cost (USHORT port_number, ULONG path_cost);

/* macbrmgt.c */

enum BOOLEAN stp_forwarding_enabled (USHORT port_number);
void stp_printf (enum STP_PRINTF_GROUPS printf_group,const char *cptr_format, ...);
void enable_or_disable_stp_printing (enum BOOLEAN enable_or_disable);
void enable_or_disable_stp_group_printing (enum BOOLEAN enable_or_disable,enum STP_PRINTF_GROUPS printf_group);

#ifdef DEBUG
	void display_spanning_tree_packet (USHORT port_number,ETHERNET_BUFFER *sptr_rx_packet,USHORT size_of_packet);
#endif

/* macbrflt.c */

enum BOOLEAN stp_filter (USHORT port_number,ETHERNET_BUFFER *sptr_rx_buffer);

