#include "defs.h"
#include <string.h>
#include "spx.h"
/****************************************************************************/
static enum TEST spx_close_all_connections_and_send_close_connection_messages_to_all_applications (void);
/****************************************************************************/
enum TEST spx_control (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	switch (command)
		{
		case OPEN_TRANSPORT:

			break;

		case CLOSE_TRANSPORT:

			if (spx_close_all_connections_and_send_close_connection_messages_to_all_applications () == FAIL)
				{
				return (FAIL);
				}

			spx_printf (SPX_ALARM_PRINTF, "SPX: Transport Layer Closed\n");

			spx.enabled = FALSE;

			break;

		default:

			if (spx_configuration (command, parameter_0, parameter_1) == FAIL)
				{
				spx_printf (SPX_ALARM_PRINTF, "SPX: spx_control () : Bad command %u with parameters: %lu, %lu\n",
					command, parameter_0, parameter_1);
				}

		}

	return (PASS);
}
/*************************************************************************/
void set_spx_class_to_zero (void)
{
	memset ((void *) &spx, sizeof (SPX_CLASS), 0x00);
}
/*************************************************************************/
static enum TEST spx_close_all_connections_and_send_close_connection_messages_to_all_applications (void)
{
	return (PASS);
}
