#include "defs.h"
/*	$Modname: spxinit.c$  $version: 1.4$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 08/08/94 ross Added copyright
1.3 11/21/94 ross changed to compile under C++.
1.4 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define GLOBAL_FILE
#include "spx.h"
/****************************************************************************/
enum TEST initialize_spx (ULONG clock_ticks_per_second)
{
	USHORT dummy_transport_id;
	void *dummy_context[NUMBER_OF_IPX_PORTS];

	if (spx.enabled == FALSE)
		{
		return (PASS);
		}
	spx.clock_ticks_per_second = clock_ticks_per_second;

#ifdef __LSL__
		if ((enum TEST) lsl_control (REGISTER_TRANSPORT, "SPX Transport", SPX_TRANSPORT, spx_timer, spx_control, &spx.transport_id)
			== FAIL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: failed to register spx with lsl\n");

			return (FAIL);
			}

/*
		if ((enum TEST) lsl_control (PROTOCOL_STACK_CONTROL, "IPX Routing", REGISTER_TO_IPX_FROM_UPPER_LAYER, SPX_PROTOCOL,
			(enum RX_PACKET_STATE (*) (void *sptr_spx_rx_packet, USHORT number_of_bytes_received))	spx_receive_packet,
			NULL) == FAIL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: failed to register spx with ipx\n");

			return (FAIL);
			}
*/

	if (register_transport_to_ipx ("SPX Transport", SPX_TRANSPORT, spx_packet_transmitted,
		(enum RX_PACKET_STATE (*) (void *sptr_spx_rx_packet, USHORT number_of_bytes_received))	spx_receive_packet,
		NULL, spx_control, dummy_context, &dummy_transport_id) == FAIL)
		{
		spx_printf (SPX_ALARM_PRINTF, "Problem registering SPX with IPX\n");
		}

/*
		if ((enum TEST) lsl_control (INITIALIZE_IPX_FUNCTION_POINTERS, IPX_PROTOCOL_STACK, INITIALIZE_STACK_FUNCTION_POINTERS,
			TRANSPORT_LAYER_TYPE, &spx.ipx_fptrs) == FAIL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: failed to initialize function pointers to the ipx library\n");

			return (FAIL);
			}
*/
#else
	if (register_transport_to_ipx ("SPX Transport", SPX_TRANSPORT, spx_packet_transmitted,
		(enum RX_PACKET_STATE (*) (void *sptr_spx_rx_packet, USHORT number_of_bytes_received))	spx_receive_packet,
		spx_timer, spx_control, dummy_context, &spx.transport_id) == FAIL)
		{
		spx_printf (SPX_ALARM_PRINTF, "Problem registering SPX with IPX\n");
		}
#endif

 	spx.timer_enabled = TRUE; 

	return (PASS);
}
