#include "defs.h"
/*	$Modname: spxrx.c$  $version: 1.5$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Added copyright
1.4 11/21/94 ross changed to compile under C++.
1.5 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "spx.h"
/****************************************************************************/
static enum SPX_EVENT determine_receive_event (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
EVENT_CONTROL_BLOCK *find_receive_ecb (enum SPX_EVENT receive_event,SPX_SESSION_CLASS *sptr_session,
	SPX_PACKET *sptr_spx_rx_packet,USHORT number_of_bytes_received);
static enum TEST check_connection_control_bits (SPX_PACKET *sptr_spx_rx_packet,enum BOOLEAN end_of_message,
	enum BOOLEAN attention,enum BOOLEAN ack_required,enum BOOLEAN system_packet);
static enum SPX_EVENT check_for_connection_request (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_connection_ack (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_watchdog_retry_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_data_ack_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_watchdog_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_disconnect_packet (SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_disconnect_ack_packet (SPX_PACKET *sptr_spx_rx_packet);
static enum SPX_EVENT check_for_data_packet (SPX_PACKET *sptr_spx_rx_packet);
/****************************************************************************/
enum RX_PACKET_STATE spx_receive_packet (SPX_PACKET *sptr_spx_rx_packet, USHORT number_of_bytes_received)
{
	SPX_SESSION_CLASS *sptr_session;
	enum SPX_EVENT receive_event;
	EVENT_CONTROL_BLOCK *sptr_rx_ecb;

	spx_printf (SPX_DATA_PRINTF, "SPX: packet received\r\n");

	if (sptr_spx_rx_packet->spx_header.destination_connection_id != ILLEGAL_CONNECTION_ID)
		{
		sptr_session = get_session_using_connection_id (swap (sptr_spx_rx_packet->spx_header.destination_connection_id));

		if (sptr_session == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: Invalid Connection ID in rxed packet\r\n");

			return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
			}
		}
	else
		{
		/* this occurs only when a connection hasn't yet been setup.
		 * then we look for a session class that is in the SPX_LISTENING state */

		sptr_session = find_session_class_corresponding_to_received_packet (sptr_spx_rx_packet);

		if (sptr_session == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: No session class available for rxed packet\r\n");

			return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
			}
		else
			{
			sptr_session->remote_connection_id = sptr_spx_rx_packet->spx_header.source_connection_id;
			}
		}

	receive_event = determine_receive_event (sptr_session,sptr_spx_rx_packet);

	if (receive_event == ILLEGAL_SPX_EVENT)
		{
		spx_printf (SPX_ALARM_PRINTF,"SPX: Illegal receive event on session %04x\r\n",sptr_session->connection_id);

		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
																 
	switch (receive_event)								 /* If we get a receive, but the sequence number is out of sequence,	*/
		{														 /* treat it as an ACK so we can process the ack_number for our */
		case SPX_RX_DATA:									 /* transmit acknowlegements */
																  
			if (sptr_session->remote_ack_number != swap (sptr_spx_rx_packet->spx_header.sequence_number))
				{
				++spx.statistics.number_of_rx_frames_discarded;

				spx_printf (SPX_STATE_PRINTF, "SPX: Bad Incomming Sequence %04x, state %04x\r\n", 
					swap (sptr_spx_rx_packet->spx_header.sequence_number), sptr_session->remote_ack_number);

				receive_event = SPX_TX_DATA_ACK_RXED;
				}

		case SPX_TX_DATA_ACK_RXED:							
		case SPX_RX_WATCHDOG:								/* Save latest remote acknowlegement and allocation numbers */
		case SPX_RX_WATCHDOG_RETRY:						/* for use in tx kickstarting */
																	 
			sptr_session->ack_number = swap (sptr_spx_rx_packet->spx_header.ack_number);

			sptr_session->remote_allocation_number = swap (sptr_spx_rx_packet->spx_header.allocation_number);

			break;
		}

	sptr_rx_ecb = find_receive_ecb (receive_event, sptr_session, sptr_spx_rx_packet, number_of_bytes_received);

	if ((sptr_rx_ecb != NULL) || (receive_event == SPX_RX_WATCHDOG_RETRY) || (receive_event == SPX_RX_WATCHDOG))
		{
		execute_spx_state_machine (receive_event, sptr_session, sptr_rx_ecb);
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: No receive ecb available for event on session %04x\r\n",
			sptr_session->connection_id);
		}

	return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
}
/****************************************************************************/
static enum SPX_EVENT determine_receive_event (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	enum SPX_EVENT receive_event;

	receive_event = check_for_connection_request (sptr_session,sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_connection_ack (sptr_session,sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_data_ack_packet (sptr_session,sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_watchdog_retry_packet (sptr_session,sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_watchdog_packet (sptr_session,sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_disconnect_packet (sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	receive_event = check_for_disconnect_ack_packet (sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	if (sptr_spx_rx_packet->spx_header.connection_control._bit.system_packet == TRUE)
		{
		return (ILLEGAL_SPX_EVENT);
		}

	receive_event = check_for_data_packet (sptr_spx_rx_packet);

	if (receive_event != UNDETERMINED_SPX_EVENT)
		{
		return (receive_event);
		}

	return (ILLEGAL_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_connection_request (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	if (sptr_spx_rx_packet->spx_header.destination_connection_id == ILLEGAL_CONNECTION_ID)
		{
		if (sptr_session->state == SPX_LISTENING)
			{
			if (check_connection_control_bits (sptr_spx_rx_packet,FALSE,FALSE,TRUE,TRUE) == FAIL)
				{
				return (ILLEGAL_SPX_EVENT);
				}
			else if (swap (sptr_spx_rx_packet->ipx_header.length) != (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
				{
				return (ILLEGAL_SPX_EVENT);
				}
			else
				{
				check_hop_count (sptr_session,sptr_spx_rx_packet->ipx_header.transport_control_hop_count);

				spx_printf (SPX_STATE_PRINTF,"SPX: Connection request on session %04x\r\n",
					sptr_spx_rx_packet->spx_header.destination_connection_id);

				return (SPX_CONNECTION_REQUEST_RXED);
				}
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_connection_ack (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	if (check_connection_control_bits (sptr_spx_rx_packet,FALSE,FALSE,FALSE,TRUE) == PASS)
		{
		if (sptr_session->state == SPX_CONNECT_REQUEST_SENT)
			{
			if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
				{
				check_hop_count (sptr_session,sptr_spx_rx_packet->ipx_header.transport_control_hop_count);

				spx_printf (SPX_STATE_PRINTF,"SPX: Connection ack on session %04x\r\n",
					sptr_spx_rx_packet->spx_header.destination_connection_id);

				return (SPX_CONNECTION_ACK_RXED);
				}
			else
				{
				return (ILLEGAL_SPX_EVENT);
				}
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_watchdog_retry_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	if (check_connection_control_bits (sptr_spx_rx_packet,FALSE,FALSE,TRUE,TRUE) == PASS)
		{
		if (sptr_session->state == SPX_CONNECTED)
			{
			if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
				{
				spx_printf (SPX_STATE_PRINTF,"SPX: Watchdog retry packet received on session %04x\r\n",
					sptr_spx_rx_packet->spx_header.destination_connection_id);

				return (SPX_RX_WATCHDOG_RETRY);
				}
			else
				{
				return (ILLEGAL_SPX_EVENT);
				}
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_data_ack_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	if (check_connection_control_bits (sptr_spx_rx_packet, FALSE, FALSE, FALSE, TRUE) == PASS)
		{
        if ((sptr_session->state == SPX_CONNECTED) && (sptr_session->unacked_send_ecb_list.sptr_forward_link != NULL))
			{
			if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
				{
				spx_printf (SPX_STATE_PRINTF, "SPX: Data ack packet received on session %04x\r\n",
					sptr_spx_rx_packet->spx_header.destination_connection_id);

				return (SPX_TX_DATA_ACK_RXED);
				}
			else
				{
				return (ILLEGAL_SPX_EVENT);
				}
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_watchdog_packet (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_rx_packet)
{
	if (check_connection_control_bits (sptr_spx_rx_packet,FALSE,FALSE,FALSE,TRUE) == PASS)
		{
		if (sptr_session->state == SPX_CONNECTED)
			{
			if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
				{
				spx_printf (SPX_STATE_PRINTF,"SPX: Watchdog packet received on session %04x\r\n",
					sptr_spx_rx_packet->spx_header.destination_connection_id);

				return (SPX_RX_WATCHDOG);
				}
			else
				{
				return (ILLEGAL_SPX_EVENT);
				}
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_disconnect_packet (SPX_PACKET *sptr_spx_rx_packet)
{
	if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
		{
		if (sptr_spx_rx_packet->spx_header.datastream_type == END_OF_CONNECTION)
			{
			spx_printf (SPX_STATE_PRINTF,"SPX: Disconnect packet received on session %04x\r\n",
				sptr_spx_rx_packet->spx_header.destination_connection_id);

			return (SPX_DISCONNECT_RXED);
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_disconnect_ack_packet (SPX_PACKET *sptr_spx_rx_packet)
{
	if (swap (sptr_spx_rx_packet->ipx_header.length) == (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
		{
		if (sptr_spx_rx_packet->spx_header.datastream_type == END_OF_CONNECTION_ACKNOWLEDGEMENT)
			{
			spx_printf (SPX_STATE_PRINTF,"SPX: Disconnect ack packet received on session %04x\r\n",
				sptr_spx_rx_packet->spx_header.destination_connection_id);

			return (SPX_DISCONNECT_ACK_RXED);
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
static enum SPX_EVENT check_for_data_packet (SPX_PACKET *sptr_spx_rx_packet)
{
	if (swap (sptr_spx_rx_packet->ipx_header.length) > (sizeof (IPX_HEADER) + sizeof (SPX_HEADER)))
		{
		if (check_connection_control_bits (sptr_spx_rx_packet,FALSE,FALSE,TRUE,FALSE) == PASS)
			{
			spx_printf (SPX_STATE_PRINTF,"SPX: Data received on session %04x\r\n",
				sptr_spx_rx_packet->spx_header.destination_connection_id);

			return (SPX_RX_DATA);
			}
		}

	return (UNDETERMINED_SPX_EVENT);
}
/****************************************************************************/
EVENT_CONTROL_BLOCK *find_receive_ecb (enum SPX_EVENT receive_event, SPX_SESSION_CLASS *sptr_session,
	SPX_PACKET *sptr_spx_rx_packet, USHORT number_of_bytes_received)
{
	EVENT_CONTROL_BLOCK *sptr_rx_ecb;

	sptr_rx_ecb = NULL;

	if (number_of_bytes_received > (USHORT) (swap (sptr_spx_rx_packet->ipx_header.length) + sizeof (UNION_MAC_HEADER)))
		{
/*		spx_printf (SPX_ALARM_PRINTF, "SPX: number of bytes received was adjusted\r\n"); */

		number_of_bytes_received = (USHORT) (swap (sptr_spx_rx_packet->ipx_header.length) + sizeof (UNION_MAC_HEADER));
		}

	switch (receive_event)
		{
		case SPX_CONNECTION_REQUEST_RXED:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_CONNECTION_REQUEST_RXED\r\n");

			sptr_session->remote_connection_id = sptr_spx_rx_packet->spx_header.source_connection_id;

			sptr_rx_ecb = sptr_session->sptr_listen_connect_ecb;

			sptr_rx_ecb->destination_ipx_address = sptr_spx_rx_packet->ipx_header.source;
			break;
		case SPX_CONNECTION_ACK_RXED:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_CONNECTION_ACK_RXED\r\n");

			sptr_session->remote_connection_id = sptr_spx_rx_packet->spx_header.source_connection_id;

			sptr_rx_ecb = sptr_session->sptr_connect_ecb;

			sptr_rx_ecb->destination_ipx_address = sptr_spx_rx_packet->ipx_header.source;
			break;
		case SPX_DISCONNECT_RXED:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_DISCONNECT_RXED\r\n");

			sptr_rx_ecb = sptr_session->sptr_disconnect_ecb;
			break;
		case SPX_DISCONNECT_ACK_RXED:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_DISCONNECT_ACK_RXED\r\n");

			sptr_rx_ecb = sptr_session->sptr_disconnect_ecb;
			break;
		case SPX_RX_DATA:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_RX_DATA\r\n");

			if (sptr_session->previous_unacked_packet != NULL)
			{
				sptr_rx_ecb = NULL;
				spx.statistics.number_of_rx_frames_discarded++;
				spx_printf (SPX_ALARM_PRINTF, "SPX: no receive ECB for received packet of length %d\r\n", number_of_bytes_received);

				break;
			}

			sptr_rx_ecb = (EVENT_CONTROL_BLOCK *) get_entry_from_list ((LINK *) &sptr_session->listen_ecb_list);

			if (sptr_rx_ecb == NULL)
				{
				/* If there isn't a receive ECB, the NACS module ran out of buffers,
				 * so ping him here to try to get a buffer out */

				sptr_rx_ecb = sptr_session->sptr_connect_ecb;

				if (sptr_rx_ecb == NULL)
					{
					sptr_rx_ecb = sptr_session->sptr_listen_connect_ecb;
					}

				sptr_rx_ecb->completion_code = SPX_OUT_OF_RESOURCES;

				spx_printf (SPX_DATA_PRINTF, "SPX: calling event service routine with SPX_OUT_OF_RESOURCES\r\n");

				call_ecb_esr (sptr_rx_ecb);

				sptr_rx_ecb = get_entry_from_list ((LINK *) &sptr_session->listen_ecb_list);

				if (sptr_rx_ecb == NULL)
				{
					sptr_rx_ecb = (EVENT_CONTROL_BLOCK *) table_malloc (1, sizeof (EVENT_CONTROL_BLOCK));
					if (sptr_rx_ecb == NULL)
					{
						spx.statistics.number_of_rx_frames_discarded++;
						spx_printf (SPX_ALARM_PRINTF, "SPX: no receive ECB for received packet of length %d\r\n", number_of_bytes_received);
					}
					else
					{
			
						/* Do some init of the ECB */
						sptr_rx_ecb->in_use = TRUE;
						sptr_rx_ecb->completion_code = 0;
						sptr_rx_ecb->fptr_event_service_routine = NULL;
						sptr_rx_ecb->fragment_count = 1;
						sptr_rx_ecb->fragment_descriptor[0].size_of_buffer = 1518;
						sptr_rx_ecb->fragment_descriptor[0].type.vptr_buffer = spx_get_a_send_packet(1518);
						if (sptr_rx_ecb->fragment_descriptor[0].type.vptr_buffer == NULL)
						{
							table_free(sptr_rx_ecb);

							sptr_session->previous_unacked_packet = sptr_rx_ecb = NULL;

							spx.statistics.number_of_rx_frames_discarded++;
							spx_printf (SPX_ALARM_PRINTF, "SPX: no receive ECB for received packet of length %d\r\n", number_of_bytes_received);
						}
/* Naveen 20/06/1997 Took it from start of this block */
						sptr_session->previous_unacked_packet = sptr_rx_ecb;
/* Naveen 20/06/1997 */
					}
				}
			}
			break;
		case SPX_TX_DATA_ACK_RXED:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_TX_DATA_ACK_RXED\r\n");

			sptr_rx_ecb = (EVENT_CONTROL_BLOCK *) sptr_spx_rx_packet;
			break;
		case SPX_RX_WATCHDOG:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_RX_WATCHDOG\r\n");

			sptr_rx_ecb = NULL;
			break;
		case SPX_RX_WATCHDOG_RETRY:
			spx_printf (SPX_DATA_PRINTF, "SPX: receive event is SPX_RX_WATCHDOG_RETRY\r\n");

			sptr_rx_ecb = NULL;
			break;
		default:
			spx_printf (SPX_ALARM_PRINTF, "SPX: invalid receive event on session %04x\r\n", sptr_session->connection_id);
			break;
		}

	if ((sptr_rx_ecb != NULL) && (sptr_rx_ecb != (EVENT_CONTROL_BLOCK *) sptr_spx_rx_packet))
		{
		if ((receive_event != SPX_CONNECTION_ACK_RXED) && (receive_event != SPX_DISCONNECT_ACK_RXED))
			{
			if (receive_event != SPX_CONNECTION_REQUEST_RXED)
				{
				spx_printf (SPX_ALARM_PRINTF, "SPX: processing receive ecb for data %d\r\n", number_of_bytes_received);
				}

			if (number_of_bytes_received > sptr_rx_ecb->fragment_descriptor[0].size_of_buffer)
				{
				spx_printf (SPX_ALARM_PRINTF, "SPX: receive ecb too small on session %04x\r\n", sptr_session->connection_id);

				call_ecb_esr (sptr_rx_ecb);

				return (NULL);
				}
			else
				{
				memcpy (sptr_rx_ecb->fragment_descriptor[0].type.vptr_buffer, sptr_spx_rx_packet, number_of_bytes_received);

				sptr_rx_ecb->fragment_descriptor[0].size_of_buffer = (USHORT) (number_of_bytes_received -
					(sizeof (UNION_MAC_HEADER) + sizeof (IPX_HEADER) + sizeof (SPX_HEADER)));
				}
			}
		}

	return (sptr_rx_ecb);
}
/****************************************************************************/
static enum TEST check_connection_control_bits (SPX_PACKET *sptr_spx_rx_packet,enum BOOLEAN end_of_message,
	enum BOOLEAN attention,enum BOOLEAN ack_required,enum BOOLEAN system_packet)
{
/* Sachin */
#if 0

	if (sptr_spx_rx_packet->spx_header.connection_control._bit.end_of_message != (unsigned int) end_of_message)
		{
		return (FAIL);
		}

	if (sptr_spx_rx_packet->spx_header.connection_control._bit.attention != (unsigned int) attention)
		{
		return (FAIL);
		}

#endif
/* Sachin */

	if (sptr_spx_rx_packet->spx_header.connection_control._bit.ack_required != (unsigned int) ack_required)
		{
		return (FAIL);
		}

	if (sptr_spx_rx_packet->spx_header.connection_control._bit.system_packet != (unsigned int) system_packet)
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
enum SPX_RETURN_CODE spx_listen_for_connection (BYTE number_of_connection_retries, enum BOOLEAN watchdog,
	ULONG *ulptr_session_handle, EVENT_CONTROL_BLOCK *sptr_listen_connect_ecb,
	EVENT_CONTROL_BLOCK *sptr_disconnect_ecb)
{
	SPX_SESSION_CLASS *sptr_session;
	enum SPX_RETURN_CODE return_code;

	return_code = spx_open_socket (&sptr_listen_connect_ecb->socket_number);

/*
	if (return_code == SPX_IPX_SOCKET_IN_USE)
		{
		spx_close_socket (sptr_listen_connect_ecb->socket_number);

		return (SPX_SOCKET_NOT_FOUND);
		}
*/

	if (return_code == SPX_SOCKET_TABLE_FULL)
		{
		return (SPX_SOCKET_NOT_FOUND);
		}

	sptr_session = (SPX_SESSION_CLASS *) table_malloc (1, sizeof (SPX_SESSION_CLASS));

	if (sptr_session == NULL)
		{
	 	spx_printf (SPX_ALARM_PRINTF, "SPX: table_malloc failed\r\n");

		return (SPX_OUT_OF_RESOURCES);
		}

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated SESSION %p\n", sptr_session);

	if (set_connection_number (sptr_session) == FAIL)
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SESSION %p\n", sptr_session);

		table_free (sptr_session);

		return (SPX_CONNECT_TABLE_FULL);
		}

	sptr_listen_connect_ecb->session_handle = (ULONG) sptr_session;

	sptr_session->sptr_listen_connect_ecb = sptr_listen_connect_ecb;

	if (number_of_connection_retries > 0x00)
		{
		sptr_session->number_of_connection_retries = number_of_connection_retries;
		sptr_session->number_of_data_retries = number_of_connection_retries;
		}
	else
		{
		sptr_session->number_of_connection_retries = spx.number_of_connection_retries;
		sptr_session->number_of_data_retries = spx.number_of_data_retries;
		}

	sptr_session->current_number_of_connection_retries = 0x0000;
	sptr_session->socket = sptr_listen_connect_ecb->socket_number;
	sptr_session->watchdog = watchdog;
	sptr_session->ack_timeout = spx.ack_timeout;
	sptr_session->watchdog_timeout = spx.watchdog_timeout;
	sptr_session->sptr_disconnect_ecb = sptr_disconnect_ecb;
	sptr_session->previous_unacked_packet = NULL;

	add_entry_to_list ((LINK *) &spx.session_list, (LINK *) &sptr_session->links);

	execute_spx_state_machine (SPX_LISTEN_FOR_CONNECTION, sptr_session, sptr_listen_connect_ecb);

	*ulptr_session_handle = (ULONG) sptr_session;

	++spx.number_of_listen_connections;

	return (SPX_SUCCESSFUL);
}
/****************************************************************************/
void spx_listen_for_sequenced_packets (ULONG connection_handle, EVENT_CONTROL_BLOCK *sptr_listen_ecb)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_session = (SPX_SESSION_CLASS *) connection_handle;

	++sptr_session->allocation_number;

	sptr_listen_ecb->completion_code = SPX_SUCCESSFUL;

	if (sptr_session->previous_unacked_packet != NULL)
	{
		if (sptr_listen_ecb->fragment_descriptor[0].size_of_buffer < 
				sptr_session->previous_unacked_packet->fragment_descriptor[0].size_of_buffer)
		{
			/* Insufficient buffer. So arrange so that normal SPX actions will
			** take place.
			*/

			spx_free_a_send_packet(sptr_session->previous_unacked_packet->fragment_descriptor[0].type.vptr_buffer);
			table_free(sptr_session->previous_unacked_packet);
			sptr_session->previous_unacked_packet = NULL;

			add_entry_to_list ((LINK *) &sptr_session->listen_ecb_list, (LINK *) &sptr_listen_ecb->links);
		}
		else
		{
			memcpy(sptr_listen_ecb->fragment_descriptor[0].type.vptr_buffer, 
				sptr_session->previous_unacked_packet->fragment_descriptor[0].type.vptr_buffer,
				sptr_listen_ecb->fragment_descriptor[0].size_of_buffer);

			sptr_listen_ecb->fragment_descriptor[0].size_of_buffer =
				sptr_session->previous_unacked_packet->fragment_descriptor[0].size_of_buffer;

			spx_free_a_send_packet(sptr_session->previous_unacked_packet->fragment_descriptor[0].type.vptr_buffer);
			table_free(sptr_session->previous_unacked_packet);
			sptr_session->previous_unacked_packet = NULL;

			call_ecb_esr (sptr_listen_ecb);

	 		spx_send_data_ack_packet (sptr_session);
		}
	}
	else
	{
		add_entry_to_list ((LINK *) &sptr_session->listen_ecb_list, (LINK *) &sptr_listen_ecb->links);
	}
}
/****************************************************************************/
void spx_watchdog_packet_received (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);

	if (sptr_session->watchdog == TRUE)
		{
		spx_printf (SPX_STATE_PRINTF,"SPX: Watchdog Rx timer on watchdog %08lx\r\n",sptr_session->time_since_last_watchdog_packet_rxed);

		sptr_session->current_number_of_watchdog_retries = 0x0000;
		sptr_session->time_since_last_watchdog_packet_rxed = 0x00000000L;
		}
}
/****************************************************************************/
void spx_watchdog_retry_packet_received (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);

	sptr_session->current_number_of_watchdog_retries = 0x0000;
	sptr_session->time_since_last_watchdog_packet_rxed = 0x00000000L;

	spx_send_internal_packet (sptr_session,SPX_WATCHDOG_PACKET);
}
/****************************************************************************/
void spx_pass_rx_packet_to_upper_layer (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);

	++sptr_session->remote_sequence_number;
	++sptr_session->remote_ack_number;

	if (sptr_session->previous_unacked_packet == NULL)
	{
		sptr_ecb->completion_code = SPX_SUCCESSFUL;

		call_ecb_esr (sptr_ecb);

	 	spx_send_data_ack_packet (sptr_session);
	}

	++spx.statistics.number_of_rx_frames;
}
/****************************************************************************/
void spx_data_ack_received (SPX_SESSION_CLASS *sptr_session, SPX_PACKET *sptr_spx_ack_packet,
	enum SPX_CONNECTION_STATE end_state)
{
	EVENT_CONTROL_BLOCK *sptr_send_ecb;
	USHORT acked_transmits;

	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_spx_ack_packet);

	acked_transmits = (USHORT) (sptr_session->ack_number - sptr_session->last_ack_number);

	if (acked_transmits > UNREASONABLE_WINDOW_SIZE)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: Wrong ack received for data ack %04x, lastack %04x\r\n", sptr_session->ack_number,
			sptr_session->last_ack_number);
		}

	/* Any receive activity will inhibit watchdogs - You don't have to send */

	if (sptr_session->watchdog == TRUE)
		{
		sptr_session->current_number_of_watchdog_retries = 0x0000;
		sptr_session->time_since_last_watchdog_packet_rxed = 0x00000000L;
		}

	sptr_send_ecb = get_pointer_to_first_entry_in_list ((LINK *) &sptr_session->unacked_send_ecb_list);

	while (acked_transmits-- != 0x0000)
		{
		if (sptr_send_ecb == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: Unacked Queue Mismatch\r\n");

			break;
			}

		if ((swap (sptr_send_ecb->fragment_descriptor[0].type.sptr_spx_packet->spx_header.sequence_number)) ==
			sptr_session->last_ack_number)
			{
			delete_entry_from_list ((LINK *) &sptr_session->unacked_send_ecb_list, (LINK *) sptr_send_ecb);

			/* Reset dta retry count and ack timer when ack received */

			sptr_session->current_number_of_data_retries = 0x0000;
			sptr_session->time_since_last_data_ack_packet_rxed = 0x00000000L;

			++sptr_session->last_ack_number;

			call_ecb_esr (sptr_send_ecb);
			}
		else
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: Wrong ack received for data sent %04x, rxed %04x\r\n",
				swap (sptr_send_ecb->fragment_descriptor[0].type.sptr_spx_packet->spx_header.sequence_number),
				sptr_session->last_ack_number);

			sptr_send_ecb = get_pointer_to_next_entry_in_list ((LINK *) sptr_send_ecb);
			}

		}

	kickstart_transmit_queues (sptr_session);
}
/****************************************************************************/
void check_hop_count (SPX_SESSION_CLASS *sptr_session,BYTE hop_count)
{
	if (hop_count > 0x00)
		{
		sptr_session->ack_timeout += 0x00000002L;
		sptr_session->watchdog_timeout += 0x00000002L;
		}
}
