#include "defs.h"
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "spx.h"
/*****************************************************************************************/
static enum TEST spx_wait_for_connection_to_be_set_up (USER_SOCKET *sptr_user_socket);
static enum TEST convert_socket_address_to_ipx_address (IPX_ADDRESS *sptr_ipx_address, SOCKADDR_IPX *sptr_socket_ipx_address);
static void autobind (USER_SOCKET *sptr_user_socket);
/*****************************************************************************************/
enum TEST socket_spx (USER_SOCKET *sptr_user_socket, USHORT protocol)
{
	PARAMETER_NOT_USED (protocol);

	sptr_user_socket->socket_type_of_service = TYPE_SPX;

	return (PASS);
}
/*****************************************************************************************/
enum TEST socket_spx_listen (USER_SOCKET *sptr_user_socket, USHORT mode)
{
	IPX_ADDRESS local_address;

	PARAMETER_NOT_USED (mode);
	
	convert_socket_address_to_ipx_address (&local_address, (SOCKADDR_IPX *) sptr_user_socket->vptr_address);

	sptr_user_socket->vptr_protocol_control_block = (void *) spx_listen_connect (sptr_user_socket, local_address, mode);

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		return (FAIL);
		}

	return (PASS);
}
/*****************************************************************************************/
enum TEST socket_spx_connect (USER_SOCKET *sptr_user_socket)
{
	IPX_ADDRESS local_address;
	IPX_ADDRESS remote_address;

	if (sptr_user_socket->connection_initiated == FALSE)
		{
		/* if connection is not yet initiated */

		if (sptr_user_socket->vptr_address == NULL)
			{
			autobind (sptr_user_socket);
			}

		convert_socket_address_to_ipx_address (&local_address, (SOCKADDR_IPX *) sptr_user_socket->vptr_address);

		convert_socket_address_to_ipx_address (&remote_address, (SOCKADDR_IPX *) sptr_user_socket->vptr_peer_address);

		sptr_user_socket->vptr_protocol_control_block = (void *) spx_establish_connection (sptr_user_socket, local_address,
			remote_address);

		if (sptr_user_socket->vptr_protocol_control_block != NULL)
			{
			sptr_user_socket->connection_initiated = TRUE;
			}
		else if (sptr_user_socket->vptr_protocol_control_block == NULL)
			{
			return (FAIL);
			}
		}

	/* Wait for the connection to complete */

	if (spx_wait_for_connection_to_be_set_up (sptr_user_socket) == FAIL)
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST spx_wait_for_connection_to_be_set_up (USER_SOCKET *sptr_user_socket)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	SPX_SESSION_CLASS *sptr_session;

	sptr_ecb_socket_entry = (SPX_ECB_SOCKET_LIST_ENTRY *) sptr_user_socket->vptr_protocol_control_block;

	if (sptr_ecb_socket_entry == NULL)
		{
		return (FAIL);
		}
		
	sptr_session = (SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle;

	while ((sptr_session != NULL) && (sptr_session->state != SPX_CONNECTED))
		{
		if (sptr_user_socket->do_not_block == TRUE)
			{
			/* If non-blocking socket interface is used this is where control returns to the application. With non-blocking
			 * more than one application can be waiting on a socket */

			(*spx.socket_fptrs.fptr_set_socket_class_error_number) (WOULD_BLOCK_ERROR);

		 	spx_printf (SPX_ALARM_PRINTF, "SPX: WAITING for connection to be established\n");

			return (FAIL);
			}
		else
			{
			/* For operating systems that support multiple processes this where the process goes to sleep waiting on the socket.
			 * Routerware's socket library does not support blocking on multiple sockets. It supports blocking only on a single
			 * socket. Blocking on multiple sockets or putting the process to sleep etc. should be done by using the operating
			 * system facilities provided by the customer's environment and is the responsibility of the customer. */

		 	spx_printf (SPX_ALARM_PRINTF, "SPX: ERROR: SPX does not support BLOCKING on sockets\n");
			}
		}

	if (sptr_session == NULL)
		{
		/* Probably got refused */

		if (sptr_user_socket->vptr_peer_address != NULL)
			{
		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing socket peer address %p\n", sptr_user_socket->vptr_peer_address);

			table_free (sptr_user_socket->vptr_peer_address);

			sptr_user_socket->vptr_peer_address = NULL;
			}

		(*spx.socket_fptrs.fptr_set_socket_class_error_number) (CONNECTION_REFUSED_ERROR);

		return (FAIL);
		}

	return (PASS);
}
/*****************************************************************************************/
USHORT socket_spx_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_address_length, enum TEST *eptr_error)
{
	USHORT count;
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	PARAMETER_NOT_USED (sptr_sockaddr);
	PARAMETER_NOT_USED (usptr_address_length);

	count = 0x0000;

	sptr_ecb_socket_entry = (SPX_ECB_SOCKET_LIST_ENTRY *) sptr_user_socket->vptr_protocol_control_block;

	if (sptr_ecb_socket_entry == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}
		
	sptr_ecb_with_packet = (ECB_WITH_PACKET *) sptr_ecb_socket_entry->rx_ecb_list.sptr_forward_link;

	if (sptr_ecb_with_packet == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}
		
	while (sptr_ecb_with_packet != NULL)
		{
		count = spx_get_data_from_ecb (sptr_ecb_socket_entry, &sptr_ecb_with_packet, vptr_data, length);

		if (count != 0x0000)
			{
			break;
			}
		else if (sptr_user_socket->do_not_block == TRUE)
			{
			/* If non-blocking socket interface is used this is where control returns to the application. With non-blocking
			 * more than one application can be waiting on a socket */

			(*spx.socket_fptrs.fptr_set_socket_class_error_number) (WOULD_BLOCK_ERROR);

			*eptr_error = FAIL;

			return (0x0000);
			}
		else
		  {
			/* For operating systems that support multiple processes this where the process goes to sleep waiting on the socket.
			 * Routerware's socket library does not support blocking on multiple sockets. It supports blocking only on a single
			 * socket. Blocking on multiple sockets or putting the process to sleep etc. should be done by using the operating
			 * system facilities provided by the customer's environment and is the responsibility of the customer. */

		 	spx_printf (SPX_ALARM_PRINTF, "SPX: ERROR: SPX does not support BLOCKING on sockets\n");
		  }
		}

	if (sptr_ecb_socket_entry == NULL)
		{
		/* Connection went away */

		(*spx.socket_fptrs.fptr_set_socket_class_error_number) (NOT_CONNECTED_ERROR);

		*eptr_error = FAIL;

		return (0x0000);
		}

	return (count);
}
/*****************************************************************************************/
USHORT socket_spx_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;

	PARAMETER_NOT_USED (sptr_sockaddr);

	sptr_ecb_socket_entry = (SPX_ECB_SOCKET_LIST_ENTRY *) sptr_user_socket->vptr_protocol_control_block;

	if (sptr_ecb_socket_entry == NULL)
		{
		(*spx.socket_fptrs.fptr_set_socket_class_error_number) (NOT_CONNECTED_ERROR);

		*eptr_error = FAIL;

		return (0x0000);
		}

	length = spx_send_data (sptr_ecb_socket_entry, vptr_data, length);

	if (length == 0x0000)
		{
		*eptr_error = FAIL;
		}

	return (length);
}
/*****************************************************************************************/
enum TEST socket_spx_close (USER_SOCKET *sptr_user_socket)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;

	sptr_ecb_socket_entry = (SPX_ECB_SOCKET_LIST_ENTRY *) sptr_user_socket->vptr_protocol_control_block;

	if (sptr_ecb_socket_entry != NULL)
		{
	   spx_terminate_connection (sptr_ecb_socket_entry->session_handle, &sptr_ecb_socket_entry->disconnect_ecb.ecb);

		sptr_ecb_socket_entry->connection_terminated = TRUE;
		}

	return (PASS);
}
/*****************************************************************************************/
enum TEST spx_check_ipx_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length)
{
	SOCKADDR_IPX *sptr_sockaddr_ipx;

	sptr_sockaddr_ipx = (SOCKADDR_IPX *) sptr_sockaddr;

	if ((sptr_sockaddr_ipx->family != AF_NETWARE) || (sockaddr_length < sizeof (SOCKADDR_IPX)))
		{
		return (FAIL);
		}

	return (PASS);
}
/*************************************************************************/
static enum TEST convert_socket_address_to_ipx_address (IPX_ADDRESS *sptr_ipx_address, SOCKADDR_IPX *sptr_sockaddr_ipx)
{
	if (spx_check_ipx_address ((SOCKADDR *) sptr_sockaddr_ipx, sizeof (SOCKADDR)) == PASS)
		{
		memcpy (sptr_ipx_address, &sptr_sockaddr_ipx->ipx_address, sizeof (sptr_sockaddr_ipx->ipx_address));

		sptr_ipx_address->socket = sptr_sockaddr_ipx->port;

		return (PASS);
		}

	return (FAIL);
}
/*****************************************************************************************/
/* Issue an automatic bind of a local address */

static void autobind (USER_SOCKET *sptr_user_socket)
{
	SOCKADDR_IPX local_sockaddr_ipx;

	local_sockaddr_ipx.family = AF_NETWARE;

	memset (&local_sockaddr_ipx.ipx_address[0], '0x00', sizeof(local_sockaddr_ipx.ipx_address));

	local_sockaddr_ipx.port = (*spx.socket_fptrs.fptr_get_number_of_already_allocated_ports_in_socket_class) ();

	++local_sockaddr_ipx.port;

	(*spx.socket_fptrs.fptr_set_number_of_already_allocated_ports_in_socket_class) (local_sockaddr_ipx.port);

	(*spx.socket_fptrs.fptr_bind) ((int) sptr_user_socket->socket_descriptor, (SOCKADDR *) &local_sockaddr_ipx,
		sizeof (SOCKADDR_IPX));
}
