/*	TCP.H -- structs related to TCP implemenation
** Modifications : sudha 15-Oct-1999. Put in fixes taken from ras tcp code
**						 in TCP_PER_CONN structure definition.
*/

/* General Notes:
** 	In all timer related constants below, values are given as number
**			of times the timer routine is called. The timer routine is called
**			once every 50ms. So (for example) a value of 10 implies 500ms has 
**			elapsed. i.e all timer values are computed as "ticks".
*/

#ifndef _TCPH_
#define _TCPH_

#define NUM_TCP_STATES	12

enum ACK_TYPES { DELAYED_ACK, IMMEDIATE_ACK };

/* Client, Server open modes */
enum OPEN_TYPES { ACTIVE_OPEN, PASSIVE_OPEN, UNKNOWN_OPEN };

#define DEF_RECV_WIN_SIZE		1536				/* Rx win is this many bytes */
#define DEF_SEND_WIN_SIZE		1536				/* Tx win is this many bytes */
#define DEF_TCP_MSS				536				/* Def. max segment size */

#define MAX_RTX_RETRIES			10					/* Mumber of retransmit retries */

#define RECV_MSS					1500				/* Max seg size the receiver
															** will advertise
															*/
#define DEF_TOS					0					/* Default type of service */

/* Time related stuff */
#if defined(__MS_DOS__)
#define MSPT					55							/* 55 milliseconds/tick */
#else /* __MS_DOS__ */
#define MSPT					50							/* 50 milliseconds/tick */
#endif /* __MS_DOS__ */
#define STMS					1000						/* Multiplier - Sec To MSec */
/* from now on all time in "ticks" */
#define TWO_MSL				((240 * STMS) / MSPT)/* 240 seconds is 2*MSL */
#define DEF_CONN_IDLE_TIME	(TWO_MSL * 4)			/* Arbitary value */
#define MAX_RTX_TIMEOUT		TWO_MSL
#define MIN_RTX_TIMEOUT		(1)			 			/* atleast 40ms */
#define DEF_RTO				((3 * STMS) / MSPT)	/* 3 second first-time RTO 
																** estimate
																*/
#define MAX_ACK_DELAY		(200 / MSPT)			/* max 200ms delaying of ACK's */
#define DEF_CONNECT_RTO		((1 * STMS) /MSPT)		/* 1 second first-time */

/* Specs recommend a value of 10 for below constant. Ours is a telnet app.
** This much should do.
*/
#define MAX_ALIVE_PROBE_RETRIES	5					/* No. of times a keep-alive
																** probe will be sent before
																** connection is reset.
																*/
#define ALIVE_PROBE_INTERVAL	 ((75 * STMS) / MSPT)/* 75 sec probe interval */


/* Bit flags used in the 'conn_flags' field of the connection record */
/* None of these flags are valid when in the CLOSED state */
#define TCPF_NEEDACK				0x00000001L		/* Need to send out an ACK seg */
/* #define TCPF_NEEDRTX				0x00000002L		*/ /* Need the retransmit timer */
															/* to tick and then go to 0 and */
															/* then cause retransmission */
#define TCPF_RECVPSH				0x00000004L		/* A segment with PSH bit was */
															/* detected recently */
/* #define TCPF_RECVURG				0x00000008L		*/ /* Some urgent data was found */
#define TCPF_SENDFIN				0x00000010L		/* If this flag is detected to 
															** to be on by any send, a FIN
															** is sent if all data has been
															** sent and state changed approp
															*/
#define TCPF_SENDPSH				0x00000020L		/* Force a send irrespective
															** of amount in send window 
															*/
#define TCPF_TIMEACK				0x00000040L		/* Can use the time estimate
															** for current ack to calc RTO
															*/
#define TCPF_RTXON				0x00000080L		/* A retransmit has occured so
															** ignore ACK's for RTO estimates
															*/
#define TCPF_CONNPENDING		0x00000100L		/* A connection is in SYN_RCVD
															** state and is awaiting an ACK
															** Listen won't succeed until
															** this flag is reset.
															*/
#define TCPF_CONNFIN				0x00000200L		/* This flag set implies conn
															** has seen FIN in sequence and 
															** can receive no more data.
															*/
#define TCPF_ALIVEPROBE			0x00000400L		/* Bit set indicates a keep-alive
															** probe has been sent. If so,
															** a 75 second timer (specs say
															** 75, we will use 100 sec timer)
															** is set and on expiry another
															** probe is sent. Done 9 times.
															*/

/* Some IP info that will be extracted from the IP packet and placed into
** the connection record initially. Note the reversed order of source and
** destination info as maintained in the record. Address are w.r.t pkt that
** came in.
*/
typedef struct IP_INFO {
	IPADDR source_address;							/* IP addr from where pkt came */
	IPADDR destination_address;					/* "This" machine's IP address */
} IP_INFO;

/* Retransmission info record -- A queue (singly linked list) of such 
** records is maintained on a per-connection basis for segments that have
** been sent and not yet acknowledged
** NOTE: 
**		That unack'ed segments are retained in the send window buffer itself
**			and only info related to that is maintained in this record.
*/
typedef struct RTX_INFO_RECORD {
	struct RTX_INFO_RECORD *next_rtx_record_ptr;
	TCPSEQ rtx_seg_seq_num;
	ULONG	rtx_seg_len;
} RTX_INFO_RECORD;

/* Per connection information -- connection record or connection entry */
/* A connection record is free if 'tcp_state' is CLOSED and in this state, */
/* other fields do not have any meaning. All ptrs are invalid when NULL. */
/* NOTE: When a listen succeeds, a new connection record is allocated and */
/*			required portions of the listen record are copied over to this */
/*			new record. So take care when introducing new fields. */
typedef struct tcp_conn {

	/* generally static info */
	IPADDR		local_addr;					 	/* local host IP addr */
	IPADDR		remote_addr;					/* foreign host IP addr */
	USHORT		local_port;						/* local port number */
	USHORT		remote_port;					/* foreign port number */
	USER_SOCKET *socket_record_ptr;			/* ptr to socket record related 
														** to this connection
														*/
	struct tcp_conn *parent_conn_rec_ptr;	/* ptr to listen conn record that
														** started this conn
														*/
	enum TCP_STATES	tcp_state;				/* current state of connection */
	enum OPEN_TYPES	tcp_open;				/* passive or active? */
	USHORT		conn_error;						/* error code for conn error */
	ULONG			conn_flags;						/* some bit flags used in the
														** lifetime of a connection 
														*/
	ULONG			conn_alive_timer;				/* keeps track of conn. aliveness; 
														** init-ed to max on activity;
														** decremented regulary; 0 means
														** conn should be aborted
														*/
	BYTE			conn_probe_retries;			/* times the connection alive probe
														** has been sent
														*/
	ULONG			two_msl_timer;					/* 2MSL timer */

	/* info related to the packet just received */
	/* the below info is not valid all the time -- only for the duration */
	/* of processing a segment that has come in */
	IP_INFO 		seg_ip_params;					/* IP info for seg that came in */
	BYTE *		seg_header;						/* ptr to the header of new seg */
	BYTE *		seg_options;					/* ptr to the options fields */
	BYTE *		seg_data;						/* ptr to the actual seg data */
	USHORT		seg_len;							/* length of new seg excluding */
														/* header and option fields len */
	USHORT		temp_mss;						/* tentative mss as picked up */
														/* from option field of new seg */

	/* send and send window related info */
	/* send_nxt == send_una => send window is empty */
	TCPSEQ		init_send_seq_num;			/* ISN */
	TCPSEQ		send_nxt;						/* next octet to send */
	TCPSEQ		send_una;						/* last unack'ed octet */
	BYTE *		send_buf;						/* ptr to send window buffer */
	ULONG			send_filled;					/* count of bytes freshly added */
	ULONG			send_una_amount;				/* amount of unack'ed data */
	ULONG			send_bstart;					/* index to first unack'ed byte */
	ULONG			send_bnext;						/* index to first fresh byte */
	ULONG			send_persist_timer;			/* persist timer */

	ULONG			send_buf_size;					/* maximum send window size */
	ULONG 		send_wnd;						/* current send window size */
	ULONG			send_max_advert;				/* max of advertised send windows */
	TCPSEQ 		send_lwseq;						/* seq num for last win update */
	TCPSEQ 		send_lwack;						/* ack num for last win update */
	USHORT		send_mss;						/* max seg size to use on send's */

	/* recv related info */
	TCPSEQ		init_recv_seq_num;			/* initial receive sequence num */
	TCPSEQ 		recv_nxt;						/* next sequence number to recv */
	BYTE *		recv_buf;						/* receive window buffer */
	ULONG			recv_filled;					/* bytes in window that have been */
														/* received and not picked up by app */
	ULONG			recv_first;						/* index to first byte received */

	ULONG 		recv_buf_size;					/* max recv window size */
	ULONG			recv_last_advert;				/* last advertised window value */

	/* retransmit globals */
	ULONG			rtx_counter;					/* count up to retransmit time if
														** any elements in the retransmit
														** queue
														*/
	BYTE			rtx_retries;					/* number of retries for re-tx */
	RTX_INFO_RECORD *rtx_queue;				/* linked list of info records on
														** unacked segments 
														*/

	/* retransmit timeout calculation related stuff */
	ULONG			last_seg_sent_tick;			/* tick when last segment was sent;
														** this is used when ack for the
														** segment is received to calc RTT;
														** valid only if the TCPF_TIMEACK 
														** bit is set in 'conn_flags'
														*/
	ULONG			seg_for_rtt_estimate;		/* sequence number of segment that
														** will be used for next RTT
														** estimate
														*/
	ULONG			rtx_timeout;					/* retransmit timeout (RTO) */
	ULONG			srtt;								/* smoothed round-trip-time */
	ULONG			srtt_deviation;				/* SRTT deviation */

/* sudha 15-Oct-1999.Taken 2 additional parameters from ras tcp code */
	void			(*urgent_data_handler)(USER_SOCKET *, ULONG offset, USHORT length);/* Urgent data handler */
} TCP_PER_CONN;

#endif

