/*
** TCPABORT.C -- Code that handles aborting a TCP session
** Modifications : sudha 15-Oct-1999. In tcp_abort() function, fix from
**						 ras tcp has taken.	
*/

/* General Notes:
** 	In the RouterWare method of implementation, everything runs is the
**		foreground and there is no method of callbacks or signalling. So
**		when aborting, it is not possible to signal apps that may issue a
**		read or write telling them that the connection associated with the
**		socket is to be aborted. Instead, we make a call to the socket
**		routines telling the socket library to set an error code and 
**		dissociate sockets using the port being aborted from the port. The
**		socket library will clean up its socket record only when the app
**		has issued a socket library call and has realised that the 
**		connection has aborted.
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"


/*
** tcp_abort()
**		Called to terminate a currently active connection.
** Params:
**		Ptr to connection record
**		Error to report to socket lib
*/
void
tcp_abort(TCP_PER_CONN *ptr_conn_info, int errno)
{
/* sudha 15-Oct-1999.Taken from ras tcp code... */
/*
Satish, 27th Jan 1998.
If there's connection abort in the SYN_RCVD state, make sure you
you reset the CONNPENDING flag of the listen record (which will
be the parent record in this case) so that further listen's go
thru
*/
	if (ptr_conn_info->tcp_state == SYN_RCVD)
	{
		if (ptr_conn_info->parent_conn_rec_ptr)
		{
			ptr_conn_info->parent_conn_rec_ptr->conn_flags &= ~TCPF_CONNPENDING;

		}
	}
/* ...sudha 15-Oct-1999.Taken from ras tcp code */

	if (ptr_conn_info->socket_record_ptr == NULL)
	{
		/* If there is no assoicate socket currently, then directly free this
		** connection record. 
		*/

#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: tcp_abort() connection set to FREE\n");
#endif /* DEBUG */

		ptr_conn_info->conn_error = 0;
		free_tcp_conn_record(ptr_conn_info);
	}
	else
	{
		/* Else set state the CLOSED and free record later when app comes to
		** know of this.
		*/

#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: tcp_abort() connection set to CLOSED\n");
#endif /* DEBUG */

		/* Turn off flags that may cause inconsistent operation */
		ptr_conn_info->conn_flags = 0;

		/* Set error code that will be read by a later socket lib call */
		ptr_conn_info->conn_error = errno;

		tcp_printf(TCP_STATES_PRINTF, "TCP: Moved from %s to CLOSED state\n", 
				get_state_string(ptr_conn_info->tcp_state));
		ptr_conn_info->tcp_state = CLOSED;
	}
}

/*
** tcp_quiet_abort()
**		Called to terminate a currently active connection without informing
**		socket guys. Used when socket guys are not yet inited properly.
** Params:
**		Ptr to connection record
*/
void
tcp_quiet_abort(TCP_PER_CONN *ptr_conn_info)
{
#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: Quiet abort...\n");
#endif /* DEBUG */
	free_tcp_conn_record(ptr_conn_info);
}

