/*
** TCPPROBE.C -- Has code to prepare a probe packet and send on a 
**					  connection if the advertised window is 0.
** Modifications : sudha 15-Oct-1999. Put in fixes taken from ras tcp code
**						 in tcp_persist() function.	
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

void
tcp_persist(TCP_PER_CONN *ptr_conn_info)
{
	BYTE *ptcpbuf;
	TCP_HEADER tcp_header;


	if (ptr_conn_info->send_filled == 0)
		return;

#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: Persisting...persist timeout = %d\n", tcp.min_rtx_timeout);

	if (ptr_conn_info->send_wnd != 0)
	{
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: !@!@! Persist function called though not zero window\n");
	}

	if (ptr_conn_info->rtx_queue != NULL)
	{
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: !@!@! Persist function called though rtx queue non-empty\n");
	}

#endif /* DEBUG */

	ptcpbuf = tcp_get_user_buffer(sizeof(TCP_HEADER) + 1);
	if (ptcpbuf == NULL)
	{
		tcp_printf(TCP_ALARM_PRINTF, "TCP: Insufficient memory for send (send will be delayed)\n");
		return;
	}
	
	/* Fill in the header */
	tcp_header.src_port = ptr_conn_info->local_port;
	tcp_header.dst_port = ptr_conn_info->remote_port;
	tcp_header.seq_num = ptr_conn_info->send_nxt;
	tcp_header.ack_num = ptr_conn_info->recv_nxt;
	ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;
	tcp_header.code_and_hlen.code_and_hdrlen_word = 0;
	tcp_header.code_and_hlen.code_and_hdrlen.hlen = 
																sizeof(TCP_HEADER) / 4;
	TURN_ACK_ON(&tcp_header);
	if ((ptr_conn_info->conn_flags & TCPF_SENDPSH) != 0)
	{
		TURN_PSH_ON(&tcp_header);
		ptr_conn_info->conn_flags &= ~TCPF_SENDPSH;
	}
	tcp_header.win_size = tcp_recv_wnd(ptr_conn_info);
	tcp_header.urg_ptr = 0;

	/* to network format we go... */
	tcp_hdr_hton((TCP_HEADER *)ptcpbuf, &tcp_header);
	
	/* 1-octet data to probe */
	ptcpbuf[sizeof(TCP_HEADER)] = (ptr_conn_info->send_buf)
												[ptr_conn_info->send_bnext];

/* sudha 15-Oct-1999. Taken from ras tcp code... */
#ifdef INTERNET_TYPE_OF_SERVICE_BUG
	/* send packet on its way to IP */
	send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			ptr_conn_info->socket_record_ptr->internet_type_of_service,
			ptcpbuf, sizeof(TCP_HEADER) + 1, FALSE);
#endif

	send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			0,
			ptcpbuf, sizeof(TCP_HEADER) + 1, FALSE);

/* ...sudha 15-Oct-1999. Taken from ras tcp code */

	/* Put segment on retransmit queue */
	add_to_tcp_rtx_queue(ptr_conn_info, ptr_conn_info->send_nxt, 1);

	/* Update 'nxt' and 'bnext' and 'filled' */

/* Sudha & Brindha while doing AG.11 March 1999 */
	ptr_conn_info->send_una_amount += 1; 
	ptr_conn_info->send_filled -= 1;
	ptr_conn_info->send_nxt += 1;
	ptr_conn_info->send_bnext = (1 + ptr_conn_info->send_bnext) 
											% ptr_conn_info->send_buf_size;
}

