/*
** TCPSEND.C -- Code that performs the actual sending of data in the send
**					  window.
** Modifications : sudha 15-Oct-1999. Put in fixes taken from ras tcp code
**						 in tcp_send() function.	
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_send()
** 	Send all "new" bytes available in the send window onto the network.
**		The bytes may be sent as multiple segments. When called, this
**		routine assumes that the decision as to whether to send or not
**		has already been made.
** Params:
**		Ptr to the connection record to perform send for
** NOTE:
**		This send is NOT invoked on retransmits.
*/
void
tcp_send(TCP_PER_CONN *ptr_conn_info)
{
	BYTE *ptcpbuf, *pdata;
	TCP_HEADER tcp_header;
	ULONG to_send, current_send, i;
	ULONG first_to_send, last_seg_seq;
	enum BOOLEAN send_truncated = FALSE;


	if (ptr_conn_info->send_wnd == 0)
	{
		/* Send window throttled out of existence -- cannot send */
		return;
	}

	to_send = ptr_conn_info->send_filled;
	first_to_send = ptr_conn_info->send_bnext;


/*
Satish, 22nd April 1997.
window size checking was not correct. If two packets each with a size less than
the current send but together more than the send window size arrive  we were
transmitting the packet. Used the variable send_una_amount to now determine the
actual size that can be sent. ( send window size - unacked send amount)
*/

	/* Truncate to receiver advertised window if required */
	if (to_send > (ptr_conn_info->send_wnd - ptr_conn_info->send_una_amount))
	{
		to_send = ptr_conn_info->send_wnd - ptr_conn_info->send_una_amount;
		send_truncated = TRUE;
	}
   if (to_send == 0)
	{
		return;
	}
	/* 'to_send' bytes to send - acquire a buffer, copy from send window
	**	to the buffer, call IP to send the packet and init for retransmit
	** immediately.
	** ALSO, 'to_send' bytes may be larger than the MSS, so truncate into
	** multiple segments and send
	** ALSO piggy-back receive side ACK's and clear the ACK pending flag
	**	if required.
	*/

	/* Let this loop go thro' atleast once to allow for just control packs */
	do 
	{
		/* Take care of segment size restrictions */
		if (to_send > ptr_conn_info->send_mss)
			current_send = ptr_conn_info->send_mss;
		else 
			current_send = to_send;

		ptcpbuf = tcp_get_user_buffer(current_send + sizeof(TCP_HEADER));
		if (ptcpbuf == NULL)
		{
			/* ?? MIB ?? */
			return;			/* can't send -- no buffers */
		}
		pdata = ptcpbuf + sizeof(TCP_HEADER);
		for (i = 0; i < current_send; i++)
		{
			pdata[i] = (ptr_conn_info->send_buf)[first_to_send];
			first_to_send = (first_to_send + 1) % ptr_conn_info->send_buf_size;
		}

		/* Prepare TCP header */
		tcp_header.src_port = ptr_conn_info->local_port;
		tcp_header.dst_port = ptr_conn_info->remote_port;
		last_seg_seq = tcp_header.seq_num = ptr_conn_info->send_nxt;
		tcp_header.ack_num = ptr_conn_info->recv_nxt;	/* piggy-ACK */
		ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;	/* we ACK all */
		tcp_header.code_and_hlen.code_and_hdrlen_word = 0;
		tcp_header.code_and_hlen.code_and_hdrlen.hlen = 
																sizeof(TCP_HEADER) / 4;
		TURN_ACK_ON(&tcp_header);
		if ((ptr_conn_info->conn_flags & TCPF_SENDPSH) != 0)
		{
			if (send_truncated == FALSE)
			{
				TURN_PSH_ON(&tcp_header);
			}
		}
		else if ((ptr_conn_info->send_una_amount + ptr_conn_info->send_filled) == 
					ptr_conn_info->send_buf_size)
		{
			/* Force a PUSH if the send window is full */
			TURN_PSH_ON(&tcp_header);
		}

		tcp_header.win_size = tcp_recv_wnd(ptr_conn_info);
		tcp_header.urg_ptr = 0;

		/* to network format we go... */
		tcp_hdr_hton((TCP_HEADER *)ptcpbuf, &tcp_header);

/* sudha 15-Oct-1999.Taken from ras tcp code... */
#ifdef INTERNET_TYPE_OF_SERVICE_BUG
		/* send packet on its way to IP */
		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
				ptr_conn_info->socket_record_ptr->internet_type_of_service, ptcpbuf, 
				current_send + sizeof(TCP_HEADER), FALSE);
#endif

		/* send packet on its way to IP */

		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
				0, ptcpbuf, current_send + sizeof(TCP_HEADER), FALSE);

/* ...sudha 15-Oct-1999.Taken from ras tcp code */

		/* Put segment on retransmit queue */
		add_to_tcp_rtx_queue(ptr_conn_info, ptr_conn_info->send_nxt, 
				current_send);

		/* Update 'send_una_amount', 'nxt' and 'bnext' and 'filled' */
		ptr_conn_info->send_una_amount += current_send;
#if defined(DEBUG)
		if (ptr_conn_info->send_una_amount > ptr_conn_info->send_buf_size)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: 'send_una_amount' not being updated properly\n\r");
#endif /* DEBUG */
		ptr_conn_info->send_filled -= current_send;
		ptr_conn_info->send_nxt += current_send;
		ptr_conn_info->send_bnext = (current_send + ptr_conn_info->send_bnext) 
												% ptr_conn_info->send_buf_size;

		to_send -= current_send;				/* update bytes left to send */
	} while (to_send);

	/* Reset the PSH bit if it's okay to do so */
	if ((ptr_conn_info->conn_flags & TCPF_SENDPSH) != 0)
	{
		if (send_truncated == FALSE)
		{
			ptr_conn_info->conn_flags &= ~TCPF_SENDPSH;
		}
	}

	/* Record send related info for RTT estimation if not already doing
	** such a thing (TCPF_TIMEACK is not on) or Karn's algorithm is not
	** in progress (TCPF_RTXON is not on)
	*/
	if (
			((ptr_conn_info->conn_flags & TCPF_TIMEACK) == 0) 
			&&
			((ptr_conn_info->conn_flags & TCPF_RTXON) == 0)
		)
	{
		ptr_conn_info->conn_flags |= TCPF_TIMEACK;	/* Busy estimating RTT */
		ptr_conn_info->last_seg_sent_tick = get_current_tick_count();
		ptr_conn_info->seg_for_rtt_estimate = last_seg_seq;
	}
}

/*
** tcp_tx_completion()
**		Called by lower layer after the packet has been sent. We will free
**		allocated buffer here and adjust stats. This function is registered
**		with LSL during init time.
** Params:
**		Port number on which the packet was sent (NOT USED)
**		Ptr to the original buffer sent ??
*/
void
tcp_tx_completion(USHORT port_number, UNION_IP_PACKET *sptr_tcp_tx_packet)
{
	PARAMETER_NOT_USED(port_number);


	tcp_free_user_buffer((BYTE *)sptr_tcp_tx_packet);
}

