/*
** TCPTIMER.C -- Code related to starting off timers for various TCP
**					  purposes.
** Modifications : sudha 15-Oct-1999. Put in fixes taken from ras tcp
**						 code in tcp_timer() function.
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

extern ULONG timer_ulong;

/* 
** get_current_tick_count()
**		Returns the current tick count
*/
ULONG 
get_current_tick_count()
{
	return timer_ulong;
}

/* 
** tcp_timer()
**		Called periodically by the rtrware foreground. We take care of
**		connection related timeouts, etc. in this routine.
*/
void
tcp_timer()
{
	USHORT i;
	TCP_PER_CONN *ptr_conn_info;

	/*-----------------------------------------------------------------*/
	/* Look before you leap */

	if (tcp.timer_enabled == FALSE)
		return;
	
	/*-----------------------------------------------------------------*/
	/* Handle ISN timer */

	/* We can't do better than 50ms. RFC demands a millisecond timer. 
	** Make do with what we have.
	*/
	tcp.isn_clk_time++;			

	/*-----------------------------------------------------------------*/
	/* Handle retransmissions */

	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{
		if (ptr_conn_info->tcp_state == CLOSED || 
			ptr_conn_info->tcp_state == FREE ||
			ptr_conn_info->tcp_state == TIME_WAIT)
			continue;

		/* Count up retransmit timer if there is something in the retransmit
		** queue
		*/
		if (ptr_conn_info->rtx_queue == NULL)
			continue;

		++ptr_conn_info->rtx_counter;

		if (ptr_conn_info->rtx_counter >= ptr_conn_info->rtx_timeout) 
		{
			tcp_rtx(ptr_conn_info);
		}
	}

	/*-----------------------------------------------------------------*/
	/* Do normal sends */

	tcp_send_fgnd();										


	/*-----------------------------------------------------------------*/
	/* Acknowledgements within a certain time */

	++tcp.tcp_ack_timer;
	if (tcp.tcp_ack_timer >= tcp.max_ack_delay)
	{
		tcp.tcp_ack_timer = 0;						/* Restart the ACK timer */

		ptr_conn_info = tcp.tcp_conn_table;
		for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
		{
			if (ptr_conn_info->tcp_state == CLOSED || 
					ptr_conn_info->tcp_state == FREE)
				continue;


			if ((ptr_conn_info->conn_flags & TCPF_NEEDACK) != 0)
			{
				send_tcp_control_seg(ptr_conn_info, ptr_conn_info->send_nxt, 
						ptr_conn_info->recv_nxt, ACK);
				ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;
			}
		}
	}

	/*-----------------------------------------------------------------*/
	/* Persist timer -- probe zero windows */

	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{
		if (ptr_conn_info->tcp_state == FREE || 
				ptr_conn_info->tcp_state == TIME_WAIT)
			continue;
		if (ptr_conn_info->send_wnd != 0 || ptr_conn_info->rtx_queue != NULL)
			continue;

#if defined(DEBUG)
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: !@!@! Persisting\n");
#endif /* DEBUG */

		/* Persist timer is valid only if the send window size is 0 */

		if (ptr_conn_info->send_persist_timer)
			ptr_conn_info->send_persist_timer--;
		if (ptr_conn_info->send_persist_timer == 0)
		{
			tcp_persist(ptr_conn_info);
		}
	}

	/*-----------------------------------------------------------------*/
	/* Two MSL business */
	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{					  	
/*
Satish. 8th March 1997.
2msl timer is used to clean up TCP connections after entering TIME_WAIT state.
But sometimes we get struck in FIN_WAIT_2 state expecting a FIN from the remote.
If for some reason the remote does not send the FIN (lets say a application bug)
the TCP connection stays in FIN_WAIT_2 state forever.
To take care of this, we start a 2msl timer when in FIN_WAIT_2 state.
So here we decrement the 2msl timer if the state is FIN_WAIT_2.
Hopefully there are no side effects.
*/
		if (ptr_conn_info->tcp_state == TIME_WAIT ||
				ptr_conn_info->tcp_state == LAST_ACK || ptr_conn_info->tcp_state == FIN_WAIT_2)
		{
			if (ptr_conn_info->two_msl_timer == 0)
			{
				tcp_quiet_abort(ptr_conn_info);
			}
			else
				ptr_conn_info->two_msl_timer--;
		}
	}

	/*-----------------------------------------------------------------*/
	/* Connection idle timer */

	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{
			if (ptr_conn_info->tcp_state != ESTAB)
				continue;

			if (ptr_conn_info->conn_alive_timer == 0xFFFFFFFF)
				continue;							/* Special case - no timeout */

			if (ptr_conn_info->conn_alive_timer)
				ptr_conn_info->conn_alive_timer--;

/* sudha 15-Oct-1999.Taken from ras tcp code... */
			if (ptr_conn_info->conn_alive_timer == 0)
			{
				if (ptr_conn_info->tcp_state == SYN_RCVD)
				{
/*
Satish, 24rth Jan 1998.
if a tcp client after sending a SYN for which we respond with a SYN+ACK does not
send back an ack, the original listen record gets screwd. So after the connection
timeout put back the parent record back to listen state and clean up this
record.
*/
					if (ptr_conn_info->parent_conn_rec_ptr)
						ptr_conn_info->parent_conn_rec_ptr->conn_flags &= ~TCPF_CONNPENDING;
					tcp_quiet_abort(ptr_conn_info);
					++tcp.mib.tcpAttemptFails;
					continue;
				}

				if (ptr_conn_info->tcp_state == ESTAB)
					send_keep_alive_probe(ptr_conn_info);
		}
/* ...sudha 23-Sep-1999.Taken from ras tcp code */
	}

	/*-----------------------------------------------------------------*/
	/* Debug */

#if defined(DEBUG)

	tcp_debug();

#endif /* DEBUG */

}

/* 
** tcp_start_2msl_timer()
**		Starts off the 2MSL timer when in the TIME_WAIT state
** Params:
**		Ptr to connection record for connection
*/
void
tcp_start_2msl_timer(TCP_PER_CONN *ptr_conn_info)
{
	ptr_conn_info->two_msl_timer = tcp.two_msl;
}

