/*
** TCPURG.C -- Urgent data processing support code
** Modifications : sudha 15-Oct-1999. Put in fixes taken from ras tcp code
**						 in tcp_urgent() function.	
*/

/* General Notes:
** 	See design docs for our kind of URGent data processing
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_urgent()
**		If the urgent bit is set in the incoming segment, informs app
**		related to connection that some urgent data has come in.
** Params:
**		Ptr to connection record for connection
**		Ptr to host format TCP header for segment that came in
** NOTES:
**		We will simply call app function, ignore the URGENT data field and
**			leave the urgent data in the normal data stream.
*/

/* sudha 15-Oct-1999. Taken from ras tcp code. Added one more parameter
"urgent_length" */

void 
tcp_urgent(TCP_PER_CONN *ptr_conn_info, TCP_HEADER *tcp_header, ULONG urgent_length)
{
	if (IS_URG_ON(tcp_header))
	{
#if defined(DEBUG)
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: URRRRRGENT!!! Data\n");
#endif /* DEBUG */

		switch (ptr_conn_info->tcp_state)
		{
		case CLOSE_WAIT:
		case CLOSING:
		case LAST_ACK:
		case TIME_WAIT:
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: URGENT data rx-ed in bad state (%s)\n",
							get_state_string(ptr_conn_info->tcp_state));
#endif /* DEBUG */
			TURN_URG_OFF(tcp_header);
			return;
		}

		TURN_URG_OFF(tcp_header);
		ptr_conn_info->conn_flags |= TCPF_RECVPSH;	/* PUSH data on next 
																	** socket receive call
																	*/
		if (ptr_conn_info->socket_record_ptr != NULL)
		{

/* sudha 15-Oct-1999.Taken from ras tcp code... */
/*
We assume a few more things.
We assume that the segment that has URG flag set has ONLY urgent data. The complete data in the
packet is treated as URGENT. Any normal data that comes along will also we treated as URGENT.
Comer says this's an acceptable assumption.
Further we call an application defined function informing the socket, the length of the segment
and the offset at which the urgent data begins. This offset is the difference between the current
pointer and the last read pointer. Basically this will tell us after how many bytes from the
next read will we reach the URG ptr.
Satish. 11th March 1997.
*/

/* The comment below is obselete */
			/* Upcall to app -- app should increment a counter and return */
/* The comment above is obselete */
/* Satish. 11th March 1997 */
/*
This code causes a screw up when our prev ack is lost. Basically recv_filled - seg_len becomes negative
which will cause the screw up. So now a new parameter is added to function which sends the actual
length of the segment
Satish. 3rd Oct 1997
 			(*ptr_conn_info->urgent_data_handler)(ptr_conn_info->socket_record_ptr,
					( ptr_conn_info->recv_filled  - ptr_conn_info->seg_len ),ptr_conn_info->seg_len);

*/
			if (ptr_conn_info->urgent_data_handler)
			{
	 			(*ptr_conn_info->urgent_data_handler)(ptr_conn_info->socket_record_ptr,
						( ptr_conn_info->recv_filled  - urgent_length ),urgent_length);
			}
/*
Once 5.0 is out have to sit and change the URG handling mechanism completely.
We should have seperate queues to process urgent data and should remove all
the assumptions we are making as of now
Satish. 11th March 1997.
*/
/* ...sudha 15-Oct-1999.Taken from ras tcp code */
		}
	}
}


