/*.BM*********************************************************************
	Copyright (C) 1982,1983 Intermetrics, Inc.
AUTHOR		:   Leo Lanzillo
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/xalloc.c
SCCS ID		:   1.5
LAST DELTA	:   4/3/92  14:09:12
DATE OF GET	:   12/2/92  14:08:34
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.xalloc.c
@(#)m/rt/c/ansi/xalloc.c	1.5
**************************************************************************
.EM*/

/* include stdlib.h to get NULL and size_t */
#include "stdlib.h"

static int already_alloc = 0;

#ifdef CHANGED
#define MAINSIZE ( (3 * 1024 * 1024) - (2*1024) ) /* 2k is reduced forSMC BUF*/ 
#endif

extern int MAINSIZE;

extern char *TheHeap ;

    char *
_alloc (size_t size, size_t *sizegiven)
{
/*.SP*********************************************************************

	FUNCTION _alloc
	RETURNS pointer to free storage
	REQUIRES
	     size -- the number of bytes requested and
	     sizegiven -- a pointer to an integer where the
		number of bytes given will go
	EFFECTS
	    This function is the lowest level of the storage management
	    subsystem.  It is called when the higher level routines run
	    out of space.  In a system with an operating system this
	    function would call the operating system to obtain storage.
	    As it stands, this routine is very simple: it has one chunk
	    of storage (TheHeap).  If this is big enough, it returns it.
	    If not, or if it has already given away its chunk, then it
	    returns NULL.
	METHODS
	    Checks to be sure space has not been allocated.
	    If not it returns a pointer to that space, but before
	    doing so it sets already_alloc to true.
	AUTHOR
	    Leo Lanzillo

**************************************************************************
.EP*/

    if (already_alloc || (size > MAINSIZE))  {
	return(NULL);
    } else {
	already_alloc = 1;
	*sizegiven = MAINSIZE;
        return(TheHeap);
    }

} /* _alloc */
