/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/calloc.c
SCCS ID		:   1.19
LAST DELTA	:   9/15/92  09:40:03
DATE OF GET	:   9/21/92  16:12:56
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.calloc.c
@(#)m/rt/c/ansi/calloc.c	1.19

    RELATION:
	Routines that perform dynamic storage management.
    MODULES DEFINED :
	calloc		-- allocate and zero dynamic storage
	malloc		-- allocate and do NOT zero dynamic storage
	free		-- free dynamic storage
	Note: cfree is not part of ANSI C
    INTERNAL ROUTINES :
	linkin		-- link in the new free space from alloc into free list
	alloc_cells	-- grab the space
    EXTERNAL PROCEDURES:
	__free_cell	-- return a cell to the heap
	_alloc		-- Get another heap from the outer environment.
			   This is intended to be a user-supplied routine.

************************************************************************
.EM*/

#include "stdlib.h"
#include "rt.h"

/* Note: these definitions also appear in realloc.c */
#if MEM_DEBUG

#define	STORE_SIZE	2048
char *malloc_ptrs[STORE_SIZE];
char *rtn_add[STORE_SIZE] ;
char *rtn_rtn_add[STORE_SIZE] ;
unsigned long block_lengths[STORE_SIZE] ;

unsigned long	birth_time[STORE_SIZE];


extern char *GetReturnAddress (void) ;
extern char *GetReturnReturnAddress (void) ;

extern unsigned long timer_ulong;
int mem_debug_on = 0;	/* this is to turn loggin on */

#endif

int number_of_blocks_held_by_malloc = 0 ;
unsigned long mem_avail ;
int	total_size_alloced = 0;

#if MEM_NO_FREE			/* defined in "itopts" file in this dir */
int SizePrint=0;
char *LastCaller;
char *PrevAlloc =0;
int	PrevSize;
extern char *GetReturnAddress (void) ;
extern char *GetReturnReturnAddress (void) ;
#endif /* MEM_NO_FREE */


struct cell
{
    size_t		size;
    struct cell		*link;
};

/* Note: CELLSIZE must be at least as big as "struct cell", but */
/* it can be larger.  CELLSIZE must also be a power of two.     */

#ifdef M96002
#define CELLSIZE 2
#else
#ifdef N772X0
#define CELLSIZE 2
#else
#define CELLSIZE 8
#endif
#endif

#define CELLSIZE_MINUS_ONE (CELLSIZE-1)
#define ROUND_UP_TO_CELLS(n) ((~CELLSIZE_MINUS_ONE)&((n)+CELLSIZE_MINUS_ONE))
#define ROUND_DOWN_TO_CELLS(n) ((n)&(~CELLSIZE_MINUS_ONE))


/* Vidy, Sachin for memory debug */
#if MEM_DEBUG
void add_alloced_address (char *address, char *cptr_rtn_add, char *cptr_rtn_rtn_add, unsigned long length)
{
	int i ; 
	for (i = 0 ; i < STORE_SIZE ; i++)
	{
		if (malloc_ptrs[i] == NULL)
		{
			malloc_ptrs[i] = address ;
         rtn_add[i] = cptr_rtn_add ;
         rtn_rtn_add[i] = cptr_rtn_rtn_add ;
         /* number_of_blocks_held_by_malloc++ ; */
         block_lengths[i] = length ;
			birth_time[i] = timer_ulong;
         mem_avail -= length ;
			return ;
		}
	}
	printf ("Not enough space to log malloced addresses\n") ;
   /* number_of_blocks_held_by_malloc++ ; */
}

void	clean_alloc_ptrs(void)
{
	int i;

	for (i = 0; i < STORE_SIZE ; i++)
		malloc_ptrs[i] = 0;
}

void print_allocation_table(void)
{
	int i, count; 
	char print_buf[1024];

	printf("\nAllocation table...(time=%08lx)\n", timer_ulong);

	for (i = 0; i < STORE_SIZE ; i++)
	{
		if (malloc_ptrs[i])
		{
			printf("Buf=%08lx, len=%08lx, rtn=%08lx, rrtn=%08lx born=%08lx\n",
					malloc_ptrs[i], block_lengths[i], rtn_add[i],
					rtn_rtn_add[i], birth_time[i]);
			for(count = 0; count < 0x1ffff; count++);
		}
	}
}

void remove_alloced_address (char *address, char *cptr_rtn_add)
{
	int i ; 
	for (i = 0 ; i < STORE_SIZE ; i++)
	{
		if (malloc_ptrs[i] == address)
		{
			malloc_ptrs[i] = 0 ;
         /* number_of_blocks_held_by_malloc-- ; */
         mem_avail += block_lengths[i] ;
			birth_time[i] = 0;
			return ;
		}
	}
/*	while (1) */
	{
		for (i=0; i < 0x1FFFF; i++);
		printf ("Buffer %08X was never allocated, caller : %08X\n", address, cptr_rtn_add) ;
	}
}
#endif
/* Vidy, Sachin */

    /********************************************************************/
    /*     WARNING: There is a very important trick here.		*/
    /* It is essential that the address of "avail" not be null, since	*/
    /* "avail" is the start of the chain of available cells, and "null"	*/
    /* is the end of the chain.  If it is possible that "avail" might	*/
    /* be the first variable in the initialized data area (idata), then	*/
    /* its offset would be 0.  In the 8086 small model, pointers are	*/
    /* only offsets, so the first variable can come out with a null	*/
    /* address!  Declaring another initialized variable (sure to wind	*/
    /* up ahead of "avail" in idata) avoids this problem.		*/
    /********************************************************************/

extern struct cell avail;
#ifdef DDDEBUG
static struct cell *rover = &avail;
static struct cell avail = {0};
#endif
struct cell *rover = &avail;
struct cell avail = {0};
extern char* _alloc(size_t, size_t*); /* see xalloc.c for a sample */
static struct cell * alloc_cells(size_t n); /* forwards reference */

    void *
calloc (size_t count, size_t size)
/*.SP*********************************************************************

	FUNCTION calloc
	EFFECTS
	    Return a pointer to enough storage for 'count' objects of
	    'size' bytes each.  (For word-addressable targets, the objects
	    are of 'size' words).  Zeroize the storage and return its addr.

**************************************************************************
.EP*/

{
    struct cell *p;

/* To force the LINK instruction */
#if MEM_DEBUG || MEM_NO_FREE
    int a[50] ;

    a[0] = 1 ;
#endif

#if MEM_NO_FREE
/* if (SizePrint)	/* toggled by signature "mem debug" handler */
	if (PrevAlloc)
	{
		printf("calloc: return add %lx\n", LastCaller);
	}
	LastCaller = GetReturnAddress();
#endif /* MEM_NO_FREE */

    if (size != 1) {
#ifdef M96002
	count *= size; /* 96002 target */
#else
#ifdef N772X0
	count *= size; /* 77240 target */
#else
	if (size == 4) { /* optimize this common case */
	    count <<= 2;
	} else {
	    size += size&1;	/* align */
	    count *= size;
	}
#endif
#endif

#if 0
if (SizePrint)	/* toggled by signature "mem debug" handler */
{
	printf("calloc: Caller%lx, size%d", LastCaller, count);
}
#endif

    }
    if ((count != 0) && (p = alloc_cells(ROUND_UP_TO_CELLS(count)+CELLSIZE))) {
	p++;
	/* initialize returned space to zero */
	memset(p,0,count);
#if MEM_DEBUG
	if (mem_debug_on)
		add_alloced_address(p, GetReturnAddress(), GetReturnReturnAddress(), count);
#endif
        number_of_blocks_held_by_malloc++ ;
      
        return (p);
    }
	 printf ("calloc fails\n") ;
    return (NULL);
} /* calloc */


    void *
malloc (size_t size)
/*.SP*********************************************************************

	FUNCTION malloc
	RETURNS pointer to space
	EFFECTS
	    Returns a pointer to 'size' bytes of storage.  (For
	    word-addressable targets, returns a pointer to 'size'
	    words of storage).
	AUTHOR
	    Julian Horn

**************************************************************************
.EP*/

{
    struct cell *p;
/* To force the LINK instruction */
#if MEM_DEBUG || MEM_NO_FREE
    int a[50] ;

    a[0] = 1 ;
#endif

#if MEM_NO_FREE
/*if (SizePrint)	/* toggled by signature "mem debug" handler */
	if (PrevAlloc)
	{
		printf("malloc: return add %lx\n", LastCaller);
		LastCaller = GetReturnAddress();
	}

if (SizePrint)	/* toggled by signature "mem debug" handler */
{
	printf("malloc: Caller%lx, size%d", LastCaller, size);
}
#endif /* MEM_NO_FREE */

    if ((size != 0) && (p = alloc_cells(ROUND_UP_TO_CELLS(size)+CELLSIZE))) {
#if MEM_DEBUG
	if (mem_debug_on)
		add_alloced_address(p+1, GetReturnAddress(), GetReturnReturnAddress(), size);
#endif
        number_of_blocks_held_by_malloc++ ;

        return (++p);
    }
	 printf ("malloc fails\n") ;
    return (NULL);
} /* malloc */


    static struct cell *
linkin(struct cell *start, struct cell *new, struct cell **prev)
/*.SP*********************************************************************

	FUNCTION linkin
	RETURNS a pointer to the start of the new space
	EFFECTS
	    links "new" into the list of cells anchored at "start".
	    Sets "*prev" to point to the cell just before "new".
	    Returns new, unless "new" was merged at the end of another
	    cell.  In that case we return the address of the cell into
	    which "new" was merged.
	AUTHOR
	     Leo Lanzillo

**************************************************************************
.EP*/

{
    struct cell *temp;

    /* push up start until start->link is nil or no  */
    /* less than new. Leave temp set to start->link. */
    temp = start->link;
    if ((temp != 0) && (temp < new)) {
	do {
	    start = temp;
	    temp = temp->link;
	} while ((temp != 0) && (temp < new));
    }
    *prev = start;
    new->link = temp;
    start->link = new;
	/* now it's linked in: see if we can coalese adjacent cells */
    if (((struct cell *)((char*)new + new->size) == temp) && (temp != 0)) {
	/* merge new with the cell after it (temp) */
	new->size += temp->size;
	new->link = temp->link;
    }
    if ((struct cell *)((char*)start + start->size) == new) {
	/* merge new with the cell before it (start) */
	start->size += new->size;
	start->link = new->link;
	new = start;
    }
    return (new);
} /* linkin */


#define MAX_CALLOC_FAILS	10
extern	void	Reset(void);
static	unsigned char   consecutive_calloc_fails;	/* Vidy 30/4/99 */

    static struct cell *
alloc_cells(size_t n)
/*.SP*********************************************************************

	FUNCTION alloc_cells
	RETURNS  a pointer to the first cell of the new space
	REQUIRES
	     EXTERNAL PROCEDURES: _alloc()
	AUTHOR
	    Leo Lanzillo

**************************************************************************
.EP*/

{
    struct cell * x;
    struct cell * p, *q, *r, *new, *prev;
    size_t k;
    size_t sizegiven;

#if MEM_NO_FREE
	 if (PrevAlloc)
	 	printf("calloc: 2nd alloc. Last size=%d\n", PrevSize);
	 else
	 	PrevAlloc = 1;
	PrevSize = n;
#endif /* MEM_NO_FREE */

    /*----------------------------------------------------------------*/
    /* search for large enough avail piece			      */
    /* start search at rover; if that fails, restart at start of list */
    /*----------------------------------------------------------------*/

	x = rover;
   while (1)
	{
		q = x;
		while (p = q->link)
		{
	   	/* Fix for ptm 1385: just check >= n, not n+cell size.  */
	    	/* The size of the cell was already counted in earlier. */
	    	if (p->size >= n)
			{
				k = p->size - n;
				if (k == 0)
				{
					q->link = p->link;
				}
				else
				{
		      	p->size = k;
				}
				(r=(struct cell *)((char*)p+k))->size = n;
				if (!(rover=q->link))
					rover = &avail ;
total_size_alloced += n;
				consecutive_calloc_fails = 0;

				return (r);
			}
		   q = p;
		}
		if (x == &avail)
		{
		    break;
		}
		x = &avail; /* try one more time */
	}

	/*--------------------------------------*/
	/* if we get here we have not found any */
	/* place large enough on the freelist.  */
	/*--------------------------------------*/

    new = (struct cell *)_alloc(n,&sizegiven);
    if (new == NULL)
	 {
		if (consecutive_calloc_fails++ > MAX_CALLOC_FAILS)
			Reset();

		return ((struct cell *) NULL);
    }
    /* round sizegiven down to even number of cells */
    new->size = ROUND_DOWN_TO_CELLS(sizegiven);
    new = linkin(&avail, new, &prev);
	/* prev will get freespace that precedes new and points to it */
    k = new->size - n;
	if (k == 0)
	{
		prev->link = new->link;
   }
	else
	{
		new->size = k;
   }
   (r=(struct cell *)((char*)new + k))->size = n;
   if (!(rover= new->link)) rover = &avail;
total_size_alloced += n;
   consecutive_calloc_fails = 0;
   return (r);
} /* alloc_cells */


    void
free (void *ptr)
/*.SP*********************************************************************

	PROCEDURE free
	REQUIRES
	    ptr must either be null or acquired from malloc or calloc.
	EFFECTS
	    Frees up the space and coalesces it with contiguous free
	    space if possible.

**************************************************************************
.EP*/

{
    struct cell *r;
    struct cell *p, *q;

/* To force the LINK instruction */
#if MEM_DEBUG
   int x[20] ;
   x[0] = 0 ;
#endif
    /* point r to the system header before the start */
    r = (struct cell *)ptr;
    if (!r) return; /* null argument is OK */
    r -= 1;

#if MEM_NO_FREE
PrevAlloc = 0;
#endif /* MEM_NO_FREE */

#if MEM_DEBUG
	if (mem_debug_on)
	    remove_alloced_address(ptr, GetReturnAddress());
#endif
    number_of_blocks_held_by_malloc-- ;
	total_size_alloced -= r->size;

    /* find first item in avail list to the right of segment being freed */
    q = &avail;
    if (p = q->link) {
	do {
	    if (p>r) break;
	    q = p;
	} while (p = q->link);
    }

    /* coalesce with item on the right, if they are contiguous */
    /* note that maybe p==0 here */
    if ((struct cell *)((char*)r + r->size) == p) {
	r->size += p->size;
	r->link  = p->link;
	if (rover==p) rover = &avail;
    } else {
	r->link  = p;
    }

    /* coalesce with item on the left, if they are contiguous */
    if ((struct cell *)((char*)q + q->size) == r) {
	q->size += r->size;
	q->link  = r->link;
	if (rover==r) rover = &avail;
    } else {
	q->link  = r;
    }

} /* free */

