/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/ctype.h
SCCS ID		:   1.11
LAST DELTA	:   9/21/93  15:46:43
DATE OF GET	:   9/21/93  15:46:44
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.ctype.h
@(#)m/rt/c/ansi/ctype.h	1.11
**************************************************************************
.EM*/

#ifndef __CTYPE_INCLUDED
#define __CTYPE_INCLUDED

#define _C	1	/* is control character */
#define _S	2	/* is white space */
#define _P	4	/* is punctuation */
#define _SP	8	/* is space */
#define _D	16	/* is decimal digit */
#define _UC	32	/* is upper case */
#define _X	64	/* is hex */
#define _LC	128	/* is lower case */

#pragma separate __ctype class constant
extern const unsigned char __ctype[];

/* Character testing functions */

extern int	isalnum(int);
extern int	isalpha(int);
extern int	iscntrl(int);
extern int	isdigit(int);
extern int	isgraph(int);
extern int	islower(int);
extern int	isprint(int);
extern int	ispunct(int);
extern int	isspace(int);
extern int	isupper(int);
extern int	isxdigit(int);

#define isalnum(c)	((__ctype+1)[c] & (_UC|_LC|_D))
#define isalpha(c)	((__ctype+1)[c] & (_UC|_LC))
#define iscntrl(c)	((__ctype+1)[c] & _C)
#define isdigit(c)	((__ctype+1)[c] & _D)
#define isgraph(c)	((__ctype+1)[c] & (_UC|_LC|_D|_P))
#define islower(c)	((__ctype+1)[c] & _LC)
#define isprint(c)	((__ctype+1)[c] & (_UC|_LC|_D|_P|_SP))
#define ispunct(c)	((__ctype+1)[c] & _P)
#define isspace(c)	((__ctype+1)[c] & _S)
#define isupper(c)	((__ctype+1)[c] & _UC)
#define isxdigit(c)	((__ctype+1)[c] & _X)

/* Character case mapping functions */

extern int	tolower(int);
extern int	toupper(int);


/* this endif matches the ifndef __CTYPE_INCLUDED at the start of this file */
#endif
