/*.BM*********************************************************************
	Copyright (C) 1986 Intermetrics, Inc.
AUTHOR		:   Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/com/math.h
SCCS ID		:   1.13
LAST DELTA	:   5/2/91   18:14:52
UNIX FILE	:   s.math.h
@(#)m/rt/c/68000/com/math.h	1.13
**************************************************************************
.EM*/

#ifndef __MATH_INCLUDED
#define __MATH_INCLUDED

/* HUGE_VAL is an IEEE infinity */
#define HUGE_VAL 99.e999

/* Trigonometric functions */

extern double	acos(double);
extern double	asin(double);
extern double	atan(double);
extern double	atan2(double, double);
extern double	cos(double);
extern double	sin(double);
extern double	tan(double);

/* Hyperbolic functions */

extern double	cosh(double);
extern double	sinh(double);
extern double	tanh(double);

/* Exponential and logarithmic functions */

extern double	exp(double);
extern double	frexp(double, int *);
extern double	ldexp(double, int);
extern double	log(double);
extern double	log10(double);
extern double	modf(double, double *);

/* Power functions */

extern double	pow(double, double);
extern double	sqrt(double);

/* Nearest integer, absolute value, and remainder functions */

extern double	ceil(double);
extern double	fabs(double);
extern double	floor(double);
extern double	fmod(double, double);

/* Extra routines not in ANSI C */

#ifdef _EXTENSIONS
#include "extended.h"
#endif

#endif
