/*.BM*******************************************************************
	Copyright (C) 1990 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/memcmp.c
SCCS ID		:   1.4
LAST DELTA	:   5/11/93 17:11:53
DATE OF GET	:   5/11/93 17:11:57
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.memcmp.c
@(#)m/rt/c/ansi/memcmp.c	1.4

    FUNCTIONS DEFINED:
	int memcmp(s1,s2,n) - Memory compare

    RELATION:
	Compare n bytes of memory from s2 to s1.
	Just like strcmp, but doesn't stop at zeros.

**************************************************************************
.EM*/

#include "string.h"

#ifdef M96002
#undef memcmp
#endif

    int
memcmp(register const void *s1, register const void *s2, register size_t n)
{
    while (n != 0) {
	if (*(char *)s1 != *(char *)s2) {
	    return (*(char *)s1 - *(char *)s2); /* miscompare */
	} else {
	    --n;
	    s1 = (char *)s1 + 1;
	    s2 = (char *)s2 + 1;
	}
    }
    return(0); /* equal */
}
