/*----------------------------------------------------------------------------
	file	:	memcpy.c
	Modu	:	68360 library
	Auth	:	Vidy
	Synop	:	This stdlib routine for memcpy funtion is optimised for a 32 bit
				processor with all the 32 bits data bus wired to memory.
----------------------------------------------------------------------------*/
#include "string.h"

void *memcpy(register unsigned long *p1, register unsigned long *p2, register size_t count)
{
	register int residue;
	register void *result = p1;

	if (count < 6) {
		residue = count;
		goto not_worth_all_this;
	}

	/* we try to align destination to a long word boundary */
	if (((unsigned long)p1 & 3)) {
		residue = 4 - ((unsigned long) p1 & 3);
		count -= residue;
		while(residue--)
			*((char *) p1)++ = *((char *) p2)++;
	}

	/* now copy the rest as long words as far as possible */
	residue = count & 0x3;	/* keep the residue count of last bytes */
	count >>= 2;				/* now byte count is made long count */
	while(count--) 
		*p1++ = *p2++;			/* long word copy */

not_worth_all_this:
	while(residue--)			/* copy the residual byte count */
		*((char *) p1)++ = *((char *) p2)++;	/* byte copy */

	return result;
}

