/*.BM*********************************************************************
	Copyright (C) 1990 Intermetrics, Inc.
AUTHOR		:   Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/com/memset.c
SCCS ID		:   1.2
LAST DELTA	:   4/28/92  18:39:12
DATE OF GET	:   4/28/92  18:39:15
UNIX FILE	:   s.memset.c
@(#)m/rt/c/68000/com/memset.c	1.2

    FUNCTIONS DEFINED:
	void * memset(s,c,n) - Memory fill

    RELATION:
	Fill n-byte memory region at s to c.  Returns s.

**************************************************************************
.EM*/

#include "string.h"

    void *
memset(void *s, int c, size_t n)
{
    char *cp;
    long *lp;
    void *result;
#ifdef _LONGINT
#define INT16 short
#else
#define INT16 int
#endif
    INT16 int16ctr;
    long lv = (char)c;

    result = cp = s;

	/* for small blocks, it's best just to move byte by byte */
    if (n <= 24) {
	int16ctr = n;
	int16ctr -= 1;
	do {
	    *cp++ = lv;
	} while (int16ctr--);
	return (result);
    }

    /* The best way to fill memory is with word moves. */
    /* However, you can only do word moves into word   */
    /* aligned addresses.  This code takes care of     */
    /* a few initial bytes, then does a block of longs */
    /* then it does the trailing bytes, if any.  Also, */
    /* the best kind of loop is a DBF, which requres a */
    /* 16-bit unsigned count-down counter.  This is    */
    /* either declared as unsigned or unsigned short,  */
    /* depending on the state of the -L switch.        */

	/* duplicate the char value c four times in lv */
    lv += lv << 8;
    lv += (lv << 16);

	/* push up cp until its fullword aligned */
    int16ctr = (short)cp & 3;
    if (int16ctr) {
	*cp++ = lv;
	n -= int16ctr;
	if (--int16ctr) {
	    *cp++ = lv;
	    if (--int16ctr) {
		*cp++ = lv;
	    }
	}
    }
	/* move block of longs */
    lp = (long *)cp;
    if (n < 0x3ffff) {
	/* use optimized loop */
	int16ctr = (n >> 2);
	int16ctr--;
	n &= 3;
	do {
	    *lp++ = lv;
	} while (int16ctr--);
    } else {
	int16ctr = n;
	int16ctr &= 3;
	n >>= 2;
	do {
	    *lp++ = lv;
	    n--;
	} while (n);
	n = int16ctr;
    }

    /* move trailing bytes */
    cp = (char *)lp;
    if (n != 0) {
	*cp++ = lv;
	n--;
	if (n != 0) {
	    *cp++ = lv;
	    n--;
	    if (n != 0) {
		*cp++ = lv;
		n--;
	    }
	}
    }
    return(result);
} /* memset */
