/*.BM*******************************************************************
	Copyright (C) 1982 Intermetrics, Inc.
AUTHOR		:   Don Y. Sakahara, modified by Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/modf.c
SCCS ID		:   1.10
LAST DELTA	:   1/25/93  10:54:51
DATE OF GET	:   1/25/93  10:55:07
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.modf.c
@(#)m/rt/c/ansi/modf.c	1.10
************************************************************************
.EM*/

#include "rt.h"
#include "fpdef.h"
/* MOTOROLA is defined in byteord.h */
#include "byteord.h"

    /* This table is used to mask off mantissa bits in the */
    /* byte that also contains the low_order exponent bits */
#pragma separate exp_masktable class constant segment S___libcdata
static const UINT8 exp_masktable[9] =
    { 0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff };

    /*  This union is used so that we can access the fp number */
    /*  as bytes, longwords, or as a floating point number.    */
typedef union {
    REAL64      fp64num;
    UINT32      fp64long[2];
    UINT8       fp64byte[8];
} FP64, * FP64PTR;

    /* If the "make doubles into floats" switch is on,    */
    /* then use the single precision forms in the macros. */
    /* Definitions for EXPOF and FEXPOF are in fpdef.h.   */
#ifdef _DBLISFLT
    #define BYTES_PER_DOUBLE	4
    #define MANT_BITS		23
    #define NON_MANT_BITS	9
    #define EXP_BIAS		127
    #define EXP_PART		FEXPOF
#else
    #define BYTES_PER_DOUBLE	8
    #define MANT_BITS		52
    #define NON_MANT_BITS	12
    #define EXP_BIAS		1023
    #define EXP_PART		EXPOF
#endif

    REAL64
modf(REAL64 arg, FP64PTR intpart)
{

/*.SP*********************************************************************

	FUNCTION  modf
	EFFECTS
	    modf returns the fractional part of arg, and stores
	    the integral part indirectly through the pointer intptr.
	METHODS
	    The arg is copied to *intptr.  Then the base 2 exponent
	    of the number is determined and that many bits of the mantissa
	    are preserved in *intpart.  The integer part is then subtracted
	    from the initial number and the result is recorded in arg.
	    Then arg is returned.

**************************************************************************
.EP*/

    INT16	i;
    INT16	numbits;
    INT16	numbytes;
    INT16	exp;
#ifdef _TI340
    UINT32	temp32;
#endif

#ifdef TRACE
    printf("ENTERING MODF; arg =");
    for (i = 0; i <= (BYTES_PER_DOUBLE-1); i++) {
        printf(" %02x",  ((FP64PTR)&arg)->fp64byte[i]);
    }
    printf("\n");
#endif

    intpart->fp64num = ((FP64PTR)&arg)->fp64num;

    /*-----------------------------------------------------------*/
    /* exp will have number of bits of the mantissa we want to   */
    /* save.  if less than zero save none, greater than total    */
    /* number of bits of mantissa then save it all.		 */
    /*-----------------------------------------------------------*/

    exp = EXP_PART((UINT32*)&arg);
    exp = exp - EXP_BIAS;
    if (exp < 0 ) {
	intpart->fp64num = 0;
    } else if (exp >= MANT_BITS) {
	((FP64PTR)&arg)->fp64num = 0;
    } else {

	exp += NON_MANT_BITS;
	numbytes = exp >> 3; /* same as exp/8 because we know exp >= 0 */
	numbits = exp - (numbytes << 3);

#ifdef _TI340
	/* Very annoying -- must swap 32-bit words */
	/* before the following masking code       */
	temp32 = intpart->fp64long[1];
	intpart->fp64long[1] = intpart->fp64long[0];
	intpart->fp64long[0] = temp32;
#endif

#ifdef MOTOROLA
	for (i=numbytes + 1; i < BYTES_PER_DOUBLE; i++) {
	    intpart->fp64byte[i] = 0;
	}
	intpart->fp64byte[numbytes] =
	    intpart->fp64byte[numbytes] & exp_masktable[numbits];
#else
	for (i = 0; i < (BYTES_PER_DOUBLE-1) - numbytes; i++) {
	    intpart->fp64byte[i] = 0;
	}

	/* i has the index to the byte with some significant mantissa */

	intpart->fp64byte[i] =
	    intpart->fp64byte[i] & exp_masktable[numbits];
#endif

#ifdef _TI340
	/* Swap back */
	temp32 = intpart->fp64long[1];
	intpart->fp64long[1] = intpart->fp64long[0];
	intpart->fp64long[0] = temp32;
#endif

        ((FP64PTR)&arg)->fp64num =
	    ((FP64PTR)&arg)->fp64num - intpart->fp64num;
    }				/* else  */

#ifdef TRACE
    printf("Leaving MODF; int =");
    for (i = 0; i <= (BYTES_PER_DOUBLE-1); i++) {
	printf(" %02x",intpart->fp64byte[i]);
    }
    printf(", fraction =");
    for (i = 0; i <= (BYTES_PER_DOUBLE-1); i++) {
        printf(" %02x",  ((FP64PTR)&arg)->fp64byte[i]);
    }
    printf("\n");
#endif

    return(arg);
} /* modf */
